<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>Smart Report Maker</title>

    <link rel="stylesheet" href="<?php echo e(public_path('dist/css/all.min.css'). '?v='. $srmVersion); ?>">
    <link rel="stylesheet" href="<?php echo e(public_path('dist/css/adminlte.min.css'). '?v='. $srmVersion); ?>">
    <link rel="stylesheet" href="<?php echo e(public_path('dist/css/style.css'). '?v='. $srmVersion); ?>" />

    <style>
        table {
            width: 100%;
            border-collapse: collapse;
        }

        table td,
        table th,
        table thead,
        table {
            word-wrap: break-word;
            /* For non-IE */
            overflow-wrap: break-word;
            /* For IE */
            word-break: break-all;
            /* Force breaking long words and URLs */
        }
    </style>


<body>

    <div class="content-wrapper" style="background-color:white !important">
        <section class="content-header">
            <div class="row">
                <div class="col-sm-7 float-left">
                    <h2 style="font-weight: bold"><?php echo e(ucwords($chart->getResourceConfiguration('name'))); ?></h2>
                    <h6><?php echo e(\Carbon\Carbon::now()->format('d M Y h:i A')); ?>

                    </h6>
                </div>
                <div class="col-sm-4 text-right float-right">
                    <div class="branding-logo">
                        <?php if(is_null(getSettingsValue('system_logo'))): ?>
                        <img src="<?php echo e(public_path('dist/images/srm-logo.jpg')); ?>" alt="Logo" class="brand-image" />
                        <?php else: ?>
                        <img src="<?php echo e(getSystemLogo(true)); ?>" alt="Logo" class="brand-image w-100" />
                        <?php endif; ?>
                    </div>

                </div>
                <div style="clear:both"></div>
            </div>

            <hr style="border-top: 1px solid rgba(0, 0, 0, .5);">

            <div class="row">
                <div class="col-9">
                    <?php if(is_array($label)): ?>
                    <h6 class="py-3" style="font-weight:bold">
                        <?php echo e(ucwords($chart->getResourceConfiguration('x_axis_column'))); ?>

                        : <span class="text-primary " style="font-weight:normal"><?php echo e($label[0]); ?></span> to
                        <span class="text-primary" style="font-weight:normal"><?php echo e($label[1]); ?></span>
                    </h6>
                    <?php else: ?>
                    <h6 class="py-3" style="font-weight:bold"><?php echo e(ucwords($chart->getResourceConfiguration('x_axis_column'))); ?>

                        : <span class="text-primary" style="font-weight:normal"><?php echo e(ucwords($xValue)); ?></span>
                    </h6>

                    <?php endif; ?>
                </div>

            </div>

            <div class="table table-bordered">
                <table width="100%" style="table-layout:fixed;">
                    <thead>
                        <tr style="background-color: #d6d8da">
                            <?php $__currentLoopData = $keys; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if(count($keys) > 5): ?>
                            <th style="font-size:0.8rem;<?php echo e(strlen($key) > 8 ? 'font-size:0.6rem' : ''); ?>">
                                <?php echo e($key); ?>

                            </th>
                            <?php else: ?>
                            <th>
                                <?php echo e($key); ?>

                            </th>
                            <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if(count($data) > 0): ?>
                        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if(count($keys) > 7): ?>

                        <tr class="smaller-font">
                            <?php $__currentLoopData = $row; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <td>
                                <div style="font-size:0.8rem;<?php echo e(strlen($item) > 20 ? 'font-size:0.6rem' : ''); ?>">
                                    <?php echo e($item); ?>

                                </div>
                            </td>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tr>
                        <?php else: ?>
                        <tr class="smaller-font">
                            <?php $__currentLoopData = $row; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <td>
                                <?php echo e($item); ?>

                            </td>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tr>

                        <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php else: ?>
                        <tr style="background-color:transparent">
                            <td style="text-align: center" colspan="<?php echo e(count($keys)); ?>">
                                <h6>Sorry, There is no data</h6>
                            </td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>

            </div>

    </div>
</body>
<?php /**PATH /var/www/html/srm_phpv81_or_later/srm/dashboard/resources/views/dashboard/charts/pdf/drill.blade.php ENDPATH**/ ?>