<?php $__env->startSection('styles'); ?>

<link rel="stylesheet" href="<?php echo e(get_asset('dist/css/c3.min.css'). '?v='. $srmVersion); ?>" />

<link rel="stylesheet" href="<?php echo e(get_asset('dist/css/metrics.css'). '?v='. $srmVersion); ?>">

<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>
<script src="<?php echo e(get_asset('dist/js/d3.v5.min.js'). '?v='. $srmVersion); ?>"></script>
<script src="<?php echo e(get_asset('dist/js/c3.min.js'). '?v='. $srmVersion); ?>"></script>
<div class="content-wrapper" style="">
    <?php echo $__env->make('dashboard.metrics.partials._metric-confirmation-modal',[
    'id' => 'delete-metric',
    'modal_title' =>'Delete Confirmation',
    'method'=> 'DELETE'
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div id="change-category-modal-container">
    </div>
    <?php if((isset($metricModule) && $metricModule->checkWhoCanAccessModule()) || auth()->user()->isAdminOrOwner()): ?>
    <?php echo $__env->make('dashboard.metrics.iframe.create', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php endif; ?>
    <?php echo $__env->make('dashboard.metrics.iframe.edit', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('dashboard.metrics.partials.success-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Content Header (Page header) -->
    <section class="content-header mx-3">
        <div class="container-fluid">
            <div class="row mb-2 mt-3">
                <div class="col-sm-6">
                    <h3> <i class="fas fa-chart-line fa-fw"></i>
                        Metrics</h3>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Home</a></li>
                        <li class="breadcrumb-item active">Metrics</li>
                    </ol>
                </div>
            </div>
        </div>
        <!-- /.container-fluid -->
        <div class="container-fluid metric-parent-container">

            <div>
                <form action="<?php echo e(route('metrics.index')); ?>" method="GET" id="metric-search-form">
                    <div class="bg-white py-3">

                        <div class="row bg-white mx-3 row-no-padding-left">
                            <div class="col">
                                <label class="sr-only">Title</label>
                                <div class="input-group input-box">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text rounded-small">Title</div>
                                    </div>
                                    <input type="text" class="form-control rounded-small" id="metric-title"
                                        placeholder="Search" name="metricTitle" value="<?php echo e(request()->metricTitle); ?>">
                                    <i class="fa fa-search"></i>

                                </div>
                            </div>
                            <div class="col">
                                <label class="sr-only">Metric</label>
                                <div class="input-group input-box">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text rounded-small">Metric</div>
                                    </div>
                                    <select type="text" class="form-control rounded-small" id="metric-category"
                                        placeholder="search" name="metricCategory">
                                        <option value="">Please Choose Metric Category</option>
                                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($category->id); ?>" <?php echo e(request()->metricCategory ==
                                            $category->id ? 'selected' : ''); ?> ><?php echo e($category->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="text-center mt-3">
                        <button class="btn btn-primary px-3 py-2 my-2 my-sm-0 srm-button" id="metric-search"
                            type="submit">
                            <i class="fas fa-search"></i> Search
                        </button>

                        <button class="btn btn-outline-primary px-3 py-2 my-sm-0 srm-button show-all" type="button">
                            <i class="fa-solid fa-eye"></i> Show All
                        </button>
                    </div>

                </form>
            </div>
            <div class="mt-4">
                <?php if((isset($metricModule) && $metricModule->checkWhoCanAccessModule()) ||
                auth()->user()->isAdminOrOwner()): ?>

                <button class="btn btn-primary px-3 py-2 float-right srm-button" type="button" id="add-metric-button"
                    data-url="<?php echo e(route('metrics.wizard.appearance.show')); ?>"
                    data-forget="<?php echo e(route('charts.forgetSession')); ?>">
                    <i class="fas fa-plus"></i> Add New Metric
                </button>
                <?php endif; ?>
            </div>
            <div class="clearfix"></div>
            <div class="metric-container" style="min-height: 40vh">
                <div class="metrics mt-4">
                    <?php if(!empty($metrics[0])): ?>

                    <div class="loader" style="display: none">
                        <img src="<?php echo e(get_asset('dist/images/loader.gif')); ?>" class="loader-img" alt="Loader">
                    </div>

                    <div class="row">
                        <?php $__currentLoopData = $metrics; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $metric): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                        <?php if(!is_null($metric)): ?>

                        <?php if($metric->configurations->chart_type == "gauge_chart"): ?>
                        <div class="col-md-3 col-12">

                            <div class="small-box bg-white">
                                <h6 class="float-left pt-2 pl-2 mb-0" style="font-size:0.8rem"><?php echo e($metric->getResourceConfiguration('title')); ?></h6>
                                <?php if(!array_key_exists('error',$metric->data)): ?>
                                <div class="card-tools-right pt-2 float-right">
                                    <?php if(
                                    (
                                    isset($metric->creator) &&
                                    $metric->creator->user_ID == auth()->user()->user_ID
                                    )
                                    ||
                                    auth()->user()->isAdminOrOwner()): ?>

                                    <div class="dropdown">
                                        <button type="button" id="ellipsisMenu2" data-toggle="dropdown"
                                            aria-haspopup="true" aria-expanded="false"
                                            style="border:none;background:none;padding: 0 10px;">
                                            <!-- Your SVG icon -->
                                            <svg xmlns=" http://www.w3.org/2000/svg" width="16" height="16"
                                                fill="currentColor" class="bi bi-three-dots-vertical"
                                                viewBox="0 0 16 16">
                                                <path
                                                    d="M9.5 13a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0z">
                                                </path>
                                            </svg>
                                        </button>
                                        <div class="dropdown-menu dropdown-menu-right" aria-labelledby="ellipsisMenu">
                                            <?php if(
                                            (
                                            isset($metric->creator) &&
                                            $metric->creator->user_ID == auth()->user()->user_ID
                                            )
                                            ||
                                            auth()->user()->isAdminOrOwner()): ?>
                                            <a class="dropdown-item edit-metric"
                                                data-url="<?php echo e(route('metrics.wizard.appearance.edit',$metric->id)); ?>">Edit</a>

                                            <a class="dropdown-item change-category"
                                                data-url="<?php echo e(route('metrics.getCategories',$metric->id)); ?>">Change
                                                category</a>

                                            <a class="dropdown-item delete-metric" data-toggle="modal"
                                                data-target="#delete-metric-modal"
                                                data-url="<?php echo e(route('metrics.destroy',$metric->id)); ?>">Delete</a>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <?php endif; ?>
                                </div>
                                <?php endif; ?>
                                <div class="clearfix"></div>
                                <div class="inner" style="padding: 0">
                                    <?php if(!array_key_exists('error',$metric->data)): ?>
                                    <div id="<?php echo e(Str::of($metric->name)->kebab()); ?>"></div>

                                    <?php else: ?>
                                    <div class="text-center text-danger pt-4" style="height: 110px"
                                    data-toggle="tooltip" data-placement="top" data-title="<?php echo e($metric->data['error']); ?>"><?php echo e(\Illuminate\Support\Str::limit($metric->data['error'], 80)); ?></div>
                                    <?php endif; ?>
                                </div>
                                <script>
                                    <?php echo $metric->script; ?>

                                </script>

                                <?php if(!array_key_exists('error',$metric->data)): ?>

                                <?php if($metric->getResourceConfiguration('drill_down')): ?>
                                <a href="<?php echo e(route('metrics.drill',$metric->id)); ?>" class="small-box-footer">
                                    More info <i class="fas fa-arrow-circle-right"></i>
                                </a>
                                <?php endif; ?>
                                <?php else: ?>
                                <div style="height: 30px;background-color:rgba(0, 0, 0, .1)">
                                </div>
                                <?php endif; ?>
                            </div>


                        </div>
                        <?php else: ?>
                        <div class="col-md-3 col-12">

                            <div class="small-box <?php echo e($metric->getMetricBgColor()); ?>">
                                <?php if(!array_key_exists('error',$metric->data)): ?>

                                <div class="card-tools-custom">
                                    <?php if(
                                    $metric->creator->user_ID == auth()->user()->user_ID
                                    ||
                                    auth()->user()->isAdminOrOwner()
                                    ): ?>

                                    <div class="dropdown">
                                        <button type="button" id="ellipsisMenu2" data-toggle="dropdown"
                                            aria-haspopup="true" aria-expanded="false" style="border:none;background:none;
                                            <?php if($metric->metric_color != 'white' ): ?> <?php echo e('color:white'); ?> <?php endif; ?>">
                                            <!-- Your SVG icon -->
                                            <svg xmlns=" http://www.w3.org/2000/svg" width="16" height="16"
                                                fill="currentColor" class="bi bi-three-dots-vertical"
                                                viewBox="0 0 16 16">
                                                <path
                                                    d="M9.5 13a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0z">
                                                </path>
                                            </svg>
                                        </button>
                                        <div class="dropdown-menu dropdown-menu-right" aria-labelledby="ellipsisMenu">
                                            <?php if(
                                            $metric->creator->user_ID == auth()->user()->user_ID
                                            ||
                                            auth()->user()->isAdminOrOwner()): ?>
                                            <a class="dropdown-item edit-metric"
                                                data-url="<?php echo e(route('metrics.wizard.appearance.edit',$metric->id)); ?>">Edit</a>

                                            <a class="dropdown-item change-category"
                                                data-url="<?php echo e(route('metrics.getCategories',$metric->id)); ?>">Change
                                                category</a>

                                            <a class="dropdown-item delete-metric" data-toggle="modal"
                                                data-target="#delete-metric-modal"
                                                data-url="<?php echo e(route('metrics.destroy',$metric->id)); ?>">Delete</a>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <?php endif; ?>
                                </div>
                                <?php endif; ?>
                                <div class="inner">
                                    <?php if(!array_key_exists('error',$metric->data)): ?>

                                    <?php if($metric->getResourceConfiguration('compare_with') != "no_comparison"): ?>
                                    <span data-toggle="custom-tooltip" data-html="true" data-placement="bottom"
                                        title="<?php echo e($metric->data['tooltip']); ?>"
                                        style="margin-left: 1rem;font-size:small">
                                        <?php if(!in_array($metric->getResourceConfiguration('display_format'),['percentage','percentage_of_total'])): ?>
                                        <?php echo e($metric->data['change']); ?>

                                        <?php endif; ?>
                                        (
                                        <?php if(!is_numeric($metric->data['trend'])): ?>
                                        <?php echo e($metric->data['trend']); ?>%
                                        <?php elseif($metric->data['trend_direction'] == "positive"): ?>
                                        ↑<?php echo e($metric->data['trend']); ?>%
                                        <?php elseif($metric->data['trend_direction'] == "negative"): ?>
                                        ↓<?php echo e($metric->data['trend']); ?>%
                                        <?php endif; ?>
                                        )</span>
                                    <br>
                                    <span <?php if($metric->getResourceConfiguration('compare_with') == "no_comparison"): ?>
                                        class="mt-4" <?php endif; ?> data-toggle="custom-tooltip" data-html="true"
                                        data-placement="bottom" style="font-size:2rem;font-weight:bold"
                                        title="<?php echo e($metric->data['tooltip']); ?>"><?php echo e($metric->data['original_metric']); ?>

                                    </span>
                                    <p><?php echo e($metric->getResourceConfiguration('title')); ?></p>

                                    <?php else: ?>
                                    <h3 <?php if($metric->getResourceConfiguration('compare_with') == "no_comparison"): ?>
                                        class="mt-4" <?php endif; ?>><?php echo e($metric->data['original_metric']); ?></h3>
                                    <p><?php echo e($metric->getResourceConfiguration('title')); ?></p>
                                    <?php endif; ?>
                                    <?php else: ?>
                                    <p><?php echo e($metric->getResourceConfiguration('title')); ?></p>
                                    <div class="text-center text-danger" style="height: 75px" 
                                    data-toggle="tooltip" data-placement="top" data-title="<?php echo e($metric->data['error']); ?>"><?php echo e(\Illuminate\Support\Str::limit($metric->data['error'], 80)); ?></div>
                                    <?php endif; ?>
                                </div>
                                <?php if($metric->configurations->chart_type == "info_box_with_icon"): ?>
                                <div class="icon">
                                    
                                    <i class="icon-custom fas" style="font-family: 'FontAwesome'"><?php echo $metric->getResourceIcon(); ?></i>
                                </div>
                                <?php endif; ?>
                                <?php if(!array_key_exists('error',$metric->data)): ?>
                                <?php if($metric->getResourceConfiguration('drill_down')): ?>
                                <a href="<?php echo e(route('metrics.drill',$metric->id)); ?>" class="small-box-footer">
                                    More info <i class="fas fa-arrow-circle-right"></i>
                                </a>
                                <?php endif; ?>
                                <?php else: ?>
                                <div style="height: 30px;background-color:rgba(0, 0, 0, .1)">
                                </div>

                                <?php endif; ?>
                            </div>
                        </div>
                        <?php endif; ?>

                        <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <?php else: ?>
                    <?php if($search): ?>
                    <div class="text-center message">
                        <h6>No records matches your search criteria.</h6>
                    </div>
                    <?php else: ?>
                    <div class="text-center message">
                        <h6>No metric to preview.</h6>
                    </div>
                    <?php endif; ?>
                    <?php endif; ?>

                </div>

            </div>
            <?php if($metrics->lastPage() > 1): ?>
            <div class="float-right">
                <?php echo e($metrics->appends(request()->query())->links()); ?>

            </div>
            <div class="clearfix"></div>
            <?php endif; ?>

    </section>

</div>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
<script src="<?php echo e(get_asset('dist/js/metrics.js') . '?v='. $srmVersion); ?>"></script>

<?php if(session('add')): ?>

<script>
    window.onload= function(){
        $('#add-metric-button').click();
    }

</script>

<?php endif; ?>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/srm_phpv81_or_later/srm/dashboard/resources/views/dashboard/metrics/index.blade.php ENDPATH**/ ?>