<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>Smart Report Maker</title>

    <link rel="stylesheet" href="<?php echo e(public_path('dist/css/all.min.css'). '?v='. $srmVersion); ?>">
    <link rel="stylesheet" href="<?php echo e(public_path('dist/css/adminlte.min.css'). '?v='. $srmVersion); ?>">
    <link rel="stylesheet" href="<?php echo e(public_path('dist/css/style.css'). '?v='. $srmVersion); ?>" />
    

<body>

    <div class="content-wrapper" style="background-color:white !important">
        <section class="content-header">
            <div class="row">
                <div class="col-sm-7 float-left">
                    <h3 style="font-weight: bold;line-height: 1.8"><?php echo e(ucwords($chart->getResourceConfiguration('name'))); ?></h3>
                    <h6><?php echo e(\Carbon\Carbon::now()->format('d M Y h:i A')); ?>

                    </h6>
                </div>
                <div class="col-sm-4 text-right float-right">
                    <div class="branding-logo">
                        <?php if(is_null(getSettingsValue('system_logo'))): ?>
                        <img src="<?php echo e(public_path('dist/images/srm-logo.jpg')); ?>" alt="Logo" class="brand-image" />
                        <?php else: ?>
                        <img src="<?php echo e(getSystemLogo(true)); ?>" alt="Logo" class="brand-image w-100" />
                        <?php endif; ?>
                    </div>

                </div>
                <div style="clear:both"></div>
            </div>
            <hr style="border-top: 1px solid rgba(0, 0, 0, .5);">
            <div>
                <table class="table table-bordered" style="word-wrap: break-all;">
                    <thead>
                        <tr style="background-color: #d6d8da">
                            <th><?php echo e(ucwords($chart->getResourceConfiguration('x_axis_column'))); ?></th>
                            <th><?php echo e(!empty($chart->getResourceConfiguration('label')) ?
                                ucwords($chart->getResourceConfiguration('label')) :
                                ucwords($chart->getResourceConfiguration('y_axis_column'))); ?></th>
                        </tr>
                    </thead>
                    <tbody>

                        <?php $__currentLoopData = array_combine($chart->data['x_axis'],$chart->data['y_axis']); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $x_axis
                        =>$y_axis): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr class="smaller-font">
                            <td>
                                <?php if($chart->getResourceConfiguration('date_time_scale') == "months"): ?>
                                <?php echo e(Illuminate\Support\Carbon::parse($x_axis)->format('Y-m')); ?>

                                <?php elseif($chart->getResourceConfiguration('date_time_scale') == "years"): ?>
                                <?php echo e(Illuminate\Support\Carbon::parse($x_axis)->format('Y')); ?>

                                <?php else: ?>
                                <?php echo e($x_axis); ?>

                                <?php endif; ?>

                            </td>
                            <td><?php echo e($y_axis); ?></td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
                <div class="pt-5">
                    <img src="<?php echo e($image); ?>" alt="Chart Image" class="p-0 m-0 w-100" style="width:100%">
                </div>

            </div>

    </div>
</body>
<?php /**PATH /var/www/html/srm_phpv81_or_later/srm/dashboard/resources/views/dashboard/charts/pdf/details.blade.php ENDPATH**/ ?>