<div class="modal fade" id="<?php echo e($id); ?>-modal" tabindex="-1" role="dialog" aria-labelledby="<?php echo e($id); ?>-modal"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <div class="modal-content custom-rounded-edges">
            <div class="modal-header">
                <h5 class="modal-title ml-3" id="exampleModalLongTitle">
                    <i class="fa-solid fa-users mx-2"></i>
                    Group Details
                </h5>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>

            <div class="modal-body mx-4 my-3">
                <form data-url="<?php echo e(route('groups.store')); ?>" id="<?php echo e($id); ?>-form">
                    <?php echo csrf_field(); ?>
                    <div class="form-group">

                        <label for="name" class="mr-2 h5">Group Name</label>
                        <input type="text" class="form-control" id="group-name" name="name"
                            placeholder="Enter group name">

                    </div>
                    <?php if($modules->count()): ?>
                    <h5>Permissions</h5>
                    <div class="accordion my-3" id="mainaccordion">
                        <?php $__currentLoopData = $modules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $module): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="card">
                            <div class="card-header" id="<?php echo e(str_replace([' / ',' '],'-',$module->name)); ?>-heading"
                                data-toggle="collapse"
                                data-target="#<?php echo e(str_replace([' / ',' '],'-',$module->name)); ?>-collapse"
                                aria-expanded="true"
                                aria-controls="<?php echo e(str_replace([' / ',' '],'-',$module->name)); ?>-collapse">
                                <h5 class="mb-0">
                                    <!-- <input type="checkbox" id="checkboxOne">  -->
                                    <label for="checkboxOne" class="mt-1"> <?php echo $module->logo; ?> <?php echo e($module->name); ?></label>
                                </h5>
                            </div>

                            <div id="<?php echo e(str_replace([' / ',' '],'-',$module->name)); ?>-collapse" class="collapse show"
                                aria-labelledby="headingOne">
                                <div class="card-body row" style="
                                max-height: 150px;
                                overflow-y: scroll;
                                overflow-x: hidden;
                                width: 100%;
                            ">
                                    <div class="col-12">
                                        <div>
                                            <input type="checkbox" id="can-create-<?php echo e($module->name); ?>"
                                                name="permissions[create][]" value="<?php echo e($module->id); ?>">
                                            <span for="can-create-<?php echo e($module->name); ?>" class="mx-1">Can Create New <?php echo e($module->name); ?></span>
                                            <span class="tool-question mx-2" data-toggle="tooltip" data-placement="top"
                                                title=""
                                                data-original-title="Selecting this checkbox grants users within this group permission to create new <?php echo e($module->name); ?>. The user creating the new <?php echo e($module->name); ?> will also have the ability to edit and delete them.">
                                                <i class="fa-solid fa-circle-question"></i>
                                            </span>

                                        </div>
                                    </div>
                                    <?php if($module->resources->count() || $module->children->count()): ?>

                                    <div class="col-12">
                                        <label for="" class="mb-1 mt-2"> <i class="fa-solid fa-eye fa-fw"></i> Access
                                            Existing <?php echo e($module->name); ?></label>
                                        <span class="tool-question mx-2" data-toggle="tooltip" data-placement="top"
                                            title=""
                                            data-original-title="Check the checkboxes next to the <?php echo e($module->name); ?> to grant access to users in this group.">
                                            <i class="fa-solid fa-circle-question"></i>
                                        </span>

                                    </div>
                                    <!-- Three children with checkboxes -->
                                    <?php $__currentLoopData = $module->resources; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $resource): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="col-4 mt-2">
                                        <div>
                                            <input type="checkbox" id="can-access-<?php echo e($resource->name); ?>"
                                                name="permissions[access][]" value="<?php echo e($resource->id); ?>">
                                            <span for="can-access-<?php echo e($resource->name); ?>" class="mx-1"><?php echo e($resource->name); ?></span>
                                        </div>
                                    </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    <?php $__currentLoopData = $module->children; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php $__currentLoopData = $child->resources; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $resource): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="col-4 mt-2">
                                        <div>
                                            <input type="checkbox" id="can-access-<?php echo e($resource->name); ?>"
                                                name="permissions[access][]" value="<?php echo e($resource->id); ?>">
                                            <span for="can-access-<?php echo e($resource->name); ?>" class="mx-1"><?php echo e($resource->name); ?></span>
                                        </div>
                                    </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <?php endif; ?>

                    <div class="text-center">
                        <button type="button" id="saveBtn-<?php echo e($id); ?>" class="btn btn-primary mx-2 px-5 py-2 my-2">
                            Save
                        </button>
                        <button type="button" class="btn btn-light mx-2 px-5 py-2 my-2" id="cancelBtn-<?php echo e($id); ?>"
                            data-dismiss="modal">
                            Cancel
                        </button>

                    </div>
                    <div class="col-md-12 mt-3">
                        <div id="<?php echo e($id); ?>-confirm" class="alert bootstrap-alert-success mx-4 mb-3" role="alert"
                            style="display: none">
                        </div>
                        <div id="<?php echo e($id); ?>-error" class="alert bootstrap-alert-danger mx-4 mb-3" role="alert"
                            style="display: none">
                        </div>

                    </div>
                </form>
            </div>
        </div>
    </div>
</div><?php /**PATH /var/www/html/srm_phpv81_or_later/srm/dashboard/resources/views/dashboard/users/partials/_group-modal.blade.php ENDPATH**/ ?>