<?php $__env->startSection('content'); ?>

<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Profile</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Home</a></li>
                        <li class="breadcrumb-item active">Profile</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <div class="content">
        <div class="container-fluid">
            <div class="row">
                <?php if(auth()->user()->isAdminOrOwner()): ?>
                <div class="col-lg-6">
                    <div class="card bg-white">
                        <div class="card-header">
                            <div class="d-flex justify-content-between">
                                <h3 class="card-title font-weight-bold">
                                    <i class="fa-solid fa-briefcase mr-2"></i>Organization
                                    details
                                </h3>
                            </div>
                        </div>
                        <form id="organization-form" data-url="<?php echo e(route('profile.updateOrganizationDetails')); ?>">
                            <?php echo csrf_field(); ?>
                            <div class="card-body">
                                <div class="form-group">
                                    <label for="organizationInputName">Organization Name</label>
                                    <div class="d-flex">
                                        <input type="text" class="form-control" id="organizationInputName"
                                            placeholder="Organization Name" name="name" <?php if(checkDemo()): ?>
                                            value="<organization>" <?php else: ?> <?php endif; ?>
                                            value="<?php echo e(isset($organization_details->name) ? $organization_details->name : ''); ?>" />
                                        <span class="tool-question mx-2 d-flex align-items-center" data-toggle="tooltip"
                                            data-placement="top" title="The title of your company or organization.">
                                            <i class="fa-solid fa-circle-question"></i>
                                        </span>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="organizationContactInformation">Organization Contact
                                        Information</label>
                                    <div class="d-flex">
                                        <textarea class="form-control" id="organizationContactInformation" rows="2"
                                            placeholder="Organization Contact Information"
                                            name="contact_info"><?php if(checkDemo()): ?>organization contact <?php else: ?> <?php echo e(isset($organization_details->contact_info) ? $organization_details->contact_info : ''); ?> <?php endif; ?></textarea>
                                        <span class="tool-question mx-2 d-flex align-items-center" data-toggle="tooltip"
                                            data-placement="top"
                                            title="The contact information for your company or organization, comprising email, phone, URL, or address. Please note that these details may be used to customize your reports, such as by adding them to the headers or footers of the reports.">
                                            <i class="fa-solid fa-circle-question"></i>
                                        </span>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="logo">Logo</label>
                                    <div class="input-group">
                                        <div class="custom-file">
                                            <button type="button" class="btn btn-primary" data-toggle="modal"
                                                data-target="#exampleModalCenter">
                                                Select Logo
                                            </button>

                                            <!-- Modal -->
                                            <div class="modal fade" id="exampleModalCenter" tabindex="-1" role="dialog"
                                                aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                                                <div class="modal-dialog modal-dialog-centered" role="document">

                                                    <div class="modal-content custom-rounded-edges">
                                                        <div class="modal-header">
                                                            <form action=""></form>
                                                            <h5 class="modal-title" id="exampleModalLongTitle">
                                                                Organization Logo
                                                            </h5>

                                                            <button type="button" class="close" data-dismiss="modal"
                                                                aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <form id="logo-form" enctype="multipart/form-data"
                                                            data-url="<?php echo e(route('profile.storeOrganizationLogo')); ?>"
                                                            data-delete="<?php echo e(route('profile.removeOrganizationLogo')); ?>">
                                                            <?php echo csrf_field(); ?>
                                                            <div class="modal-body">
                                                                <div class="form-group">
                                                                    <div class="d-flex justify-content-center">
                                                                        <img id="displayImage"
                                                                            src="<?php echo e(isset($organization_details->logo) ? $organization_details->getLogo() : get_asset('dist/images/2.png')); ?>"
                                                                            alt="Selected Image"
                                                                            class="centered-image my-2 mx-2" style="
                                                                            max-width: 100%;
                                                                            max-height: 100%;
                                                                        " data-width="<?php echo e(config('srm_config.dashboard.organization_logo.width',234)); ?>"
                                                                            data-height="<?php echo e(config('srm_config.dashboard.organization_logo.height',100)); ?>"
                                                                            data-original-src="<?php echo e(get_asset('dist/images/2.png')); ?>" />
                                                                    </div>

                                                                    <div class="input-group">
                                                                        <div class="custom-file">
                                                                            <input type="file" class="custom-file-input"
                                                                                id="logo" accept="image/*" name="logo"
                                                                                oninput="displaySelectedImage()" />
                                                                            <label class="custom-file-label" for="logo"
                                                                                id="logoLabel">Choose an
                                                                                Image</label>
                                                                        </div>

                                                                        <span
                                                                            class="tool-question mx-2 d-flex align-items-center"
                                                                            data-toggle="tooltip" data-placement="top"
                                                                            title="Please provide the logo for your company or organization in JPG, JPEG, or PNG format.">
                                                                            <i class="fa-solid fa-circle-question"></i>
                                                                        </span>
                                                                    </div>
                                                                </div>
                                                                <div class="text-center">
                                                                    <input type="button"
                                                                        class="btn btn-primary mx-2 px-5 py-2"
                                                                        value="Save" id="saveBtn-Logo">

                                                                    <input type="button"
                                                                        class="btn btn-danger mx-2 px-5 py-2"
                                                                        id="cancelBtn-Logo" value="Delete">

                                                                </div>
                                                        </form>

                                                        <div id="confirm-Logo"
                                                            class="alert bootstrap-alert-success my-2" role="alert"
                                                            style="display: none">
                                                        </div>

                                                        <div id="error-Logo" class="alert bootstrap-alert-danger my-2"
                                                            role="alert" style="display: none">
                                                        </div>

                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <span class="tool-question mx-2 d-flex align-items-center" data-toggle="tooltip"
                                        data-placement="top"
                                        title="Please provide the logo for your company or organization in JPG, JPEG, or PNG format.">
                                        <i class="fa-solid fa-circle-question"></i>
                                    </span>
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="taxInfo">Tax Info</label>
                                <div class="d-flex">
                                    <textarea class="form-control" id="taxInfo" rows="2" placeholder="Tax Info"
                                        name="tax_info"><?php if(checkDemo()): ?>Tax info <?php else: ?> <?php echo e(isset($organization_details->tax_info) ? $organization_details->tax_info : ''); ?> <?php endif; ?> </textarea>
                                    <span class="tool-question mx-2 d-flex align-items-center" data-toggle="tooltip"
                                        data-placement="top"
                                        title="Tax details for your company or organization such as VAT ID, if applicable. You may need to utilize this information in certain reports, such as invoices.">
                                        <i class="fa-solid fa-circle-question"></i>
                                    </span>
                                </div>
                            </div>
                            <div class="text-center">
                                <input type="button" class="btn btn-primary mx-2 px-5 py-2" value="Save"
                                    id="saveBtn-organization">

                                <input type="button" class="btn btn-secondary mx-2 px-5 py-2"
                                    id="cancelBtn-organization" value="Cancel">

                            </div>

                            <div id="confirm-organization" class="alert bootstrap-alert-success my-2" role="alert"
                                style="display: none">
                            </div>

                            <div id="error-organization" class="alert bootstrap-alert-danger my-2" role="alert"
                                style="display: none">
                            </div>

                    </div>
                    </form>
                </div>
            </div>
            <?php endif; ?>
            <div class="<?php echo e(auth()->user()->isAdminOrOwner() ? 'col-lg-6' : 'col-lg-12'); ?>">
                <div class="card bg-white">
                    <div class="card-header">
                        <div class="d-flex justify-content-between">
                            <h3 class="card-title font-weight-bold">
                                <i class="fa-solid fa-user mr-2"></i>Contact Details
                            </h3>
                        </div>
                    </div>
                    <form id="profile-form" data-url="<?php echo e(route('profile.updateContactDetails')); ?>">
                        <?php echo csrf_field(); ?>
                        <div class="card-body">
                            <div class="form-group">
                                <label for="firstName">First Name</label>
                                <input type="text" class="form-control" id="firstName" name="first_name"
                                    placeholder="First Name" <?php if(checkDemo()): ?> value="<first name>" <?php else: ?>
                                    value="<?php echo e(auth()->user()->first_name); ?>" <?php endif; ?> />
                            </div>
                            <div class="form-group">
                                <label for="lastName">Last Name</label>
                                <input type="text" class="form-control" id="lastName" name="last_name"
                                    placeholder="Last Name" <?php if(checkDemo()): ?> value="<last name>" <?php else: ?>
                                    value="<?php echo e(auth()->user()->last_name); ?>" <?php endif; ?> />
                            </div>
                            <div class="form-group">
                                <label for="userName">User Name</label>
                                <input type="text" class="form-control" id="userName" name="user_name"
                                    placeholder="User Name" <?php if(checkDemo()): ?> value="<username>" <?php else: ?>
                                    value="<?php echo e(auth()->user()->user_name); ?>" <?php endif; ?> />
                            </div>
                            <div class="form-group">
                                <label for="email">Email</label>
                                <label type="email" class="d-block" id="email" placeholder="Email">
                                    <?php if(checkDemo()): ?>
                                    &lt;Email&gt;
                                    <?php else: ?>
                                    <?php echo e(auth()->user()->Email); ?>

                                    <?php endif; ?>
                                </label>
                            </div>
                            <div class="form-group">
                                <label for="phone">Phone</label>
                                <input type="tel" class="form-control" id="phone" name="Phone" placeholder="Phone"
                                    <?php if(checkDemo()): ?> value="<phone>" <?php else: ?> value="<?php echo e(auth()->user()->Phone); ?>" <?php endif; ?> />
                            </div>
                            <div class="form-group">
                                <label for="securityQuestion">Security Question</label>
                                <select class="form-control" id="securityQuestion" name="Security_question_index">
                                    <option value="">Please Select Security Question</option>
                                    <?php $__currentLoopData = $security_questions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index=>$question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($index); ?>" <?php echo e(auth()->user()->Security_question_index ===$index
                                        ? 'selected' : ''); ?>><?php echo e($question); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="answer">Answer</label>
                                <input type="text" class="form-control" id="answer" name="Security_answer"
                                    placeholder="Answer" <?php if(checkDemo()): ?> value="<Security answer>" <?php else: ?>
                                    value="<?php echo e(auth()->user()->Security_answer); ?>" <?php endif; ?> />
                            </div>

                            <div class="text-center">
                                <input type="button" class="btn btn-primary mx-2 px-5 py-2" value="Save"
                                    id="saveBtn-contact">

                                <input type="button" class="btn btn-secondary mx-2 px-5 py-2" id="cancelBtn-contact"
                                    value="Cancel">

                            </div>

                            <div id="confirm-contact" class="alert bootstrap-alert-success my-2" role="alert"
                                style="display: none">
                            </div>

                            <div id="error-contact" class="alert bootstrap-alert-danger my-2" role="alert"
                                style="display: none">
                            </div>
                        </div>

                    </form>
                </div>

                <div class="card bg-white">
                    <div class="card-header">
                        <div class="d-flex justify-content-between">
                            <h3 class="card-title font-weight-bold">
                                <i class="fa-solid fa-lock mr-2"></i>Change Password
                            </h3>
                        </div>
                    </div>
                    <form id="changepassword-form" data-url="<?php echo e(route('profile.changePassword')); ?>">
                        <?php echo csrf_field(); ?>
                        <div class="card-body">
                            <div class="form-group">
                                <label for="password">Current Password</label>
                                <input type="password" class="form-control" id="currentpassword" name="currentpassword"
                                    placeholder="Current Password" />
                            </div>
                            <div class="form-group">
                                <label for="contactName">New Password</label>
                                <input type="password" class="form-control" id="password" name="password"
                                    placeholder="Password" />
                            </div>
                            <div class="form-group">
                                <label for="confirmPassword">Confirm Password</label>
                                <input type="password" class="form-control" id="password_confirmation"
                                    name="password_confirmation" placeholder="Confirm Password" />
                            </div>
                            <div class="text-center">
                                <input type="button" class="btn btn-primary mx-2 px-5 py-2" value="Save"
                                    id="saveBtn-changepassword">

                                <input type="button" class="btn btn-secondary mx-2 px-5 py-2"
                                    id="cancelBtn-changepassword" value="Cancel">
                            </div>

                            <div id="confirm-changepassword" class="alert bootstrap-alert-success my-2"
                                style="display: none" role="alert">

                            </div>
                            <div id="error-changepassword" class="alert bootstrap-alert-danger my-2"
                                style="display: none" role="alert">
                            </div>

                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script src="<?php echo e(get_asset('dist/js/profile.js')); ?>" defer>
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/srm_phpv81_or_later/srm/dashboard/resources/views/dashboard/profile/index.blade.php ENDPATH**/ ?>