<div class="modal fade" id="add-joins-modal" tabindex="-1" role="dialog" aria-labelledby="activate-user-modal"
    aria-modal="true">
    <div class="modal-dialog modal-dialog-centered  modal-lg" role="document">
        <div class="modal-content custom-rounded-edges">
            <div class="modal-header">
                <h5 class="modal-title ml-2" id="joins-title">
                    Add joins
                </h5>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <form id="add-join-form">
                <?php echo csrf_field(); ?>

                <div class="modal-body mx-3 my-2">
                    <div class="modal-spinner" style="display: none"></div>
                    <div class="modal-container">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="primary-table">Primary table</label>
                                    <i class="fa fa-question-circle" data-toggle="tooltip"
                                        data-title="Select the main table that contains the primary key in the relationship."
                                        style="color: #68b3c8;" data-original-title="" title="">
                                    </i>

                                    <select class="form-control" id="primary-table" name="primary_table"
                                        data-url="<?php echo e(route('data_connections.index')); ?>">
                                        <option value="">Please Select Table</option>
                                        <?php $__currentLoopData = $tables; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $table): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($table); ?>"><?php echo e($table); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6" id="report-list-container">
                                <div class="form-group">
                                    <label for="foreign-table">Foreign table</label>
                                    <i class="fa fa-question-circle" data-toggle="tooltip"
                                        data-title="Select the related table that contains the foreign key linking to the primary table."
                                        style="color: #68b3c8;" data-original-title="" title="">
                                    </i>

                                    <select class="form-control" id="foreign-table" name="foreign_table"
                                        data-url="<?php echo e(route('data_connections.index')); ?>">
                                        <option value="">Please Select Table</option>
                                        <?php $__currentLoopData = $tables; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $table): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($table); ?>"><?php echo e($table); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="primary-key">Primary key</label>
                                    <i class="fa fa-question-circle" data-toggle="tooltip"
                                        data-title="Select the primary key column from the selected Primary Table."
                                        style="color: #68b3c8;" data-original-title="" title="">
                                    </i>

                                    <select class="form-control" id="primary-key" name="primary_key">
                                        <option value="">Please Select Key</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="foreign-key">Foreign key</label>
                                    <i class="fa fa-question-circle" data-toggle="tooltip"
                                        data-title="Select the foreign key column from the selected Foreign Table that references the primary key."
                                        style="color: #68b3c8;" data-original-title="" title="">
                                    </i>

                                    <select class="form-control" id="foreign-key" name="foreign_key">
                                        <option value="">Please Select Key</option>
                                    </select>
                                </div>
                            </div>

                        </div>
                        <div>
                            <div class="form-group">
                                <label for="join-type">Join type</label>
                                <i class="fa fa-question-circle" data-toggle="tooltip"
                                    data-title="Choose the type of join: Inner Join (default) retrieves matching rows from both tables, while Left Join retrieves all rows from the primary table and matching rows from the foreign table."
                                    style="color: #68b3c8;" data-original-title="" title="">
                                </i>

                                <div class="row">
                                    <div class="col-md-2">
                                        <div class="form-check">
                                            <input class="form-check-input" type="radio" name="join_type"
                                                id="inner-join" value="inner" checked>
                                            <label class="form-check-label" for="inner-join">Inner Join</label>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-check">
                                            <input class="form-check-input" type="radio" name="join_type"
                                                id="left-outer-join" value="left">
                                            <label class="form-check-label" for="left-outer-join">Left Outer
                                                Join</label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="modal-footer justify-content-center">
                            <div class="text-center">
                                <button type="button" id="saveBtn-add-join" class="btn btn-primary mx-2 px-5 py-2">
                                    Save
                                </button>
                                <button type="button" id="cancelBtn-add-join" class="btn btn-light mx-2 px-5 py-2"
                                    data-dismiss="modal">
                                    Cancel
                                </button>
                                <div class="mt-3">
                                    <div id="add-join-confirm" class="alert bootstrap-alert-success mx-4 mb-3"
                                        role="alert" style="display: none">
                                    </div>
                                    <div id="add-join-error" class="alert bootstrap-alert-danger mx-4 mb-3" role="alert"
                                        style="display: none">
                                    </div>
                                </div>

                            </div>

                        </div>
                    </div>
                </div>
            </form>

        </div>
    </div>
</div>
<?php /**PATH /var/www/html/srm_phpv81_or_later/srm/dashboard/resources/views/dashboard/pivot-tables/partials/joins-modal.blade.php ENDPATH**/ ?>