<aside class="main-sidebar sidebar-dark-primary sidebar-no-expand elevation-4">
    <div class="bg-white p-2 branding-logo">
        <a href="<?php echo e(route('home')); ?>">
            <?php if(is_null(getSettingsValue('system_logo'))): ?>
            <img src="<?php echo e(get_asset('dist/images/srm-logo.jpg')); ?>" alt="Logo" class="brand-image img-fluid" />
            <?php else: ?>
            <img src="<?php echo e(getSystemLogo()); ?>" alt="Logo" class="brand-image img-fluid" />
            <?php endif; ?>
        </a>
    </div>
    <div class="sidebar">
        <div class="user-panel py-2 d-flex">
            <div class="image py-1">
                <i class="fa-regular fa-circle-user"></i>
            </div>
            <div class="info">
                <span href="#" class="d-block">Welcome

                    <a class="text-white" href="<?php echo e(route('profile.index')); ?>">
                        <?php if(checkDemo()): ?>
                        admin
                        <?php else: ?>
                        <?php echo e(isset(auth()->user()->user_name) ? auth()->user()->user_name :''); ?>

                        <?php endif; ?>
                    </a></span>

            </div>
        </div>
        <nav class="mt-2">
            <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu" data-accordion="false">
                <li class="nav-item">
                    <a href="<?php echo e(route('home')); ?>"
                        class="nav-link home-page <?php echo e(Route::currentRouteNamed('home') ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-home"></i>
                        <p>Home</p>
                    </a>
                </li>
                <li class="nav-item dashboard-page <?php echo e(Route::currentRouteNamed('dashboards.*') ? 'menu-open' : ''); ?>">
                    <a href="#" class="nav-link">
                        <i class="nav-icon fas fa-tachometer-alt"></i>
                        <p>
                            Dashboards
                            <i class="right fas fa-angle-left"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview" id="dashboard-aside-container">
                        <li class="nav-item">
                            <a href="<?php echo e(route('dashboards.index')); ?>"
                                class="nav-link <?php echo e(Route::currentRouteNamed('dashboards.index') ? 'active' : ''); ?>">
                                <i class="nav-icon fas fa-tachometer-alt"></i>
                                <p>Dashboard Manager</p>
                            </a>
                        </li>
                        <?php $__currentLoopData = $userDashboards; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $userDashboard): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                        <li class="nav-item">
                            <a href="<?php echo e(route('dashboards.show',[$userDashboard->id])); ?>" class="nav-link <?php echo e(Route::currentRouteNamed('dashboards.show') && request()->
                            route('dashboard')->id == $userDashboard->id ? 'active' : ''); ?>">
                                <i class="nav-icon fa fa-fw" style="font-family: 'FontAwesome'"> <?php echo '&'.
                                    $userDashboard->icon; ?></i>

                                
                                <p><?php echo e($userDashboard->name); ?></p>
                            </a>
                        </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </li>
                <li class="nav-item">
                    <a href="<?php echo e(route('reports.index')); ?>"
                        class="nav-link reports-page <?php echo e(Route::currentRouteNamed('reports.*') ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-chart-simple"></i>
                        <p>Reports</p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="<?php echo e(route('pivot-tables.index')); ?>"
                        class="nav-link pivot-tables-page <?php echo e(Route::currentRouteNamed('pivot-tables.*') ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-table"></i>
                        <p>Pivot Tables
                            <?php if(checkDemo()): ?>
                            <img src="<?php echo e(get_asset('dist/images/new.png')); ?>" alt="new"
                            class="ml-1">
                            <?php endif; ?>
                        </p>
                    </a>
                </li>
                <?php if(auth()->user()->isAdminOrOwner()): ?>
                <li class="nav-item">
                    <a href="<?php echo e(route('scheduled-reports.index')); ?>"
                        class="nav-link scheduled-reports-page <?php echo e(Route::currentRouteNamed('scheduled-reports.*') ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-calendar-days"></i>
                        <p>Scheduled Reports</p>
                    </a>
                </li>
                <?php endif; ?>
                <li class="nav-item">
                    <a href="<?php echo e(route('charts.index')); ?>"
                        class="nav-link charts-page <?php echo e(Route::currentRouteNamed('charts.*') ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-chart-line"></i>
                        <p>Charts</p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="<?php echo e(route('metrics.index')); ?>"
                        class="nav-link kpis-page <?php echo e(Route::currentRouteNamed('metrics.*') ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-timeline"></i>
                        <p>KPIs / Metrics</p>
                    </a>
                </li>
                <?php if(auth()->user()->isAdminOrOwner()): ?>
                <li
                    class="nav-item <?php echo e((Route::currentRouteNamed('general.index') || Route::currentRouteNamed('data_connections.index') ||
                Route::currentRouteNamed('categories.index') || Route::currentRouteNamed('users.index') || (!checkDemo() && !isCheckedGuidedTour())) ? 'menu-open' : ''); ?>">
                    <a href="#" class="nav-link">
                        <i class="nav-icon fa-solid fa-gear"></i>
                        <p>
                            Settings
                            <i class="right fas fa-angle-left"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="<?php echo e(route('general.index')); ?>"
                                class="nav-link <?php echo e(Route::currentRouteNamed('general.index') ? 'active' : ''); ?>">
                                <i class="nav-icon fa-solid fa-wrench"></i>
                                <p>General</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="<?php echo e(route('data_connections.index')); ?>"
                                class="nav-link data-connection-page <?php echo e(Route::currentRouteNamed('data_connections.index') ? 'active' : ''); ?>">
                                <i class="nav-icon fa-solid fa-database"></i>
                                <p>Data Connections</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="<?php echo e(route('categories.index')); ?>"
                                class="nav-link <?php echo e(Route::currentRouteNamed('categories.index') ? 'active' : ''); ?>">
                                <i class="nav-icon fas fa-list-alt"></i>
                                <p>Categories</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="<?php echo e(route('users.index')); ?>"
                                class="nav-link <?php echo e(Route::currentRouteNamed('users.index') ? 'active' : ''); ?>">
                                <i class="nav-icon fa-solid fa-users"></i>
                                <p>Users</p>
                            </a>
                        </li>
                    </ul>
                </li>
                <?php endif; ?>
            </ul>
        </nav>
    </div>
</aside>
<?php /**PATH /var/www/html/srm_phpv81_or_later/srm/dashboard/resources/views/partials/_aside.blade.php ENDPATH**/ ?>