<div class="row">
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title"><i class="fas fa-cog"></i> General Settings</h5>
            </div>
            <div class="card-body">
                <div class="form-group">
                    <label for="category" class="form-label">Category</label>
                    <i class="fa fa-question-circle" data-toggle="tooltip"
                        data-title="The category where you want to organize the pivot table. Categories act as folders, helping you classify and manage your resources efficiently on the manage page."
                        style="color: #68b3c8; margin-left: 5px" data-original-title="" title="">
                    </i>
                    <select name="category" id="category" class="form-control">
                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($category->id); ?>" <?php if(isset($pivotTable) && $pivotTable->category_id == $category->id): ?>
                            selected
                            <?php endif; ?>><?php echo e($category->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <div class="form-group">
                    <label for="combine-filters" class="form-label">Combine Filters By</label>
                    <i class="fa fa-question-circle" data-toggle="tooltip"
                        data-title='You can choose to group all filtering conditions using "AND" (default) or "OR", depending on how you want the filters to be applied.'
                        style="color: #68b3c8; margin-left: 5px" data-original-title="" title="">
                    </i>
                    <select name="combine_filters" id="combine-filters" class="form-control">
                        <option value="and" <?php echo e(isset($pivotTable) && $pivotTable->getResourceConfiguration('combine_filters') == "and" ? 'selected' : ''); ?>>And</option>
                        <option value="or" <?php echo e(isset($pivotTable) && $pivotTable->getResourceConfiguration('combine_filters') == "or" ? 'selected' : ''); ?>>Or</option>
                    </select>
                </div>

                <div class="form-group form-check">
                    <?php
                        $defaultShowGrandTotals = isset($pivotTable)
                            ? $pivotTable->getResourceConfiguration('show_grand_totals')
                            : true; // Default to checked on create
                    ?>

                    <input type="hidden" name="show_grand_totals" value="0">

                    <input type="checkbox" class="form-check-input" id="show-grand-totals"
                        name="show_grand_totals" value="1" <?php echo e($defaultShowGrandTotals ? 'checked' :''); ?>>

                    <label for="show-grand-totals" class="form-label">Show Grand Totals</label>
                </div>

            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title"><i class="fas fa-lock"></i> Access Settings</h5>
            </div>
            <div class="card-body">
                <div class="form-group">
                    <label for="access-level" class="form-label">Access Level</label>
                    <i class="fa fa-question-circle" data-toggle="tooltip" data-html="true"
                        data-title="Choose who can view the pivot table:
                        <br>• Private: Only users in specific groups can view the pivot table<br>• Public: Anyone with the URL can access it without logging in. Use this if you plan to share or embed it on a public webpage"
                        style="color: #68b3c8; margin-left: 5px" data-original-title="" title="">
                    </i>

                    <select name="access_level" id="access-level" class="form-control">
                        <option value="private" <?php echo e(isset($pivotTable) && $pivotTable->getResourceConfiguration('access_level') == "private" ? 'selected' : ''); ?>>Private</option>
                        <option value="public" <?php echo e(isset($pivotTable) && $pivotTable->getResourceConfiguration('access_level') == "public" ? 'selected' : ''); ?>>Public</option>
                    </select>
                </div>
                <div class="form-group">
                    <label for="groups" class="form-label">Allowed Groups</label>
                    <i class="fa fa-question-circle" data-toggle="tooltip"
                        data-title="Select the user groups that will have access to the pivot table if the private access level is chosen."
                        style="color: #68b3c8; margin-left: 5px" data-original-title="" title="">
                    </i>

                    <select name="groups[]" id="groups" class="form-control" style="height: 125px;" multiple>
                        <?php $__currentLoopData = $groups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($group->group_ID); ?>" <?php if(isset($pivotTable) && $pivotTable->
                            resource_permissions->contains('group_ID', $group->group_ID)): ?>
                            selected
                            <?php elseif(!auth()->user()->isAdminOrOwner() && auth()->user()->group_id == $group->group_ID): ?>
                            selected
                            <?php endif; ?>
                            ><?php echo e($group->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /var/www/html/srm_phpv81_or_later/srm/dashboard/resources/views/dashboard/pivot-tables/partials/_options.blade.php ENDPATH**/ ?>