@extends('layouts.app')

@section('styles')
<!-- DataTables -->
<link rel="stylesheet" href="{{ get_asset('dist/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css'). '?v='. $srmVersion}}">
<link rel=" stylesheet" href="{{ get_asset('dist/plugins/datatables-responsive/css/responsive.bootstrap4.min.css'). '?v='. $srmVersion}}">
<link rel=" stylesheet" href="{{ get_asset('dist/plugins/datatables-buttons/css/buttons.bootstrap4.min.css'). '?v='. $srmVersion}}">
<link rel=" stylesheet" href="{{ get_asset('dist/plugins/datatables-rowgroup/css/rowGroup.bootstrap4.min.css'). '?v='. $srmVersion}}">

<style>
    .group-start {
        cursor: pointer;
        background-color: #e4e3e3 !important;
        user-select: none;
    }

    .toggle-box {
        display: inline-block;
        width: 20px;
        height: 20px;
        line-height: 20px;
        text-align: center;
        border: 1px solid #ccc;
        border-radius: 4px;
        background-color: #f9f9f9;
        color: #333;
        font-weight: bold;
        cursor: pointer;
        margin-right: 10px;
    }

    .toggle-box:hover {
        background-color: #ddd;
    }
</style>
@endsection

@section('content')

@include('dashboard.reports.partials.success-modal')


@include('dashboard.reports.partials._reports-confirmation-modal',[
'id' => 'delete-report',
'modal_title' =>'Delete Confirmation',
'method'=> 'DELETE'
])

<div id="change-category-modal-container">

</div>


<div id="display-blank-report-modal-container">
    @include('dashboard.reports.blank-reports.show')
</div>

<div id="edit-report-modal-container">
    @include('dashboard.reports.blank-reports.edit')
</div>
@if((isset($blankReportModule) && $blankReportModule->checkWhoCanAccessModule()) || auth()->user()->isAdminOrOwner())

<div id="create-report-modal-container">
    @include('dashboard.reports.blank-reports.create')
</div>

@endif
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2 mt-2">
                <div class="col-sm-6">
                    <h3> <i class="fa-solid fa-file-text mx-2"></i> Reports</h3>

                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                        <li class="breadcrumb-item">Reports</li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
        <div class="container-fluid mt-5">
            <!-- Use container-fluid for full-width -->

            <div class="form-group mx-2">
                <div class="row">
                    <div class="{{ auth()->user()->isAdminOrOwner() ? 'col-md-6' : 'col-md-12' }}">

                        <form>
                            <div class="form-group">
                                <label for="category-search">Category</label>
                                <select class="form-control" id="category-search">
                                    @if(isset($categories))
                                    <option value="">Choose Category</option>
                                    @foreach($categories as $category)
                                    <option value="{{ $category->name }}">{{ $category->name }}</option>
                                    @endforeach
                                    @endif
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="connection-name-search">Report Name</label>
                                <input type="text" class="form-control" id="report-name-search">
                            </div>

                        </form>
                    </div>
                    @if(auth()->user()->isAdminOrOwner())
                    <div class="col-md-6">
                        <!-- Second column -->
                        <form>
                            <div class="form-group">
                                <label for="creator-search">Creator</label>
                                <select class="form-control" id="creator-search">
                                    <option value="">Choose Creator</option>
                                    @php $i = 0 ; @endphp
                                    @foreach ($users as $user)
                                    @if(checkDemo())
                                    <option value="{{ '<user ' .++$i . '>' }}">{{ '<user ' .$i . '>' }}</option>
                                    @else
                                    <option value="{{ $user->user_name }}">{{ $user->user_name }}</option>
                                    @endif
                                    @endforeach
                                </select>
                            </div>
                            {{-- <div class="form-group">
                                <label for="databases-search">Data Bases</label>
                                <select class="form-control" id="databases-search">
                                    <option value="">All</option>
                                    @foreach ($databases as $database)
                                    <option value="{{ $database }}">{{ $database }}</option>
                                    @endforeach
                                </select>
                            </div> --}}
                        </form>
                    </div>
                    @endif

                </div>

                <div class="form-group text-center mt-3">
                    <button class="btn btn-primary px-3 py-2 my-2 my-sm-0 srm-button search-filter" type="submit"><i
                            class="fas fa-search"></i> Search</button>
                    <button class="btn btn-outline-primary px-3 py-2 my-2 ml-2 my-sm-0 srm-button reset-filter"
                        type="button"><i class="fa-solid fa-eye"></i> Show All</button>
                </div>
                <div class="card-body mt-2 d-flex justify-content-end">
                    @if((isset($blankReportModule) && $blankReportModule->checkWhoCanAccessModule()) ||
                    auth()->user()->isAdminOrOwner())
                    <button class="btn btn-primary create-report px-3 py-2 float-right srm-button" type="button"
                        data-url="{{ route('reports.create') }}">
                        <i class="fas fa-plus"></i> Add New Report
                    </button>
                    @endif
                </div>


                <div class="card-body">
                    <table id="reports" class="table table-bordered table-hover">
                        <thead>
                            <tr>
                                <th>Name</th>
                                <th>Category</th>
                                <th>order</th>
                                <th>Creator</th>
                                <th>Creation Date</th>
                                <th>Access Control</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @php
                            $i=1;
                            @endphp
                            @foreach($reports as $report)
                            <tr>
                                <td><a data-display="inside_page" data-url="{{ route('reports.show',$report->id) }}"
                                        class="text-black display-report" style="cursor:pointer">{{
                                        $report->name }}</a></td>
                                <td>@if(strpos($report->category->icon, '<i class') !==false) {!!
                                        $report->category->icon !!}
                                        @else
                                        <i class="fa fa-fw" style="font-family: 'FontAwesome'"> {!! '&'.
                                            $report->category->icon
                                            !!}</i>
                                        @endif {{ $report->category->name }}</td>
                                <td>{{ $report->category->order }}</td>
                                @if(checkDemo())
                                <td>{{ isset($report->creator) ? $report->report_creator : '' }}</td>
                                @else
                                <td>{{ isset($report->creator) ? $report->creator->user_name : '' }}</td>

                                @endif
                                <td>{{ $report->created_at }}</td>
                                <td>
                                    {{ $report->access_control_type }}
                                    @if($report->access_control_type === "Public")
                                    <span class="tool-question" data-toggle="tooltip" data-placement="top"
                                        title="Access is allowed without authentication.">
                                        <i class="fa-solid fa-circle-question"></i>
                                    </span>

                                    @else
                                    <span class="tool-question" data-toggle="tooltip" data-placement="top"
                                        title="{{
                                            $report->getGroupsCanAccessResource()->isEmpty()
                                                ? 'Access is allowed only by admins.'
                                                : (
                                                    count($report->getGroupsCanAccessResource()) == 1
                                                        ? 'Access is allowed only by ' . $report->getGroupsCanAccessResource()->implode(', ') . ' group.'
                                                        : 'Access is allowed only by ' . $report->getGroupsCanAccessResource()->implode(', ') . ' groups.'
                                                )
                                        }}">

                                        <i class="fa-solid fa-circle-question"></i>
                                    </span>

                                    @endif
                                </td>
                                <td>
                                    <div class="dropdown">
                                        <button type="button" id="ellipsisMenu2" data-toggle="dropdown"
                                            aria-haspopup="true" aria-expanded="false"
                                            style="border:none;background:none">
                                            <!-- Your SVG icon -->
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                                fill="currentColor" class="bi bi-three-dots-vertical"
                                                viewBox="0 0 16 16">
                                                <path
                                                    d="M9.5 13a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0z" />
                                            </svg>
                                        </button>

                                        <div class="dropdown-menu" aria-labelledby="ellipsisMenu">
                                            <a class="dropdown-item display-report"
                                                data-display="{{ config('srm_config.dashboard.report_display') }}"
                                                data-url="{{ route('reports.show',$report->id) }}">Display</a>
                                            @if(
                                            (
                                            isset($report->creator) &&
                                            $report->creator->user_ID == auth()->user()->user_ID
                                            )
                                            ||
                                            auth()->user()->isAdminOrOwner())
                                            <a class="dropdown-item edit-report"
                                                data-url="{{ route('reports.edit',$report->id) }}"
                                                data-display="{{ route('reports.show',$report->id) }}">Edit</a>

                                            <a class="dropdown-item change-category"
                                                data-url="{{ route('reports.getCategories',$report->id) }}">Change
                                                category</a>

                                            <a class="dropdown-item delete-report" data-toggle="modal"
                                                data-target="#delete-report-modal"
                                                data-url="{{ route('reports.destroy',$report->id) }}">Delete</a>
                                            @endif
                                        </div>
                                    </div>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>

                </div>
            </div>

        </div>

</div>


@endsection

@section('scripts')

<script src="{{ get_asset('dist/plugins/datatables/jquery.dataTables.min.js'). '?v='. $srmVersion}}"></script>
<script src="{{ get_asset('dist/plugins/datatables-responsive/js/dataTables.responsive.min.js'). '?v='. $srmVersion}}"></script>
<script src="{{ get_asset('dist/plugins/datatables-responsive/js/responsive.bootstrap4.min.js'). '?v='. $srmVersion}}"></script>
<script src="{{ get_asset('dist/plugins/datatables-buttons/js/dataTables.buttons.min.js'). '?v='. $srmVersion}}"></script>
<script src="{{ get_asset('dist/plugins/datatables-buttons/js/buttons.bootstrap4.min.js'). '?v='. $srmVersion}}"></script>
<script src="{{ get_asset('dist/plugins/jszip/jszip.min.js'). '?v='. $srmVersion}}"></script>
<script src="{{ get_asset('dist/plugins/pdfmake/pdfmake.min.js'). '?v='. $srmVersion}}"></script>
<script src="{{ get_asset('dist/plugins/pdfmake/vfs_fonts.js'). '?v='. $srmVersion}}"></script>
<script src="{{ get_asset('dist/plugins/datatables-buttons/js/buttons.html5.min.js'). '?v='. $srmVersion}}"></script>
<script src="{{ get_asset('dist/plugins/datatables-buttons/js/buttons.print.min.js'). '?v='. $srmVersion}}"></script>
<script src="{{ get_asset('dist/plugins/datatables-buttons/js/buttons.colVis.min.js'). '?v='. $srmVersion}}"></script>
<script src="{{ get_asset('dist/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js'). '?v='. $srmVersion}}"></script>
<script src="{{ get_asset('dist/plugins/datatables-rowgroup/js/dataTables.rowGroup.min.js'). '?v='. $srmVersion}}"></script>
<script src="{{ get_asset('dist/plugins/datatables-rowgroup/js/rowGroup.bootstrap4.min.js'). '?v='. $srmVersion}}"></script>
<script src="{{ get_asset('dist/js/custom-datatables.js'). '?v='. $srmVersion}}"></script>

@if(!checkDemo())
<script src="{{ get_asset('dist/js/reports-datatable.js'). '?v='. $srmVersion}}"></script>
@else
<script src="{{ get_asset('dist/js/reports-datatable-demo.js'). '?v='. $srmVersion}}"></script>
@endif
<script>
    displayUserPanel();
</script>

<script src="{{ get_asset('dist/js/reports.js'). '?v='. $srmVersion}}">
</script>

@if(session('add'))
<script>
    $(document).ready(function() {
            $('.create-report').click();
        });
</script>
@endif

@endsection
