<div class="fields-container d-flex flex-column">

    <div class="mt-2">
        <div class="alert" style="background-color: #DAE8FC" role="alert">
            Drag and drop the required fields from the data source panel to specify the desired columns in different
            sections of the Pivot table.
        </div>

    </div>

    <div class="row align-items-center justify-content-center">
        <div class="col-md-4 col-12 row mb-3 mb-md-0">
            <div class="col-12">
                <div id="row-headers-container" class="row-fluid ui-droppable ui-sortable field-container">
                    <span class="required-star">*</span>
                    <label class="row-headers-label span2 field-label p-1" for="row-headers">Row Headers
                        Field
                            <i class="fa fa-question-circle options" data-bs-placement="right" data-html="true" data-toggle="tooltip" data-title='Drag the desired field to the Row Headings box from the data source panel. For example, to create a pivot table with products as rows, years as columns, and total sales in each cell, drop the product name field into Row Headings. The rows will list products (e.g., "Laptop", "Tablet"), columns will show years, and cells will display total sales per product per year.' style="color: #68b3c8;" data-original-title="" title="">
                            </i>
                    </label>
                    <div class="ul-container">
                        <ul class="fields-ul nav nav-pills span9" id="row-headers">
                        </ul>
                    </div>
                    <div class="text-center">
                        <label class="drop-field-label-first-row">Drop Field Here</label>
                    </div>
                    <input type="text" id="row-headers-textbox" name="row_headers" class="field-textbox"
                    value="{{ isset($pivotTable) && !empty($pivotTable->getResourceConfiguration('row_headers'))  ? $pivotTable->getResourceConfiguration('row_headers') : ""}}"
                    readonly />
                </div>
            </div>
        </div>
        <div class="col-md-4 col-12 row mb-3 mb-md-0">
            <div class="col-12">
                <div id="column-headings-container" class="row-fluid ui-droppable ui-sortable field-container">
                    <span class="required-star">*</span>

                    <label class="column-headings-label span2 field-label p-1" for="column-headings">Column Headings
                        Field
                    <i class="fa fa-question-circle options" data-bs-placement="right" data-html="true" data-toggle="tooltip" data-title='Drag the desired field to the Column Headings box from the data source panel. For example, to display years as columns in a pivot table, drop the "order_date" field here. Then, click the field block to expand it and select the "Year" function to extract only the year. If additional functions are available, an arrow indicator will appear, allowing you to apply them.'
                        style="color: #68b3c8;" data-original-title="" title="">
                    </i>

                    </label>
                    <div class="ul-container">
                        <ul class="fields-ul nav nav-pills span9" id="column-headings">

                        </ul>
                    </div>
                    <div class="text-center">
                        <label class="drop-field-label-first-row">Drop Field Here</label>
                    </div>
                    <input type="text" id="column-headings-textbox" name="column_headings" class="field-textbox"
                        value="{{ isset($pivotTable) && !empty($pivotTable->getResourceConfiguration('column_headings'))  ? $pivotTable->getResourceConfiguration('column_headings') : ""}}"
                        readonly />
                </div>
            </div>
        </div>
        <div class="col-md-4 col-12 row mb-3 mb-md-0">
            <div class="col-12">
                <div id="values-fields-container" class="row-fluid ui-droppable ui-sortable field-container">
                    <span class="required-star">*</span>

                    <label class="values-fields-label span2 field-label p-1" for="values-fields">Values Section
                        Field
                    <i class="fa fa-question-circle options" data-bs-placement="right" data-html="true" data-toggle="tooltip" data-title='Drag the desired field to the Values box from the data source panel to define the data used in pivot table calculations. Use numerical fields for functions like Sum, Average, Min, or Max. For Count and Count Distinct, any data type, including text fields, can be used.'
                        style="color: #68b3c8;" data-original-title="" title="">
                    </i>
                    </label>
                    <div class="ul-container">
                        <ul class="fields-ul nav nav-pills span9" id="values-fields">
                        </ul>
                    </div>
                    <div class="text-center">
                        <label class="drop-field-label-first-row">Drop Field Here</label>
                    </div>
                    <input type="text" id="values-fields-textbox" name="values_fields" class="field-textbox"
                    value="{{ isset($pivotTable) && !empty($pivotTable->getResourceConfiguration('values_fields'))  ? $pivotTable->getResourceConfiguration('values_fields') : ""}}"

                    readonly />
                </div>
            </div>

        </div>
    </div>

    <div class="row mt-3 justify-content-center">
        <div class="col-md-4 col-12 row mb-3 mb-md-0">
            <div class="col-12">
                <div id="joins-container" class="row-fluid ui-droppable ui-sortable field-container">
                    <label class="joins-label span2 field-label p-1 mb-1" for="joins">
                        Joins
                        <i class="fa fa-question-circle options" data-toggle="tooltip"
                            data-title="Use this option only when fields in different pivot table areas come from multiple related tables. In such cases, you may need to define joins based on selected fields to establish relationships between the tables."
                            style="color: #68b3c8;" data-original-title="" title="">
                        </i>
                    </label>
                    <div class="joins-ul-container ul-container">
                        <ul class="fields-ul nav nav-pills span9" id="joins" style="min-height: 90px">
                        </ul>
                    </div>
                    <input type="text" id="joins-textbox" name="joins" class="field-textbox"
                    value="{{ isset($pivotTable) && !empty($pivotTable->getResourceConfiguration('joins'))  ? $pivotTable->getResourceConfiguration('joins') : ""}}"
                    readonly />
                </div>
                <div class="text-right">
                    <a href="#" id="add-joins-button" data-checkJoin="{{route('data_connections.index')}}"
                        data-url="{{ route('pivot-tables-joins.create') }}">+ Add
                        joins</a>
                </div>
            </div>
        </div>
        <div class="col-md-4 col-12 row mb-3 mb-md-0">
            <div class="col-12">
                <div id="static-filters-container" class="row-fluid ui-droppable ui-sortable field-container">
                    <label class="static-filters-label span2 field-label p-1" for="static-filters">Static
                        filters
                        <i class="fa fa-question-circle options" data-bs-placement="right" data-html="true" data-toggle="tooltip" data-title='Drag fields from the side panel and drop them here to apply static filters. These filters are set at design time, meaning their values remain fixed. For example, to filter a date field for records between two specific dates, define the range while designing the pivot table.'
                            style="color: #68b3c8;" data-original-title="" title="">
                        </i>
                    </label>
                    <div class="static-filter-ul-container ul-container" style="height: 100px">
                        <ul class="fields-ul nav nav-pills span9" id="static-filters">
                        </ul>
                    </div>
                    <div class="text-center">
                        <label class="drop-field-label">Drop Field Here</label>
                    </div>
                    <input type="text" id="static-filters-textbox" name="static_filters" class="field-textbox"
                    value="{{ isset($pivotTable) && !empty($pivotTable->getResourceConfiguration('static_filters'))  ? $pivotTable->getResourceConfiguration('static_filters') : ""}}"

                    readonly />
                </div>
            </div>

        </div>
        <div class="col-md-4 col-12 row mb-3 mb-md-0">
            <div class="col-12">
                <div id="parameters-container" class="row-fluid ui-droppable ui-sortable field-container">
                    <label class="parameters-label span2 field-label p-1" for="parameters">
                        Parameters
                        <i class="fa fa-question-circle options" data-bs-placement="right" data-html="true" data-toggle="tooltip" data-title='Drag fields from the side panel and drop them here to use as dynamic filter parameters. These filters are set by the end user at runtime, allowing them to change with each execution. For example, a date field filter can be adjusted by the user to specify a different date range each time the pivot table runs.'
                            style="color: #68b3c8;" data-original-title="" title="">
                        </i>

                    </label>

                    <div class="parameters-ul-container ul-container" style="height: 100px">
                        <ul class="fields-ul nav nav-pills span9" id="parameters">
                        </ul>
                    </div>

                    <div class="text-center">
                        <label class="drop-field-label">Drop Field Here</label>
                    </div>
                    <input type="text" id="parameters-textbox" name="parameters" class="field-textbox"
                    value="{{ isset($pivotTable) && !empty($pivotTable->getResourceConfiguration('parameters'))  ? $pivotTable->getResourceConfiguration('parameters') : ""}}"

                    readonly />
                </div>
            </div>


        </div>
    </div>
</div>

