@extends('layouts.app')

@section('styles')
<!-- DataTables -->
<link rel="stylesheet" href="{{ get_asset('dist/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css'). '?v='. $srmVersion}}">
<link rel=" stylesheet" href="{{ get_asset('dist/plugins/datatables-responsive/css/responsive.bootstrap4.min.css'). '?v='. $srmVersion}}">
<link rel=" stylesheet" href="{{ get_asset('dist/plugins/datatables-buttons/css/buttons.bootstrap4.min.css'). '?v='. $srmVersion}}">
<link rel=" stylesheet" href="{{ get_asset('dist/plugins/datatables-rowgroup/css/rowGroup.bootstrap4.min.css'). '?v='. $srmVersion}}">

<style>
    .group-start {
        cursor: pointer;
        background-color: #e4e3e3 !important;
        user-select: none;
    }

    .toggle-box {
        display: inline-block;
        width: 20px;
        height: 20px;
        line-height: 20px;
        text-align: center;
        border: 1px solid #ccc;
        border-radius: 4px;
        background-color: #f9f9f9;
        color: #333;
        font-weight: bold;
        cursor: pointer;
        margin-right: 10px;
    }

    .toggle-box:hover {
        background-color: #ddd;
    }

    #popupOverlay {
        display: none;
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background-color: rgba(0, 0, 0, 0.6);
        z-index: 1000;
    }

    #popupContent {
        position: absolute;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
        background: #fff;
        padding: 0;
        border-radius: 8px;
        box-shadow: 0 0 15px rgba(0, 0, 0, 0.5);
    }

    #popupContent iframe {
        border-radius: 8px;
        display: block;
    }

    #closePopup {
        position: absolute;
        top: -10px;
        right: -10px;
        background: #f00;
        color: #fff;
        padding: 5px 10px;
        font-weight: bold;
        font-size: 20px;
        cursor: pointer;
        border-radius: 50%;
    }
    .popupTitle {
        font-size: 18px;
        font-weight: bold;
        text-align: center;
        padding: 15px 20px 10px;
        color: #333;
    }
</style>
@endsection

@section('content')

@include('dashboard.reports.partials.success-modal')


@include('dashboard.pivot-tables.partials._pivot-tables-confirmation-modal',[
'id' => 'delete-pivot-table',
'modal_title' =>'Delete Confirmation',
'method'=> 'DELETE'
])

<div id="change-category-modal-container">

</div>



@if((isset($pivotTableModule) && $pivotTableModule->checkWhoCanAccessModule()) || auth()->user()->isAdminOrOwner())

@endif
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2 mt-2">
                <div class="col-sm-6">
                    @if(!checkDemo())
                    <h3> <i class="fa-solid fa-table mx-2"></i> Pivot tables</h3>
                    @else
                    <h3> <i class="fa-solid fa-table mx-2"></i> Pivot tables <a href="#" id="openPopup" ><img
                                src="{{ get_asset('dist/images/youtube.jpg') }}" style="width: 40px" class="mx-2 mb-1" alt="Watch the Pivot Table Report in Action"
                                data-toggle="tooltip" data-title="Watch the Pivot Table Report in Action" data-placement="bottom"></a></h3>
                    <div id="popupOverlay">
                        <div id="popupContent" style="padding: 10px">
                            <span id="closePopup">&times;</span>
                            <div class="popupTitle">Watch the Pivot Table Report in Action</div>
                            <iframe id="youtubeVideo" width="800" height="515"
				src="{{config('srm_config.dashboard.demo.pivot_table_youtube_video')}}"
				data-vidoe="{{config('srm_config.dashboard.demo.pivot_table_youtube_video')}}"
                                allow="autoplay; encrypted-media">
                            </iframe>
                        </div>
                    </div>
                    @endif
                </div>

                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                        <li class="breadcrumb-item">Pivot Tables</li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
        <div class="container-fluid mt-5">
            <!-- Use container-fluid for full-width -->

            <div class="form-group mx-2">
                <div class="row">
                    <div class="{{ auth()->user()->isAdminOrOwner() ? 'col-md-6' : 'col-md-12' }}">

                        <form>
                            <div class="form-group">
                                <label for="category-search">Category</label>
                                <select class="form-control" id="category-search">
                                    @if(isset($categories))
                                    <option value="">Choose Category</option>
                                    @foreach($categories as $category)
                                    <option value="{{ $category->name }}">{{ $category->name }}</option>
                                    @endforeach
                                    @endif
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="connection-name-search">Pivot table Name</label>
                                <input type="text" class="form-control" id="pivot-table-name-search">
                            </div>

                        </form>
                    </div>
                    @if(auth()->user()->isAdminOrOwner())
                    <div class="col-md-6">
                        <!-- Second column -->
                        <form>
                            <div class="form-group">
                                <label for="creator-search">Creator</label>
                                <select class="form-control" id="creator-search">
                                    <option value="">Choose Creator</option>
                                    @php $i = 0 ; @endphp
                                    @foreach ($users as $user)
                                    @if(checkDemo())
                                    <option value="{{ '<user ' .++$i . '>' }}">{{ '<user ' .$i . '>' }}</option>
                                    @else
                                    <option value="{{ $user->user_name }}">{{ $user->user_name }}</option>
                                    @endif
                                    @endforeach
                                </select>
                            </div>
                            {{-- <div class="form-group">
                                <label for="databases-search">Data Bases</label>
                                <select class="form-control" id="databases-search">
                                    <option value="">All</option>
                                    @foreach ($databases as $database)
                                    <option value="{{ $database }}">{{ $database }}</option>
                                    @endforeach
                                </select>
                            </div> --}}
                        </form>
                    </div>
                    @endif

                </div>

                <div class="form-group text-center mt-3">
                    <button class="btn btn-primary px-3 py-2 my-2 my-sm-0 srm-button search-filter" type="submit"><i
                            class="fas fa-search"></i> Search</button>
                    <button class="btn btn-outline-primary px-3 py-2 my-2 ml-2 my-sm-0 srm-button reset-filter"
                        type="button"><i class="fa-solid fa-eye"></i> Show All</button>
                </div>
                <div class="card-body mt-2 d-flex justify-content-end">
                    @if((isset($pivotTableModule) && $pivotTableModule->checkWhoCanAccessModule()) ||
                    auth()->user()->isAdminOrOwner())
                    <a href="{{ route('pivot-tables.create') }}" class="btn btn-primary create-pivot-table px-3 py-2 float-right srm-button" type="button">
                        <i class="fas fa-plus"></i> Add Pivot Table
                    </a>
                    @endif
                </div>


                <div class="card-body">
                    <table id="pivot-tables" class="table table-bordered table-hover">
                        <thead>
                            <tr>
                                <th>Name</th>
                                <th>Category</th>
                                <th>order</th>
                                <th>Creator</th>
                                <th>Creation Date</th>
                                <th>Access Control</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @php
                            $i=1;
                            @endphp
                            @foreach($pivotTables as $pivotTable)
                            <tr>
                                <td><a data-url="{{ route('pivot-tables.show',$pivotTable->name) }}"
                                        class="text-black display-pivot-table" style="cursor:pointer">{{
                                        $pivotTable->name }}</a></td>
                                <td>@if(strpos($pivotTable->category->icon, '<i class') !==false) {!!
                                        $pivotTable->category->icon !!}
                                        @else
                                        <i class="fa fa-fw" style="font-family: 'FontAwesome'"> {!! '&'.
                                            $pivotTable->category->icon
                                            !!}</i>
                                        @endif {{ $pivotTable->category->name }}</td>
                                <td>{{ $pivotTable->category->order }}</td>

                                @if(checkDemo())

                                <td>{{ isset($pivotTable->creator) ? $pivotTable->report_creator : '' }}</td>

                                @else
                                <td>{{ isset($pivotTable->creator) ? $pivotTable->creator->user_name : '' }}</td>
                                @endif
                                <td>{{ $pivotTable->created_at }}</td>
                                <td>
                                    {{ $pivotTable->access_control_type }}
                                    @if($pivotTable->access_control_type === "Public")
                                    <span class="tool-question" data-toggle="tooltip" data-placement="top"
                                        title="Access is allowed without authentication.">
                                        <i class="fa-solid fa-circle-question"></i>
                                    </span>

                                    @else
                                    <span class="tool-question" data-toggle="tooltip" data-placement="top"
                                        title="{{
                                            $pivotTable->getGroupsCanAccessResource()->isEmpty()
                                                ? 'Access is allowed only by admins.'
                                                : (
                                                    count($pivotTable->getGroupsCanAccessResource()) == 1
                                                        ? 'Access is allowed only by ' . $pivotTable->getGroupsCanAccessResource()->implode(', ') . ' group.'
                                                        : 'Access is allowed only by ' . $pivotTable->getGroupsCanAccessResource()->implode(', ') . ' groups.'
                                                )
                                        }}"">
                                        <i class="fa-solid fa-circle-question"></i>
                                    </span>

                                    @endif
                                </td>
                                <td>
                                    <div class="dropdown">
                                        <button type="button" id="ellipsisMenu2" data-toggle="dropdown"
                                            aria-haspopup="true" aria-expanded="false"
                                            style="border:none;background:none">
                                            <!-- Your SVG icon -->
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                                fill="currentColor" class="bi bi-three-dots-vertical"
                                                viewBox="0 0 16 16">
                                                <path
                                                    d="M9.5 13a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0z" />
                                            </svg>
                                        </button>

                                        <div class="dropdown-menu" aria-labelledby="ellipsisMenu">
                                            <a class="dropdown-item display-pivot-table"
                                                data-display="{{ config('srm_config.dashboard.report_display') }}"
                                                data-url="{{ route('pivot-tables.show',$pivotTable->name) }}">Display</a>
                                            @if(
                                            (
                                            isset($pivotTable->creator) &&
                                            $pivotTable->creator->user_ID == auth()->user()->user_ID
                                            )
                                            ||
                                            auth()->user()->isAdminOrOwner())
                                            <a class="dropdown-item edit-pivot-table"
                                                data-url="{{ route('pivot-tables.edit',$pivotTable->name) }}"
                                                data-display="{{ route('pivot-tables.edit',$pivotTable->name) }}">Edit</a>

                                            <a class="dropdown-item change-category"
                                                data-url="{{ route('pivot-tables.getCategories',$pivotTable->name) }}">Change
                                                category</a>

                                            <a class="dropdown-item delete-pivot-table" data-toggle="modal"
                                                data-target="#delete-pivot-table-modal"
                                                data-url="{{ route('pivot-tables.destroy',$pivotTable->name) }}">Delete</a>
                                            @endif
                                        </div>
                                    </div>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>

                </div>
            </div>

        </div>

</div>


@endsection

@section('scripts')

<script src="{{ get_asset('dist/plugins/datatables/jquery.dataTables.min.js') . '?v='. $srmVersion }}"></script>
<script src="{{ get_asset('dist/plugins/datatables-responsive/js/dataTables.responsive.min.js') . '?v='. $srmVersion }}"></script>
<script src="{{ get_asset('dist/plugins/datatables-responsive/js/responsive.bootstrap4.min.js') . '?v='. $srmVersion }}"></script>
<script src="{{ get_asset('dist/plugins/datatables-buttons/js/dataTables.buttons.min.js') . '?v='. $srmVersion }}"></script>
<script src="{{ get_asset('dist/plugins/datatables-buttons/js/buttons.bootstrap4.min.js') . '?v='. $srmVersion }}"></script>
<script src="{{ get_asset('dist/plugins/jszip/jszip.min.js') . '?v='. $srmVersion }}"></script>
<script src="{{ get_asset('dist/plugins/pdfmake/pdfmake.min.js') . '?v='. $srmVersion }}"></script>
<script src="{{ get_asset('dist/plugins/pdfmake/vfs_fonts.js') . '?v='. $srmVersion }}"></script>
<script src="{{ get_asset('dist/plugins/datatables-buttons/js/buttons.html5.min.js') . '?v='. $srmVersion }}"></script>
<script src="{{ get_asset('dist/plugins/datatables-buttons/js/buttons.print.min.js') . '?v='. $srmVersion }}"></script>
<script src="{{ get_asset('dist/plugins/datatables-buttons/js/buttons.colVis.min.js') . '?v='. $srmVersion }}"></script>
<script src="{{ get_asset('dist/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js') . '?v='. $srmVersion }}"></script>
<script src="{{ get_asset('dist/plugins/datatables-rowgroup/js/dataTables.rowGroup.min.js') . '?v='. $srmVersion }}"></script>
<script src="{{ get_asset('dist/plugins/datatables-rowgroup/js/rowGroup.bootstrap4.min.js') . '?v='. $srmVersion }}"></script>
<script src="{{ get_asset('dist/js/custom-datatables.js') . '?v='. $srmVersion }}"></script>

@if(!checkDemo())
<script src="{{ get_asset('dist/js/pivot-tables-datatable.js') . '?v='. $srmVersion }}"></script>
@else
<script src="{{ get_asset('dist/js/pivot-tables-datatable-demo.js') . '?v='. $srmVersion }}"></script>

<script>
    const openBtn = document.getElementById("openPopup");
    const closeBtn = document.getElementById("closePopup");
    const overlay = document.getElementById("popupOverlay");

    openBtn.addEventListener("click", function(e) {
        overlay.style.display = "block";
    });

    closeBtn.addEventListener("click", function() {
        overlay.style.display = "none";
        // Stop video playback
        const iframe = document.getElementById("youtubeVideo");
        iframe.src = iframe.src;
    });

    window.addEventListener("click", function(e) {
    if (e.target === overlay) {
        overlay.style.display = "none";
        const iframe = document.getElementById("youtubeVideo");
        iframe.src = iframe.src;
    }
    });
</script>

@endif
<script>
    displayUserPanel();
</script>

<script src="{{ get_asset('dist/js/pivot-tables/pivot-tables.js') . '?v='. $srmVersion }}">
</script>
@if(session('add'))
<script>
    $(document).ready(function() {
            $('.create-report').click();
        });
</script>
@endif

@endsection
