@extends('layouts.app')

@section('styles')
<!-- DataTables -->
<link rel="stylesheet" href="{{ get_asset('dist/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css'). '?v='. $srmVersion}}">
<link rel=" stylesheet" href="{{ get_asset('dist/plugins/datatables-responsive/css/responsive.bootstrap4.min.css'). '?v='. $srmVersion}}">
<link rel=" stylesheet" href="{{ get_asset('dist/plugins/datatables-buttons/css/buttons.bootstrap4.min.css'). '?v='. $srmVersion}}">
@if(checkDemo())
<link href="{{ get_asset('dist/css/alertify.core.css'). '?v='. $srmVersion}}" rel="stylesheet">
<link href="{{ get_asset('dist/css/alertify.default.css'). '?v='. $srmVersion}}" rel="stylesheet">
@endif

@endsection

@section('content')

@include('dashboard.dashboards.partials.success-modal')

@include('dashboard.dashboards.partials._dashboards-confirmation-modal',[
'id' => 'delete-dashboard',
'modal_title' =>'Delete Confirmation',
'method'=> 'DELETE'
])


<div id="edit-dashboard-modal-container">

</div>

<div id="add-dashboard-modal-container">

</div>


<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2 mt-2">
                <div class="col-sm-6">
                    <h3> <i class="fas fa-tachometer-alt mx-2"></i> Dashboards</h3>

                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                        <li class="breadcrumb-item">Dashboards</li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
        <div class="container-fluid mt-5">
            <!-- Use container-fluid for full-width -->

            <div class="form-group mx-2">
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="name-search">Name</label>
                            <input type="text" class="form-control" id="name-search">
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="title-search">Title</label>
                            <input type="text" class="form-control" id="title-search">
                        </div>
                    </div>

                </div>
            </div>

            <div class="form-group text-center">
                <button class="btn btn-primary my-2 my-sm-0 px-3 py-2 srm-button search-filter" type="submit"><i
                        class="fas fa-search"></i> Search</button>
                <button class="btn btn-outline-primary my-2 my-sm-0 ml-2 px-3 py-2 srm-button reset-filter"
                    type="button"><i class="fa-solid fa-eye"></i> Show
                    All</button>
            </div>
            </form>
            <div class="card-body mt-2 d-flex justify-content-end">
                <button type="button" class="btn btn-primary float-right px-3 py-2 srm-button" id="add-dashboard-button"
                    data-url="{{ route('dashboards.create') }}">
                    <i class="fas fa-plus"></i> Add New Dashboard
                </button>
            </div>

            <div class="card-body">
                <table id="dashboards" class="table table-bordered table-hover">
                    <thead>
                        <tr>
                            <th>Dashboard name</th>
                            <th>Dashboard Title</th>
                            <th>Dashboard Icon</th>
                            <th>Widgets Count</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($dashboards as $dashboard)

                        <tr>
                            <td><a href="{{ route('dashboards.show',[$dashboard->id]) }}" style="color: black">{{
                                    $dashboard->name }}</a>
                            </td>
                            <td>{{ $dashboard->title }}</td>
                            <td>
                                <i class="fa fa-fw" style="font-family: 'FontAwesome'"> {!! '&'. $dashboard->icon
                                    !!}</i>
                            </td>
                            <td>{{ $dashboard->widgets_count }}</td>
                            <td>
                                <div class="dropdown">
                                    <button type="button" id="ellipsisMenu2" data-toggle="dropdown" aria-haspopup="true"
                                        aria-expanded="false" style="border:none;background:none">
                                        <!-- Your SVG icon -->
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                            fill="currentColor" class="bi bi-three-dots-vertical" viewBox="0 0 16 16">
                                            <path
                                                d="M9.5 13a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0z" />
                                        </svg>
                                    </button>

                                    <div class="dropdown-menu" aria-labelledby="ellipsisMenu">

                                        <a class="dropdown-item display"
                                            data-url="{{ route('dashboards.show',$dashboard->id) }}"
                                            href="{{ route('dashboards.show',$dashboard->id) }}">Display</a>
                                        <a class="dropdown-item edit-dashboard"
                                            data-url="{{ route('dashboards.edit',$dashboard->id) }}">Edit</a>

                                        <a class="dropdown-item move-up-dashboard"
                                            data-url="{{ route('dashboards.moveUp',$dashboard->id) }}">Move Up</a>
                                        <a class="dropdown-item move-down-dashboard"
                                            data-url="{{ route('dashboards.moveDown',$dashboard->id) }}">Move
                                            Down</a>

                                        <a class="dropdown-item delete-dashboard" data-toggle="modal"
                                            data-target="#delete-dashboard-modal"
                                            data-url="{{ route('dashboards.destroy',$dashboard->id) }}">Delete</a>
                                    </div>
                                </div>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>

            </div>
        </div>

</div>

</div>


@endsection

@section('scripts')
<script src="{{ get_asset('dist/plugins/datatables/jquery.dataTables.min.js') . '?v='. $srmVersion }}"></script>
<script src="{{ get_asset('dist/plugins/datatables-responsive/js/dataTables.responsive.min.js') . '?v='. $srmVersion }}"></script>
<script src="{{ get_asset('dist/plugins/datatables-responsive/js/responsive.bootstrap4.min.js') . '?v='. $srmVersion }}"></script>
<script src="{{ get_asset('dist/plugins/datatables-buttons/js/dataTables.buttons.min.js') . '?v='. $srmVersion }}"></script>
<script src="{{ get_asset('dist/plugins/datatables-buttons/js/buttons.bootstrap4.min.js') . '?v='. $srmVersion }}"></script>
<script src="{{ get_asset('dist/plugins/jszip/jszip.min.js') . '?v='. $srmVersion }}"></script>
<script src="{{ get_asset('dist/plugins/pdfmake/pdfmake.min.js') . '?v='. $srmVersion }}"></script>
<script src="{{ get_asset('dist/plugins/pdfmake/vfs_fonts.js') . '?v='. $srmVersion }}"></script>
<script src="{{ get_asset('dist/plugins/datatables-buttons/js/buttons.html5.min.js') . '?v='. $srmVersion }}"></script>
<script src="{{ get_asset('dist/plugins/datatables-buttons/js/buttons.print.min.js') . '?v='. $srmVersion }}"></script>
<script src="{{ get_asset('dist/plugins/datatables-buttons/js/buttons.colVis.min.js') . '?v='. $srmVersion }}"></script>
<script src="{{ get_asset('dist/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js') . '?v='. $srmVersion }}"></script>
<script src="{{ get_asset('dist/js/custom-datatables.js') . '?v='. $srmVersion }}"></script>

@if(checkDemo())
<script src="{{ get_asset('dist/js/alertify.min.js') . '?v='. $srmVersion }}"></script>
@endif


<script src="{{ get_asset('dist/js/dashboards.js') }}" defer>
</script>



@if(session('add'))

<script>
    setTimeout(() => {
        $(document).ready(function(){
            $('#add-dashboard-button').click();
        });
    }, 500);
</script>

@endif

@endsection
