@extends('layouts.bootstrap3')
@section('styles')

<link href="{{ get_asset('dist/css/paper-bootstrap-wizard.css'). '?v='. $srmVersion }}" rel="stylesheet">
<link rel="stylesheet" href="{{ get_asset('dist/css/charts.css'). '?v='. $srmVersion }}">

<link href="{{ get_asset('dist/css/themify-icons.css'). '?v='. $srmVersion}}" rel="stylesheet">

@if(checkDemo())
<link href="{{ get_asset('dist/css/alertify.core.css'). '?v='. $srmVersion}}" rel="stylesheet">
<link href="{{ get_asset('dist/css/alertify.default.css'). '?v='. $srmVersion}}" rel="stylesheet">
@endif

@endsection

@section('content')
@include('dashboard.charts.partials.confirm-public')
<div id="global-loader">
    <img src="{{get_asset('dist/images/loader.gif')}}" class="loader-img" alt="Loader">
    <div class="loader-text"></div>

</div>

<div>
    <div class="container">
        <div class="row">
            <div class="col-sm-12">
                <!--      Wizard container        -->
                <div class="wizard-container">
                    <div class="card wizard-card" data-color="blue" id="wizard"
                        style="box-shadow:0 0 0 0 rgba(0, 0, 0, 0.57);margin-bottom: 0px;padding:0">
                        <!--        You can switch " data-color="green" "  with one of the next bright colors: "blue", "azure", "orange", "red"       -->
                        <div class="wizard-navigation">
                            <div class="progress-with-circle">
                                <div class="progress-bar" role="progressbar" aria-valuenow="1" aria-valuemin="1"
                                    aria-valuemax="4" style="width: 10%"></div>
                            </div>
                            <ul class="steps nav nav-pills" id="tabs">
                                <li id="database" class="" style="width: 20%">
                                    <a href="#type" data-toggle="tab" aria-expanded="false">
                                        <div class="icon-circle checked">
                                            <i class="ti-brush"></i>
                                        </div>
                                        Appearnce
                                    </a>
                                </li>

                                <li id="database" class="" style="width: 20%">
                                    <a href="#setup" data-toggle="tab" aria-expanded="false">
                                        <div class="icon-circle checked">
                                            <i class="ti-settings"></i>
                                        </div>
                                        Settings
                                    </a>
                                </li>
                                <li style="width: 20%">
                                    <a href="#data" data-toggle="tab">
                                        <div class="icon-circle">
                                            <i class="ti-server"></i>
                                        </div>
                                        Data
                                    </a>
                                </li>
                            </ul>
                        </div>
                        <div class="tab-content" style="padding:105px 20px 0px">
                            @if(checkDemo())
                            <div class="alert alert-info">This demo chart is for demonstration purposes only! Its
                                settings cannot be altered.
                            </div>
                            @endif
                            <div class="tab-pane" id="type">
                                <div class="row"></div>
                                <form action="#" id="chart-type-form"
                                    data-url="{{ route('charts.wizard.appearance.store') }}">
                                    @csrf
                                    <div class="row">
                                        <div class="col-sm-12">
                                            <div class="form-group">
                                                <h5 style="color: #67b0ca;margin-bottom:0">
                                                    <b>Select Chart Type</b>
                                                </h5>

                                                <div class="text-center">
                                                    @foreach (array_chunk($chartsTypes, 3) as $charts_chunk)
                                                    <div class="row">
                                                        @foreach ($charts_chunk as $type)
                                                        <div class="col-sm-4" style="margin-bottom: 0">
                                                            <label class="chart-container"
                                                                for="{{ $type['value'] }}Radio">
                                                                <img src="{{ get_asset('dist/images/' .
                                                                    $type['image'])}}" width="30%" alt="Bar Chart" />
                                                            </label>
                                                            <div class="custom-control custom-radio">
                                                                <input type="radio" id="{{ $type['value'] }}Radio"
                                                                    name="chart_type" value="{{ $type['value'] }}"
                                                                    @if($chart->configurations->chart_type ==
                                                                $type['value'])
                                                                checked
                                                                @endif
                                                                class="custom-control-input" />
                                                                <label class="custom-control-label"
                                                                    for="{{ $type['value'] }}Radio">{{$type['label']}}</label>
                                                            </div>
                                                        </div>
                                                        @endforeach

                                                    </div>
                                                    @endforeach

                                                    <div class="col-sm-5" style="margin-top: 10px;text-align:left">
                                                        <h5 style="color: #67b0ca">
                                                            <b>Select Widget Size </b>
                                                            <span class="glyphicon glyphicon-info-sign"
                                                                data-toggle="tooltip"
                                                                data-title="Widget Size Selection: This field determines the size of the widget housing the generated chart. Select 'Full Width' for the chart to appear in a widget spanning the full width of the display, allowing only one chart per row. If '1/2 Width' is chosen, the chart will be displayed in a widget occupying half of the available width, enabling two charts to be displayed side by side in a row."
                                                                style="color: #68b3c8; margin-left: 5px">
                                                            </span>
                                                        </h5>
                                                        <div class="form-group">
                                                            <select class="form-control" id="widgetSize"
                                                                name="widget_size">
                                                                <option value="">Please Choose Widget Size</option>
                                                                <option value="full" @if($chart->widget_size ==
                                                                    \App\Models\Resource::CHART_FULL_SIZE ) {{
                                                                    "selected" }}
                                                                    @endif>Full Width</option>
                                                                <option value="half" @if($chart->widget_size ==
                                                                    \App\Models\Resource::CHART_HALF_SIZE ) {{
                                                                    "selected" }}
                                                                    @endif>Half Width</option>
                                                            </select>
                                                        </div>

                                                    </div>
                                                    <div class="col-sm-5" style="margin-top: 10px;text-align:left;
                                                        @if(!in_array($chart->getResourceConfiguration('chart_type'),['pie-chart','donut-chart']))
                                                        display:none
                                                        @endif
                                                        " id="sections-color-palette-drop-menu">
                                                        <h5 style="color: #67b0ca">
                                                            <b>Sections Color Palette</b>
                                                            <span class="glyphicon glyphicon-info-sign"
                                                                data-toggle="tooltip"
                                                                data-title="Choose the colors for the sections of your chart. Note: If there are more than 7 sections, random colors will be assigned to highlight each section."
                                                                style="color: #68b3c8; margin-left: 5px">
                                                            </span>
                                                        </h5>
                                                        <div class="form-group">
                                                            <select class="form-control" id="sections-color-palette"
                                                                name="sections_color_palette">
                                                                <option value="blue-gradient" @if($chart->
                                                                    getResourceConfiguration('sections_color_palette')
                                                                    == "blue-gradient") {{ 'selected' }}@endif>Blue
                                                                    Gradient Palette
                                                                </option>
                                                                <option value="blue-green" @if($chart->
                                                                    getResourceConfiguration('sections_color_palette')
                                                                    == "blue-green") {{ 'selected' }}@endif>Blue-Green
                                                                    Palette</option>
                                                                <option value="multi-color" @if($chart->
                                                                    getResourceConfiguration('sections_color_palette')
                                                                    == "multi-color") {{ 'selected' }}@endif>Multi-color
                                                                    Palette</option>
                                                            </select>
                                                        </div>

                                                    </div>


                                                    <div class="col-sm-5" style="margin-top: 20px;display: none"
                                                        id="map-selection-drop-menu">
                                                        <h5 style="color: #67b0ca">
                                                            <b>Map Selection</b>
                                                            <span class="glyphicon glyphicon-info-sign"
                                                                data-toggle="tooltip" data-title="Maps"
                                                                style="color: #68b3c8; margin-left: 5px">
                                                            </span>
                                                        </h5>
                                                        <div class="form-group">
                                                            <select class="form-control" id="mapSelection"
                                                                name="map_selection">
                                                                <option value="">Please Choose map</option>
                                                                <option value="world-map">World map</option>
                                                                <option value="us-states-map">US states map</option>
                                                                <option value="eu-map">EU Map</option>
                                                                <option value="africa-map">Africa Map</option>
                                                                <option value="asia-map">Asia Map</option>
                                                                <option value="europe-map">Europe Map</option>
                                                                <option value="north-america-map">North America Map
                                                                </option>
                                                                <option value="south-america-map">South America Map
                                                                </option>
                                                                <option value="oceania-map">Oceania Map</option>
                                                            </select>
                                                        </div>

                                                    </div>

                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                                <div class="row"></div>
                            </div>
                            <div class="tab-pane" id="setup">
                                <div class="row"></div>

                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <h5 style="color: #67b0ca">
                                                <b>Chart Settings</b>
                                            </h5>
                                        </div>
                                    </div>
                                </div>
                                <form action="#" id="chart-setup-form"
                                    data-url="{{ route('charts.wizard.setting.update',$chart->id) }}">
                                    @csrf
                                    @method('PUT')
                                    <div class="row">
                                        <div class="col-sm-5 col-sm-offset-1">
                                            <div class="form-group">
                                                <label>Chart Name</label>
                                                <span class="glyphicon glyphicon-info-sign" style="color: #68b3c8"
                                                    data-toggle="tooltip"
                                                    data-title="Unique Chart Name Required: Smart Report categorizes charts, reports, metrics, and other modules as 'Analytical Resources.' Each analytical resource, regardless of its type, must have a distinct name. Therefore, please ensure that the chart name you provide is unique."></span>
                                                <input id="chart-name" name="name" type="text"
                                                    class="form-control username" placeholder=""
                                                    value="{{ $chart->name }}" />
                                            </div>
                                        </div>
                                        <div class="col-sm-5">
                                            <div class="form-group">
                                                <label>Chart Title</label>
                                                <span class="glyphicon glyphicon-info-sign" style="color: #68b3c8"
                                                    data-toggle="tooltip"
                                                    data-title="Chart Title Required: Please add a title for the chart. This title will be prominently displayed on the generated chart, providing essential context and information to viewers.">
                                                </span>
                                                <input id="title" name="title" type="text" class="form-control username"
                                                    placeholder="" value="{{ $chart->getResourceConfiguration('title')
                                                    }}" />
                                            </div>
                                        </div>

                                        <div class="col-sm-5 col-sm-offset-1">
                                            <div class="form-group">
                                                <label> Chart Category </label>
                                                <span class="glyphicon glyphicon-info-sign"
                                                    style="color: #68b3c8; margin-left: 5px" data-toggle="tooltip"
                                                    data-title="Category Selection Required: Please choose the category to which the chart belongs. This helps organize and classify the chart appropriately for easy retrieval and navigation."></span>

                                                <select id="category" name="category" class="form-control"
                                                    placeholder="">
                                                    <option value="">Please Choose Category</option>
                                                    @foreach ($categories as $category)
                                                    <option value="{{ $category->id }}" @if($chart->category_id ==
                                                        $category->id) {{ "selected" }} @endif>{{ $category->name }}
                                                    </option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-sm-5">
                                            <div class="form-group">
                                                <label> Date Connection </label>
                                                <span class="glyphicon glyphicon-info-sign" data-toggle="tooltip"
                                                    data-title="Data Connection Selection: Please select the data connection through which Smart Report Maker can access the necessary data for generating the chart. This ensures that the correct data source is utilized to produce relevant visualizations."
                                                    style="color: #68b3c8; margin-left: 5px">
                                                </span>
                                                <label class="form-control" id="connection" @if(isset($chart->
                                                    data_connection_id))
                                                    data-url="{{
                                                    route('data_connections.getTables',$chart->data_connection_id) }}"
                                                    @else
                                                    data-url="{{ route('data_connections.getTables','default') }}"
                                                    @endif

                                                    @if(isset($chart->data_connection))
                                                    data-connection="{{ $chart->data_connection_id }}"
                                                    @else
                                                    data-connection="default"
                                                    @endif

                                                    >
                                                    @if(isset($chart->data_connection))
                                                    {{$chart->data_connection->connection_name }}
                                                    @else
                                                    {{ "default" }}
                                                    @endif
                                                </label>

                                            </div>
                                        </div>

                                        <div class="col-sm-5 col-sm-offset-1">
                                            <div class="form-group">
                                                <label> Security Type </label><span
                                                    class="glyphicon glyphicon-info-sign" data-toggle="tooltip"
                                                    data-title="Security Type Selection: Choose the security type for your chart. Select 'Private' to restrict access to logged-in users from specified groups. Alternatively, choose 'Public' to allow access to anyone, even without logging in."
                                                    style="color: #68b3c8; margin-left: 5px">
                                                </span>
                                                <select id="security-type" name="security_type" class="form-control"
                                                    placeholder="">
                                                    <option value="">Please Choose Security type</option>
                                                    <option value="private" @if(strtolower($chart->access_control_type)
                                                        == "private") {{ "selected" }} @endif>Private</option>
                                                    <option value="public" @if(strtolower($chart->access_control_type)
                                                        == "public") {{ "selected" }} @endif>Public</option>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-sm-5">
                                            <div class="form-group">
                                                <label> Who Can Access Chart </label><span
                                                    class="glyphicon glyphicon-info-sign" data-toggle="tooltip"
                                                    data-title="Group Selection: If the security type is set to private, please select the groups whose users will have access to this chart. Only members of the selected groups will be able to view the chart."
                                                    style="color: #68b3c8; margin-left: 5px">
                                                </span>
                                                <select multiple id="groups" name="groups[]" class="form-control"
                                                    placeholder="">
                                                    @foreach ($groups as $group)
                                                    <option value="{{ $group->group_ID }}" @if($chart->
                                                        resource_permissions->contains('group_ID', $group->group_ID))
                                                        selected
                                                        @endif


                                                        >{{ $group->name }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-sm-5 col-sm-offset-1">
                                            <div class="form-group">
                                                <input class="form-check-input" name="chart_link" type="checkbox"
                                                    value="" id="detaild-page"
                                                    @if($chart->getResourceConfiguration("chart_link"))
                                                {{ "checked" }}
                                                @endif
                                                />
                                                <label for="detaild-page">Link chart to a summery report</label>
                                                <span class="glyphicon glyphicon-info-sign" data-toggle="tooltip"
                                                    data-title="Enable Detail Page Redirect: When this option is enabled, clicking the chart will redirect users to a detailed page. This page will include a summary report containing both the chart data and the chart itself, providing users with comprehensive information and insights."
                                                    style="color: #68b3c8; margin-left: 10px">
                                                </span>
                                            </div>
                                        </div>
                                        <div class="col-sm-5">
                                            <div class="form-group"></div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                            <div class="tab-pane" id="data">
                                <form action="#" id="chart-data-form"
                                    data-url="{{ route('charts.wizard.data.update',$chart->id) }}">
                                    @csrf
                                    <div class="row"></div>
                                    <div class="row">
                                        <div class="col-sm-12">
                                            <div class="form-group">
                                                <h5 style="color: #67b0ca"><b>Data Settings</b></h5>

                                                <label style="color: #67b0ca; margin-left: 25px" class="x-axis-label">
                                                    @if(in_array($chart->configurations->chart_type,["pie-chart","3d-bar-chart",'donut-chart','3d-donut-chart']))
                                                    Segment Axis
                                                    @elseif($chart->configurations->chart_type == 'geo-chart')
                                                    Geographic Axis
                                                    @else
                                                    X Axis Settings
                                                    @endif
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-sm-5 col-sm-offset-1">
                                            <div class="form-group">
                                                <label>Table</label>
                                                <span class="glyphicon glyphicon-info-sign" data-toggle="tooltip"
                                                    data-title="Select the database table providing data for this axis."
                                                    style="color: #68b3c8; margin-left: 5px">
                                                </span>
                                                <select class="form-control" id="x-table" name="x_table"
                                                    data-url="{{ route('data_connections.index') }}">
                                                    <option value="">Please Select Table</option>
                                                    @foreach ($tables as $table)
                                                    <option value="{{ $table }}" @if($table==$chart->
                                                        getResourceConfiguration('x_table')) {{ 'selected' }} @endif>{{
                                                        $table }}
                                                    </option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-sm-5">
                                            <div class="form-group">
                                                <label>Column</label>
                                                <span class="glyphicon glyphicon-info-sign" data-toggle="tooltip"
                                                    data-title="Select the column to represent on this axis. For data series charts, choose a date or datetime column. For Pie and Donut charts, select a textual column to label the segments."
                                                    style="color: #68b3c8; margin-left: 5px">
                                                </span>
                                                <select class="form-control" id="x-axis-column" name="x_axis_column"
                                                    data-url="{{ route('data_connections.index') }}">
                                                    <option value="">Please Select Column</option>
                                                    @foreach ($xTableColumns as $column)
                                                    <option value="{{ $column }}" @if($column==$chart->
                                                        getResourceConfiguration('x_axis_column')) {{ 'selected' }}
                                                        @endif>{{
                                                        $column }}
                                                    </option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>

                                        <div class="time-series" @if(in_array($xColumnType,["timestamp", "date"
                                            , "datetime" ]) || $chart->configurations->chart_type == "timeseries")
                                            style="display: block" @else style="display: none" @endif>
                                            <div class="col-sm-5 col-sm-offset-1">
                                                <div class="form-group">
                                                    <label>Date Range</label>
                                                    <span class="glyphicon glyphicon-info-sign" data-toggle="tooltip"
                                                        data-title="The date range selection determines the filter applied to your data, displaying only the data within the specified range on your chart. These filters are automatically updated at runtime. For example, selecting 'This Month' will dynamically apply to the current month when the chart is viewed, not the current month at the time of chart creation."
                                                        style="color: #68b3c8; margin-left: 5px">
                                                    </span>
                                                    <select class="form-control" id="date_range" name="date_range"
                                                        data-url="{{ route('charts.index') }}">
                                                        @foreach ($dateRanges as $range)
                                                        <option value="{{ $range['value'] }}" @if($chart->
                                                            getResourceConfiguration('date_range') == $range['value'])
                                                            {{ "selected" }}@endif>{{ $range['label'] }}
                                                        </option>

                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-sm-5">
                                                <div class="form-group">
                                                    <label>Time Scale</label>
                                                    <span class="glyphicon glyphicon-info-sign" data-toggle="tooltip"
                                                        data-title="Select your preferred time scale to display data on the X-axis, such as days, weeks, months, quarters, or years. This option is only applicable for time series charts or when the X-axis represents date or date-time columns."
                                                        style="color: #68b3c8; margin-left: 5px">
                                                    </span>
                                                    <select class="form-control" id="date_time_scale"
                                                        name="date_time_scale">
                                                        @foreach ($chart->getChartDateRangeTimeScale() as $scale =>
                                                        $label)
                                                        <option value="{{ $scale }}" @if($chart->
                                                            getResourceConfiguration('date_time_scale') ==
                                                            $scale) {{ 'selected' }} @endif>{{
                                                            $label }}
                                                        </option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="data-filtration" @if(!in_array($xColumnType,["timestamp", "date"
                                            , "datetime" ]) && $chart->configurations->chart_type != "timeseries" &&
                                            $textualCount > 0)
                                            style="display: block" @else style="display: none" @endif>
                                            <div class="col-sm-5 col-sm-offset-1">
                                                <div class="form-group">
                                                    <label>Data Filtration</label>
                                                    <span class="glyphicon glyphicon-info-sign" data-toggle="tooltip"
                                                        data-title="Select the specific data you wish to show on your chart."
                                                        style="color: #68b3c8; margin-left: 5px">
                                                    </span>
                                                    <div class="dropdown">
                                                        <button class="btn btn-default dropdown-toggle" type="button"
                                                            data-toggle="dropdown">
                                                            <span class="dropdown-text">

                                                                @if(!(is_null($chart->getResourceConfiguration('data_filter_columns'))
                                                                ||
                                                                empty($chart->getResourceConfiguration('data_filter_columns')))
                                                                &&
                                                                count($chart->getResourceConfiguration('data_filter_columns'))
                                                                > 0)
                                                                ({{
                                                                count($chart->getResourceConfiguration('data_filter_columns'))
                                                                }}) Selected
                                                                @else
                                                                Select Columns

                                                                @endif
                                                            </span>
                                                            <span class="caret"></span>
                                                        </button>
                                                        <ul class="dropdown-menu data-filter-columns scrollable"
                                                            data-url="{{ route('data_connections.index') }}">
                                                            <li>
                                                                <a href="#">
                                                                    <label><input type="checkbox" class="selectall"
                                                                            @if(!(is_null($chart->getResourceConfiguration('data_filter_columns'))
                                                                        ||
                                                                        empty($chart->getResourceConfiguration('data_filter_columns')))
                                                                        &&count($chart->getResourceConfiguration('data_filter_columns'))
                                                                        == count($dataFilterItems))
                                                                        {{ "checked" }}
                                                                        @endif>
                                                                        <span class="select-text">
                                                                            @if(!(is_null($chart->getResourceConfiguration('data_filter_columns'))
                                                                            ||
                                                                            empty($chart->getResourceConfiguration('data_filter_columns')))
                                                                            &&
                                                                            count($chart->getResourceConfiguration('data_filter_columns'))
                                                                            == count($dataFilterItems))
                                                                            {{ "Deselect" }}
                                                                            @else
                                                                            {{ "Select" }}
                                                                            @endif
                                                                        </span>
                                                                        All
                                                                    </label>
                                                                </a>
                                                            </li>
                                                            <li class="divider"></li>
                                                            @foreach ($dataFilterItems as $item)
                                                            <li>
                                                                <a href="#" class="option-link">
                                                                    <label>
                                                                        <input name="data_filter_columns[]"
                                                                            type="checkbox" class="option justone"
                                                                            value="{{ $item }}" @if(collect($chart->
                                                                        getResourceConfiguration("data_filter_columns"))->contains(
                                                                        $item)) {{ "checked" }} @endif> {{ $item }}
                                                                    </label>
                                                                </a>
                                                            </li>
                                                            @endforeach

                                                        </ul>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-5">
                                            </div>
                                        </div>

                                        <div class="col-sm-12">
                                            <div class="form-group">
                                                <label style="color: #67b0ca; margin-left: 25px" class="y-axis-label">
                                                    @if(in_array($chart->configurations->chart_type,["pie-chart","3d-bar-chart",'donut-chart','3d-donut-chart']))
                                                    Values Axis
                                                    @elseif($chart->configurations->chart_type == 'geo-chart')
                                                    Values Axis
                                                    @else
                                                    Y Axis Settings
                                                    @endif

                                                </label>
                                            </div>
                                        </div>
                                        <div class="col-sm-5 col-sm-offset-1">
                                            <div class="form-group">
                                                <label>Table</label>
                                                <span class="glyphicon glyphicon-info-sign" data-toggle="tooltip"
                                                    data-title="Select the database table providing data for this axis."
                                                    style="color: #68b3c8; margin-left: 5px">
                                                </span>
                                                <select class="form-control" id="y-table" name="y_table"
                                                    data-url="{{ route('data_connections.index') }}">
                                                    <option value="">Please Select Table</option>
                                                    @foreach ($tables as $table)
                                                    <option value="{{ $table }}" @if($table==$chart->
                                                        getResourceConfiguration('y_table')) {{ 'selected' }} @endif>{{
                                                        $table }}
                                                    </option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-sm-5">
                                            <div class="form-group">
                                                <label>Column</label>
                                                <span class="glyphicon glyphicon-info-sign" data-toggle="tooltip"
                                                    data-title="Choose the column to represent on this axis. A numeric column is required, except if you select 'count' as your function."
                                                    style="color: #68b3c8; margin-left: 5px">
                                                </span>
                                                <select class="form-control" id="y-axis-column" name="y_axis_column"
                                                    data-url="{{ route('data_connections.index') }}">
                                                    <option value="">Please Select Column</option>
                                                    @foreach ($yTableColumns as $column)
                                                    <option value="{{ $column }}" @if($column==$chart->
                                                        getResourceConfiguration('y_axis_column')) {{ 'selected' }}
                                                        @endif>{{
                                                        $column }}
                                                    </option>
                                                    @endforeach

                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-sm-5 col-sm-offset-1">
                                            <div class="form-group">
                                                <label>Label</label>
                                                <span class="glyphicon glyphicon-info-sign" data-toggle="tooltip"
                                                    data-title="Add an optional label for the axis. If included, it will be embedded in the generated chart."
                                                    style="color: #68b3c8; margin-left: 5px">
                                                </span>
                                                <input type="text" class="form-control" name="label" placeholder=""
                                                    value="{{ $chart->getResourceConfiguration('label') }}" />
                                            </div>
                                        </div>
                                        <div class="col-sm-5">
                                            <div class="form-group">
                                                <label>Function</label>
                                                <span class="glyphicon glyphicon-info-sign" data-toggle="tooltip"
                                                    data-title="The function you wish to utilize on the values within the column of this axis."
                                                    style="color: #68b3c8; margin-left: 5px">
                                                </span>
                                                <select class="form-control" id="function" name="function">
                                                    <option value="count" @if($chart->
                                                        getResourceConfiguration('function') =="count") {{ 'selected' }}
                                                        @endif>Count</option>
                                                    <option value="sum" @if($chart->
                                                        getResourceConfiguration('function') =="sum") {{ 'selected' }}
                                                        @endif>Sum</option>
                                                    <option value="average" @if($chart->
                                                        getResourceConfiguration('function') =="average") {{ 'selected'
                                                        }}
                                                        @endif>Average</option>
                                                    <option value="max" @if($chart->
                                                        getResourceConfiguration('function') =="max") {{ 'selected' }}
                                                        @endif>Max</option>
                                                    <option value="min" @if($chart->
                                                        getResourceConfiguration('function') =="min") {{ 'selected' }}
                                                        @endif>Min</option>
                                                    <option value="sample-standard-deviation" @if($chart->
                                                        getResourceConfiguration('function') ==
                                                        'sample-standard-deviation')
                                                        {{ 'selected' }}@endif>Sample Standard Deviation
                                                    </option>
                                                    <option value="population-standard-deviation" @if($chart->
                                                        getResourceConfiguration('function')
                                                        =="population-standard-deviation") {{ 'selected' }}
                                                        @endif>Population Standard Deviation</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-sm-5 col-sm-offset-1">
                                            <div class="form-group">
                                                <input class="form-check-input" type="checkbox" id="drill-down"
                                                    name="drill_down"
                                                    @if($chart->getResourceConfiguration("drill_down"))
                                                {{ "checked" }}
                                                @endif/>
                                                <label for="drill-down"> Enable Drill Down </label>
                                                <span class="glyphicon glyphicon-info-sign" data-toggle="tooltip"
                                                    data-title="Checking this box enables the drill-down feature, which is a data analysis tool that allows you to interactively navigate through specific sections of the generated chart. This functionality provides deeper insights by enabling exploration of detailed data related to a particular chart area. For example, if you display a chart showing the number of orders per store, clicking on a specific store in the chart will allow you to navigate to a report containing the individual orders for that store."
                                                    style="color: #68b3c8; margin-left: 5px">
                                                </span>
                                            </div>
                                        </div>
                                        <div class="col-sm-5">
                                            <div class="form-group">
                                                <div class="form-group">
                                                    <label>Drill Down Columns</label><span
                                                        class="glyphicon glyphicon-info-sign" data-toggle="tooltip"
                                                        data-title="Choose the columns to be displayed in the detailed report to which users will be directed when drilling down on specific sections of the chart."
                                                        style="color: #68b3c8; margin-left: 5px">
                                                    </span>
                                                    <select multiple id="drill-down-columns" name="drill_down_columns[]"
                                                        class="form-control" placeholder="">
                                                        @foreach ($yTableColumns as $column)
                                                        <option value="{{ $column }}" @if($column==collect($chart->
                                                            getResourceConfiguration("drill_down_columns"))->contains(
                                                            $column)) {{
                                                            'selected' }}
                                                            @endif>{{
                                                            $column }}
                                                        </option>
                                                        @endforeach

                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                            <div class="wizard-footer">

                                <div class="text-center">
                                    <label id="error" style="display: none;font-size:1em;color:red" class="error"
                                        data-toggle="tooltip" data-title="" for="confirmpassword">

                                    </label>

                                </div>
                                <div class="pull-right">
                                    <!-- Finish Button -->
                                    <input type="button" class="btn btn-finish btn-fill btn-warning btn-wd"
                                        name="finish" value="Finish" style="display: none" />

                                    <input type="button" class="btn btn-next btn-fill btn-warning btn-wd type-step"
                                        name="next" value="Next" />
                                </div>
                                <div class="pull-left">
                                    <input type="button" class="btn btn-previous btn-default btn-wd disabled"
                                        name="previous" value="Previous" />
                                </div>
                                <div class="clearfix"></div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- wizard container -->
            </div>
        </div>
        <!-- row -->
    </div>
</div>

@endsection

@section('scripts')

@if(!checkDemo())
<script src="{{ get_asset('dist/js/charts/edit.js') . '?v='. $srmVersion }}"></script>
@else
<script src="{{ get_asset('dist/js/alertify.min.js') . '?v='. $srmVersion }}"></script>
<script src="{{ get_asset('dist/js/charts/demo.js') . '?v='. $srmVersion }}"></script>
@endif
@endsection
