<?php

/**
 * Smart Report Maker
 * Version 9.0.0
 * Author : Webuccino
 * All copyrights are preserved to Webuccino
 * URL : http://mysqlreports.com/
 */
defined('DIRECTACESS') or die("Error 301: Access denied!");
require_once "request.php";
$_SESSION[Session_wizard_key]['page_key'] = "data_source";
require_once 'activePages.php';

$auto_columns = array();

$listOfViews = array();
$views       = $dbHandler->query("SHOW FULL TABLES IN `$db` WHERE TABLE_TYPE LIKE 'VIEW'", "NUM", array(), $srm_dashboard);

foreach ($views as $value) {
    $listOfViews[] = $value[0];
}

$numOfViews = $dbHandler->get_num_rows();

$sql = (isset($_SESSION[Session_report_Settings_key]['sql'])) ? $_SESSION[Session_report_Settings_key]['sql'] : '';

$sql = make_valid($sql); // validate sql

$isStandalone = $_SESSION[Session_report_Settings_key]["report_relationship"] === "standalone";
$isStandalone = $_SESSION[Session_report_Settings_key]["report_relationship"] === "standalone";
$isLinkedOrIntermediate     = in_array( $_SESSION[Session_report_Settings_key]["report_relationship"],["linked","intermediate"]);
$parameters   = isset($_SESSION[Session_report_Parameters]) ? $_SESSION[Session_report_Parameters] : array();

?>
<!--
<html>
	<head>
		<title>Query based report</title>
	</head>
	<body>
-->
<div id="tabs" style="min-height: 350px;" class="container col-xs-12">
  <!-- -->
  <!-- Nav tabs nav nav-tabs -->
  <?php

  if ($isLinkedOrIntermediate): ?>
    <ul class="" style="font-size: 12px;">
      <li class="active"><a id="tables-nav" href="#tables" data-toggle="tab"><span
            class="glyphicon glyphicon-list-alt"></span> Query</a></li>
      <li><a id="parameters-nav" href="#parameters" data-toggle="tab"><span class="glyphicon glyphicon-cog"></span>
          Parameters</a></li>
    </ul>
  <?php endif?>

  <!-- Tab panes -->
  <div class="tab-content">
    <div class="tab-pane active" id="tables">
      <form action="<?php echo($_SERVER['PHP_SELF']); ?>" role="form" method="post" onsubmit="return false;">
        <input type='hidden' id='csrfToken' name='csrfToken' value='<?php echo $request_token_value; ?>' />

        <div class="row">
          <div class="col-xs-1"></div>
          <div id="error-container" class="col-xs-10">
            <!-- .alert -->
          </div>
          <div class="col-xs-1"></div>
        </div><!-- .row (error) -->

        <?php

        if (is_numeric($numOfViews) && $numOfViews !== '' && $numOfViews > 0) {?>
          <div class="row">
            <div class="col-xs-1"></div>
            <div class="form-group col-xs-10">
              <label for="sql">Load SQL query from an existed view (Optional)</label>
              <div class="left-inner-addon">
                <i class="glyphicon glyphicon-pushpin"></i>
                <select id="views" class="form-control" name="views">
                  <option value="None">None</option>
                  <?php
                      $selected = '';

            foreach ($listOfViews as $value) {

                if (isset($_SESSION[Session_report_Settings_key]['view']) && $value === $_SESSION[Session_report_Settings_key]['view']) {
                    $selected = 'selected';
                } else {
                    $selected = '';
                }

                echo '<option value="' . $value . '" ' . $selected . '>' . $value . '</option>';
            }

            ?>
                </select>
              </div>
            </div>
            <div class="help-container col-xs-1">
              <a href="" id="viewsHelp" onClick="return false;">
                <img src="includes/images/help.png" width="15" height="15" border="0">
              </a>
            </div>
          </div><!-- .row ( views ) -->
        <?php }

        ?>

        <div class="row">
          <div class="col-xs-1"></div>
          <div class="form-group col-xs-10">
            <label for="sql">Enter Query</label>
            <div class="left-inner-addon">
              <i class="glyphicon glyphicon-edit"></i>
              <textarea id="sql" class="form-control textarea-btn-inside" name="sql" rows="7"><?php echo $sql; ?></textarea>
            </div>
          </div>
          <div class="help-container col-xs-1">
            <a href="" id="sqlHelp" onClick="return false;">
              <img src="includes/images/help.png" width="15" height="15" border="0">
            </a>
          </div>
        </div><!-- .row ( sql textarea ) -->

        <div style="min-height: 100px;" class="row" style="position: relative;top: -10px;">
          <div class="col-xs-8"></div>
          <div class="col-xs-3">
            <button name="btn_validate" class="btn btn-primary btn-block btn-xs" style="font-size: 12px;"
              id="btn_validate">Validate</button />
          </div>
          <div class="col-xs-1"></div>
        </div><!-- .row (validate btn) -->
      </form>
    </div>

    <div class="tab-pane" id="parameters">

      <table class="table table-bordered text-center table-margin" id="parametersTable">
        <thead>
          <tr>
            <th class="table-header-primary text-center">Parameter Key</th>
            <th class="table-header-primary text-center">Field</th>
            <th class="table-header-primary text-center">If Empty</th>
            <th class="table-header-primary text-center">Default Value</th>
            <th class="table-header-primary text-center"  style="width: 15%;"></th>
          </tr>
        </thead>
        <tbody style="font-size: smaller;" id="parametersTableBody">
          <?php
              $parametersCounter = 0;
if (is_array($parameters)) {

    foreach ($parameters as $key => $parameter) {
        ?>
              <tr data-id="parameter_<?php echo $parametersCounter++?>" class="parameter-row">
                <td class="vertical-align-middle parameter-body"><?php echo $parameter['key'] ?></td>
                <td class="vertical-align-middle parameter-body"><?php echo $parameter['column'] ?></td>
                <td class="vertical-align-middle parameter-body"><?php echo $parameter['if_empty'] ?></td>
                <td class="vertical-align-middle parameter-body"><?php echo $parameter['default'] ?></td>
              <td class="vertical-align-middle" style="width: 15%;">
                  <button class="icon-btn btn btn-secondary btn-sm edit-btn" title="Edit">
                      <span class="fa fa-edit fa-fw"></span>
                  </button>
                  <button class="icon-btn btn btn-secondary btn-sm delete-btn" title="Delete">
                      <span class="fa fa-trash-alt fa-fw"></span>
                  </button>
              </td>
              </tr>
          <?php
    }

}

?>

        </tbody>
      </table>

      <!-- Form Section -->
      <form id="parameterForm"  action="<?php echo($_SERVER['PHP_SELF']); ?>" method="post" name="myform2" onsubmit="return false;" style="margin-top:20px">
      <fieldset class="fieldset">
        <legend class="legend"><i class="fa fa-gear"></i> Parameter Settings</legend>
        <div class="row form-group">
          <div class="col-xs-5">
            <label for="parameter_column">Parameter Column</label>
            <select class="form-control" id="parameter_column">
              <option selected>Select column</option>
            </select>
          </div>
          <div class="help-container col-xs-1">
            <a href="" id="pcHelp" onclick="return false;" data-toggle="popover" data-original-title="" title=""> <img src="includes/images/help.png" width="15" height="15" border="0">
            </a>
          </div>

          <div class="col-xs-5">
            <label for="ifEmpty">If Empty</label>
            <select class="form-control" id="ifEmpty">
              <option value="show-all">Show All</option>
              <option value="default">Default</option>
            </select>
          </div>
          <div class="help-container col-xs-1">
            <a href="" id="pifEmptyHelp" onclick="return false;" data-toggle="popover" data-original-title="" title=""> <img src="includes/images/help.png" width="15" height="15" border="0">
            </a>
          </div>

        </div>

        <div class="row form-group">

          <div class="col-xs-5">
            <label>Parameter URL Key</label>
            <input type="text" id="parameter_url_key" name="parameter_url_key" class="form-control">
          </div>
          <div class="help-container col-xs-1">
            <a href="" id="pKeyHelp" onclick="return false;" data-toggle="popover" data-original-title="" title=""> <img src="includes/images/help.png" width="15" height="15" border="0">
            </a>
          </div>
          <div class="col-xs-5">
            <label for="defaultValue">Default Value</label>
            <div class="default-value-container" id="defaultValueContainer">
              <input type="text" class="form-control" id="defaultValue" name="defaultValue">
            </div>

          </div>
          <div class="help-container col-xs-1">
            <a href="" id="pDefaultValHelp" onclick="return false;" data-toggle="popover" data-original-title="" title=""> <img src="includes/images/help.png" width="15" height="15" border="0">
            </a>
          </div>

        </div>

        <div class="row form-group" style="display: flex;justify-content: center;">
            <div class="col-xs-2">
                <button class="btn btn-primary btn-block btn-xs" style="font-size: 12px; outline: none;" id="saveParamBtn">Save</button>
            </div>
            <div class="col-xs-2">
                <button class="btn btn-primary btn-block btn-xs" style="font-size: 12px; outline: none;" id="clearBtn">Clear</button>

            </div>
        </div>

        <!-- Hidden inputs container -->
        <div id="hiddenInputsContainer">
          <?php
    $inputsCounter = 0;
if (is_array($parameters)) {

    foreach ($parameters as $key => $parameter) {
        ?>
              <tr>
                <input type="hidden" name="parameter_<?php echo $inputsCounter ?>[column]" value="<?php echo $parameter['column'] ?>">
                <input type="hidden" name="parameter_<?php echo $inputsCounter ?>[if_empty]" value="<?php echo $parameter['if_empty'] ?>">
                <input type="hidden" name="parameter_<?php echo $inputsCounter ?>[default]" value="<?php echo $parameter['default'] ?>">
                <input type="hidden" name="parameter_<?php echo $inputsCounter ?>[key]" value="<?php echo $parameter['key'] ?>">
              </tr>
          <?php
              $inputsCounter++;
    }

}

?>

        </div>
    </div>
    <div class="alert alert-danger" id="validationAlert" style="display: none;">
      <span id="validationMessage"></span>
    </div>
    <br />
    <?php

    if ($_SESSION[Session_wizard_key]["edit_mode"]) {?>
      <div class="alert alert-info">
        <div class="row">
          <div class="col-xs-1" style="margin-right: -17px;margin-top: 5px;">
            <i class="fa fa-info-circle fa-fw"></i>
          </div>
          <div class="col-xs-11">

            <span style="font-size: smaller;">If you make changes to saved options at any point, remember to click
              'Next' on that step to ensure your changes are saved</span>
          </div>
        </div>
      </div>
    <?php }

    ?>

    <div class="row" style="margin-top:10px">
      <div class="col-xs-1"></div>
      <div class="col-xs-4">
        <button name="btn_back" id="btn_back" class="btn btn-sunny btn-block">
          <span class="icon glyphicon glyphicon-backward"></span><span class="separator"></span> Back
        </button>
      </div>
      <div class="col-xs-2"></div>
      <div class="col-xs-4">
        <button name="btn_continue" id="btn_cont" class="btn btn-sunny btn-block">
          <span class="icon glyphicon glyphicon-forward"></span><span class="separator"></span> Next
        </button>
      </div>
      <div class="col-xs-1"></div>
    </div><!-- .row (navigation buttons) -->
  </fieldset>
  </form>
  </div>
  <!-- end of first tab -->


  <div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel">
    <div class="modal-dialog" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
          <h4 class="modal-title" id="deleteModalLabel">
            <span class="glyphicon glyphicon-warning-sign text-warning"></span>
            Confirm Delete
          </h4>
        </div>
        <div class="modal-body">
          <p style="font-size: smaller;">Are you sure you want to delete the parameter <strong id="parameterToDelete"></strong>?</p>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
          <button type="button" class="btn btn-danger" id="confirmDeleteBtn">
            <span class="glyphicon glyphicon-trash"></span>
            Delete
          </button>
        </div>
      </div>

    </div>
  </div><!-- to complete index tags -->
</div>

</div>
</div>
</div>
<!-- end index tags -->
<script type="text/javascript">
  $(function() {
    // set header images
    $("#page-header").empty();
    $("#page-header").append(
      '<div id="img-container"><img src="includes/images/sql.png" width="70" height="70"/></div>');
    $("#page-header").append('<div id="text-container"><h4>Enter SQL Query</h4>Please enter valid SQL Query</div>');
    // set auto complete
    var availableTags = [
      "ACCESSIBLE`", "ADD", "ALL ", "ALTER", "ANALYZE", "AND ", "AS",
      "ASC", "ASENSITIVE ", "BEFORE", "BETWEEN", "BIGINT ", "BINARY",
      "BLOB", "BOTH ", "BY", "CALL", "CASCADE ", "CASE", "CHANGE",
      "CHAR ", "CHARACTER", "CHECK", "COLLATE ", "COLUMN", "CONDITION",
      "CONSTRAINT ", "CONTINUE", "CONVERT", "CREATE ", "CROSS", "CURRENT_DATE",
      "CURRENT_TIME ", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR ", "DATABASE",
      "DATABASES", "DAY_HOUR ", "DAY_MICROSECOND", "DAY_MINUTE", "DAY_SECOND ",
      "DEC", "DECIMAL", "DECLARE ", "DEFAULT", "DELAYED", "DELETE ", "DESC",
      "DESCRIBE", "DETERMINISTIC ", "DISTINCT", "DISTINCTROW", "DIV ", "DOUBLE",
      "DROP", "DUAL ", "EACH", "ELSE", "ELSEIF ", "ENCLOSED", "ESCAPED", "EXISTS ",
      "EXIT", "EXPLAIN", "FALSE ", "FETCH", "FLOAT", "FLOAT4 ", "FLOAT8", "FOR", "FORCE ",
      "FOREIGN", "FROM", "FULLTEXT ", "GENERAL[a]", "GRANT", "GROUP ", "HAVING", "HIGH_PRIORITY",
      "HOUR_MICROSECOND ", "HOUR_MINUTE", "HOUR_SECOND", "IF ", "IGNORE", "IGNORE_SERVER_IDS[b]",
      "IN ", "INDEX", "INFILE", "INNER ", "INOUT", "INSENSITIVE", "INSERT ", "INT", "INT1", "INT2 ",
      "INT3", "INT4", "INT8 ", "INTEGER", "INTERVAL", "INTO ", "IS", "ITERATE", "JOIN ", "KEY", "KEYS",
      "KILL ", "LEADING", "LEAVE", "LEFT ", "LIKE", "LIMIT", "LINEAR ", "LINES", "LOAD", "LOCALTIME ",
      "LOCALTIMESTAMP", "LOCK", "LONG ", "LONGBLOB", "LONGTEXT", "LOOP ", "LOW_PRIORITY",
      "MASTER_HEARTBEAT_PERIOD[c]",
      "MASTER_SSL_VERIFY_SERVER_CERT ", "MATCH", "MAXVALUE", "MEDIUMBLOB ", "MEDIUMINT", "MEDIUMTEXT", "MIDDLEINT ",
      "MINUTE_MICROSECOND", "MINUTE_SECOND", "MOD ", "MODIFIES", "NATURAL", "NOT ", "NO_WRITE_TO_BINLOG", "NULL",
      "NUMERIC ", "ON", "OPTIMIZE", "OPTION ", "OPTIONALLY", "OR", "ORDER ", "OUT", "OUTER", "OUTFILE ",
      "PRECISION",
      "PRIMARY", "PROCEDURE ", "PURGE", "RANGE", "READ ", "READS", "READ_WRITE", "REAL ", "REFERENCES", "REGEXP",
      "RELEASE ",
      "RENAME", "REPEAT", "REPLACE ", "REQUIRE", "RESIGNAL", "RESTRICT ", "RETURN", "REVOKE", "RIGHT ", "RLIKE",
      "SCHEMA",
      "SCHEMAS ", "SECOND_MICROSECOND", "SELECT", "SENSITIVE ", "SEPARATOR", "SET", "SHOW ", "SIGNAL", "SLOW[d]",
      "SMALLINT ",
      "SPATIAL", "SPECIFIC", "SQL ", "SQLEXCEPTION", "SQLSTATE", "SQLWARNING ", "SQL_BIG_RESULT",
      "SQL_CALC_FOUND_ROWS",
      "SQL_SMALL_RESULT ", "SSL", "STARTING", "STRAIGHT_JOIN ", "TABLE", "TERMINATED", "THEN ", "TINYBLOB",
      "TINYINT",
      "TINYTEXT ", "TO", "TRAILING", "TRIGGER ", "TRUE", "UNDO", "UNION ", "UNIQUE", "UNLOCK", "UNSIGNED ",
      "UPDATE",
      "USAGE", "USE ", "USING", "UTC_DATE", "UTC_TIME ", "UTC_TIMESTAMP", "VALUES", "VARBINARY ", "VARCHAR",
      "VARCHARACTER",
      "VARYING ", "WHEN", "WHERE", "WHILE ", "WITH", "WRITE", "XOR ", "YEAR_MONTH", "ZEROFILL",

    ];

    function split(val) {
      return val.split(/ /);
    }

    function extractLast(term) {
      return split(term).pop();
    }

    // don't navigate away from the field on tab when selecting an item
    $("#sql").bind("keydown", function(event) {
        if (event.keyCode === $.ui.keyCode.TAB && $(this).data("ui-autocomplete").menu.active) {
          event.preventDefault();
        }
      })
      .autocomplete({
        minLength: 0,
        source: function(request, response) {
          // delegate back to autocomplete, but extract the last term
          response($.ui.autocomplete.filter(
            availableTags, extractLast(request.term)));
        },
        focus: function() {
          // prevent value inserted on focus
          return false;
        },
        select: function(event, ui) {
          var terms = split(this.value);
          // remove the current input
          terms.pop();
          // add the selected item
          terms.push(ui.item.value);
          // add placeholder to get the comma-and-space at the end
          terms.push("");
          this.value = terms.join(" ");
          return false;
        }
      });
  });
  // -----------------------------------------------------------------------------------
  var validated = false;
  $(document).ready(function() {


    $("#tabs").tabs();
    
    <?php if ($_SESSION[Session_wizard_key]["edit_mode"] == true && $isLinkedOrIntermediate): ?>
    validateOnEdit();

    <?php endif;?>

    <?php if (online_demo_mode):?>
      $("#confirmDeleteBtn").off('click');

    <?php endif?>

    $("#views").change(function() {
      var selectedView = $(this).val();
      $.ajax({
        url: "services/step_3_sql.php",
        type: "post",
        data: "selected_view=" + selectedView,
        success: function(data) {
          $("#sql").val(data);
        },
        error: function() {

        }
      });
    });

    $("#btn_validate").mousedown(function() {
      const $switchLi = $('#switchStatus').closest('li');
      $switchLi.nextAll('li').addClass('disabled-now');

      validate();
    });

    $("#btn_cont").mousedown(function() {
    var tab = $(".ui-tabs-nav li.active a").attr('id');
    if(tab == "tables-nav" && <?php echo $isLinkedOrIntermediate ? "true" : "false"; ?> ){
      $("#parameters-nav").trigger("click");
      return;
    }


      var sql = $("#sql").val();
      $.ajax({
        url: "services/step_3_sql.php",
        type: "post",
        data: "continue_sql=" + encodeURIComponent(sql),
        success: function(data) {
          $("#error-container").empty();
          var is_success = data.search("success");


          if (is_success !== -1) {
              <?php if ($isLinkedOrIntermediate):?>
              if(checkEmptyParametersTable()){
                showValidationAlert("At least one Parameter should be added since the Report Relationship type is linked");
                return;
              }
              <?php endif;?>
            nextToPage("2");
            SwitchStatusDone();
          } else {
            if (data === '') $("#error-container").append(
              "<div class='alert alert-danger'> No response from serevr </div>");
            else $("#error-container").append("<div class='alert alert-danger'>" + data + "</div>");
            SwitchStatusError();
            return;
          }



        },
        error: function() {

        }
      });

    });


    $("#btn_back").mousedown(function() {
      backToPage("0");
    });

    $("#parameters-nav").click(function(e) {
      if(<?php echo isset($_SESSION[Session_wizard_key]["sql"]) ? "false" : "true" ?>){
        
      }
      else if (!validated && (<?php echo $_SESSION[Session_wizard_key]["edit_mode"] == true ? "false" : "true" ?> || <?php echo isset($_SESSION[Session_wizard_key]["sql"]) ? "false" : "true" ?>)){
        e.preventDefault();
        $("#tables-nav").click();
        alertify.error("Please validate sql before this step");
        return;
      }
    });

    /**
     * Parameters
     *
     */

    let editingRowIndex = -1;
    let parameterCounter = 0;

    $("#parameter_column").on('change', function() {
      if ($(this).val() != "select column")
        $("#parameter_url_key").val($(this).val());

      updateDefaultValueInput();

    })


    $("#defaultValue").prop('disabled', true);

    $("#ifEmpty").on('change', function() {
      if ($(this).val() == "show-all") {
        $("#defaultValue").prop('disabled', true);

      } else if ($(this).val() == "default") {
        $("#defaultValue").prop('disabled', false);

      }

      updateDefaultValueInput();

    });

    // Save Parameter functionality
    $('#saveParamBtn').click(function(e) {
      e.preventDefault();
      $('#validationAlert').hide();
      const formData = {
        parameterColumn: $('#parameter_column').val(),
        ifEmpty: $('#ifEmpty').val(),
        defaultValue: getDefaultValue(),
        parameterUrlKey: $('#parameter_url_key').val()
      };


      const validationResult = validateForm(formData, editingRowIndex);
      if (!validationResult.isValid) {
        showValidationAlert(validationResult.message);
        return;
      }

      // Validate required fields
      if (!formData.parameterColumn || !formData.parameterUrlKey) {
        showValidationAlert('Please fill in all required fields: Parameter Column, and Parameter URL Key');
        return;
      }

      $(".empty-message").remove();

      if (editingRowIndex >= 0) {
        // Update existing row
        updateTableRow(editingRowIndex, formData, formData.parameterColumn);
        updateHiddenInput(editingRowIndex, formData);
        editingRowIndex = -1;
        $('#saveParamBtn').text('Save');
      } else {
        // Add new row
        addTableRow(formData, formData.parameterColumn);
        const newIndex = getNextParameterIndex();
        addHiddenInput(formData, newIndex);
        parameterCounter++;
      }

      // Clear form
      clearForm();
      updateHiddenInputsDisplay();

      // Send AJAX request with all hidden input data
      sendHiddenInputsAjax();

    });



    // Clear form functionality
    $('#clearBtn').click(function(e) {
      e.preventDefault();
      clearForm();
      editingRowIndex = -1;
      $('#validationAlert').hide();
      $('#saveParamBtn').text('Save');
      $('.editing-row').removeClass('editing-row');
    });

    // Edit functionality
    $(document).on('click', '.edit-btn', function() {
      const row = $(this).closest('tr');
      editingRowIndex = row.index();
      $('#validationAlert').hide();

      // Remove editing class from all rows
      $('.editing-row').removeClass('editing-row');
      // Add editing class to current row
      row.addClass('editing-row');

      // Get data from row
      const parameterKey = row.find('td:eq(0)').text();
      const field = row.find('td:eq(1)').text();
      const ifEmpty = row.find('td:eq(2)').text();
      const defaultValue = row.find('td:eq(3)').text();

      // Parse field to get table and column
      const column = field;

      // Populate form
      $('#parameter_column').val(column);
      $('#ifEmpty').val(ifEmpty === 'default' ? 'default' : 'show-all');
      $('#defaultValue').prop("disabled", ifEmpty != 'default' ? true : false);
      $('#parameter_url_key').val(parameterKey);

      updateDefaultValueInputForEdit(defaultValue);

      // Change button text
      // $('#saveParamBtn').text('Update');
    });

    // Delete functionality
    $(document).on('click', '.delete-btn', function() {
      const row = $(this).closest('tr');
      const parameterKey = row.find('td:eq(0)').text();
      $('#validationAlert').hide();
      // Store the row to be deleted
      rowToDelete = row;

      // Update modal content
      $('#parameterToDelete').text(parameterKey);

      // Show the modal
      $('#deleteModal').modal('show');

      updateDefaultValueInputForEdit(defaultValue);


    });

    // Confirm delete functionality
    $('#confirmDeleteBtn').click(function() {
      if (rowToDelete) {
        const rowId = rowToDelete.attr("data-id");
        if($(`tr[data-id="${rowId}"]`).length > 0)
          $(`tr[data-id="${rowId}"]`).remove();
        else
          rowToDelete.remove();
        
        $(`tr[data-id="${rowId}"]`).remove();
        removeHiddenInput(rowId);
        updateHiddenInputsDisplay();
        sendHiddenInputsAjax();
        // Clear the stored row
        rowToDelete = null;

        // Hide the modal
        $('#deleteModal').modal('hide');

        // Check if table is empty
        checkEmptyTable();
      }
    });

    // Clear rowToDelete when modal is closed
    $('#deleteModal').on('hidden.bs.modal', function() {
      rowToDelete = null;
    });
    // Initialize hidden inputs for the existing row
    updateHiddenInputsDisplay();
    // Check if table is empty on load (in case the initial row is removed)
    checkEmptyTable();

    // --------------------------------------------------------------------------------------------------------------------


    setTimeout(() => {
      $("#confirmDeleteBtn").click(function() {
        $('#deleteModal').modal('hide');
        alertify.error("Available Only in Full version.");
        return false;
      });

      $("#saveParamBtn").click(function() {
        alertify.error("Available Only in Full version.");
        return false;
      });

    }, 1000);

  });

  function validate(){

      $("#parametersTableBody tr").remove();
      checkEmptyTable();
      $("#hiddenInputsContainer input").remove();

      var sql = $("#sql").val();
      $.ajax({
        url: "services/step_3_sql.php",
        type: "post",
        data: "validate_sql=" + encodeURIComponent(sql),
        success: function(data) {
          $("#error-container").empty();
          var is_success = data.search("success");
          if (is_success !== -1) { //SELECT * FROM `orders`
            data = data.split("|");
            $("#error-container").append("<div class='alert alert-success'>Valid SQL statement, Returns " +
              data[1] + " rows</div>");
            validated = true;
            getTablesInfo(sql);
          } else {
            if (data === '') $("#error-container").append(
              "<div class='alert alert-danger'> Server Error! </div>");
            else $("#error-container").append("<div class='alert alert-danger'>" + data + "</div>");

          }
        },
        error: function() {

        }
      });

  }

  function validateOnEdit(){
      var sql = $("#sql").val();
      $.ajax({
        url: "services/step_3_sql.php",
        type: "post",
        data: "validate_sql=" + encodeURIComponent(sql) + "&edit_mode=true",
        success: function(data) {
          $("#error-container").empty();
          var is_success = data.search("success");
          if (is_success !== -1) { //SELECT * FROM `orders`
            validated = true;
            getTablesInfo(sql);
          } else {
            if (data === '') $("#error-container").append(
              "<div class='alert alert-danger'> Server Error! </div>");
            else $("#error-container").append("<div class='alert alert-danger'>" + data + "</div>");

          }
        },
        error: function() {

        }
      });

  }

  function updateDefaultValueInputForEdit(defaultValue) {
    const selectedColumn = $('#parameter_column option:selected').first();
    const ifEmptyValue = $('#ifEmpty').val();
    const dataType = selectedColumn.attr('datatype');
    const dataValues = selectedColumn.attr('enumvalues');
    const container = $('#defaultValueContainer');

    // Clear the container
    container.empty();

    if (ifEmptyValue !== 'default') {
        // If "Show All" is selected, show disabled input
        container.html('<input type="text" class="form-control" id="defaultValue" name="defaultValue" disabled>');
        return;
    }

    if (!dataType) {
        // No column selected or no data type, show regular input with value
        container.html(`<input type="text" class="form-control" id="defaultValue" name="defaultValue" placeholder="Enter default value" value="${defaultValue || ''}">`);
        return;
    }

    // Create appropriate input based on data type and set the value
    switch(dataType.toLowerCase()) {
        case 'enum':
        case 'set':
            createEnumSetInputForEdit(container, dataValues, dataType, defaultValue);
            break;
        case 'varchar':
        case 'char':
        case 'text':
            createTextInputForEdit(container, 'Enter default text value', defaultValue);
            break;
        case 'int':
        case 'decimal':
        case 'float':
        case 'double':
            createNumberInputForEdit(container, dataType, defaultValue);
            break;
        case 'bit':
        case 'tinyint':
            createBitInputForEdit(container, defaultValue);
            break;
        case 'date':
            createDynamicLabel(container, 'Current Date - Dynamic');
            break;
        case 'time':
            createDynamicLabel(container, 'Current Time - Dynamic');
            break;
        case 'datetime':
        case 'timestamp':
            createDynamicLabel(container, 'Current DateTime - Dynamic');
            break;
        default:
            createTextInputForEdit(container, 'Enter default value', defaultValue);
    }
}

// Helper functions for edit mode that include setting values
function createEnumSetInputForEdit(container, dataValues, dataType, defaultValue) {
    if (!dataValues) {
        container.html(`<input type="text" class="form-control" id="defaultValue" name="defaultValue" placeholder="Enter default value" value="${defaultValue || ''}">`);
        return;
    }

    const values = dataValues.split(',');
    let selectHtml = '<select class="form-control" id="defaultValue" name="defaultValue">';
    selectHtml += '<option value="">Select a value</option>';

    values.forEach(value => {
        const trimmedValue = value.trim();
        const selected = trimmedValue === defaultValue ? 'selected' : '';
        selectHtml += `<option value="${trimmedValue}" ${selected}>${trimmedValue}</option>`;
    });

    selectHtml += '</select>';
    container.html(selectHtml);
}

function createTextInputForEdit(container, placeholder, defaultValue) {
    container.html(`<input type="text" class="form-control" id="defaultValue" name="defaultValue" placeholder="${placeholder}" value="${defaultValue || ''}">`);
}

function createNumberInputForEdit(container, dataType, defaultValue) {
    const step = (dataType.toLowerCase() === 'int') ? '1' : '0.01';
    container.html(`<input type="number" class="form-control" id="defaultValue" name="defaultValue" placeholder="Enter default number" step="${step}" value="${defaultValue || ''}">`);
}

function createBitInputForEdit(container, defaultValue) {
    const checked0 = (defaultValue === '0' || defaultValue === 0) ? 'checked' : '';
    const checked1 = (defaultValue === '1' || defaultValue === 1) ? 'checked' : '';

    container.html(`
<div class="radio-group">
            <div class="radio">
                <label>
                    <input type="radio" name="defaultValue" value="1" ${checked1}>
                    True
                </label>
            </div>
            <div class="radio">
                <label>
                    <input type="radio" name="defaultValue" value="0" ${checked0}>
                    False
                </label>
            </div>
        </div>    `
      );
}


function updateDefaultValueInput() {
  const selectedColumn = $('#parameter_column option:selected').first();
  const ifEmptyValue = $('#ifEmpty').val();
  const dataType = selectedColumn.attr('datatype');
  const dataValues = selectedColumn.attr('enumvalues');
  const container = $('#defaultValueContainer');

  // Clear the container
  container.empty();

  if (ifEmptyValue !== 'default') {
      // If "Show All" is selected, show disabled input
      container.html('<input type="text" class="form-control" id="defaultValue" name="defaultValue" disabled>');
      return;
  }

  if (!dataType) {
      // No column selected or no data type, show regular input
      container.html('<input type="text" class="form-control" id="defaultValue" name="defaultValue" placeholder="Enter default value">');
      return;
  }

  // Create appropriate input based on data type
  switch(dataType.toLowerCase()) {
      case 'enum':
      case 'set':
          createEnumSetInput(container, dataValues, dataType);
          break;
      case 'varchar':
      case 'char':
      case 'text':
          createTextInput(container, 'Enter default text value');
          break;
      case 'int':
      case 'decimal':
      case 'float':
      case 'double':
          createNumberInput(container, dataType);
          break;
      case 'bit':
      case 'tinyint':
          createBitInput(container);
          break;
      case 'date':
          createDynamicLabel(container, 'Current Date - Dynamic');
          break;
      case 'time':
          createDynamicLabel(container, 'Current Time - Dynamic');
          break;
      case 'datetime':
      case 'timestamp':
          createDynamicLabel(container, 'Current DateTime - Dynamic');
          break;
      default:
          createTextInput(container, 'Enter default value');
  }
}

function createEnumSetInput(container, values, type) {
  if (!values) {
      createTextInput(container, 'No values defined for this ' + type);
      return;
  }

  const valuesArray = values.split(',');
  let selectHtml = '<select class="form-control" id="defaultValue" name="defaultValue">';
  selectHtml += '<option value="">Select default value</option>';

  valuesArray.forEach(function(value) {
      selectHtml += `<option value="${value.trim()}">${value.trim()}</option>`;
  });

  selectHtml += '</select>';
  container.html(selectHtml);
}

function createTextInput(container, placeholder) {
  container.html(`<input type="text" class="form-control" id="defaultValue" name="defaultValue" placeholder="${placeholder}">`);
}

function createNumberInput(container, dataType) {
  const isDecimal = dataType.toLowerCase() === 'decimal' || dataType.toLowerCase() === 'float' || dataType.toLowerCase() === 'double';
  const step = isDecimal ? 'step="0.01"' : '';
  container.html(`<input type="text" class="form-control" id="defaultValue" name="defaultValue" placeholder="Enter default number" ${step}>`);
}

function createBitInput(container) {
    const radioHtml = `
        <div class="radio-group">
            <div class="radio">
                <label>
                    <input type="radio" name="defaultValue" value="1"> 
                    True
                </label>
            </div>
            <div class="radio">
                <label>
                    <input type="radio" name="defaultValue" value="0"> 
                    False
                </label>
            </div>
        </div>
    `;
    container.html(radioHtml);
}

function createDynamicLabel(container, text) {

  container.html(`<div class="dynamic-label">${text}</div><input type="hidden" id="defaultValue" name="defaultValue" value="${text}">`);
}

function getDefaultValue() {
    // Check if it's a radio button first
    if ($('input[name="defaultValue"]:radio').length > 0) {
        return $('input[name="defaultValue"]:checked').val() || '';
    }
    
    // For other input types, use the ID selector
    const defaultValueElement = $('#defaultValue');
    
    if (defaultValueElement.attr('type') === 'checkbox') {
        return defaultValueElement.is(':checked') ? '1' : '0';
    } else if (defaultValueElement.attr('type') === 'hidden') {
        return defaultValueElement.val();
    } else {
        return defaultValueElement.val() || '';
    }
}

function setDefaultValue(value, dataType) {
    // Check if it's a radio button
    if ($('input[name="defaultValue"]:radio').length > 0) {
        $('input[name="defaultValue"][value="' + value + '"]').prop('checked', true);
    } else {
        const defaultValueElement = $('#defaultValue');
        
        if (defaultValueElement.attr('type') === 'checkbox') {
            defaultValueElement.prop('checked', value === '1' || value === 'true');
        } else {
            defaultValueElement.val(value);
        }
    }
}


  function sendHiddenInputsAjax() {
    let linkedParameters = {};

    // Loop over each parameter group
    $('#hiddenInputsContainer').find('input[name^="parameter_"]').each(function() {
      let inputName = $(this).attr('name'); // example: parameter_1[column]
      let inputValue = $(this).val();

      // Extract Param_id and field name
      let matches = inputName.match(/^parameter_(\d+)\[(\w+)\]$/);
      if (matches) {
        let paramId = "parameter_" + matches[1];
        let fieldName = matches[2];

        if (!linkedParameters[paramId]) {
          linkedParameters[paramId] = {};
        }
        linkedParameters[paramId][fieldName] = inputValue;
      }
    });

    $.ajax({
      url: 'services/step_3_sql.php',
      type: 'POST',
      contentType: 'application/json',
      data: JSON.stringify({
        linked_parameters: linkedParameters
      }),
      success: function(response) {},
      error: function(xhr, status, error) {}
    });
  }


  function addTableRow(formData, fieldName) {
      const ifEmptyText = formData.ifEmpty === 'default' ? 'default' : 'show all';
      
      const newRow = `
          
          <tr class="parameter-row">
              <td class="vertical-align-middle parameter-body">${formData.parameterUrlKey}</td>
              <td class="vertical-align-middle parameter-body">${fieldName}</td>
              <td class="vertical-align-middle parameter-body">${ifEmptyText}</td>
              <td class="vertical-align-middle parameter-body">${formData.defaultValue}</td>
              <td class="vertical-align-middle" style="width: 15%;">
                  <button class="icon-btn btn btn-secondary btn-sm edit-btn" title="Edit">
                      <span class="fa fa-edit fa-fw"></span>
                  </button>
                  <button class="icon-btn btn btn-secondary btn-sm delete-btn" title="Delete">
                      <span class="fa fa-trash-alt fa-fw"></span>
                  </button>
              </td>
          </tr>
      `;
    $('#parametersTableBody').append(newRow);
  }

  function updateTableRow(rowIndex, formData, fieldName) {
    const row = $('#parametersTableBody tr:eq(' + rowIndex + ')');
    const ifEmptyText = formData.ifEmpty === 'default' ? 'default' : 'show all';

    row.find('td:eq(0)').text(formData.parameterUrlKey);
    row.find('td:eq(1)').text(fieldName);
    row.find('td:eq(2)').text(ifEmptyText);
    row.find('td:eq(3)').text(formData.defaultValue);
    row.removeClass('editing-row');
  }

  function addHiddenInput(formData, parameterCounter) {
    const hiddenInputsHtml = `
          <input type="hidden" name="parameter_${parameterCounter}[column]" value="${formData.parameterColumn}">
          <input type="hidden" name="parameter_${parameterCounter}[if_empty]" value="${formData.ifEmpty}">
          <input type="hidden" name="parameter_${parameterCounter}[default]" value="${formData.defaultValue}">
          <input type="hidden" name="parameter_${parameterCounter}[key]" value="${formData.parameterUrlKey}">
      `;
    $('#hiddenInputsContainer').append(hiddenInputsHtml);
  }

  function getNextParameterIndex() {
    let maxIndex = -1;
      $('#hiddenInputsContainer input[name^="parameter_"][name$="[column]"]').each(function () {
          const name = $(this).attr('name'); // e.g., "parameter_2[column]"
          const match = name.match(/^parameter_(\d+)\[column\]$/);
          if (match && match[1]) {
              const index = parseInt(match[1]);
              if (index > maxIndex) {
                  maxIndex = index;
              }
          }
      });
      return maxIndex + 1;
  }

  function updateHiddenInput(rowIndex, formData) {
      $(`input[name="parameter_${rowIndex}[column]"`).val(formData.parameterColumn);
      $(`input[name="parameter_${rowIndex}[if_empty]"`).val(formData.ifEmpty);
      $(`input[name="parameter_${rowIndex}[default]"`).val(formData.defaultValue);
      $(`input[name="parameter_${rowIndex}[key]"`).val(formData.parameterUrlKey);
  }

  function removeHiddenInput(rowId) {
      $(`input[name^="${rowId}["]`).remove();
  }

  function clearForm() {
    
    $('#parameterForm')[0].reset();
    $('#parameter_table').val('');
    $('#parameter_column').val('');
    $('#ifEmpty').val('show-all');
    const defaultValueContainer = $('#defaultValueContainer');
    defaultValueContainer.html( '<input type="text" class="form-control" id="defaultValue" name="defaultValue" disabled="">');
  }

  function updateHiddenInputsDisplay() {
    const hiddenInputs = $('#hiddenInputsContainer input');
    if (hiddenInputs.length === 0) {
      $('#hiddenInputsDisplay').html('No hidden inputs yet');
    } else {
      let displayHtml = '';
      hiddenInputs.each(function() {
        displayHtml += `<div><strong>${$(this).attr('name')}:</strong> ${$(this).val()}</div>`;
      });
      $('#hiddenInputsDisplay').html(displayHtml);
    }
  }

  function validateForm(formData, editingRowIndex) {
    // 1. Check if column is selected
    if (!formData.parameterColumn || formData.parameterColumn == "Select column") {
      return {
        isValid: false,
        message: "Please select Parameter Column"
      };
    }

    // 2. Check if key exists
    if (!formData.parameterUrlKey) {
      return {
        isValid: false,
        message: "Parameter Key can't be empty"
      };
    }

    // 3. Check if key has spaces or special characters
    const keyRegex = /^[a-zA-Z0-9_]+$/;
    if (!keyRegex.test(formData.parameterUrlKey)) {
      return {
        isValid: false,
        message: "Key can't have spaces or special characters"
      };
    }

    // 4. Check if key already exists (except when editing the same row)
    const existingKeys = [];
    $('#parametersTableBody tr:not(.empty-message)').each(function(index) {
      if (editingRowIndex === -1 || index !== editingRowIndex) {
        const key = $(this).find('td:eq(0)').text().trim();
        if (key) {
          existingKeys.push(key.toLowerCase());
        }
      }
    });

    if (existingKeys.includes(formData.parameterUrlKey.toLowerCase())) {
      return {
        isValid: false,
        message: "Parameter key must be unique"
      };
    }

    // 5. Check if "use default" is selected but default value is empty
    if (formData.ifEmpty === 'default' && !formData.defaultValue) {
      return {
        isValid: false,
        message: "Please add a default value or change the if empty option"
      };
    }

    return {
      isValid: true,
      message: ""
    };
  }

  function showValidationAlert(message) {
    $('#validationMessage').text(message);
    $('#validationAlert').slideDown();

  }

  function checkEmptyParametersTable() {
    const dataRows = $('#parametersTableBody tr:not(.empty-message)');
    if (dataRows.length === 0) {
      return true;
    }
    return false
  }

  function checkEmptyTable() {
    const dataRows = $('#parametersTableBody tr:not(.empty-message)');
    if (dataRows.length === 0) {
      showEmptyMessage();
    }
  }

  function showEmptyMessage() {
    const emptyRow = `
          <tr class="empty-message">
              <td colspan="5" class="parameter-body">
                  No parameters added yet
              </td>
          </tr>
      `;
    $('#parametersTableBody').append(emptyRow);
  }

  function removeEmptyMessage() {
    $('#parametersTableBody .empty-message').remove();
  }

  function getTablesInfo(sql) {
    $.ajax({
      url: "services/columnInfo.php",
      type: "post",
      data: "columnsInfo=" + encodeURIComponent(sql),
      success: function(data) {
        selectedTables = JSON.parse(data)['columns'];

        setColumnsInfo("parameter_column",selectedTables,true,"Select column");
      }
    });
}


function setColumnsInfo(id, value, firstOption=false , firstOptionText = "") {
  id = "#" + id;
    $(id).empty();

    if(firstOption)
      $(id).append('<option>' + firstOptionText + '</option>');
    
    // for(var i = 0; i < value.length; i++) $(id).append('<option value="'+value[i][0]+'">'+value[i][0]+'</option>');
    for (var key in value)
    $(id).append(`<option value="${key}" datatype="${(typeof value[key] === 'object') ? value[key].type : value[key]}" enumvalues="${(typeof value[key] === 'object') ? value[key].enum_values : ''}">${key}</option>`);
}

</script>
<!--
	</body>
</html>
-->