<?php
if (!defined('DIRECTACESS'))
    exit('No direct script access allowed');

$isParent       = $report_relation === "parent";
$isIntermediate = $report_relation === "intermediate";

if ($isParent || $isIntermediate) {
    $report_mapping         = $srm_dashboard->prepare_parameters_mapping($tables_parameters_mapping);
    $linked_reports_count   = count($report_mapping);
    $isParentOrIntermediate = !empty($report_mapping);
} else {
    $isParentOrIntermediate = false;
}

$hide_labels = !empty($field_settings['hide_field_label']);
$use_title   = !empty($field_settings['use_first_as_title']);

$non_group_fields = array_values(array_diff($actual_fields, $group_by));
$title_field      = $use_title && count($non_group_fields) ? $non_group_fields[0] : null;

// Convert result to array
$result_array = [];
foreach ($result as $row) {
    foreach ($calculated_columns as $key => $value) {
        $row[$key] = $value($row);
    }
    $result_array[] = $row;
}

// Function to render one record cell
$renderRecord = function ($row) use ($actual_fields, $labels, $cells, $isParentOrIntermediate, $report_mapping, $hide_labels, $use_title, $title_field) {
    global $_CLEANED;

    if ($row === null) {
        echo "<div style='flex:1;'>&nbsp;</div>";
        return;
    }

    echo "<div style='flex:1;display:flex; flex-direction:column;' class='full-backgroud'>";
    echo "<table width='100%' cellspacing='0' cellpadding='2' class='record-table'>";

    foreach ($actual_fields as $val) {
        $field_value = $row[get_field_part($val, $row)];
        $cell_conf   = isset($cells[$val]) ? $cells[$val] : [];

        // Title field
        if ($use_title && $val === $title_field) {
            echo "<tr><td colspan='2' style='text-align:center;'  class='HColumnHeader'>";
            if (in_array($cell_conf['cellType'] ?? '', ['image', 'main-image', 'barcode', 'qr'])) {
                echo render($field_value, $cell_conf, $val, false, false, true);
            } else {
                echo "<span style='font-weight:bold;font-size:x-large;'>" 
                    . render($field_value, $cell_conf, $val, false, false, true) 
                    . "</span>";
            }
            echo "</td></tr>";
            continue;
        }

        // Empty value handling
        if ($field_value === "") {
            if ($hide_labels) {
                echo "<tr><td colspan='2' class='HColumnHeader'>" . render("&nbsp;", $cell_conf, $val) . "</td></tr>";
            } else {
                echo "<tr><td align='left' class='HColumnHeader'>{$labels[$val]}</td><td class='HTableCell-horizontal'>" 
                    . render("&nbsp;", $cell_conf, $val) 
                    . "</td></tr>";
            }
            continue;
        }

        // Hide labels mode
        if ($hide_labels || $cells[$val] == "image") {
            if($cells[$val] == "image") {
                echo "<tr><td colspan='2'>" . render($field_value, $cell_conf, $val, false, false, true) . "</td></tr>";
            } else {
                echo "<tr><td colspan='2' class='HColumnHeader'>" . render($field_value, $cell_conf, $val, false, false, true) . "</td></tr>";
            }
        } else {
            echo "<tr><td align='left' class='HColumnHeader'>{$labels[$val]}</td><td class='HTableCell-horizontal'>" 
                . render($field_value, $cell_conf, $val, false, false, true) 
                . "</td></tr>";
        }
    }

    // Parent/intermediate dropdown
    if ($isParentOrIntermediate) {
        echo "<tr>";
        if(!$hide_labels){
            echo "<td class='HColumnHeader'>More</td>";
        }
        echo "<td class='HTableCell-horizontal'><div class='dropdown'>";
        echo "<span class='btn btn-default btn-sm dropdown-toggle' type='button' data-toggle='dropdown' aria-haspopup='true' aria-expanded='false'>";
        echo "<span class='arrow-icon arrow-icon-horizontal'></span>";
        echo "</span>";
        echo "<ul class='dropdown-menu dropdown-menu-right-horizontal' style='max-width: 300px;'>";

        foreach ($report_mapping as $report_key => $report_data) {
            $params_string = "";
            if (!empty($report_data['params'])) {
                $params_array = array();
                foreach ($report_data['params'] as $param_key => $param_value) {
                    $row_value = $row[get_field_part($param_value, $row)];
                    $params_array[] = urlencode($param_key) . "=" . urlencode($row_value);
                }
                $params_string = "?" . implode("&", $params_array);
            }
            
            if (isset($_CLEANED['token'])) {
                if ($params_string === "") {
                    $params_string = "?token=" . urlencode($_CLEANED['token']) . "&mode=embed";
                } else {
                    $params_string .= "&token=" . urlencode($_CLEANED['token']) . "&mode=embed";
                }
            }

            if (isset($_CLEANED['mode'])) {
                if ($params_string === "") {
                    $params_string = "?mode=embed";
                } else {
                    $params_string .= "&mode=embed";
                }
            }
            $redirect_url = get_cur_url_report($report_data['url']) . $params_string;
            echo "<li><a href='$redirect_url'>" . htmlspecialchars($report_data['message']) . "</a></li>";
        }

        echo "</ul>";
        echo "</div>";
        echo "</td></tr>";
    }

    echo "</table>";
    echo "</div>";
};

// Group by logic
$current_group_key = null;
$group_records = [];

foreach ($result_array as $row) {
    $group_parts = [];
    foreach ($group_by as $val) {
        $group_parts[] = render($row[get_field_part($val, $row)], $cells[$val], $val);
    }
    $group_key = implode('|', $group_parts);

    // New group
    if ($group_key !== $current_group_key) {
        // Print previous group
        if (!empty($group_records)) {
            // Print records for last group in triplets
            for ($i = 0; $i < count($group_records); $i += 3) {
                echo "<tr><td colspan='3'>";
                echo "<div style='display:flex; gap:20px; align-items:stretch;'>";
                $renderRecord($group_records[$i] ?? null);
                $renderRecord($group_records[$i+1] ?? null);
                $renderRecord($group_records[$i+2] ?? null);
                echo "</div>";
                echo "</td></tr>";
                echo "<tr><td colspan='3' style='height:20px;'>&nbsp;</td></tr>";
            }
        }

        // Start new group header
        foreach ($group_by as $i => $val) {
            $class = $i === 0 ? 'MainGroup' : 'SubGroup';
            echo "<tr><td class='$class' colspan='" . (($actual_columns_count * 3) + 2) . "'>
                    <span style='float:" . $align . ";'>" . $labels[$group_by_source[$i]] . ":&nbsp; </span>" .
                    render($row[get_field_part($group_by[$i], $row)], $cells[$group_by[$i]], $group_by[$i]) .
                 "</td></tr>";
        }

        $current_group_key = $group_key;
        $group_records = [];
    }

    $group_records[] = $row;
}

// Print last group's records
if (!empty($group_records)) {
    for ($i = 0; $i < count($group_records); $i += 3) {
        echo "<tr><td colspan='3'>";
        echo "<div style='display:flex; gap:20px; align-items:stretch;'>";
        $renderRecord($group_records[$i] ?? null);
        $renderRecord($group_records[$i+1] ?? null);
        $renderRecord($group_records[$i+2] ?? null);
        echo "</div>";
        echo "</td></tr>";
        echo "<tr><td colspan='3' style='height:20px;'>&nbsp;</td></tr>";
    }
}
?>

<!-- ******************** start custom footer ******************** !-->
<?php
if (!empty($footer)) {
    echo "<tr><td>$footer</td></tr>";
}
?>
<!-- ******************** end custom footer ******************** !-->
