<?php
if (!defined('DIRECTACESS')) {
    exit('No direct script access allowed');
}

$isParent       = $report_relation === "parent";
$isIntermediate = $report_relation === "intermediate";

if ($isParent || $isIntermediate) {
    $report_mapping         = $srm_dashboard->prepare_parameters_mapping($tables_parameters_mapping);
    $linked_reports_count   = count($report_mapping);
    $isParentOrIntermediate =  !empty($report_mapping);
} else {
    $isParentOrIntermediate = false;
}

// Check for main image column
$mainImageColumn = array_keys(array_filter($cells, function ($v) {
    return $v === "main-image";
}))[0] ?? null;
// If no main-image found, look for any image cell and promote it
if (empty($mainImageColumn)) {
    $imageColumns = array_keys(array_filter($cells, function ($v) {
        return $v === "image";
    }));

    if (!empty($imageColumns)) {
        $mainImageColumn = $imageColumns[0]; // Use first image column found
        // Change its celltype to main-image
        $cells[$mainImageColumn] = "main-image";
    }
}

$hasMainImage = !empty($mainImageColumn);


// Initialize cur_row if not set
if (!isset($cur_row)) {
    $cur_row = 0;
}

foreach ($result as $row) {

    foreach ($calculated_columns as $key => $value) {
        $row[$key] = $value($row);
    }

    // fill array with current grouping fields
    foreach ($group_by as $key => $val) {
        $cur_group_ar[$val] = render($row[get_field_part($val, $row)], $cells[$val], $val);
    }

    // Initialize last_group_ar if not set
    if (!isset($last_group_ar)) {
        $last_group_ar = array();
    }

    // print group by fields in case of grouping values variation
    if (count($last_group_ar) != 0) {
        $diff_index = grouping_diff_index($cur_group_ar, $last_group_ar);
    } else {
        $diff_index = 0;
    }

    if ($diff_index != -1) {
        for ($i = $diff_index; $i < count($group_by_source); $i++) {
            if ($i == 0 && $diff_index == 0) {
                echo "<tr><td class='MainGroup' colspan=" . ($actual_columns_count + 1) . "> <span style='float:" . $align . ";'>" . $labels[$group_by_source[$i]] . ":&nbsp; </span>" . render($row[get_field_part($group_by[$i], $row)], $cells[$group_by[$i]], $group_by[$i]) . " </td></tr>";
            } else {
                echo "<tr><td class='SubGroup' colspan=" . ($actual_columns_count + 1) . "> <span style='float:" . $align . ";'>" . $labels[$group_by_source[$i]] . ":&nbsp; </span>" . render($row[get_field_part($group_by[$i], $row)], $cells[$group_by[$i]], $group_by[$i]) . "</td></tr>";
            }
        }

        if ($cur_row == 0) {
            ?>
            <tr>
                <td>
                    <table
                    <?php
                    // width of report
                    if ($_print_option != 0) {
                        echo "width='700'";
                    } else {
                        echo "width='100%'";
                    }
            ?>
                        cellspacing="0" cellpadding="2" align='center' class="inner-data-table">
            <?php
        }
    }

    // Start row for each record
    echo "<tr>";

    // Create wrapper table for main content and image
    echo "<td colspan='3'>";
    echo "<table width='100%' cellspacing='0' cellpadding='0'>";
    echo "<tr>";

    // Main content cell (left side)
    echo "<td valign='top'>";
    echo "<table width='100%' cellspacing='0' cellpadding='2'>";

    foreach ($actual_fields as $key => $val) {
        // Skip the main image field as it's displayed on the right side
        if ($hasMainImage && $val === $mainImageColumn) {
            continue;
        }

        if ($row[get_field_part($val, $row)] === "") {
            echo "<tr><td align='left' class='HColumnHeader'>" . $labels[$val] . "</td><td class='HTableCell'>" . render("&nbsp;", $cells[$val], $val) . "</td></tr>";
        } else {
            echo "<tr><td align='left' class='HColumnHeader'>" . $labels[$val] . "</td><td class='HTableCell'>" . render($row[get_field_part($val, $row)], $cells[$val], $val, false, false, true) . "</td></tr>";
        }
    }

    $row_id = "row_" . uniqid();

    // Add dropdown for parent/intermediate reports
    if ($isParentOrIntermediate) {
        echo "<tr><td class='HColumnHeader'>More</td><td class='HTableCell'>";
        echo "<div class='dropdown'>";
        echo "<span class='btn btn-default btn-sm dropdown-toggle' type='button' data-toggle='dropdown' aria-haspopup='true' aria-expanded='false'>";
        echo "<span class='arrow-icon arrow-icon-horizontal'></span>";
        echo "</span>";
        echo "<ul class='dropdown-menu dropdown-menu-right-horizontal' style='max-width: 300px;'>";

        foreach ($report_mapping as $report_key => $report_data) {
            $params_string = "";
            if (!empty($report_data['params'])) {
                $params_array = array();
                foreach ($report_data['params'] as $param_key => $param_value) {
                    $row_value = $row[get_field_part($param_value, $row)];
                    $params_array[] = urlencode($param_key) . "=" . urlencode($row_value);
                }
                $params_string = "?" . implode("&", $params_array);
            }

            if (isset($_CLEANED['token'])) {
                if ($params_string === "") {
                    $params_string = "?token=" . urlencode($_CLEANED['token']) . "&mode=embed";
                } else {
                    $params_string .= "&token=" . urlencode($_CLEANED['token']) . "&mode=embed";
                }
            }

            if (isset($_CLEANED['mode'])) {
                if ($params_string === "") {
                    $params_string = "?mode=embed";
                } else {
                    $params_string .= "&mode=embed";
                }
            }

            $redirect_url = get_cur_url_report($report_data['url']) . $params_string;
            echo "<li><a href='$redirect_url'>" . htmlspecialchars($report_data['message']) . "</a></li>";
        }

        echo "</ul>";
        echo "</div>";
        echo "</td></tr>";
    }

    echo "</table>"; // End main content table
    echo "</td>"; // End main content cell

    // Image cell (right side) - only show if record has main image
    if ($hasMainImage) {
        $imageValue = $row[get_field_part($mainImageColumn, $row)];

        if (!empty($imageValue) && $imageValue !== "&nbsp;") {
            $imageLabel = isset($labels[$mainImageColumn]) ? $labels[$mainImageColumn] : 'Main Image';

            echo "<td valign='top' style='width: 15%; text-align: center; padding-left: 10px;'>";
            echo "<div title='" . htmlspecialchars($imageLabel) . "' style='width: 300px;height: 200px;overflow: hidden;display: flex;justify-content: center;align-items: center;'>";
            echo render($imageValue, $cells[$mainImageColumn], $mainImageColumn, false, false, true);
            echo "</div>";
            echo "</td>";
        }
        // If no image value, don't show image column at all for this record
    }

    echo "</tr>";
    echo "</table>"; // End wrapper table
    echo "</td>";
    echo "</tr>";

    // Add spacing row
    echo "<tr><td colspan='3'>&nbsp;</td></tr>";

    // update new grouping
    if ($diff_index != -1) {
        $last_group_ar = array();
        foreach ($group_by as $key => $val) {
            $last_group_ar[$val] = render($row[get_field_part($val, $row)], $cells[$val], $val);
        }
    }

    // increment current rows
    $cur_row++;
}
?>

</table></td>
</tr>

<!-- ******************** start custom footer ******************** -->
<?php
if (!empty($footer)) {
    echo "<tr><td>$footer</td></tr>";
}
?>
<!-- ******************** end custom footer ******************** -->