<?php

/**
 * Smart Report Engine
 * Version 2.0.0
 * Author : Webuccino
 * All copyrights are preserved to Webuccino
 * URL : https://mysqlreports.com/
 *
 */

if (!defined("DIRECTACESS")) {
    exit("No direct script access allowed");
}

if ($datasource == 'sql') {
    require_once "../shared/helpers/Model/Report.php";
    require_once "../shared/helpers/Model/QueryReport.php";
} else {
    require_once "../shared/helpers/Model/search.php";
    require_once "../shared/helpers/Model/Report.php";
    require_once "../shared/helpers/Model/TableReport.php";
}

// require_once ('../shared/pdf/class.ezpdf.php');

//export all
if ($pdf_export === 1) {
    require_once "../shared/pdf1/tcpdf.php";
    require_once "../shared/helpers/pdf_export_provider1.php";
} elseif ($pdf_export === 2) {

    require_once "../shared/pdf2/Cezpdf.php";
    require_once "../shared/helpers/pdf_export_provider2.php";
} elseif ($pdf_export === 3) {
    require_once '../shared/pdf3/autoload.inc.php';
    require_once "../shared/helpers/pdf_export_provider2.php";
}

require_once "../shared/excel/xlsxwriter.class.php";

require_once "../shared/helpers/functions.php";
require_once "../shared/helpers/celltypes.php";
require_once "calculated_columns.php";
require_once "../shared/helpers/lib.php";

require_once "../shared/helpers/excel_export.php";

require_once "../shared/helpers/export.php";
function get_short_name($fully_qualified_name)
{
    if (strstr($fully_qualified_name, ".")) {
        $tmp = explode(".", $fully_qualified_name);
        return $tmp[1];
    } else {
        return $fully_qualified_name;
    }

}

/*
 * #################################################################################################
 * Creating the Report Sql
 * ################################################################################################
 */

global $cells, $group_by;

if ($datasource == 'sql') {
    $sql = Prepare_QSql();
} else {
    $sql = Prepare_TSql();
}

if ($empty_search_parameters || $possible_attack) {
    // case user send empty search keywords or entered the $Enter_your_search_lang in the search box

    $all_records      = array();
    $nRecords         = 0;
    $empty_Report     = true;
    $numberOfPages    = 1;
    $records_per_page = 10;
} else {

    $all_records = query($sql[0], "LayOut : Prepare SQL", $sql[1], $sql[2]);

    if (isset($sub_totals["group_by"])) {
        $fully_qualified_group_by_column = $sub_totals["group_by"];
        $group_by_column                 = get_short_name($sub_totals["group_by"]);
    }

// custom
    foreach ($all_records as &$record) {
        foreach ($record as $key => $value) {
            if (isset($cells[$key])) {
                $type = $cells[$key];

                if (in_array($type,["value", "geo"]) 
                    || strstr($type, "barcode") || strstr($type, "qr") ) {
                    // No formatting needed
                    continue;
                }

// Format as date
                if ((isDate($value) || isDateTime($value) || isTime($value))) {
                    $record[$key] = date($type, strtotime($value));
                }

            }

        }

    }

    unset($record); // good practice when using & reference

    usort($all_records, function ($a, $b) use ($group_by, $cells, $sort_by) {
        // Direction map: field => ASC/DESC
        $sortMap = [];

        foreach ($sort_by as $rule) {
            [$field, $dir]   = $rule;
            $sortMap[$field] = $dir == "1" ? 'DESC' : 'ASC';
        }

        // Month map
        $monthMap = array_change_key_case(array_flip([
            '', 'January', 'February', 'March', 'April', 'May', 'June',
            'July', 'August', 'September', 'October', 'November', 'December'
        ]));

        $onlyDateTypes = [
            "m/d/Y",
            "Y-m-d",
            "d/m/Y",
            "F j, Y",
            "F, Y",
            "l",
            "F",
            "Y",
            "m/d/Y H:i:s",
            "d/m/Y H:i:s",
            "Y-m-d H:i:s",
            "F j, Y H:i:s",
            "H:i:s",
            "h A",
            "h:i:s A",
            "H:i",
            "h:i A",
            "H"
        ];

        // Normalize value to sortable format (timestamp or string/number)
        $normalize = function ($val, $cellType = '') use ($monthMap, $onlyDateTypes) {

            $val = trim($val);

            if (!in_array($cellType, $onlyDateTypes)) {
                return $val;
            }

// 1. Weekday ("Monday")
            if ($cellType === 'l') {
                return (date('w', strtotime($val)) + 6) % 7; // Monday = 0
            }

// 2. AM/PM time (e.g. "03 AM")
            if (preg_match('/^\d{1,2} ?(AM|PM)$/i', $val)) {
                return strtotime($val);
            }

// 3. HH:MM:SS
            if (preg_match('/^\d{1,2}:\d{2}:\d{2}$/', $val)) {
                return strtotime("1970-01-01 $val");
            }

// 4. Month name only (e.g. "May")
            if (preg_match('/^[A-Za-z]+$/', $val)) {
                return $monthMap[strtolower($val)] ?? 0;
            }

// 5. Month, Year (e.g. "May, 2024")
            if (preg_match('/^([A-Za-z]+),\s*(\d{4})$/', $val, $m)) {
                $month = $monthMap[strtolower($m[1])] ?? 0;
                return mktime(0, 0, 0, $month, 1, (int) $m[2]);
            }

            $dt = DateTime::createFromFormat($cellType, $val);
            if ($dt) {
                return $dt->getTimestamp();
            }

            return $val;
        };

// 1. Sort by group_by
        foreach ($group_by as $key) {
            $direction = $sortMap[$key] ?? 'ASC';
            $valA      = $normalize($a[$key] ?? '', $cells[$key] ?? '');
            $valB      = $normalize($b[$key] ?? '', $cells[$key] ?? '');

            if ($valA != $valB) {
                return $direction === 'ASC' ? $valA <=> $valB : $valB <=> $valA;
            }

        }

// 2. Then sort by sort_by
        foreach ($sortMap as $key => $direction) {
            if (in_array($key, $group_by)) {
                continue;
            }

            $valA = $normalize($a[$key] ?? '', $cells[$key] ?? '');
            $valB = $normalize($b[$key] ?? '', $cells[$key] ?? '');
            if ($valA != $valB) {
                return $direction === 'ASC' ? $valA <=> $valB : $valB <=> $valA;
            }

        }

        return 0;
    });
    $nRecords = (is_array($all_records)) ? count($all_records) : 0;
    if ($records_per_page == 0) {
        $records_per_page = 10;
    }

    $numberOfPages = ceil($nRecords / $records_per_page);
    if ($numberOfPages == 0 || $nRecords == 0) {
        $empty_Report  = true;
        $numberOfPages = 1;
    } else {
        $empty_Report = false;
        if (isset($sub_totals) && !empty($sub_totals) && in_array($sub_totals["group_by"], $group_by)) {
            require_once "../shared/helpers/Model/SubTotal.php";
            if (isset($calculated_columns) && is_array($calculated_columns)) {
                $sub_totals_obj = new SubTotal($sub_totals, $all_records, $calculated_columns);
            } else {
                $sub_totals_obj = new SubTotal($sub_totals, $all_records);
            }

        }

    }

}

$levels = count($group_by);
