if (typeof window.driver === 'undefined') {
    window.driver = {};
}

const driverInstance = window.driver.js ? window.driver.js.driver : null;
var imagePath = document.getElementById("start-demo-tour").getAttribute("data-image")
if (driverInstance) {
    const driverObjManual = driverInstance({
        popoverClass: "driverjs-theme",
        showButtons: [
            'next',
            'previous',
        ],
        steps: [
            {
                element: 'container-fluid',
                popover: {
                    title: 'Welcome to Smart Report Maker!',
                    description: `<div class='text-center mb-3'><img src='${imagePath}'></div> Welcome to Smart Report Maker! This all-in-one solution allows you to harness the full potential of your existing MySQL databases, enabling you to create comprehensive reports, insightful charts, essential KPIs, scheduled reports, and dynamic dashboardsâ€”all directly from your existing databases. Best of all, Smart Report Maker runs on your own server, seamlessly integrating into your environment for complete control and customization.<br> The goal of this demo is to navigate through the features so you can understand what the system offers. Please note that you won't be able to edit or change the demo data for security reasons. Let's take a tour to explore these powerful features.",
                    nextBtnText: "Oki, start!`,
                },
                side: "bottom",
                align: "center"
            },
            {
                element: '#start-demo-tour',
                popover: {
                    title: 'Rewatch the Guided Tour Anytime',
                    description: "If you would like to rewatch this guided tour at any time, simply click this icon.",
                }
            },
            {
                element: '.charts-page',
                popover: {
                    title: 'Charts Section',
                    description: 'In this section, you can create and manage charts directly from your existing databases. Choose from a variety of chart types to display your data and apply advanced filtering to focus on any time range. Additionally, you can drill down into specific charts for more detailed analysis and insights.'
                }
            },
            {
                element: '.reports-page',
                popover: {
                    title: 'Reports Section',
                    description: 'In this section, you can create and manage reports directly from your existing MySQL databases. Take advantage of advanced features such as data filtration, sub-totals, conditional formatting, robust security options, customizable appearance, and much more to tailor reports to your specific needs.'
                }
            },
            {
                element: '.pivot-tables-page',
                popover: {
                    title: 'Pivot Table Section',
                    description: 'In this section, you can easily create and manage pivot tables from your MySQL databases using a user-friendly drag-and-drop builder. Simply click on "Add New Pivot Table," choose the desired connection, and drag fields into the appropriate areas of the pivot table.'
                }
            },
            {
                element: '.kpis-page',
                popover: {
                    title: 'Metrics / KPIs Section',
                    description: 'Here, you can create and manage KPIs and metrics directly from your existing databases. Track the measures that matter most to your business, monitor performance over time, and compare current data with target goals or historical values. You can also drill down into specific KPIs for deeper analysis and detailed performance comparisons.'
                }
            },
            {
                element: '.home-page',
                popover: {
                    title: 'Home Page Customization Section',
                    description: 'From this area, each user can customize their homepage with widgets displaying report lists, charts, or KPIs they care about. Tailor your dashboard to quickly access the information you need.'
                }
            },
            {
                element: '.dashboard-page',
                popover: {
                    title: 'Dashboards Section',
                    description: 'In this section, you can create and customize as many dashboards as needed, all directly from your existing databases. This allows each user or group of users to focus on the data most relevant to their work by combining multiple reports, charts, and KPIs into tailored, comprehensive views.'
                }
            },
            {
                element: '.scheduled-reports-page',
                popover: {
                    title: 'Scheduled Reports Section',
                    description: 'Finally, in this area, you can create scheduled reports, all generated from your existing databases, and send them via email to groups of users who need them. Automate your reporting process to ensure everyone stays informed with up-to-date data.'
                }
            },
        ]
    });

    document.getElementById('start-demo-tour').addEventListener('click', () => {
        driverObjManual.drive();
    });
} else {
    console.error('Driver.js is not loaded or driver is not defined.');
}
