$(document).ready(function () {

    $(".currency").hide();

    adjustParametersDropdownMenu();

    $('#connection option[value="default"]').prop('selected', true)
    if ($('#connection').val()) {
        initializeJSTree('#connection');
    }

    if($("#connection").attr("data-demo")){
        var currentConnection = $("select[name=connection] option:selected");
        $("select[name=connection]").on("change", function (e) {

            currentConnection.prop("selected", true);
            $(`#demo-modal`).find('h5').text("Available only in full version").show();
            $(`#demo-modal`).modal('show');
        });
    }else{
        $('#connection').change(function () {
            if ($(this).val() == "add-new-connection") {
                window.location.href = $('option:selected', this).data("url");
                $('#connection option[value="default"]').prop('selected', true);
            } else {
                initializeJSTree(this);
                window.clearPivotTable();
            }

        });
    }


    $(".remove-icon").remove();

    $(document).on('change', '#values-format', function () {

        if ($(this).val() == "standard_currency") {
            $(".currency").show();

            $(".currency label").text("Currency");
            $(".currency input").attr("id", "currency");
            $(".currency input").attr("name", "currency");

        } else if ($(this).val() == "custom_unit") {
            $(".currency").show();

            $(".currency label").text("Custom unit");
            $(".currency input").attr("id", "custom-unit");
            $(".currency input").attr("name", "custom_unit");
            $(".currency input").val("");

        } else {
            $(".currency").hide();
        }

        $(".currency input").val("");


    });

    $("#saveBtn-confirm-public-pivot-table").on('click', function () {
        $("#groups").attr("disabled", true);

        $("#confirm-public-pivot-table-modal").modal("hide");
    });


    $(document).on('click', '.modify-pivot-table-name', function () {
        var pivotTableNameContainer = $("#pivot-table-name-container");
        var pivotTableName = $(".pivot-table-name");
        var pivotTableNameTextBox = $("#pivot-table-name-textbox");
        var currentText = pivotTableName.text();

        var inputBox = '<div class="pivot-table-name-input-container" style=" margin-top: 5px;display:inline">' +
            '<input type="text" class="modify-pivot-table-name-input mr-2" value="' + currentText + '" style="width: 50%; display: inline;">' +
            '</div>';

        pivotTableNameContainer.append(inputBox);
        $('.modify-pivot-table-name-input').focus();
        pivotTableName.hide();

        $('.modify-pivot-table-name-input').on('keypress', function (e) {

            if (e.which === 13 && $(this).val() !== "") {
                var newText = $(this).val();

                pivotTableName.text(newText);
                pivotTableNameTextBox.val(newText);
                pivotTableName.show();

                $('.pivot-table-name-input-container').remove();
            }
        });

        $('.modify-pivot-table-name-input').on('blur', function () {
            var newText = $(this).val();
            pivotTableName.text(newText);
            pivotTableNameTextBox.val(newText);

            pivotTableName.show();
            $('.pivot-table-name-input-container').remove();

        });

    });


    $('#add-grand-totals').change(function () {
        if ($(this).val() == 'none') {
            $('#grand-totals-function').attr('disabled', true);
        } else {
            $('#grand-totals-function').attr('disabled', false);
        }
    });

    $('#access-level').change(function () {
        if ($('#access-level :selected').val() == "public") {
            $("#confirm-public-pivot-table-modal").modal({
                keyboard: false,
                backdrop: 'static',
                show: true
            });
        } else if ($('#access-level :selected').val() == "private") {
            $("#groups").attr("disabled", false);

        }
    });


    $(document).on('click', "#add-joins-button", function () {

        $('#primary-table').val('');
        $('#primary-key').val('');
        $('#foreign-table').val('');
        $('#foreign-key').val('');
        $("#joins-title").text('Add Join');
        $('#saveBtn-modify-join').attr("id", "saveBtn-add-join");
        $('#join-type').prop('checked', false);
        $('input[value="inner"]').prop("checked", true)
        $('[data-toggle="tooltip"], [data-tooltip="tooltip"]').tooltip();
        $('#error-message').remove();
        $('#add-joins-modal').modal('show');

    });


    $(document).on('change', "#primary-table", function () {
        connection = $('#connection').val();

        let url = $(`#${$(this).attr("id")}`).data("url") + "/" + connection + "/" + $(`#${$(this).attr("id")} :selected`).val() + "/get_columns";


        $.ajax({
            type: "GET",
            url: url,
            data: { connection: connection },
            headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
            success: function (response) {
                let currentSelectBox = $(`#primary-key`).attr("id");
                window.updateSelectBox(currentSelectBox, response.data, true, "Please Select Key");

            },
        });

    });

    $(document).on('change', "#foreign-table", function () {
        connection = $('#connection').val();

        let url = $(`#${$(this).attr("id")}`).data("url") + "/" + connection + "/" + $(`#${$(this).attr("id")} :selected`).val() + "/get_columns";

        $.ajax({
            type: "GET",
            url: url,
            data: { connection: connection },
            headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
            success: function (response) {
                let currentSelectBox = $(`#foreign-key`).attr("id");
                window.updateSelectBox(currentSelectBox, response.data, true, "Please Select Key");

            },
        });

    });

    $(document).on('click', "#saveBtn-add-join", function () {

        var primaryTable = $('#primary-table');
        var primaryKey = $('#primary-key');
        var foreignTable = $('#foreign-table');
        var foreignKey = $('#foreign-key');
        var foreignKey = $('#foreign-key');
        var joinType = $('input[name=join_type]:checked');

        var errorMessage = window.applyValidations(primaryTable, primaryKey, foreignTable, foreignKey);

        if (errorMessage) {
            $('#error-message').remove();
            $('#saveBtn-add-join').before(`<div id="error-message" class="alert alert-danger">${errorMessage}</div>`);
            return;
        } else {
            $('#error-message').remove();
        }

        var item = window.createJoinListItem(primaryTable, primaryKey, foreignTable, foreignKey, joinType);

        $(`#joins`).append(item);

        window.updateJoinTextBox("joins", `joins-textbox`);


        $('[data-toggle="tooltip"], [data-tooltip="tooltip"] ').tooltip({
            boundary: 'window',
        });

        $('#add-joins-modal').modal('hide');
        $('.tooltip').remove();
        primaryTable.val('');
        primaryKey.val('');
        foreignTable.val('');
        foreignKey.val('');


    });


    $(document).on('click', '.modify-join', function () {
        var listItem = $(this).closest('li');
        console.log(listItem);
        var primaryTable = listItem.attr('data-primarytable');
        var primaryKey = listItem.attr('data-primarykey');
        var foreignTable = listItem.attr('data-foreigntable');
        var foreignKey = listItem.attr('data-foreignkey');
        var joinType = listItem.attr('data-jointype');

        $('#primary-table').val(primaryTable).trigger('change');
        $('#foreign-table').val(foreignTable).trigger('change');
        $('input[name="join_type"]').removeAttr('checked');
        console.log(joinType);
        if (joinType == "inner") {
            $('#inner-join').prop('checked', true);
        } else {
            $('#left-outer-join').prop('checked', true);
        }

        $(`input[name="join_type"][value="${joinType}"]`).attr('checked', true);

        function setKeyWhenReady(selector, keyValue) {
            let observer = new MutationObserver(function (mutations, obs) {
                if ($(selector).find('option[value="' + keyValue + '"]').length > 0) {
                    $(selector).val(keyValue);
                    obs.disconnect();
                }
            });

            observer.observe($(selector)[0], { childList: true, subtree: true });
        }

        setKeyWhenReady('#primary-key', primaryKey);
        setKeyWhenReady('#foreign-key', foreignKey);

        $("#joins-title").text('Edit Join');
        $('#error-message').remove();
        $('#add-joins-modal').modal('show');

        $('#saveBtn-add-join').attr("id", "saveBtn-modify-join");

        $(document).off('click', '#saveBtn-modify-join');

        $(document).on('click', '#saveBtn-modify-join', function () {
            var newPrimaryTable = $('#primary-table');
            var newPrimaryKey = $('#primary-key');
            var newForeignTable = $('#foreign-table');
            var newForeignKey = $('#foreign-key');
            var newJoinType = $('input[name=join_type]:checked');


            var errorMessage = window.applyValidations($('#primary-table'), $('#primary-key'), $('#foreign-table'), $('#foreign-key'));

            if (errorMessage) {
                $('#error-message').remove();
                $('#saveBtn-modify-join').before(`<div id="error-message" class="alert alert-danger">${errorMessage}</div>`);
                return;
            } else {
                $('#error-message').remove();
            }

            listItem.attr('data-primarytable', newPrimaryTable.val());
            listItem.attr('data-primarykey', newPrimaryKey.val());
            listItem.attr('data-foreigntable', newForeignTable.val());
            listItem.attr('data-foreignkey', newForeignKey.val());
            listItem.attr('data-jointype', newJoinType.val());

            var text = window.prepareMessage($('#primary-table option:selected').text() + " - " + $('#foreign-table option:selected').text(), 20).fullMsg;

            listItem.attr('data-name', `${newPrimaryTable.val()}.${newPrimaryKey.val()}=${newForeignTable.val()}.${newForeignKey.val()}=${newJoinType.val()}`);
            listItem.find('span.label')
                .attr('data-original-title', $('#primary-table option:selected').text() + " - " + $('#foreign-table option:selected').text())
                .text(text);

            $('#add-joins-modal').modal('hide');

            window.updateJoinTextBox("joins", `joins-textbox`);

        });
    });

    $(document).on('click', '.delete-join', function () {
        
        $(this).closest('li').remove();

        $('.tooltip').remove();
        window.updateJoinTextBox("joins", `joins-textbox`);

    });


    $(document).on('click', "#apply-button", function (e) {
        e.preventDefault();

        let test = window.applyPivotTable("pivot-table-form",function () {
            window.changeTheme();
            window.changePivotTitle();
        });

        test.then(function (result) {
        });

    });

    $(document).on('click', "#clear-button", function (e) {
        e.preventDefault();
        window.clearPivotTableAndAddNew();

    });

    document.addEventListener("DOMContentLoaded", window.renderColumnVisibilityDropdown);


    $(document).on('click', ".show-hide-columns", function (e) {
        e.preventDefault();
        window.renderColumnVisibilityDropdown();

    });

    $(document).on('click', '#save-btn', function (e) {
        e.preventDefault();

        if (!$('#pivot-table-form').attr('data-status')) {
            let result = window.applyFilterBeforeSave();
            result.then(function (result) {
                if (result) {
                    let pivotResult = window.savePivotTable();

                    pivotResult.then(function (result) {
                        if (result.status) {
                            let resourceId = result.resource;
                            window.setPivotUpdateUrl(resourceId);
                        }

                    })
                }


            }).catch(function (error) {

            });
        } else {
            window.updatePivotTable();
        }

    });





});

