$(function () {
    let groupsTable = $('#groups').DataTable({
        "dom": "lrtip",
        "paging": true,
        "orderFixed": [1, 'asc'],
        "pageLength": 10,
        "lengthChange": false,
        "searching": true,
        "ordering": true,
        "order": [[1, "desc"]],
        "columnDefs": [{
            "targets": 3,
            "orderable": false
        },
        {
            "targets": [1, 2, 3],
            "searchable": false
        },
        {
            "targets": 1,
            "visible": false
        }
        ],
        "info": true,
        "autoWidth": false,
        "responsive": true,
        "language": {
            "zeroRecords": "No records matches your search criteria",
            "emptyTable": "No groups to preview"
        },
        drawCallback: function (settings) {
            var pagination = $(this).closest('.dataTables_wrapper').find('.dataTables_paginate');
            pagination.toggle(this.api().page.info().pages > 1);
        }

    });

    window.applyGroupSearch(groupsTable);
    window.clearGroupSearch(groupsTable);

    var categoriesTable = $('#categories').DataTable({
        "dom": "lrtip",
        "paging": true,
        "pageLength": 10,
        "lengthChange": false,
        "searching": true,
        "ordering": true,
        "order": [],
        "columnDefs": [{
            "targets": 3,
            "orderable": false
        },
        {
            "targets": [1, 2, 3],
            "searchable": false
        }
        ],
        "info": true,
        "autoWidth": false,
        "responsive": true,
        "language": {
            "zeroRecords": "No records matches your search criteria",
            "emptyTable": "No categories to preview"

        },
        drawCallback: function (settings) {
            var pagination = $(this).closest('.dataTables_wrapper').find('.dataTables_paginate');
            pagination.toggle(this.api().page.info().pages > 1);
        }

    });

    window.applyCategorySearch(categoriesTable);
    window.clearCategorySearch(categoriesTable);

    let usersTable = $('#users').DataTable({
        "dom": "lrtip",
        "paging": true,
        "pageLength": 10,
        "lengthChange": false,
        "searching": true,
        "ordering": true,
        "order": [],
        "columnDefs": [{
            "targets": 6,
            "orderable": false
        },
        ],
        "info": true,
        "autoWidth": false,
        "responsive": true,
        "language": {
            "zeroRecords": "No data matches your search criteria",
            "emptyTable": "No users to preview"

        },
        drawCallback: function (settings) {
            var pagination = $(this).closest('.dataTables_wrapper').find('.dataTables_paginate');
            pagination.toggle(this.api().page.info().pages > 1);
        }

    });
    window.applyuserSearch(usersTable);
    window.clearuserSearch(usersTable);



    let dataConnectionsTable = $('#data-connections').DataTable({
        "dom": "lrtip",
        "paging": true,
        "pageLength": 10,
        "lengthChange": false,
        "searching": true,
        "ordering": true,
        "order": [],
        "columnDefs": [{
            "targets": 5,
            "orderable": false
        },
        ],
        "info": true,
        "autoWidth": false,
        "responsive": true,
        "language": {
            "zeroRecords": "No records matches your search criteria",
            "emptyTable": "No data connections to preview"

        },
        drawCallback: function (settings) {
            var pagination = $(this).closest('.dataTables_wrapper').find('.dataTables_paginate');
            pagination.toggle(this.api().page.info().pages > 1);
        }

    });

    window.applyDataConnectionSearch(dataConnectionsTable);
    window.clearDataConnectionSearch(dataConnectionsTable);

    let scheduledReportsTable = $('#scheduled-reports').DataTable({
        "dom": "lrtip",
        "paging": true,
        "pageLength": 10,
        "lengthChange": false,
        "searching": true,
        "ordering": true,
        "order": [],
        "columnDefs": [{
            "targets": 5,
            "orderable": false
        },
        ],
        "info": true,
        "autoWidth": false,
        "responsive": true,
        "language": {
            "zeroRecords": "No records matches your search criteria",
            "emptyTable": "No scheduled reports to preview"
        },
        drawCallback: function (settings) {
            var pagination = $(this).closest('.dataTables_wrapper').find('.dataTables_paginate');
            pagination.toggle(this.api().page.info().pages > 1);
        }

    });

    window.applyScheduledReportsSearch(scheduledReportsTable);
    window.clearScheduledReportsSearch(scheduledReportsTable);



    let DashboardsTable = $('#dashboards').DataTable({
        "dom": "lrtip",
        "paging": true,
        "pageLength": 10,
        "lengthChange": false,
        "searching": true,
        "ordering": true,
        "order": [],
        "columnDefs": [{
            "targets": 4,
            "orderable": false
        },
        ],
        "info": true,
        "autoWidth": false,
        "responsive": true,
        "language": {
            "zeroRecords": "No records matches your search criteria",
            "emptyTable": "No dashboards stored for this user account"

        },
        drawCallback: function (settings) {
            var pagination = $(this).closest('.dataTables_wrapper').find('.dataTables_paginate');
            pagination.toggle(this.api().page.info().pages > 1);
        }


    });


    window.applyDashboardsSearch(DashboardsTable);
    window.clearDashboardsSearch(DashboardsTable);





});


