<?php

namespace App\Mails;

trait MailTrait
{

    /**
     * Set the value of subject
     */
    public function setSubject($subject)
    {
        $this->subject = $subject;
        return $this;
    }

    /**
     * Set the value of username
     */
    public function setUsername($username)
    {
        $this->username = $username;
        return $this;
    }

    /**
     * Set the value of signature
     */
    public function setSignature($signature)
    {
        $this->signature = $signature;
        return $this;
    }


    /**
     * Set the value of Headers
     */
    public function setHeaders()
    {
        $this->headers = 'From: ' . get_from_name() . ' <' . get_from_email() . '>';
        return $this;
    }

    /**
     * Set the value of receivcer
     */
    public function setReceivcer($receiver)
    {
        $this->receiver = $receiver;
        return $this;
    }


    public function buildMailMessage($subject)
    {
        $this->setSubject($subject)
            ->setUsername(get_user_name($this->user))
            ->setSignature(get_email_signature($this->user))
            ->setReceivcer($this->user->Email)
            ->setHeaders()
            ->setMessageContent();
    }
}
