<?php

namespace App\Mails;

use App\Mails\SendMail;
use App\Mails\MailTrait;
use App\Mails\MailInterface;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\Config;
use App\Exceptions\SystemErrorException;
use Illuminate\Validation\ValidationException;

class ActivateUserMail implements MailInterface
{
    use MailTrait;

    public $user;
    private $subject;
    private $content;
    private $username;
    private $signature;
    private $headers;
    private $receiver;

    public function __construct($user)
    {
        $this->user = $user;
    }

    public function send()
    {
        $this->buildMailMessage("Your Smart Report Maker Account is Activated!");

        SendMail::mail(
            $this->receiver,
            $this->subject,
            $this->content,
            $this->headers,
        );
    }

    /**
     * Set the value of content
     */
    public function setMessageContent()
    {
        $username = $this->username;
        $signature = $this->signature;
        $login = route('login');


        $this->content = view(
            'auth.mails.activate-user',
            compact('username', 'login', 'signature')
        )->render();
    }
}
