<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class storeOrganizationLogoRequest extends FormRequest
{
    private $maxWidth;
    private $maxHeight;
    public function __construct()
    {
        parent::__construct();

        $this->maxWidth = config('srm_config.dashboard.organization_logo.width', 234);
        $this->maxHeight = config('srm_config.dashboard.organization_logo.height', 100);
    }
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $maxWidth = $this->maxWidth;
        $maxHeight = $this->maxHeight;

        return [
            'logo' => ['required', 'mimes:jpeg,png,jpg,gif', 'max:500', "dimensions:max_width=$maxWidth,max_height=$maxHeight"]
        ];
    }

    public function messages()
    {
        $maxWidth = $this->maxWidth;
        $maxHeight = $this->maxHeight;

        return [
            'logo.max' => 'Image size can\'t exceed 500KB',
            'logo.mimes' => 'Image type must be PNG, JPG, JPEG, or GIF',
            'logo.dimensions' => "Image maximum width shouldn't exceed $maxWidth, and Image max height shouldn't exceed $maxHeight"
        ];
    }
}