<?php

namespace App\Http\Requests\Metrics;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class ApperanceStepRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'metric_type' => ['required'],
            'metric_color' => [Rule::requiredIf($this->input('metric_type') !== 'gauge_chart')],
            'info_box_icon' => [Rule::requiredIf($this->input('metric_type') === 'info_box_with_icon')],
        ];
    }

    public function messages()
    {
        return [
            'metric_type.required' => 'Please select the metric type.',
            'metric_color.required' => 'Please select the Metric color.',
            'info_box_icon.required' => 'Please select the info box icon.'
        ];
    }
}
