<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class QuickAddController extends Controller
{
    public function __invoke()
    {

        if (!is_null(request()->query('add'))) {
            $route = $this->getRoute(request()->query('add'));
        } else {
            throw new \Exception('Error');
        }

        return redirect()->route($route);
    }

    private function getRoute($type)
    {

        switch ($type) {
            case 'dashboards':

                session()->flash('add', true);
                return 'dashboards.index';
                break;
            case 'reports':
                session()->flash('add', true);
                return 'reports.index';
                break;
            case 'pivot-tables':
                session()->flash('add', true);
                return 'pivot-tables.create';
                break;
            case 'charts':

                session()->flash('add', true);
                return 'charts.index';
                break;
            case 'metrics':

                session()->flash('add', true);
                return 'metrics.index';
                break;
            case 'groups':

                session()->flash('add', true);
                session()->flash('type', 'group');
                return 'users.index';
                break;
            case 'users':

                session()->flash('add', true);
                session()->flash('type', 'user');
                return 'users.index';
                break;
            case 'data-connections':

                session()->flash('add', true);
                return 'data_connections.index';
                break;
            case 'scheduled-reports':

                return 'scheduled-reports.create';
                break;
            default:
                return 'home';
                break;
        }

    }

}
