<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Services\BrandingService;
use App\Http\Middleware\OnlyFullVersion;
use App\Http\Requests\UpdateBrandingRequest;

class BrandingController extends Controller
{
    public $brandingService;
    public function __construct(BrandingService $brandingService)
    {
        $this->brandingService = $brandingService;

        $this->middleware(OnlyFullVersion::class)->only(
            [
                'update',
                'destroy',
            ]
        );
    }

    public function update(UpdateBrandingRequest $request)
    {
        $this->brandingService->update($request->file('logo'));

        return response()->json([
            'message' => trans('branding.logo_saved')
        ]);
    }

    public function destroy()
    {
        $this->brandingService->destroy();
    }
}
