<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of access_control_abstract
 *
 * @author memad
 */
abstract class access_control_abstract implements Access_control_interface
{
    protected $user_session;
    protected $user_saved_user_id;
    protected $user_Saved_email;
    protected $user_saved_group;
    protected $user_saved_role;
    protected $user_saved_ip;
    protected $user_saved_agnet;
    protected $user__saved_username;
    protected $dashboard;

    public function validate_access_to_wizard()
    {
        $report_creator = isset($_SESSION[Session_security_key][srm_access_userid]) ? intval($_SESSION[Session_security_key][srm_access_userid]) : '';

        if (!empty($this->user_session)) {
            $this->fill_user_saved_details($this->user_session);

// if ($this->check_session_keys() && $this->check_session_formats() && $this->check_saved_ip() && $this->check_saved_agent()) {
            if ($this->check_session_keys() && $this->check_session_formats()) {
                if ($this->check_group_access_wizard()) {
                    return true;
                } elseif ($_SESSION[Session_wizard_key]["edit_mode"] && $report_creator === $_SESSION[Session_wizard_key]["report_id"]) {
                    return true;
                } else {
                    $this->redirectToLogin("group not allowing");
                }

            } else {
                $this->redirectToLogin();
            }

        } else {
            $this->redirectToLogin("session is empty");
        }

    }

    public function validate_access_to_report($resource)
    {
        $dashboard_connection = new DatabaseHandler(DEFAULT_HOST, DEFAULT_DBUSER, DEFAULT_DBPASS, DEFAULT_DBNAME);
        $readerSettings       = new Reader(tables_prefix . table_settings, $dashboard_connection);
        $sharedKey            = $readerSettings->filter_by_column('settings_key', 'shared_key')[0]['settings_value'];
        $requestSharedKey     = $_SERVER['HTTP_INTERNAL_KEY'];
        $urlToken             = $_REQUEST['token'];
        if ($urlToken && !empty($urlToken)) {
            $isValidToken = $this->isValidToken($urlToken, $dashboard_connection);
            $this->updateEmbedLog($urlToken, $isValidToken["status"], $isValidToken["reason"], $dashboard_connection);
        }

        if (strtolower($this->get_resource_type($resource)) === strtolower(public_report)
            || (isset($requestSharedKey) && $sharedKey == $requestSharedKey)
            || (isset($urlToken) && $isValidToken["status"])
        ) {
            return [
                "success"         => true,
                'origin_type'     => $isValidToken['origin_type'],
                'allowed_origins' => $isValidToken["allowed_origins"]
            ];
        } else {

            if (!empty($urlToken) && !$isValidToken["status"] && !empty($isValidToken["reason"])) {
                $this->redirectToLogin($isValidToken["reason"]);
            }

            if (!empty($this->user_session)) {
                $this->fill_user_saved_details($this->user_session);

// if ($this->check_session_keys() && $this->check_session_formats() && $this->check_saved_ip() && $this->check_saved_agent()) {
                if ($this->check_session_keys() && $this->check_session_formats()) {
                    if ($this->check_group_access_resource($resource)) {
                        return true;
                    } else {
                        $this->redirectToLogin("FORBIDDEN Access. group not allowing");
                    }

                } else {
                    $this->redirectToLogin("session keys not valid");
                }

            } else {
                $this->redirectToLogin("You are not autherized to access this report");
            }

        }

    }

    protected function updateEmbedLog($token, $success, $reason, $dashboard_connection)
    {
        $readerEmbedTokens = new Reader(tables_prefix . table_embed_tokens, $dashboard_connection);
        $readerAccessKeys  = new Reader(tables_prefix . table_access_keys, $dashboard_connection);
        $url               = $_SERVER['REQUEST_SCHEME'] . '://' . $_SERVER['HTTP_HOST'] . $_SERVER['SCRIPT_NAME'];
        $savedUrl          = 'SRM9/' . explode('/SRM9/', $url, 2)[1];

        // Find token record
        $embedToken = $readerEmbedTokens->filter_by_column('token', $token);

        if (empty($embedToken)) {
            return false;
        }

        $embedToken = $embedToken[0];

        // Get Access Key group id
        $accessKeyId     = $embedToken['access_key_id'] ?? null;
        $accessKeyRecord = $readerAccessKeys->filter_by_column('id', $accessKeyId);

        $logDetails = [
            'token_id'      => $embedToken['id'] ?? null,
            'access_key_id' => $accessKeyId,
            'resource_url'  => $url,
            'attembed_ip'   => getClientIp(),
            'origin'        => $_SERVER['HTTP_REFERER'] ?? 'Not Detected',
            'success'       => $success,
            'reason'        => $reason
        ];

        $writerEmbedLog = new Writer(tables_prefix . table_embed_log, $logDetails, $dashboard_connection);
        $writerEmbedLog->insert();

        $writerAccessKey = new Writer(tables_prefix . table_access_keys, ["uses_count" => intval($accessKeyRecord[0]["uses_count"]) + 1], $dashboard_connection);
        $writerAccessKey->update($accessKeyId, "id");

    }


    protected function isValidToken($token, $dashboard_connection)
    {
        $readerEmbedTokens         = new Reader(tables_prefix . table_embed_tokens, $dashboard_connection);
        $readerAccessKeys          = new Reader(tables_prefix . table_access_keys, $dashboard_connection);
        $readerResources           = new Reader(tables_prefix . table_resources, $dashboard_connection);
        $readerResourcePermissions = new Reader(tables_prefix . table_resources_permissions, $dashboard_connection);
        $readerSettings            = new Reader(tables_prefix . table_settings, $dashboard_connection);

        // Normalize current URL (without query string)
        $url      = $_SERVER['REQUEST_SCHEME'] . '://' . $_SERVER['HTTP_HOST'] . $_SERVER['SCRIPT_NAME'];
        $savedUrl = 'SRM9/' . explode('/SRM9/', $url, 2)[1];
        // Find token record
        $embedToken = $readerEmbedTokens->filter_by_column('token', $token);

        if (empty($embedToken) || !is_null($embedToken[0]['deleted_at'])) {
            return ['status' => false, 'reason' => 'Invalid embed token'];
        }
        $embedToken = $embedToken[0];

        // Get Access Key group id
        $accessKeyId     = $embedToken['access_key_id'] ?? null;
        $accessKeyRecord = $readerAccessKeys->filter_by_column('id', $accessKeyId);
        
        if (empty($accessKeyRecord) || !is_null($accessKeyRecord[0]['deleted_at'])) {
            return ['status' => false, 'reason' => 'Invalid embed token'];
        }

        $accessKeyRecord = $accessKeyRecord[0];
        
        $timeZone = $readerSettings->filter_by_column('settings_key', 'timezone')[0]['settings_value'];

        // Fallback to UTC if null or empty
        if (empty($timeZone)) {
            $timeZone = 'UTC';
        }

        $expireAt = new DateTime($embedToken['expire_at'], new DateTimeZone('Africa/Cairo'));

        $expireAt->setTimezone(new DateTimeZone('UTC'));

        $now = new DateTime('now', new DateTimeZone('UTC'));

        if ($now > $expireAt) {
            return ['status' => false, 'reason' => 'Embed Token is expired. Please refresh the page to generate a new token'];
        }

        if (strtolower($accessKeyRecord['type']) == "full") {
            return [
                'status'          => true,
                'origin_type'     => $accessKeyRecord["origin_type"],
                'allowed_origins' => $accessKeyRecord["allowed_origins"],
                'reason'          => 'success'
            ];
        }

        if (empty($accessKeyRecord['group_id'])) {
            return ['status' => false, 'reason' => 'Invalid embed token'];
        }

        $accessKeyGroupId = $accessKeyRecord['group_id'];

        // Get Resource ID
        $resource = $readerResources->filter_by_column('url', $savedUrl);

        if (empty($resource)) {
            return ['status' => false, 'reason' => 'Invalid embed token'];
        }

        $resourceId = $resource[0]['id'];

        // Check permissions
        $permissions = $readerResourcePermissions->filter_by_column('resource_id', $resourceId);

        foreach ($permissions as $permission) {

            if ($permission['group_id'] == $accessKeyGroupId) {
                return
                    ['status'         => true,
                    'origin_type'     => $accessKeyRecord["origin_type"],
                    'allowed_origins' => $accessKeyRecord["allowed_origins"],
                    'reason'          => 'success'
                ];
            }

        }

        return ['status' => false, 'reason' => 'Access denied'];
    }

    protected function check_session_keys()
    {

        foreach (srm_access_session_array_keys as $key) {

            if (!array_key_exists($key, $this->user_session)) {
                srm_dashboard::log("FORBIDDEN Access. Session keys security error.");
                return false;
            }

        }

        return true;
    }

    /**
     * check that session saved IP matches user's current IP
     */
    protected function check_saved_ip()
    {

        if ($this->user_saved_ip != $_SERVER['REMOTE_ADDR']) {
            srm_dashboard::log("Ip access issue saved IP in session " . $this->user_saved_ip . " while actual IP of user" . $_SERVER['REMOTE_ADDR']);
            return false;
        } else {
            return true;
        }

    }

    /**
     * check that session saved user agent matches user's current user agent
     */
    protected function check_saved_agent()
    {

        if ($this->user_saved_agnet != $_SERVER['HTTP_USER_AGENT']) {
            srm_dashboard::log("user agent saved agent in session " . $this->user_saved_agnet . " while actual agent of user" . $_SERVER['HTTP_USER_AGENT']);
            return false;
        } else {
            return true;
        }

    }

    /**
     * redirect user to login if not empty
     */
    protected function redirectToLogin($reason = "not set", $redirect = "403")
    {

        if ($redirect == "403") {
            header('HTTP/1.1 403 FORBIDDEN');
            header('Status: 403 You Do Not Have Access To This Page');
            require_once "error_page.php";
            exit();
        } else {
            header("Location: " . srm_redirect_login_page_url);
            exit();
        }

    }

    /**
     * validate user's session
     */
    protected function check_session_formats()
    {
        return true;
    }

    /**
     * fill user details from session
     */
    protected function fill_user_saved_details($array)
    {

// $this->user_saved_ip = isset($array[srm_access_ip]) ? $array[srm_access_ip] : "";
        // $this->user_saved_agnet = isset($array[srm_access_user_agent]) ? $array[srm_access_user_agent] : "";
        $this->user_saved_group     = isset($array[srm_access_group]) ? $array[srm_access_group] : "";
        $this->user_saved_role      = isset($array[srm_access_role]) ? $array[srm_access_role] : "";
        $this->user_Saved_email     = isset($array[srm_access_email]) ? $array[srm_access_email] : "";
        $this->user_saved_user_id   = isset($array[srm_access_userid]) ? $array[srm_access_userid] : "";
        $this->user__saved_username = isset($array[srm_access_username]) ? $array[srm_access_username] : "";
    }

}
