<?php

class Reader
{

    private $table;
    private $primary_key;
    private $db_handler;

    public function __construct($table, $dashboard_connection, $primary_key = "id")
    {
        $this->table       = $table;
        $this->primary_key = $primary_key;
        $this->db_handler  = $dashboard_connection;
    }

    public function select_all()
    {

        $query = "select * from `" . $this->table . "`;";

        return $this->db_handler->query($query);
    }


    public function select_all_by_column($column)
    {

        $query = "select `$column` from `" . $this->table . "`;";

        return $this->db_handler->query($query);
    }

    public function select_all_by_columns($columns, $table)
    {
        // If array, convert to backtick-escaped column list
        if (is_array($columns)) {
            $columns = array_map(fn($col) => "`" . trim($col) . "`", $columns);
            $columns = implode(", ", $columns);
        } else {
            // If string, use as-is but ensure no SQL injection
            $columns = "`" . implode("`, `", array_map('trim', explode(',', $columns))) . "`";
        }
        $query = "SELECT $columns FROM `" . $table . "`;";

        return $this->db_handler->query($query);
    }


/* get all names in a table in an assoc array that has its index as the IDs */
    /* return is an Asoc array keys are IDs and values are names */

    public function select_all_names_and_Ids($column_name = "name", $id_column = "id", $soft_delete = false)
    {
        $query = "select DISTINCT `" . $id_column . "`,`" . $column_name . "` from `" . $this->table . "`";

        if ($soft_delete) {
            $query .= " Where `" . column_deleted_at . "` is NULL";
        }

        $names   = array();
        $results = $this->db_handler->query($query);

        if (is_array($results)) {

            foreach ($results as $record) {
                $names[$record[0]] = $record[1];
            }

        }

        return $names;
    }

    public function select_all_names_and_Ids_by_order($column_name = "name", $id_column = "id", $soft_delete = false)
    {
        $query = "select DISTINCT `" . $id_column . "`,`" . $column_name . "`,`order` from `" . $this->table . "`";

        if ($soft_delete) {
            $query .= " Where `" . column_deleted_at . "` is NULL";
        }

        // add order by order
        $query .= " order by `order`";
        $names   = array();
        $results = $this->db_handler->query($query);

        if (is_array($results)) {

            foreach ($results as $record) {
                $names[$record[0]] = $record[1];
            }

        }

        return $names;
    }

/* get an id OR a  whole record by filtering a table by a textual column inside it */
    /* return is one ID or One record */

    public function filter_by_column($column, $column_value, $only_id = false, $id = "id")
    {

        if (!$only_id) {
            $query = "select * from `" . $this->table . "` where `" . $column . "` = ?;";
        } else {
            $query = "select DISTINCT `" . $id . "` from `" . $this->table . "`  where `" . $column . "` = ?;";
        }

        $results = $this->db_handler->query($query, 'ASSOC', array($column_value));

        if (is_array($results)) {
            return $results;
        } else {
            return array();
        }

    }

    public function get_last_report_id($module_id, $id = "id")
    {

        $query = "select `" . $id . "` from `" . $this->table . "` where `module_id` = ?  ORDER BY`" . "id` DESC LIMIT 1 ;";

        $results = $this->db_handler->query($query, 'ASSOC', array($module_id));

        if (is_array($results)) {
            return $results;
        } else {
            return array();
        }

    }

/* get certain property value by filteriing table by id */
    /* result is one value from one record */

    public function get_property_by_id($required_property_column_name, $id_value, $id_column, $second_condition = "")
    {
        $query = "select DISTINCT `" . $required_property_column_name . "` from `" . $this->table . "`  where `" . $id_column . "` = ? ;";

        if (!empty($second_condition)) {
            $query .= " and $second_condition";
        }

        $result = $this->db_handler->query($query, 'ASSOC', array($id_value));

        if (isset($result[0][$required_property_column_name])) {
            return $result[0][$required_property_column_name];
        } else {
            srm_dashboard::log('Error in query', __FILE__ . "  lINE NO:" . __LINE__, __METHOD__, "", log_error, "report_builder_common", $query, json_encode(array("required_property" => $required_property_column_name, "required_id" => $id_value, "id_column" => $id_column, "second_condition" => $second_condition)));
            return false;
        }

    }

    public function get_properties_by_id($required_property_columns, $id_value, $id_column, $second_condition = "")
    {
        // Handle different input types
        if (is_array($required_property_columns)) {
            $columns = implode('`, `', $required_property_columns);
            $columns = '`' . $columns . '`';
        } else if ($required_property_columns === '*') {
            $columns = '*';
        } else {
            $columns = '`' . $required_property_columns . '`';
        }
        
        $query = "SELECT DISTINCT " . $columns . " FROM `" . $this->table . "` WHERE `" . $id_column . "` = ?";
        
        if (!empty($second_condition)) {
            $query .= " AND " . $second_condition;
        }
        
        $result = $this->db_handler->query($query, 'ASSOC', array($id_value));
        
        if (isset($result[0])) {
            // If single property requested (string and not *), return the value directly for backward compatibility
            if (!is_array($required_property_columns) && $required_property_columns !== '*') {
                return isset($result[0][$required_property_columns]) ? $result[0][$required_property_columns] : false;
            }
            
            // If multiple properties requested (array) or * wildcard, return the full row
            return $result[0];
        } else {
            srm_dashboard::log('Error in query', __FILE__ . "  LINE NO:" . __LINE__, __METHOD__, "", log_error, "report_builder_common", $query, json_encode(array("required_properties" => $required_property_columns, "required_id" => $id_value, "id_column" => $id_column, "second_condition" => $second_condition)));
            return false;
        }
    }
/* use to get a forign key IDs by filtering a column */
    /* result is array of Ids from array of records */

    public function get_filtered_ids($filter_by_column, $filter_by_value, $required_column)
    {
        $query  = "select DISTINCT `" . $required_column . "` from `" . $this->table . "`  where `" . $filter_by_column . "` = ?;";
        $result = $this->db_handler->query($query, 'ASSOC', array($filter_by_value));

        if (array($result) && !empty($result)) {
            $filtered_ids = array();

            foreach ($result as $record) {
                $filtered_ids[] = $record[$required_column];
            }

            return $filtered_ids;
        } else {
            return array();
        }

    }

    public function is_entity_exist_by_value($column, $value)
    {
        $query  = "select DISTINCT `" . $column . "` from `" . $this->table . "`  where `" . $column . "` = ?;";
        $result = $this->db_handler->query($query, 'ENUM', array($value));

        if (is_array($result) && !empty($result)) {

            return true;
        } else {
            return false;
        }

    }


    public function get_property_by_condition($required_property_column_name, $condition_column, $condition_value, $second_condition = "")
    {
        $query = "SELECT DISTINCT `" . $required_property_column_name . "` FROM `" . $this->table . "` WHERE `" . $condition_column . "` = ?";

        if (!empty($second_condition)) {
            $query .= " AND $second_condition";
        }

        $result = $this->db_handler->query($query, 'ASSOC', array($condition_value));

        if (isset($result[0][$required_property_column_name])) {
            return $result[0][$required_property_column_name];
        } else {
            srm_dashboard::log('Error in query', __FILE__ . "  LINE NO:" . __LINE__, __METHOD__, "", log_error, "report_builder_common", $query, json_encode(array("required_property" => $required_property_column_name, "condition_column" => $condition_column, "condition_value" => $condition_value, "second_condition" => $second_condition)));
            return false;
        }

    }

    public function get_properties_by_condition($required_property_column_name, $condition_column, $condition_value, $second_condition = "")
    {
        $query = "SELECT " . $required_property_column_name . " FROM `" . $this->table . "` WHERE `" . $condition_column . "` = ?";
        if (!empty($second_condition)) {
            $query .= " AND $second_condition";
        }

        $result = $this->db_handler->query($query, 'ASSOC', array($condition_value));

        if ($result && count($result) > 0) {
            return $result;
        } else {
            srm_dashboard::log('No results found', __FILE__ . "  LINE NO:" . __LINE__, __METHOD__, "", log_info, "report_builder_common", $query, json_encode(array("required_property" => $required_property_column_name, "condition_column" => $condition_column, "condition_value" => $condition_value, "second_condition" => $second_condition)));
            return false;
        }

    }

    public function get_properties_by_multiple_conditions($required_property_column_name, $conditions = array(), $additional_conditions = "")
{
    if (empty($conditions)) {
        srm_dashboard::log('No conditions provided', __FILE__ . "  LINE NO:" . __LINE__, __METHOD__, "", log_error, "report_builder_common", "", "");
        return false;
    }

    $query = "SELECT DISTINCT `" . $required_property_column_name . "` FROM `" . $this->table . "` WHERE ";
    $params = array();
    $condition_parts = array();

    foreach ($conditions as $column => $value) {
        $condition_parts[] = "`" . $column . "` = ?";
        $params[] = $value;
    }

    $query .= implode(" AND ", $condition_parts);

    if (!empty($additional_conditions)) {
        $query .= " AND " . $additional_conditions;
    }

    $result = $this->db_handler->query($query, 'ASSOC', $params);

    if ($result && count($result) > 0) {
        return $result;
    } else {
        srm_dashboard::log('No results found', __FILE__ . "  LINE NO:" . __LINE__, __METHOD__, "", log_info, "report_builder_common", $query, json_encode(array("required_property" => $required_property_column_name, "conditions" => $conditions, "additional_conditions" => $additional_conditions)));
        return false;
    }
}


}
