<?php

use Illuminate\Support\Facades\DB;
use Illuminate\Contracts\Console\Kernel;
use Symfony\Component\Console\Input\ArrayInput;
use Symfony\Component\Console\Output\ConsoleOutput;

require __DIR__ . '/../vendor/autoload.php';

$app = require_once __DIR__ . '/bootstrap/app.php';

$kernel = $app->make(Kernel::class);
$kernel->bootstrap();


// $prefix = config('srm_config.installer.table_prefix', 'srm_');

// $settings = DB::table($prefix .'Settings')->get();

// $tries = $settings->where('settings_key', 'mail_retry_count')->first()->settings_value;

// $interval = $settings->where('settings_key', 'mail_retry_interval_min')->first()->settings_value;

$input = new ArrayInput([
    'command' => 'queue:work',
    '--stop-when-empty' => true,
    '--tries' => 5,
    '--backoff' => 600, // seconds
    '--timeout' => 500
    // '--once' => true,
]);

// Define the output for the worker
$output = new ConsoleOutput();

// Run the worker
$kernel->handle($input, $output);
