<div class="modal fade" id="edit-dataconnection-modal" tabindex="-1" role="dialog" aria-labelledby="modelDataSource"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content custom-rounded-edges">
            <div class="modal-header">
                <h5 class="modal-title mx-3" id="exampleModalLongTitle">
                    <i class="fa-solid fa-database mx-1"></i>
                    Data Connection
                </h5>
                <span class="tool-question" data-toggle="tooltip" data-placement="top"
                    title="A data connection refers to the specific set of parameters or configuration details required to establish a link or access a database. These parameters typically include information such as the database type (e.g., MySQL, PostgreSQL), host address, port number, authentication credentials (username, password), and other settings necessary for establishing communication with a database.">
                    <i class="fa-solid fa-circle-question"></i>
                </span>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>

            <div class="modal-body mx-4 my-1">

                <form method="POST" id="edit-dataconnection-form"
                    data-url="<?php echo e(route('data_connections.update',$connection->id)); ?>">
                    <?php echo csrf_field(); ?>


                    <div class="form-group">
                        <label for="connection-name">Connection Name</label>
                        <div class="input-group">
                            <input type="text" class="form-control" id="connection-name" name="connection_name"
                                value="<?php echo e($connection->connection_name); ?>">
                            <span class="tool-question d-flex align-items-center mx-2" data-toggle="tooltip"
                                data-placement="top"
                                title='The Connection Name functions as a distinct label for connection parameters to a specific data source. It serves as a clear identifier for the precise setup required to connect with a database. Choose a unique, detailed, and easily identifiable name that reflects the data source it connects to, such as "SalesDbConnection," "InventoryDbConnection," and so on.'>
                                <i class="fa-solid fa-circle-question"></i>
                            </span>
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="emailConfirmation">Database Type</label>
                        <div class="input-group">

                            <select class="form-control" id="database-type" name="database_type">
                                <?php if($config = config("srm_config")): ?>
                                <?php $__currentLoopData = $config["dashboard"]["dashboard_data_connections"]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $database): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($database); ?>"><?php echo e($database); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </select>
                            <span class="tool-question d-flex align-items-center mx-2" data-toggle="tooltip"
                                data-placement="top" title="The type of the database to which you want to connect.">
                                <i class="fa-solid fa-circle-question"></i>
                            </span>
                        </div>
                    </div>

                    <div class="form-group">

                        <label for="server">Server</label>
                        <div class="input-group">
                            <?php ($ip_address = request()->server('SERVER_ADDR')); ?>
                            <input type="text" class="form-control" id="server" name="server" <?php if(checkDemo()): ?>
                                value="<Server>" <?php else: ?> value="<?php echo e($connection->server); ?>" <?php endif; ?>>
                            <span class="tool-question d-flex align-items-center mx-2" data-toggle="tooltip"
                                data-placement="top"
                                title='To establish a connection to a MySQL server on the same machine, the host parameter should be set to "localhost" by default. However, if you are connecting to a remote server, you will need to use the IP address or hostname of the remote machine. In this scenario, it may be necessary to enable remote connections in your database settings from this specific IP address <?php echo e($ip_address); ?>.'>
                                <i class="fa-solid fa-circle-question"></i>
                            </span>
                        </div>
                    </div>

                    <div class="form-group">

                        <label for="database">Database</label>
                        <div class="input-group">
                            <input type="text" class="form-control" id="database" name="database" <?php if(checkDemo()): ?>
                                value="<database>" <?php else: ?> value="<?php echo e($connection->db); ?>" <?php endif; ?>>
                            <span class="tool-question d-flex align-items-center mx-2" data-toggle="tooltip"
                                data-placement="top" title="The name of the database to which you want to connect">
                                <i class="fa-solid fa-circle-question"></i>
                            </span>
                        </div>
                    </div>

                    <div class="form-group">

                        <label for="username">User Name</label>
                        <div class="input-group">
                            <input type="text" class="form-control" id="username" name="username" value="">
                            <span class="tool-question d-flex align-items-center mx-2" data-toggle="tooltip"
                                data-placement="top"
                                title="The Username is a distinctive label given to a user who accesses a database. It acts as a credential that allows users to connect to and engage with the database. Ensure that the Username has permission to execute 'SELECT' queries within the database.">
                                <i class="fa-solid fa-circle-question"></i>
                            </span>
                        </div>
                    </div>

                    <div class="form-group">

                        <label for="password">Password</label>
                        <div class="input-group">
                            <input type="password" class="form-control" id="password" name="password" value="">
                            <span class="tool-question d-flex align-items-center mx-2" data-toggle="tooltip"
                                data-placement="top"
                                title="The Database Password is a confidential parameter linked to the provided database username. It serves as a crucial security measure, acting as a secret key required to authenticate and validate access to the associated database.">
                                <i class="fa-solid fa-circle-question"></i>
                            </span>
                        </div>
                    </div>

                    <div class="form-group">

                        <label for="port">Port</label>
                        <div class="input-group">
                            <input type="text" class="form-control" id="port" name="port" value="3306">
                            <span class="tool-question d-flex align-items-center mx-2" data-toggle="tooltip"
                                data-placement="top"
                                title='The "port" parameter in database connections specifies the port number on which the database server listens for incoming connections.'>
                                <i class="fa-solid fa-circle-question"></i>
                            </span>
                        </div>
                    </div>

                    <div class="form-group">

                        <label for="charset">Charset</label>
                        <div class="input-group">
                            <input type="text" class="form-control" id="charset" name="charset" value="utf8mb4">
                            <span class="tool-question d-flex align-items-center mx-2" data-toggle="tooltip"
                                data-placement="top"
                                title="Charset, short for Character Set, is a parameter that defines the collection of characters and symbols that a database system can recognize and process. Default Mysql charset is 'utf8mb4'">
                                <i class="fa-solid fa-circle-question"></i>
                            </span>
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="collation">Collation</label>
                        <div class="input-group">
                            <input type="text" class="form-control" id="collation" name="collation"
                                value="utf8mb4_unicode_ci">
                            <span class="tool-question d-flex align-items-center mx-2" data-toggle="tooltip"
                                data-placement="top"
                                title="Collation refers to the set of rules that determine how data is sorted compared, and ordered in a database based on the character set. It defines the order in which characters are sorted and the rules for comparing strings of data.">
                                <i class="fa-solid fa-circle-question"></i>
                            </span>
                        </div>
                    </div>
                </form>

            </div>

            <div class="container">
                <div class="row justify-content-center text-center">
                    <div class="col-md-12">
                        <button class="btn btn-primary mx-2 px-5 py-2 mb-3" id="test-edit-dataconnection"
                            data-test="<?php echo e(route('data_connections.testConnection')); ?>">
                            Test Connection
                        </button>
                    </div>
                    <div class="col-md-4">
                        <button class="btn btn-success mx-2 px-5 py-2" id="saveBtn-edit-dataconnection" disabled>
                            Save
                        </button>
                    </div>
                    <div class="col-md-4">
                        <button class="btn btn-light mx-2 px-5 py-2" id="cancelBtn-edit-dataconnection"
                            data-dismiss="modal">
                            Cancel
                        </button>
                    </div>
                    <div class="col-md-12 mt-3 mb-2">
                        <div id="confirm-edit-dataconnection" class="alert bootstrap-alert-success mx-4 mb-3"
                            style="display: none" role="alert">

                        </div>
                        <div id="error-edit-dataconnection" class="alert bootstrap-alert-danger mx-4 mb-3"
                            style="display: none" role="alert">
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div><?php /**PATH /var/www/html/srm_phpv81_or_later/srm/dashboard/resources/views/dashboard/data-connections/edit.blade.php ENDPATH**/ ?>