<?php $__env->startSection('styles'); ?>

<style>
  div.custom-control-right {
    padding-right: 24px;
    padding-left: 0;
    margin-left: 0;
    margin-right: 0;
  }

  div.custom-control-right .custom-control-label::after {
    right: -1.5rem;
    left: auto;
  }

  div.custom-control-right .custom-control-label::before {
    right: -2.35rem;
    left: auto;
  }

      #popupOverlay {
        display: none;
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background-color: rgba(0, 0, 0, 0.6);
        z-index: 1000;
    }

    #popupContent {
        position: absolute;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
        background: #fff;
        padding: 0;
        border-radius: 8px;
        box-shadow: 0 0 15px rgba(0, 0, 0, 0.5);
    }

    #popupContent iframe {
        border-radius: 8px;
        display: block;
    }

    #closePopup {
        position: absolute;
        top: -10px;
        right: -10px;
        background: #f00;
        color: #fff;
        padding: 5px 10px;
        font-weight: bold;
        font-size: 20px;
        cursor: pointer;
        border-radius: 50%;
    }
    .popupTitle {
        font-size: 18px;
        font-weight: bold;
        text-align: center;
        padding: 15px 20px 10px;
        color: #333;
    }


</style>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>

<div class="content-wrapper">
  <div class="content-header mx-3">
    <div class="container-fluid">
      <div class="row mb-2 mt-3">
        <div class="col-sm-6">

                    <?php if(!checkDemo()): ?>
            <h1> <i class="fa-solid fa-wrench mx-2"></i> Embed Preferences</h1>
            <?php else: ?>
            <h1> <i class="fa-solid fa-wrench mx-2"></i> Embed Preferences <a href="#" id="openPopup"><img
                        src="<?php echo e(get_asset('dist/images/youtube.jpg')); ?>" class="mx-2 mb-1" style="width: 40px"
                        alt="Watch the Embed Manager in Action" data-toggle="tooltip"
                        data-title="Watch the Embed Manager in Action" data-placement="bottom"></a></h1>
            <div id="popupOverlay">
                <div id="popupContent" style="padding: 10px">
                    <span id="closePopup">&times;</span>
                    <div class="popupTitle">Watch the Embed Manager in Action</div>
                    <iframe id="youtubeVideo" width="800" height="515"
                        src="<?php echo e(config('srm_config.dashboard.demo.embed_manager_youtube_video')); ?>"
                        allow="autoplay; encrypted-media">
                    </iframe>
                </div>
            </div>
          <?php endif; ?>
        </div>
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Home</a></li>
            <li class="breadcrumb-item active">Embed Prefrences</li>
          </ol>
        </div>
      </div>
    </div>
        <div class="form-section alert" style="background-color: #DAE8FC">
          <div class="d-flex align-items-center mb-3">
            <i class="fas fa-info-circle text-primary mx-2"></i>
            <strong>About This Page</strong>
          </div>
          <p class="help-text">
            This page allows you to customize how a report, pivot table, or dashboard generated by Smart Report Maker is
            embedded into an external application. You can insert custom PHP code to be executed before or after the
            embedding—such as performing a security check, setting a session variable for authentication in the external
            application, or appending a common header or footer file. You can also define the dimensions of the iframe
            used to display the embedded analytics.
          </p>
        </div>


        <div class="card bg-white">
          <div class="card-body">
            <form id="embed-settings-form" class="col-12" data-url="<?php echo e(route('embed.store')); ?>">
              <?php echo csrf_field(); ?>
              <?php echo method_field('PUT'); ?>

              <div class="form-group">
                <div class="d-flex">
                  <label for="custom_php_before_embed">Custom PHP Code Before Embed</label>
                  <span class="tool-question mx-2 align-items-center" data-toggle="tooltip" data-placement="top" title="Optional  PHP code that will be inserted before the embedding code. This is useful for performing a security check, setting session variables for authentication in the external application, including a common header, or any other custom logic. When you download the PHP embed file for any resource, your code will be automatically included.
                        Note: You don't need to start the code with &lt;?php — it will be added automatically.">
                    <i class="fa-solid fa-circle-question"></i>
                  </span>
                </div>
                <div>
                  <textarea type="text" class="form-control" id="custom_php_before_embed"
                    name="custom_php_before_embed"><?php echo e(isset($preferences['custom_php_before_embed']) ? $preferences['custom_php_before_embed'] :''); ?></textarea>
                </div>
              </div>

              <div class="form-group">
                <div class="d-flex">
                  <label for="custom_php_after_embed">Custom PHP Code After Embed</label>
                  <span class="tool-question mx-2 align-items-center" data-toggle="tooltip" data-placement="top" title="Optional PHP code that will be inserted after the embedding code. This can be useful for including a common footer or adding any other custom logic. When you download the PHP embed file for any resource, this code will be automatically included.
                  Note: You don't need to start the code with &lt;?php — it will be added automatically.">
                    <i class="fa-solid fa-circle-question"></i>
                  </span>
                </div>
                <div>
                  <textarea type="text" class="form-control" id="custom_php_after_embed"
                    name="custom_php_after_embed"><?php echo e(isset($preferences['custom_php_after_embed']) ? $preferences['custom_php_after_embed'] :''); ?></textarea>
                </div>
              </div>
              <div class="form-group mt-3">
                <label>iFrame Size</label>
                <div class="d-flex align-items-center">
                  <!-- Width Setting -->
                  <label for="iframe_width" class="mb-0 mr-2">Width:</label>
                  <input type="number" class="form-control col-2" id="iframe_width" name="iframe_width" max="100"
                    value="<?php echo e(isset($preferences['iframe_width']) ? $preferences['iframe_width'] : 100); ?>">
                  <span class="ml-1 mr-5">%</span>

                  <!-- Height Setting -->
                  <label for="iframe_height" class="mb-0 mr-2">Height:</label>
                  <input type="number" class="form-control col-2" id="iframe_height" name="iframe_height"
                    name="iframe_height"
                    value="<?php echo e(isset($preferences['iframe_height']) ? $preferences['iframe_height'] : 800); ?>">
                  <span class="ml-1 mr-4">Pixels</span>

                  <!-- Tooltip -->
                  <span class="tool-question d-flex align-items-center" data-toggle="tooltip" data-placement="top"
                    title="Set the iframe width and height. You can use percentages (e.g., 100%) or fixed pixel values (e.g., 800px).">
                    <i class="fa-solid fa-circle-question"></i>
                  </span>
                </div>
              </div>

              <div class="form-group">
                <div class="d-flex">
                  <label for="custom_html_before_embed">Custom HTML Code Before Embed</label>
                  <span class="tool-question mx-2 align-items-center" data-toggle="tooltip" data-placement="top"
                    title="Optional HTML code to insert before the embedding code.
You can use this to display any custom content, such as a heading, description, or branding element.
Note: HTML embedding is only available for public resources, as there is no secure way to pass authentication to Smart Report Maker using plain HTML.">
                    <i class="fa-solid fa-circle-question"></i>
                  </span>
                </div>
                <div>
                  <textarea type="text" class="form-control" id="custom_html_before_embed"
                    name="custom_html_before_embed"><?php echo e(isset($preferences['custom_html_before_embed']) ? $preferences['custom_html_before_embed'] :''); ?></textarea>
                </div>
              </div>

              <div class="form-group">
                <div class="d-flex">
                  <label for="custom_html_after_embed">Custom HTML Code After Embed</label>
                  <span class="tool-question mx-2 align-items-center" data-toggle="tooltip" data-placement="top"
                    title="Optional HTML code to insert after the embedding code.
You can use this to display any custom content, such as a heading, description, or branding element.
Note: HTML embedding is only available for public resources, as there is no secure way to pass authentication to Smart Report Maker using plain HTML.">
                    <i class="fa-solid fa-circle-question"></i>
                  </span>
                </div>
                <div>
                  <textarea type="text" class="form-control" id="custom_html_after_embed"
                    name="custom_html_after_embed"><?php echo e(isset($preferences['custom_html_after_embed']) ? $preferences['custom_html_after_embed'] :''); ?></textarea>
                </div>
              </div>

              <div class="form-group">
                <div class="d-flex">
                  <label for="embed_token_life_span">Embed Token Lifespan (in Minutes)</label>
                  <span class="tool-question mx-2 align-items-center" data-toggle="tooltip" data-placement="top" title="Specify how long an embed token remains valid, in minutes.
For example, entering 60 means each generated token will expire 60 minutes after creation.
This does not impact embedding performance, as the page always fetches a fresh token before loading the resource.
Applies only to private resources.">
                    <i class="fa-solid fa-circle-question"></i>
                  </span>
                </div>
                <div>
                  <input type="number" class="form-control" id="embed_token_life_span" name="embed_token_life_span"
                    value="<?php echo e(isset($preferences['embed_token_life_span']) ? $preferences['embed_token_life_span'] :''); ?>">
                </div>
              </div>

              <div class="text-center">
                <input type="button" class="btn btn-primary mx-2 px-5 py-2" value="Save" id="saveBtn-embed-settings">

                <input type="button" class="btn btn-secondary mx-2 px-5 py-2" id="cancelBtn-embed-settings"
                  value="Cancel">

              </div>

              <div id="confirm-embed-settings" class="alert bootstrap-alert-success my-2" role="alert"
                style="display: none">
              </div>

              <div id="error-embed-settings" class="alert bootstrap-alert-danger my-2" role="alert"
                style="display: none">
              </div>

            </form>
          </div>
        </div>
      </div>
</div>
<?php echo $__env->make('dashboard.general.partials._smtp-connections-confirm', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<?php if(checkDemo()): ?>
<script>
    const openBtn = document.getElementById("openPopup");
    const closeBtn = document.getElementById("closePopup");
    const overlay = document.getElementById("popupOverlay");

    openBtn.addEventListener("click", function(e) {
        overlay.style.display = "block";
    });

    closeBtn.addEventListener("click", function() {
        overlay.style.display = "none";
        // Stop video playback
        const iframe = document.getElementById("youtubeVideo");
        iframe.src = iframe.src;
    });

    window.addEventListener("click", function(e) {
    if (e.target === overlay) {
        overlay.style.display = "none";
        const iframe = document.getElementById("youtubeVideo");
        iframe.src = iframe.src;
    }
    });
</script>
<?php endif; ?>
<script src="<?php echo e(get_asset('dist/js/general-settings.js')); ?>" defer>
</script>
<script src="<?php echo e(get_asset('dist/js/branding.js')); ?>" defer></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/srm_phpv81_or_later/srm/dashboard/resources/views/dashboard/embed-preferences/index.blade.php ENDPATH**/ ?>