<div class="row">
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title"><i class="fa fa-palette"></i> Appearance</h5>
            </div>
            <div class="card-body">
                <div class="form-group">
                    <label for="theme-selector" class="form-label">Theme</label>
                    <i class="fa fa-question-circle" data-toggle="tooltip"
                        data-title='The Theme Selection field allows users to customize the appearance of the pivot table by choosing a predefined theme. This selection affects the table’s colors, fonts, and overall style. Once a theme is chosen, the user must click the "Apply" button to implement the changes, ensuring that the new theme is reflected immediately in the pivot table. '
                        style="color: #68b3c8; margin-left: 5px" data-original-title="" title="">
                    </i>
                    <select id="theme-selector" class="form-control" data-theme-location="<?php echo e(get_asset('dist/css/themes')); ?>"
                    name="theme">
                        <option value="cosmo" <?php echo e(isset($pivotTable) && $pivotTable->getResourceConfiguration('theme') == "cosmo" ? 'selected' : ''); ?>>Cosmo</option>
                        <option value="default" <?php echo e(isset($pivotTable) && $pivotTable->getResourceConfiguration('theme') == "default" ? 'selected' : ''); ?>>Bootstrap</option>
                        <option value="lumen" <?php echo e(isset($pivotTable) && $pivotTable->getResourceConfiguration('theme') == "lumen" ? 'selected' : ''); ?>>Lumen</option>
                        <option value="simplex" <?php echo e(isset($pivotTable) && $pivotTable->getResourceConfiguration('theme') == "simplex" ? 'selected' : ''); ?>>Simplex</option>
                        <option value="flatly" <?php echo e(isset($pivotTable) && $pivotTable->getResourceConfiguration('theme') == "flatly" ? 'selected' : ''); ?>>Flatly</option>
                        <option value="cerulean" <?php echo e(isset($pivotTable) && $pivotTable->getResourceConfiguration('theme') == "cerulean" ? 'selected' : ''); ?>>Cerulean</option>
                        <option value="cyborg" <?php echo e(isset($pivotTable) && $pivotTable->getResourceConfiguration('theme') == "cyborg" ? 'selected' : ''); ?>>Cyborg</option>
                        <option value="journal" <?php echo e(isset($pivotTable) && $pivotTable->getResourceConfiguration('theme') == "journal" ? 'selected' : ''); ?>>Journal</option>
                        <option value="litera" <?php echo e(isset($pivotTable) && $pivotTable->getResourceConfiguration('theme') == "litera" ? 'selected' : ''); ?>>Litera</option>
                        <option value="lux" <?php echo e(isset($pivotTable) && $pivotTable->getResourceConfiguration('theme') == "lux" ? 'selected' : ''); ?>>Lux</option>
                        <option value="materia" <?php echo e(isset($pivotTable) && $pivotTable->getResourceConfiguration('theme') == "materia" ? 'selected' : ''); ?>>Materia</option>
                        <option value="minty" <?php echo e(isset($pivotTable) && $pivotTable->getResourceConfiguration('theme') == "minty" ? 'selected' : ''); ?>>Minty</option>
                        <option value="morph" <?php echo e(isset($pivotTable) && $pivotTable->getResourceConfiguration('theme') == "morph" ? 'selected' : ''); ?>>Morph</option>
                        <option value="pulse" <?php echo e(isset($pivotTable) && $pivotTable->getResourceConfiguration('theme') == "pulse" ? 'selected' : ''); ?>>Pulse</option>
                        <option value="sandstone" <?php echo e(isset($pivotTable) && $pivotTable->getResourceConfiguration('theme') == "sandstone" ? 'selected' : ''); ?>>Sandstone</option>
                        <option value="solar" <?php echo e(isset($pivotTable) && $pivotTable->getResourceConfiguration('theme') == "solar" ? 'selected' : ''); ?>>Solar</option>
                        <option value="spacelab" <?php echo e(isset($pivotTable) && $pivotTable->getResourceConfiguration('theme') == "spacelab" ? 'selected' : ''); ?>>Spacelab</option>
                        <option value="superhero" <?php echo e(isset($pivotTable) && $pivotTable->getResourceConfiguration('theme') == "superhero" ? 'selected' : ''); ?>>Superhero</option>
                        <option value="united" <?php echo e(isset($pivotTable) && $pivotTable->getResourceConfiguration('theme') == "united" ? 'selected' : ''); ?>>United</option>
                        <option value="yeti" <?php echo e(isset($pivotTable) && $pivotTable->getResourceConfiguration('theme') == "yeti" ? 'selected' : ''); ?>>Yeti</option>
                        <option value="zephyr" <?php echo e(isset($pivotTable) && $pivotTable->getResourceConfiguration('theme') == "zephyr" ? 'selected' : ''); ?>>Zephyr</option>
                    </select>
                </div>
                <div class="form-group">
                    <label for="grand-totals-function" class="form-label">Alignment</label>
                    <i class="fa fa-question-circle" data-toggle="tooltip"
                        data-title="The Alignment field determines how the values within the pivot table cells are displayed. Users can choose to align the text to the left, center, or right."
                        style="color: #68b3c8; margin-left: 5px" data-original-title="" title="">
                    </i>

                    <select name="alignment" id="alignment" class="form-control">
                        <option value="center" <?php echo e(isset($pivotTable) && $pivotTable->getResourceConfiguration('alignment') == "center" ? 'selected' : ''); ?>>Center</option>
                        <option value="right" <?php echo e(isset($pivotTable)&& $pivotTable->getResourceConfiguration('alignment') == "right" ? 'selected' : ''); ?>>Right</option>
                        <option value="left" <?php echo e(isset($pivotTable) &&$pivotTable->getResourceConfiguration('alignment') == "left" ? 'selected' : ''); ?>>Left</option>
                    </select>
                </div>
                <div class="row">
                    <div class="form-group col">
                        <label for="values-format" class="form-label">Values Format</label>
                        <i class="fa fa-question-circle" data-toggle="tooltip"
                            data-title='The Values Format field controls numeric display in the pivot table, allowing currency, percentage, or decimal formats. Users can add symbols ($, €, ¥) or custom units (kg, meters) for flexibility.'
                            style="color: #68b3c8; margin-left: 5px" data-original-title="" title="">
                        </i>
                        <select name="values_format" id="values-format" class="form-control">
                            <option value="numeric" <?php echo e(isset($pivotTable) && $pivotTable->getResourceConfiguration('values_format') == "numeric" ? 'selected' : ''); ?>>Numeric Value</option>
                            <option value="standard_currency" <?php echo e(isset($pivotTable) && $pivotTable->getResourceConfiguration('values_format') == "standard_currency" ? 'selected' : ''); ?>>Standard Currency Format</option>
                            <option value="custom_unit" <?php echo e(isset($pivotTable) && $pivotTable->getResourceConfiguration('values_format') == "custom_unit" ? 'selected' : ''); ?>>Custom Unit</option>
                        </select>
                    </div>
                    <div class="form-group col currency"
                    <?php if(isset($pivotTable) && in_array($pivotTable->getResourceConfiguration('values_format'),["numeric"])): ?>
                    style="display: none"
                    <?php endif; ?>
                    >
                        <label for="currency" class="form-label">
                            <?php if(isset($pivotTable) && $pivotTable->getResourceConfiguration('values_format') == "custom_unit"): ?>
                            Custom unit
                            <?php else: ?>
                            Currency
                            <?php endif; ?>
                        </label>
                        <?php if(isset($pivotTable) && $pivotTable->getResourceConfiguration('values_format') == "custom_unit"): ?>

                        <input name="custom_unit" id="custom-unit" class="form-control" value="<?php echo e(isset($pivotTable) ? $pivotTable->getResourceConfiguration('custom_unit') : ''); ?>"/>
                        <?php else: ?>
                        <input name="currency" id="currency" class="form-control" value="<?php echo e(isset($pivotTable) ? $pivotTable->getResourceConfiguration('currency') : ''); ?>"/>

                        <?php endif; ?>
                    </div>

                </div>
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card" style="height: 343px;">
            <div class="card-header">
                <h5 class="card-title"><i class="fa fa-heading"></i> Titles</h5>
            </div>
            <div class="card-body">
                <div class="form-group">
                    <label for="pivot-table-title" class="form-label">Pivot Table Title</label>
                    <i class="fa fa-question-circle" data-toggle="tooltip"
                        data-title="The Pivot Table Title field allows users to set a meaningful title for their pivot table, which will be displayed prominently at the top. This title helps in identifying the table’s purpose and making the report more structured. However, users have the option to leave this field empty if they prefer not to display a title."
                        style="color: #68b3c8; margin-left: 5px" data-original-title="" title="">
                    </i>
                    <input type="text" name="pivot_table_title" id="pivot-table-title" class="form-control" value="<?php echo e(isset($pivotTable) ? $pivotTable->getResourceConfiguration('pivot_table_title') : 'Pivot table title'); ?>"/>
                </div>
                <div class="form-group">
                    <label for="grand-totals-label" class="form-label">Grand Total Title</label>
                    <i class="fa fa-question-circle" data-toggle="tooltip"
                        data-title='The Grand Total Title field is used to define a custom label for the Grand Total row and column. This title will be displayed as a header for the aggregated total values in the pivot table. Users can modify this label to make it more relevant to their dataset, such as renaming it to "Total Sales" or "Overall Revenue" to better reflect the context of the data.'
                        style="color: #68b3c8; margin-left: 5px" data-original-title="" title="">
                    </i>
                    <input type="text" name="grand_totals_label" id="grand-totals-label" class="form-control" value="<?php echo e(isset($pivotTable) ? $pivotTable->getResourceConfiguration('grand_totals_label') : 'Total'); ?>"/>
                </div>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /var/www/html/srm_phpv81_or_later/srm/dashboard/resources/views/dashboard/pivot-tables/partials/_appearance.blade.php ENDPATH**/ ?>