<?php $__env->startSection('styles'); ?>
<!-- DataTables -->
<link rel="stylesheet" href="<?php echo e(get_asset('dist/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css'). '?v='. $srmVersion); ?>">
<link rel=" stylesheet" href="<?php echo e(get_asset('dist/plugins/datatables-responsive/css/responsive.bootstrap4.min.css'). '?v='. $srmVersion); ?>">
<link rel=" stylesheet" href="<?php echo e(get_asset('dist/plugins/datatables-buttons/css/buttons.bootstrap4.min.css'). '?v='. $srmVersion); ?>">

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<?php echo $__env->make('dashboard.scheduled-reports.partials.success-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


<?php echo $__env->make('dashboard.scheduled-reports.partials._reports-confirmation-modal',[
'id' => 'delete-scheduled-report',
'modal_title' =>'Delete Confirmation',
'method'=> 'DELETE'
], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php echo $__env->make('dashboard.scheduled-reports.partials._reports-confirmation-modal',[
'id' => 'stop-scheduled-report',
'modal_title' =>'Stop Confirmation',
'method'=> 'PATCH'
], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php echo $__env->make('dashboard.scheduled-reports.partials._reports-confirmation-modal',[
'id' => 'resume-scheduled-report',
'modal_title' =>'Resume Confirmation',
'method'=> 'PATCH'
], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div id="change-category-modal-container">

</div>

<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2 mt-2">
                <div class="col-sm-6">
                    <h3> <i class="fa-solid fa-calendar-days mx-2"></i> Scheduled Reports</h3>

                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Home</a></li>
                        <li class="breadcrumb-item">Scheduled Reports</li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
        <div class="container-fluid mt-5">
            <!-- Use container-fluid for full-width -->

            <div class="form-group mx-2">
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="title-search">Title</label>
                            <input type="text" class="form-control" id="title-search">
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="frequency-search">Frequency</label>
                            <select class="form-control" id="frequency-search">
                                <option value="">Choose Frequency</option>
                                <option value="hourly">Hourly</option>
                                <option value="daily">Daily</option>
                                <option value="weekly">Weekly</option>
                                <option value="monthly">Monthly</option>
                            </select>
                        </div>
                    </div>

                </div>
            </div>

            <div class="form-group text-center">
                <button class="btn btn-primary px-3 py-2 my-2 srm-button my-sm-0 search-filter" type="submit"><i
                        class="fas fa-search"></i> Search</button>
                <button class="btn btn-outline-primary px-3 py-2 my-2 ml-2 my-sm-0 srm-button reset-filter"
                    type="button"><i class="fa-solid fa-eye"></i> Show All</button>
            </div>
            </form>
            <div class="card-body mt-2 d-flex justify-content-end">
                <a class="btn btn-primary create-report px-3 py-2 float-right srm-button" type="button"
                    href="<?php echo e(route('scheduled-reports.create')); ?>">
                    <i class="fas fa-plus"></i> Add New Scheduled Report
                </a>
            </div>

            <div class="card-body">
                <table id="scheduled-reports" class="table table-bordered table-hover">
                    <thead>
                        <tr>
                            <th>Title</th>
                            <th>Frequency</th>
                            <th>Begin Date</th>
                            <th>Last Sent</th>
                            <th>last Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $tasks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $task): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                        <tr>
                            <td><?php echo e($task->title); ?></td>
                            <td><?php echo e($task->frequency); ?></td>
                            <td><?php echo e($task->begin_date); ?></td>
                            <td><?php echo e($task->last_sending_datetime); ?></td>
                            <td>
                                <?php if(checkDemo()): ?>
                                <?php echo e("success"); ?>

                                <?php else: ?>
                                <?php echo e($task->last_status); ?>

                                <?php endif; ?>
                            </td>
                            <td>
                                <div class="dropdown">
                                    <button type="button" id="ellipsisMenu2" data-toggle="dropdown" aria-haspopup="true"
                                        aria-expanded="false" style="border:none;background:none">
                                        <!-- Your SVG icon -->
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                            fill="currentColor" class="bi bi-three-dots-vertical" viewBox="0 0 16 16">
                                            <path
                                                d="M9.5 13a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0z" />
                                        </svg>
                                    </button>

                                    <div class="dropdown-menu" aria-labelledby="ellipsisMenu">
                                        <?php if(!in_array($task->last_status,['stopped','ended','deleted'])): ?>
                                        <a class="dropdown-item manual-send"
                                            data-url="<?php echo e(route('scheduled-reports.send',$task->id)); ?>"
                                            href="<?php echo e(route('scheduled-reports.send',$task->id)); ?>">Manual send Now</a>
                                        <?php endif; ?>
                                        <?php if(!checkDemo()): ?>
                                        <a class="dropdown-item view-log"
                                            data-url="<?php echo e(route('scheduled-reports.log',$task->id)); ?>"
                                            href="<?php echo e(route('scheduled-reports.log',$task->id)); ?>">View log</a>
                                        <?php endif; ?>
                                        <a class="dropdown-item edit-scheduled-report"
                                            href="<?php echo e(route('scheduled-reports.edit',$task->id)); ?>">Edit</a>
                                        <?php if($task->last_status != 'stopped'): ?>
                                        <a class="dropdown-item stop-scheduled-report" data-toggle="modal"
                                            data-url="<?php echo e(route('scheduled-reports.stop',$task->id)); ?>"
                                            data-target="#stop-scheduled-report-modal">Stop</a>
                                        <?php else: ?>
                                        <a class="dropdown-item resume-scheduled-report" data-toggle="modal"
                                            data-url="<?php echo e(route('scheduled-reports.resume',$task->id)); ?>"
                                            data-target="#resume-scheduled-report-modal">Resume</a>
                                        <?php endif; ?>
                                        <a class="dropdown-item delete-scheduled-report" data-toggle="modal"
                                            data-target="#delete-scheduled-report-modal"
                                            data-url="<?php echo e(route('scheduled-reports.destroy',$task->id)); ?>">Delete</a>
                                    </div>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>

            </div>
        </div>

</div>

</div>


<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script src="<?php echo e(get_asset('dist/plugins/datatables/jquery.dataTables.min.js') . '?v='. $srmVersion); ?>"></script>
<script src="<?php echo e(get_asset('dist/plugins/datatables-responsive/js/dataTables.responsive.min.js') . '?v='. $srmVersion); ?>"></script>
<script src="<?php echo e(get_asset('dist/plugins/datatables-responsive/js/responsive.bootstrap4.min.js') . '?v='. $srmVersion); ?>"></script>
<script src="<?php echo e(get_asset('dist/plugins/datatables-buttons/js/dataTables.buttons.min.js') . '?v='. $srmVersion); ?>"></script>
<script src="<?php echo e(get_asset('dist/plugins/datatables-buttons/js/buttons.bootstrap4.min.js') . '?v='. $srmVersion); ?>"></script>
<script src="<?php echo e(get_asset('dist/plugins/jszip/jszip.min.js') . '?v='. $srmVersion); ?>"></script>
<script src="<?php echo e(get_asset('dist/plugins/pdfmake/pdfmake.min.js') . '?v='. $srmVersion); ?>"></script>
<script src="<?php echo e(get_asset('dist/plugins/pdfmake/vfs_fonts.js') . '?v='. $srmVersion); ?>"></script>
<script src="<?php echo e(get_asset('dist/plugins/datatables-buttons/js/buttons.html5.min.js') . '?v='. $srmVersion); ?>"></script>
<script src="<?php echo e(get_asset('dist/plugins/datatables-buttons/js/buttons.print.min.js') . '?v='. $srmVersion); ?>"></script>
<script src="<?php echo e(get_asset('dist/plugins/datatables-buttons/js/buttons.colVis.min.js') . '?v='. $srmVersion); ?>"></script>
<script src="<?php echo e(get_asset('dist/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js') . '?v='. $srmVersion); ?>"></script>
<script src="<?php echo e(get_asset('dist/js/custom-datatables.js') . '?v='. $srmVersion); ?>"></script>

<script>
    displayUserPanel();

</script>

<?php if(checkDemo() && !is_null(session()->get('demo'))): ?>
<script>
    $(`#demo-modal`).find('h5').text("<?php echo e(session()->get('demo')); ?>");
    $(`#demo-modal`).modal('show');
</script>
<?php endif; ?>

<script src="<?php echo e(get_asset('dist/js/scheduled-reports.js')); ?>" defer>
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/srm_phpv81_or_later/srm/dashboard/resources/views/dashboard/scheduled-reports/index.blade.php ENDPATH**/ ?>