<?php $__env->startSection('styles'); ?>
<!-- DataTables -->
<link rel="stylesheet" href="<?php echo e(get_asset('dist/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css'). '?v='. $srmVersion); ?>">
<link rel=" stylesheet" href="<?php echo e(get_asset('dist/plugins/datatables-responsive/css/responsive.bootstrap4.min.css'). '?v='. $srmVersion); ?>">
<link rel=" stylesheet" href="<?php echo e(get_asset('dist/plugins/datatables-buttons/css/buttons.bootstrap4.min.css'). '?v='. $srmVersion); ?>">

<style>
.modal {
    z-index: 1050  !important; /* default Bootstrap modal z-index */
}
.modal.modal-front {
    z-index: 1060 !important; /* higher so it appears above */
}
.modal-backdrop {
    z-index: 1040 !important; /* default backdrop z-index */
}
.modal-backdrop.backdrop-front {
    z-index: 1055 !important; /* between the two modals */
}
</style>

<?php if(checkDemo()): ?>
<link href="<?php echo e(get_asset('dist/css/alertify.core.css'). '?v='. $srmVersion); ?>" rel="stylesheet">
<link href="<?php echo e(get_asset('dist/css/alertify.default.css'). '?v='. $srmVersion); ?>" rel="stylesheet">

<?php endif; ?>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('dashboard.dashboards.partials.confirm-public', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->startSection('content'); ?>

<?php echo $__env->make('dashboard.dashboards.partials.success-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php echo $__env->make('dashboard.dashboards.partials._dashboards-confirmation-modal',[
'id' => 'delete-dashboard',
'modal_title' =>'Delete Confirmation',
'method'=> 'DELETE'
], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


<div id="edit-dashboard-modal-container">

</div>

<div id="add-dashboard-modal-container">

</div>


<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2 mt-2">
                <div class="col-sm-6">
                    <h3> <i class="fas fa-tachometer-alt mx-2"></i> Dashboards</h3>

                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Home</a></li>
                        <li class="breadcrumb-item">Dashboards</li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
        <div class="container-fluid mt-5">
            <!-- Use container-fluid for full-width -->

            <div class="form-group mx-2">
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="name-search">Name</label>
                            <input type="text" class="form-control" id="name-search">
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="title-search">Title</label>
                            <input type="text" class="form-control" id="title-search">
                        </div>
                    </div>

                </div>
            </div>

            <div class="form-group text-center">
                <button class="btn btn-primary my-2 my-sm-0 px-3 py-2 srm-button search-filter" type="submit"><i
                        class="fas fa-search"></i> Search</button>
                <button class="btn btn-outline-primary my-2 my-sm-0 ml-2 px-3 py-2 srm-button reset-filter"
                    type="button"><i class="fa-solid fa-eye"></i> Show
                    All</button>
            </div>
            </form>
            <div class="card-body mt-2 d-flex justify-content-end">
                <button type="button" class="btn btn-primary float-right px-3 py-2 srm-button" id="add-dashboard-button"
                    data-url="<?php echo e(route('dashboards.create')); ?>">
                    <i class="fas fa-plus"></i> Add New Dashboard
                </button>
            </div>

            <div class="card-body">
                <table id="dashboards" class="table table-bordered table-hover">
                    <thead>
                        <tr>
                            <th>Dashboard name</th>
                            <th>Dashboard Title</th>
                            <th>Dashboard Icon</th>
                            <th>Widgets Count</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $dashboards; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dashboard): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                        <tr>
                            <td><a href="<?php echo e(route('dashboards.show',[$dashboard->name])); ?>" style="color: black"><?php echo e($dashboard->clean_name); ?></a>
                            </td>
                            <td><?php echo e($dashboard->title); ?></td>
                            <td>
                                <i class="fa fa-fw" style="font-family: 'FontAwesome'"> <?php echo '&'. $dashboard->icon; ?></i>
                            </td>
                            <td><?php echo e($dashboard->widgets_count); ?></td>
                            <td>
                                <div class="dropdown">
                                    <button type="button" id="ellipsisMenu2" data-toggle="dropdown" aria-haspopup="true"
                                        aria-expanded="false" style="border:none;background:none">
                                        <!-- Your SVG icon -->
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                            fill="currentColor" class="bi bi-three-dots-vertical" viewBox="0 0 16 16">
                                            <path
                                                d="M9.5 13a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0z" />
                                        </svg>
                                    </button>

                                    <div class="dropdown-menu" aria-labelledby="ellipsisMenu">

                                        <a class="dropdown-item display"
                                            data-url="<?php echo e(route('dashboards.show',$dashboard->name)); ?>"
                                            href="<?php echo e(route('dashboards.show',$dashboard->name)); ?>">Display</a>
                                        <a class="dropdown-item edit-dashboard"
                                            data-url="<?php echo e(route('dashboards.edit',$dashboard->name)); ?>">Edit</a>

                                        <a class="dropdown-item move-up-dashboard"
                                            data-url="<?php echo e(route('dashboards.moveUp',$dashboard->name)); ?>">Move Up</a>
                                        <a class="dropdown-item move-down-dashboard"
                                            data-url="<?php echo e(route('dashboards.moveDown',$dashboard->name)); ?>">Move
                                            Down</a>

                                        <a class="dropdown-item delete-dashboard" data-toggle="modal"
                                            data-target="#delete-dashboard-modal"
                                            data-url="<?php echo e(route('dashboards.destroy',$dashboard->name)); ?>">Delete</a>
                                    </div>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>

            </div>
        </div>

</div>

</div>


<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script src="<?php echo e(get_asset('dist/plugins/datatables/jquery.dataTables.min.js') . '?v='. $srmVersion); ?>"></script>
<script src="<?php echo e(get_asset('dist/plugins/datatables-responsive/js/dataTables.responsive.min.js') . '?v='. $srmVersion); ?>"></script>
<script src="<?php echo e(get_asset('dist/plugins/datatables-responsive/js/responsive.bootstrap4.min.js') . '?v='. $srmVersion); ?>"></script>
<script src="<?php echo e(get_asset('dist/plugins/datatables-buttons/js/dataTables.buttons.min.js') . '?v='. $srmVersion); ?>"></script>
<script src="<?php echo e(get_asset('dist/plugins/datatables-buttons/js/buttons.bootstrap4.min.js') . '?v='. $srmVersion); ?>"></script>
<script src="<?php echo e(get_asset('dist/plugins/jszip/jszip.min.js') . '?v='. $srmVersion); ?>"></script>
<script src="<?php echo e(get_asset('dist/plugins/pdfmake/pdfmake.min.js') . '?v='. $srmVersion); ?>"></script>
<script src="<?php echo e(get_asset('dist/plugins/pdfmake/vfs_fonts.js') . '?v='. $srmVersion); ?>"></script>
<script src="<?php echo e(get_asset('dist/plugins/datatables-buttons/js/buttons.html5.min.js') . '?v='. $srmVersion); ?>"></script>
<script src="<?php echo e(get_asset('dist/plugins/datatables-buttons/js/buttons.print.min.js') . '?v='. $srmVersion); ?>"></script>
<script src="<?php echo e(get_asset('dist/plugins/datatables-buttons/js/buttons.colVis.min.js') . '?v='. $srmVersion); ?>"></script>
<script src="<?php echo e(get_asset('dist/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js') . '?v='. $srmVersion); ?>"></script>
<script src="<?php echo e(get_asset('dist/js/custom-datatables.js') . '?v='. $srmVersion); ?>"></script>

<?php if(checkDemo()): ?>
<script src="<?php echo e(get_asset('dist/js/alertify.min.js') . '?v='. $srmVersion); ?>"></script>
<?php endif; ?>


<script src="<?php echo e(get_asset('dist/js/dashboards.js')); ?>" defer>
</script>



<?php if(session('add')): ?>

<script>
    setTimeout(() => {
        $(document).ready(function(){
            $('#add-dashboard-button').click();
        });
    }, 500);
</script>

<?php endif; ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/srm_phpv81_or_later/srm/dashboard/resources/views/dashboard/dashboards/index.blade.php ENDPATH**/ ?>