<?php $__env->startSection('styles'); ?>
<?php
$srmVersion = getSrmVersion();
?>
<style>
    .content-wrapper>* {
        font-family: 'poppins', 'arial';
    }
    .content-wrapper{
        background-color: white !important
    }
</style>
<link rel="stylesheet" href="<?php echo e(get_asset('dist/css/c3.min.css'). '?v='. $srmVersion); ?>" />
<link rel="stylesheet" href="<?php echo e(get_asset('dist/css/metrics.css'). '?v='. $srmVersion); ?>" />

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<?php echo $__env->make('dashboard.metrics.partials.success-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<!-- Content Header (Page header) -->
<section class="content-header">
    <div class="container-fluid px-4">
        <div class="row mb-2 mt-2">
            <div class="col-sm-8">
                <h2 style="font-weight: bold"><?php echo e(ucwords($metric->getResourceConfiguration('title'))); ?>

                </h2>
                <h6><?php echo e(\Carbon\Carbon::now()->format('d M Y h:i A')); ?></h6>
            </div>
            <div class="col-sm-4 text-right">
                <div class="p-2 branding-logo">
                    <?php echo $__env->make('partials._logo', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
            </div>
        </div>
        <hr style="border-top: 1px solid rgba(0, 0, 0, .5);">
    </div>
    <div class="container-fluid mt-4 px-4">
        <div class="row">
            <div class="col-6">
                
                <?php echo $metric->drillTooltip; ?>

            </div>
            <div class="col-6">
                <div class="buttons text-right mb-4">
                    <?php
                    $params = !request()->has('token')
                    ? [
                        'metric' => $metric->name
                    ]: [
                        'metric' => $metric->name,
                        'token' => request()->query('token')
                    ]
                    ?>
                    <a href="<?php echo e(resourceInternalSignedUrl('metrics.drill.print', $params, !request()->has('expires'))); ?>" id="print-metric"
                        class="btn btn-light py-3 px-4 btn-xl shadow-sm mx-4" style="display: inline-block">
                        <i class="fa-solid fa-print"></i> Print
                    </a>
                    <a href="<?php echo e(resourceInternalSignedUrl('metrics.drill.export', $params, !request()->has('expires'))); ?>" id="export-metric"
                        class="btn btn-light py-3 px-3 shadow-sm" style="display: inline-block">
                        <i class="fa-solid fa-file-export"></i> Export
                    </a>

                    <form id="metricExportForm" action="<?php echo e(resourceInternalSignedUrl('metrics.drill.export',['metric' => $metric->name], is_null(request()->query('expires')))); ?>" method="POST"
                        style="display: none;">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="page" value="<?php echo e($data->currentPage()); ?>">

                        <input type="hidden" id="metricImageData" name="metricImageData">
                    </form>

                    <form id="metricPrintForm" action="<?php echo e(resourceInternalSignedUrl('metrics.drill.print',['metric' => $metric->name], is_null(request()->query('expires')))); ?>" method="POST"
                        style="display: none;">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="page" value="<?php echo e($data->currentPage()); ?>">
                        <input type="hidden" id="metricPrintImageData" name="metricPrintImageData">
                    </form>

                </div>
            </div>

        </div>
        <div class="clearfix"></div>

        <div class="table table-bordered table-striped" style="overflow-x: auto;word-break:keep-all;">
            <table id="reports" style="width: 100%">
                <thead>
                    <tr style="background-color: #d6d8da">
                        <?php $__currentLoopData = $keys; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <th><?php echo e(ucwords($key)); ?></th>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tr>
                </thead>
                <tbody>
                    <?php if($data->total() > 0): ?>
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr class="smaller-font">
                        <?php $__currentLoopData = $row; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                        <td><?php echo e($item); ?></td>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                    <tr style="background-color:transparent">
                        <td style="text-align: center" colspan="<?php echo e(count($keys)); ?>">
                            <h6>Sorry, There is no data</h6>
                        </td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        <div class="float-right">
            <?php echo e($data->appends(request()->query())->links()); ?>

        </div>
        <div class="clearfix"></div>
        <?php if($metric->getResourceConfiguration('compare_with') !='no_comparison'): ?>
        <div class="card card-primary card-outline">
            <div class="card-header">
                <h3 class="card-title" style="color:black;font-weight:bold">
                    <?php echo e($metric->getResourceConfiguration('title')); ?>

                </h3>
            </div>
            <div class="card-body">
                <?php
                $metricID = Str::of($metric->name)->kebab();
                ?>
                <div id="<?php echo e($metricID); ?>"></div>
                <canvas id="chartCanvas" style="display: none;"></canvas>

            </div>

        </div>
        <?php endif; ?>

    </div>




    <?php $__env->stopSection(); ?>

    <?php
    $gdEnabled = extension_loaded('gd');
    ?>

    <?php $__env->startSection('scripts'); ?>
    <?php if($metric->getResourceConfiguration('compare_with') !='no_comparison'): ?>

    <script src="<?php echo e(get_asset('dist/js/moment.min.js') . '?v='. $srmVersion); ?>"></script>
    <script src="<?php echo e(get_asset('dist/js/d3.v5.min.js') . '?v='. $srmVersion); ?>"></script>
    <script src="<?php echo e(get_asset('dist/js/c3.min.js') . '?v='. $srmVersion); ?>"></script>
    <script src="<?php echo e(get_asset('dist/js/charts.js') . '?v='. $srmVersion); ?>"></script>
    <script>
        <?php echo $metric->script; ?>

    </script>
    <script src="<?php echo e(get_asset('dist/js/html2canvas.min.js')); ?>"></script>

    <script>
        function exportMetricImage(element,form) {
            let gdEnabled = <?php echo json_encode($gdEnabled, 15, 512) ?>;

            if (!gdEnabled) {
                $(`#success-modal`).find('h5').html(`
                    <div class="text-left">
                        <strong>⚠️ GD extension is not enabled on your server.</strong>
                        <br><br>
                        <strong>To enable it:</strong>
                        <ul>
                            <li>Open your <code>php.ini</code> file.</li>
                            <li>Find this line: <code>;extension=gd</code></li>
                            <li>Remove the semicolon (uncomment it): <code>extension=gd</code></li>
                            <li>Restart your web server (Apache, Nginx, etc).</li>
                        </ul>
                        <p><strong>Note:</strong> In some PHP versions, the extension name may be <code>gd2</code> instead of <code>gd</code>.</p>
                    </div>
                `).show();
                $(`#success-modal`).modal('show');
            }else{
                var metric = document.getElementById("<?php echo e($metricID); ?>");
                $("#global-loader").fadeIn();

                html2canvas(metric, {
                    backgroundColor: null,
                    scale: 1.5,
                    logging: false
                }).then(function(canvas) {
                    // Convert the canvas to a data URL (PNG format)
                    var metricImage = canvas.toDataURL('image/png');

                    // Set the metric image data in a hidden input field within the form
                    document.getElementById(element).value = metricImage;

                    $.ajax({
                        type: 'POST',
                        url: $("#" + form).attr('action'),
                        data: $("#" + form).serialize(),
                        xhrFields:{
                            responseType: 'blob'
                        },
                        beforeSend:function(){
                            $("#global-loader").fadeIn();
                        },
                        success: function(response) {
                            var blob = new Blob([response]);
                            var link = document.createElement('a');
                            link.href = URL.createObjectURL(blob);
                            link.download = "<?php echo e(ucwords($metric->getResourceConfiguration('title')) . '-page ' . $data->currentPage()); ?>.pdf";
                            link.click();

                            $("#global-loader").fadeOut("slow");
                            $("#global-loader .loader-text").html('');
                        },
                        error: function(xhr, status, error) {
                            $("#global-loader").fadeOut("slow");
                            $("#global-loader .loader-text").html('');
                        }
                    });
                });
            }
    }

    function printMetricImage(element,form) {

        let gdEnabled = <?php echo json_encode($gdEnabled, 15, 512) ?>;

        if (!gdEnabled) {
            $(`#success-modal`).find('h5').html(`
                <div class="text-left">
                    <strong>⚠️ GD extension is not enabled on your server.</strong>
                    <br><br>
                    <strong>To enable it:</strong>
                    <ul>
                        <li>Open your <code>php.ini</code> file.</li>
                        <li>Find this line: <code>;extension=gd</code></li>
                        <li>Remove the semicolon (uncomment it): <code>extension=gd</code></li>
                        <li>Restart your web server (Apache, Nginx, etc).</li>
                    </ul>
                    <p><strong>Note:</strong> In some PHP versions, the extension name may be <code>gd2</code> instead of <code>gd</code>.</p>
                </div>
            `).show();
            $(`#success-modal`).modal('show');
        }else{


            var chart = document.getElementById("<?php echo e($metricID); ?>");
            $("#global-loader").fadeIn();

            html2canvas(chart, {
                backgroundColor: null,
                scale: 1.5,
                logging: false
            }).then(function(canvas) {
                // Convert the canvas to a data URL (PNG format)
                var chartImage = canvas.toDataURL('image/png');

                // Set the chart image data in a hidden input field within the form
                document.getElementById(element).value = chartImage;

                // Submit the form
                document.getElementById(form).submit();

            });
        }
    }


    $(document).on('click','#export-metric',function(e){
        e.preventDefault();
        $("#global-loader .loader-text").html('Please wait, this may take a few minutes.');

        exportMetricImage('metricImageData','metricExportForm');

    });

    $(document).on('click','#print-metric',function(e){
        e.preventDefault();
        $("#global-loader .loader-text").html('Please wait, this may take a few minutes.');

        printMetricImage('metricPrintImageData','metricPrintForm');
    });

    </script>
    <?php else: ?>
    <script>
    function printMetricPage(form)
    {
        let gdEnabled = <?php echo json_encode($gdEnabled, 15, 512) ?>;

        if (!gdEnabled) {
            $(`#success-modal`).find('h5').html(`
                <div class="text-left">
                    <strong>⚠️ GD extension is not enabled on your server.</strong>
                    <br><br>
                    <strong>To enable it:</strong>
                    <ul>
                        <li>Open your <code>php.ini</code> file.</li>
                        <li>Find this line: <code>;extension=gd</code></li>
                        <li>Remove the semicolon (uncomment it): <code>extension=gd</code></li>
                        <li>Restart your web server (Apache, Nginx, etc).</li>
                    </ul>
                    <p><strong>Note:</strong> In some PHP versions, the extension name may be <code>gd2</code> instead of <code>gd</code>.</p>
                </div>
            `).show();
            $(`#success-modal`).modal('show');
        }else{
            $("#global-loader").fadeIn();
            document.getElementById(form).submit();
        }
    }

    function exportMetricPage(form)
    {
        let gdEnabled = <?php echo json_encode($gdEnabled, 15, 512) ?>;

        if (!gdEnabled) {
            $(`#success-modal`).find('h5').html(`
                <div class="text-left">
                    <strong>⚠️ GD extension is not enabled on your server.</strong>
                    <br><br>
                    <strong>To enable it:</strong>
                    <ul>
                        <li>Open your <code>php.ini</code> file.</li>
                        <li>Find this line: <code>;extension=gd</code></li>
                        <li>Remove the semicolon (uncomment it): <code>extension=gd</code></li>
                        <li>Restart your web server (Apache, Nginx, etc).</li>
                    </ul>
                    <p><strong>Note:</strong> In some PHP versions, the extension name may be <code>gd2</code> instead of <code>gd</code>.</p>
                </div>
            `).show();
            $(`#success-modal`).modal('show');
        }else{

            $("#global-loader").fadeIn();
            $.ajax({
                type: 'POST',
                url: $("#" + form).attr('action'),
                data: $("#" + form).serialize(),
                xhrFields:{
                    responseType: 'blob'
                },
                beforeSend:function(){
                    $("#global-loader").fadeIn();
                },
                success: function(response) {
                    var blob = new Blob([response]);
                    var link = document.createElement('a');
                    link.href = URL.createObjectURL(blob);
                    link.download = "<?php echo e(ucwords($metric->getResourceConfiguration('title'))  . '-page ' . $data->currentPage()); ?>.pdf";
                    link.click();

                    $("#global-loader").fadeOut("slow");
                    $("#global-loader .loader-text").html('');

                },
                error: function(xhr, status, error) {
                    $("#global-loader").fadeOut("slow");
                    $("#global-loader .loader-text").html('');
                }
            });
        }

    }

    $(document).on('click','#export-metric',function(e){
        e.preventDefault();
        $("#global-loader .loader-text").html('Please wait, this may take a few minutes.');

        exportMetricPage('metricExportForm');

    });

    $(document).on('click','#print-metric',function(e){
        e.preventDefault();
        $("#global-loader .loader-text").html('Please wait, this may take a few minutes.');

        printMetricPage('metricPrintForm');
    });
    </script>
    <?php endif; ?>
    <?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.public', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/srm_phpv81_or_later/srm/dashboard/resources/views/dashboard/metrics/drill-public.blade.php ENDPATH**/ ?>