<?php $__env->startSection('styles'); ?>
<style>
    .content-wrapper {
        background-color: white;
    }

    .content-wrapper>* {
        font-family: 'poppins', 'arial';
    }
</style>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<?php echo $__env->make('dashboard.charts.partials.success-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid px-4">
            <div class="row mt-2">
                <div class="col-sm-6">
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Home</a></li>
                        <li class="breadcrumb-item"><a href="<?php echo e(route('charts.index')); ?>">Charts</a></li>
                        <li class="breadcrumb-item"><?php echo e($chart->name); ?></li>
                    </ol>
                </div>
            </div>
            <div class="row mb-2 mt-2">
                <div class="col-sm-8">
                    <h2 style="font-weight: bold"><?php echo e(ucwords($chart->getResourceConfiguration('title'))); ?>

                    </h2>
                    <h6><?php echo e(\Carbon\Carbon::now()->format('d M Y h:i A')); ?></h6>
                </div>
                <div class="col-sm-4 text-right">
                    <div class="p-2 branding-logo">
                        <?php echo $__env->make('partials._logo', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                </div>
            </div>
            <hr style="border-top: 1px solid rgba(0, 0, 0, .5);">
        </div>
        <div class="container-fluid mt-4 px-4" style="min-height:60vh">
            <div class="row">
                <div class="col-6">
                    <?php if(is_array($label)): ?>
                    <h6 class="py-3" style="font-weight:bold"><?php echo e(ucwords($chart->getResourceConfiguration('x_axis_column'))); ?>

                        : <span class="text-primary " style="font-weight:normal"><?php echo e($label[0]); ?></span> to
                        <span class="text-primary" style="font-weight:normal"><?php echo e($label[1]); ?></span>
                    </h6>
                    <?php else: ?>
                    <h6 class="py-3" style="font-weight:bold"><?php echo e(ucwords($chart->getResourceConfiguration('x_axis_column'))); ?>

                        : <span class="text-primary" style="font-weight:normal"><?php echo e(ucwords($xValue)); ?></span>
                    </h6>
                    <?php endif; ?>
                </div>

                <div class="col-6">
                    <div class="buttons text-right mb-4">
                        <a href="<?php echo e(route('charts.drill.print',[$chart->name]).'?xValue=' . $xValue .'&page=' . $data->currentPage()); ?>"
                            id="print-chart" class="btn btn-light py-3 px-4 btn-xl shadow-sm mx-4"
                            style="display: inline-block">
                            <i class="fa-solid fa-print"></i> Print
                        </a>
                        <a href="<?php echo e(route('charts.drill.export',[$chart->name]).'?xValue=' . $xValue .'&page=' . $data->currentPage()); ?>"
                            id="export-chart" class="btn btn-light py-3 px-3 shadow-sm" style="display: inline-block">
                            <i class="fa-solid fa-file-export"></i> Export
                        </a>
                    </div>
                </div>

            </div>
            <div class="clearfix"></div>

            <div class="table table-bordered table-striped" style="overflow-x: auto;word-break:keep-all;">
                <table id="reports" style="width: 100%">
                    <thead>
                        <tr style="background-color: #d6d8da">
                            <?php $__currentLoopData = $keys; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <th><?php echo e(ucwords($key)); ?></th>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if($data->total() > 0): ?>
                        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr class="smaller-font">
                            <?php $__currentLoopData = $row; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                            <td><?php echo e($item); ?></td>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php else: ?>
                        <tr style="background-color:transparent">
                            <td style="text-align: center" colspan="<?php echo e(count($keys)); ?>">
                                <h6>Sorry, There is no data</h6>
                            </td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
        <div class="float-right">
            <?php echo e($data->appends(request()->query())->links()); ?>

        </div>
        <div class="clearfix"></div>

</div>


<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
<?php
    $gdEnabled = extension_loaded('gd');
?>

<script>
    $(document).on('click','#export-chart',function(e){

        e.preventDefault();

        let gdEnabled = <?php echo json_encode($gdEnabled, 15, 512) ?>;

        if (!gdEnabled) {
            $(`#success-modal`).find('h5').html(`
                <div class="text-left">
                    <strong>⚠️ GD extension is not enabled on your server.</strong>
                    <br><br>
                    <strong>To enable it:</strong>
                    <ul>
                        <li>Open your <code>php.ini</code> file.</li>
                        <li>Find this line: <code>;extension=gd</code></li>
                        <li>Remove the semicolon (uncomment it): <code>extension=gd</code></li>
                        <li>Restart your web server (Apache, Nginx, etc).</li>
                    </ul>
                    <p><strong>Note:</strong> In some PHP versions, the extension name may be <code>gd2</code> instead of <code>gd</code>.</p>
                </div>
            `).show();
            $(`#success-modal`).modal('show');
        }else{


            $("#global-loader").fadeIn();
            $("#global-loader .loader-text").html('Please wait, this may take a few minutes.');

            $.ajax({
                type: 'GET',
                url: $("#export-chart").attr('href'),
                xhrFields:{
                    responseType: 'blob'
                },
                beforeSend:function(){
                    $("#global-loader").fadeIn();
                    $("#global-loader .loader-text").html('Please wait, this may take a few minutes.');

                },
                success: function(response) {
                    var blob = new Blob([response]);
                    var link = document.createElement('a');
                    link.href = URL.createObjectURL(blob);
                    link.download = "<?php echo e(ucwords($chart->getResourceConfiguration('title'))); ?>-<?php echo e($formatedXValue); ?>-page <?php echo e($data->currentPage()); ?>.pdf";
                    link.click();

                    $("#global-loader").fadeOut("slow");
                    $("#global-loader .loader-text").html('');

                },
                error: function(xhr, status, error) {
                    $("#global-loader").fadeOut("slow");
                    $("#global-loader .loader-text").html('');
                }
            });
        }
    });

    $(document).on('click','#print-chart',function(e){
        e.preventDefault();

        let gdEnabled = <?php echo json_encode($gdEnabled, 15, 512) ?>;

        if (!gdEnabled) {
            $(`#success-modal`).find('h5').html(`
                <div class="text-left">
                    <strong>⚠️ GD extension is not enabled on your server.</strong>
                    <br><br>
                    <strong>To enable it:</strong>
                    <ul>
                        <li>Open your <code>php.ini</code> file.</li>
                        <li>Find this line: <code>;extension=gd</code></li>
                        <li>Remove the semicolon (uncomment it): <code>extension=gd</code></li>
                        <li>Restart your web server (Apache, Nginx, etc).</li>
                    </ul>
                    <p><strong>Note:</strong> In some PHP versions, the extension name may be <code>gd2</code> instead of <code>gd</code>.</p>
                </div>
            `).show();
            $(`#success-modal`).modal('show');
        }else{

            $("#global-loader").fadeIn();
            $("#global-loader .loader-text").html('Please wait, this may take a few minutes.');

            window.location.href = $("#print-chart").attr('href')
        }

    });

</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/srm_phpv81_or_later/srm/dashboard/resources/views/dashboard/charts/drill.blade.php ENDPATH**/ ?>