<?php $__env->startSection('styles'); ?>
<!-- DataTables -->
<link rel="stylesheet" href="<?php echo e(get_asset('dist/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css'). '?v='. $srmVersion); ?>">
<link rel=" stylesheet" href="<?php echo e(get_asset('dist/plugins/datatables-responsive/css/responsive.bootstrap4.min.css'). '?v='. $srmVersion); ?>">
<link rel=" stylesheet" href="<?php echo e(get_asset('dist/plugins/datatables-buttons/css/buttons.bootstrap4.min.css'). '?v='. $srmVersion); ?>">

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<div id="edit-category-modal-container">

</div>
<?php echo $__env->make('dashboard.categories.partials._category-confirmation-modal',[
'id' => 'delete-category',
'modal_title' => 'Delete Confirmation',
'method'=> 'DELETE'
], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


<?php echo $__env->make('dashboard.categories.partials._category-add-modal',[
'id' => 'add-category',
], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('dashboard.categories.partials.success-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header mx-3">
        <div class="container-fluid">
            <div class="row mb-2 mt-3">
                <div class="col-sm-6">
                    <h3> <i class="fa-solid fa-folder fa-fw"></i>
                        Categories Management</h3>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Home</a></li>
                        <li class="breadcrumb-item active">Categories Management</li>
                    </ol>
                </div>
            </div>
        </div>
        <!-- /.container-fluid -->

        <div class="row ml-5">
            <label for="search-categories" class="mr-3 mt-2 h5">Category</label>
            <div class="form-group col-md-9">

                <input id="search-categories" class="form-control w-100" type="text" placeholder="Search"
                    aria-label="Search" style="height: 50px;">
                <?php echo $__env->make('dashboard.users.partials._session', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            </div>


        </div>
        <div class="form-group text-center mt-3">
            <button class="btn btn-primary px-3 py-2 my-2 my-sm-0 srm-button search-filter" type="submit"><i
                    class="fas fa-search"></i> Search</button>
            <button class="btn btn-outline-primary px-3 py-2 my-2 ml-2 my-sm-0 srm-button reset-filter" type="button"><i
                    class="fa-solid fa-eye"></i> Show All</button>
        </div>

        <button class="btn btn-primary add-category-button px-3 py-2 mb-3 float-right srm-button " type="button"
            data-toggle="modal" data-target="#add-category-modal">
            <i class="fas fa-plus"></i> Add New Category
        </button>


        <div class="clearfix card-body mt-3">
            <table id="categories" class="table table-bordered table-hover">
                <thead>
                    <tr>
                        <th>Category</th>
                        <th>Creation Date</th>
                        <th>Resources Count</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                    <tr>
                        <td>
                            <?php if(strpos($category->icon, '<i class') !==false): ?> <?php echo $category->icon; ?>

                                <?php else: ?>
                                <i class="fa fa-fw" style="font-family: 'FontAwesome'"> <?php echo '&'. $category->icon; ?></i>
                                <?php endif; ?>
                                <?php echo e($category->name); ?>

                        </td>
                        <td><?php echo e($category->created_at); ?></td>
                        <td><?php echo e($category->resources_count); ?></td>
                        <td>
                            <?php if(!$category->isDefaultCategory("unassigned")): ?>

                            <div class="dropdown">
                                <button type="button" id="ellipsisMenu1" data-toggle="dropdown" aria-haspopup="true"
                                    aria-expanded="false" style="border:none;background:none">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor"
                                        class="bi bi-three-dots-vertical" viewBox="0 0 16 16">
                                        <path
                                            d="M9.5 13a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0z" />
                                    </svg>
                                </button>
                                <div class="dropdown-menu" aria-labelledby="ellipsisMenu">
                                    <a class="dropdown-item edit-category"
                                        data-url="<?php echo e(route('categories.edit',$category->id)); ?>">Edit</a>
                                    <a class="dropdown-item move-up"
                                        data-url="<?php echo e(route('categories.moveUp',$category->id)); ?>">Move Up</a>
                                    <a class="dropdown-item move-down"
                                        data-url="<?php echo e(route('categories.moveDown',$category->id)); ?>">Move Down</a>

                                    <a class="dropdown-item delete-category" data-toggle="modal"
                                        data-target="#delete-category-modal"
                                        data-url="<?php echo e(route('categories.destroy',$category->id)); ?>">Delete</a>
                                </div>
                            </div>
                            <?php else: ?>
                            <span>&nbsp;</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                </tbody>
            </table>
        </div>

    </section>

</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<script src="<?php echo e(get_asset('dist/plugins/datatables/jquery.dataTables.min.js'). '?v='. $srmVersion); ?>"></script>
<script src="<?php echo e(get_asset('dist/plugins/datatables-responsive/js/dataTables.responsive.min.js'). '?v='. $srmVersion); ?>"></script>
<script src="<?php echo e(get_asset('dist/plugins/datatables-responsive/js/responsive.bootstrap4.min.js'). '?v='. $srmVersion); ?>"></script>
<script src="<?php echo e(get_asset('dist/plugins/datatables-buttons/js/dataTables.buttons.min.js'). '?v='. $srmVersion); ?>"></script>
<script src="<?php echo e(get_asset('dist/plugins/datatables-buttons/js/buttons.bootstrap4.min.js'). '?v='. $srmVersion); ?>"></script>
<script src="<?php echo e(get_asset('dist/plugins/jszip/jszip.min.js'). '?v='. $srmVersion); ?>"></script>
<script src="<?php echo e(get_asset('dist/plugins/pdfmake/pdfmake.min.js'). '?v='. $srmVersion); ?>"></script>
<script src="<?php echo e(get_asset('dist/plugins/pdfmake/vfs_fonts.js'). '?v='. $srmVersion); ?>"></script>
<script src="<?php echo e(get_asset('dist/plugins/datatables-buttons/js/buttons.html5.min.js'). '?v='. $srmVersion); ?>"></script>
<script src="<?php echo e(get_asset('dist/plugins/datatables-buttons/js/buttons.print.min.js'). '?v='. $srmVersion); ?>"></script>
<script src="<?php echo e(get_asset('dist/plugins/datatables-buttons/js/buttons.colVis.min.js'). '?v='. $srmVersion); ?>"></script>
<script src="<?php echo e(get_asset('dist/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js'). '?v='. $srmVersion); ?>"></script>
<script src="<?php echo e(get_asset('dist/js/custom-datatables.js'). '?v='. $srmVersion); ?>"></script>




<script>
    displayUserPanel();
</script>
<script src="<?php echo e(get_asset('dist/js/category.js'). '?v='. $srmVersion); ?>" defer>
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/srm_phpv81_or_later/srm/dashboard/resources/views/dashboard/categories/index.blade.php ENDPATH**/ ?>