<?php $__env->startSection('styles'); ?>

<link rel="stylesheet" href="<?php echo e(get_asset('dist/css/jstree.min.css'). '?v='. $srmVersion); ?>" />
<link rel="stylesheet" href="<?php echo e(get_asset('dist/css/bootstrap-icons.css'). '?v='. $srmVersion); ?>" />
<link id="theme-stylesheet" rel="stylesheet"
    href="<?php echo e(get_asset('dist/css/themes/')); ?><?php echo e($pivotTable->getResourceConfiguration('theme')); ?>/bootstrap.css">
<link rel="stylesheet" href="<?php echo e(get_asset('dist/css/pivot-table.css'). '?v='. $srmVersion); ?>" />
<link rel="stylesheet" href="<?php echo e(get_asset('dist/css/style.css'). '?v='. $srmVersion); ?>" />
<link rel="stylesheet" href="<?php echo e(get_asset('dist/css/nouislider.min.css'). '?v='. $srmVersion); ?>" />

<style>
    @media print {
        .card-primary.card-outline {
            border-top: 0px solid #007bff;
        }

        .header-print {
            display: block !important;
            margin: 0px !important;
            margin-bottom: 10px !important;
            padding: 0px !important;
            width: 100% !important;
            max-width: 100% !important;
            overflow: visible !important;
        }

        table th,
        table td {
            -webkit-print-color-adjust: exact;
            print-color-adjust: exact;
        }

        .content-header {
            display: block !important;
        }

        table {
            width: 100% !important;
            max-width: 100% !important;
            overflow: visible !important;
        }

        #pivot-table tr {
            display: table-row !important;
        }

        td,
        th {
            white-space: nowrap;
        }

        .table-responsive {
            overflow: visible !important;
        }

        .card {
            width: 100% !important;
            max-width: 100% !important;
            overflow: visible !important;

        }

        .table-container {
            width: 100% !important;
            max-width: 100% !important;
            overflow: visible !important;

        }

        #pagination {
            display: none !important;
        }

        .title-container {
            display: block !important;
            text-align: center;
        }

        .table-preview {
            margin: 0 !important;
            padding: 0 !important;
        }

        #pivot-table .main-header {
            display: table-header-group !important;
        }
    }

    .header-print {
        display: none;
    }

    .btn-group-dropdown {

        position: relative;
        display: inline-flex;
        vertical-align: middle;
    }

    .btn-group {
        display: flex;
        align-items: center;
        gap: 10px;
        width: 100%;
    }

    .parameter-label {
        white-space: nowrap;
    }

    .btn-group input[type="date"] {
        flex: 1;
        min-width: 0;
        text-align: left;
    }

    /* header */

    .organization-name {
        font-family: 'street_corner';
        font-weight: 100;
        font-size: 14px;
        color: #801818;
    }

    .organization-contact {
        font-family: 'street_corner';
        font-size: 12px;
        font-weight: 100;
        color: #3D4652;
        margin-top: 5px;

    }

    .date-title {
        font-family: 'street_corner';
        font-weight: 100;
        font-style: oblique;
        font-size: 14px;
        color: #3D4652;

    }

    .thick-divider {
        border-width: 3px;
        margin-bottom: 0px;
        padding: 2px;
        border-color: #3D4652;
    }

    .thin-divider {
        border-width: 1px;
        margin-top: 0px;
        margin-bottom: 0px;
        padding: 0px;
        border-color: #3D4652;
    }

    /* grid */
    .report-header-grid {
        display: grid;
        grid-template-columns: 2fr 3fr 1.5fr;
        /* Middle column is wider */
        gap: 10px;
    }

    .right-header {
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: flex-start;
        grid-column: 2 / 3;
    }

    .report-header-grid .logo {
        grid-column: 1 / 2;
        grid-row: 1 / 2;
        text-align: left;
        align-self: center;
    }

    .report-header-grid .title {
        grid-column: 1 / 2;
        grid-row: 2 / 3;
    }

    .report-header-grid .org-info {
        grid-column: 2 / 3;
        grid-row: 1 / 2;
        text-align: left;
        width: 100%;
    }

    .report-header-grid .qrcode {
        grid-column: 3 / 4;
        grid-row: 1 / 2;
        align-self: center;
        justify-self: center;
    }

    .report-header-grid .date {
        grid-column: 3 / 4;
        grid-row: 2 / 3;
        align-self: center;
        justify-self: center;

    }

    .brand-image {
        max-width: 100%;
        height: auto;
        text-align: center;
        align-self: middle;

    }

    .content-wrapper {
        background-color: white;
    }

    .table-preview .row>* {
        width: 100%;
    }
</style>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header no-print">
        <div class="row mt-2  no-print">
            <div class="col-sm-6">
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Home</a></li>
                    <li class="breadcrumb-item"><a href="<?php echo e(route('pivot-tables.index')); ?>">Pivot Tables</a></li>
                    <li class="breadcrumb-item"><?php echo e($pivotTable->name); ?></li>

                </ol>
            </div>
        </div>

        <div class="report-header-grid mt-3 no-print">
            <!-- Logo -->
            <div class="logo">
                <?php if(is_null(getSettingsValue('system_logo'))): ?>
                <img src="<?php echo e(public_path('dist/images/srm-logo.jpg')); ?>" alt="Logo" class="brand-image" />
                <?php else: ?>
                <img src="<?php echo e(getSystemLogo()); ?>" alt="Logo" class="brand-image" />
                <?php endif; ?>
            </div>

            <!-- Organization Info -->
            <div class="right-header">
                <div class="org-info">
                    <div class="organization-name fw-bold">
                        <?php echo e(get_organization()); ?>

                    </div>
                    <?php if(!is_null(get_organization_details())): ?>
                    <div class="organization-contact">
                        <?php echo nl2br(get_organization_details()->contact_info); ?>

                    </div>
                    <?php endif; ?>
                </div>
            </div>

            <div class="qrcode"></div>
            <!-- Title -->
            <h2 class="title fst-italic mb-0" id="pivot-table-title" style="font-weight: 600">
                <?php echo e($pivotTable->getResourceConfiguration('pivot_table_title')); ?>

            </h2>

            <!-- Date -->
            <div class="date">
                Date: <?php echo e(\Carbon\Carbon::now()->format('d-m-Y H:i:s')); ?>

            </div>
        </div>
        <hr class="thick-divider no-print" />
        <hr class="thin-divider no-print" />
    </section>

    <div class="container-fluid px-4">
        <?php if(session()->has('success')): ?>
        <div class="alert alert-success">
            <?php echo session()->get('success'); ?>

        </div>
        <?php endif; ?>

        <?php if(session()->has('failed')): ?>
        <div class="alert alert-danger">
            <?php echo e(session()->get('failed')); ?>

        </div>
        <?php endif; ?>
        <div class="tabs-container">
            <div class="header-print">
                <div class="report-header-grid mt-3">
                    <!-- Logo -->
                    <div class="logo">
                        <?php if(is_null(getSettingsValue('system_logo'))): ?>
                        <img src="<?php echo e(public_path('dist/images/srm-logo.jpg')); ?>" alt="Logo" class="brand-image" />
                        <?php else: ?>
                        <img src="<?php echo e(getSystemLogo()); ?>" alt="Logo" class="brand-image" />
                        <?php endif; ?>
                    </div>

                    <!-- Organization Info -->
                    <div class="right-header">
                        <div class="org-info">
                            <div class="organization-name fw-bold">
                                <?php echo e(get_organization()); ?>

                            </div>
                            <?php if(!is_null(get_organization_details())): ?>
                            <div class="organization-contact">
                                <?php echo nl2br(get_organization_details()->contact_info); ?>

                            </div>
                            <?php endif; ?>
                        </div>
                    </div>

                    <div class="qrcode"></div>
                    <!-- Title -->
                    <h2 class="title fst-italic mb-0" id="pivot-table-title" style="font-weight: 600">
                        <?php echo e($pivotTable->getResourceConfiguration('pivot_table_title')); ?>

                    </h2>

                    <!-- Date -->
                    <div class="date">
                        Date: <?php echo e(\Carbon\Carbon::now()->format('d-m-Y H:i:s')); ?>

                    </div>
                </div>
                <hr class="thick-divider" />
                <hr class="thin-divider" />

            </div>
            <form data-apply="<?php echo e(route('pivot-tables.build',$pivotTable->name)); ?>" method="POST" id="pivot-table-form">
                <?php echo csrf_field(); ?>
                <input type="text" name="pivot_table_name" id="pivot-table-name-textbox" class="d-none"
                    value="Pivot_Table1">
                <input type="hidden" name="alignment" id="alignment"
                    value="<?php echo e($pivotTable->getResourceConfiguration('alignment')); ?>">
                <div class="row justify-content-center">
                    <div class="col-12">
                        <div class="table-container"
                            data-alignment="<?php echo e($pivotTable->getResourceConfiguration('alignment')); ?>">
                            <div>
                                <?php echo $__env->make('dashboard.pivot-tables.partials._preview', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

</div>


<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>


<script src=" <?php echo e(get_asset('dist/js/jstree.min.js')); ?>"></script>
<script src=" <?php echo e(get_asset('dist/js/nouislider.min.js')); ?>"></script>
<script src="<?php echo e(get_asset('dist/js/pivot-tables/pivot-functions.js')); ?>"></script>

<script src="<?php echo e(get_asset('dist/js/pivot-tables/add.js')); ?>"></script>
<script src="<?php echo e(get_asset('dist/js/pivot-tables/show.js')); ?>"></script>

<script src="<?php echo e(get_asset('dist/js/pivot-tables/database-tree.js')); ?>"></script>

<?php if(getSettingsValue('enable_qr') == '1'): ?>
<script src="<?php echo e(get_asset('dist/js/qrcode.min.js')); ?>"></script>

<script>
    document.querySelectorAll(".qrcode").forEach(element => {
        new QRCode(element, {
            text:"<?php echo e(url()->full()); ?>",
            width:100,
            height:100,
            colorDark : "#000000",
            colorLight : "#ffffff",
            correctLevel : QRCode.CorrectLevel.H

        });

    });

</script>
<?php endif; ?>

<script>
    function exportPivotTableCSV() {

        $.ajax({
            type: 'POST',
            url: "<?php echo e(route('pivot-tables.showExport', $pivotTable->name)); ?>",
            data: (function () {
                let formArray = $("#pivot-table-form").serializeArray();

                // Set operation to export
                let hasOperation = false;
                let hasExportType = false;

                for (let i = 0; i < formArray.length; i++) {
                    if (formArray[i].name === 'operation') {
                        formArray[i].value = 'export';
                        hasOperation = true;
                    }
                    if (formArray[i].name === 'export_type') {
                        formArray[i].value = 'csv';
                        hasExportType = true;
                    }
                }

                if (!hasOperation) {
                    formArray.push({ name: 'operation', value: 'export' });
                }

                if (!hasExportType) {
                    formArray.push({ name: 'export_type', value: 'csv' });
                }

                return $.param(formArray);
            })(),

            beforeSend: function () {
                $("#global-loader").fadeIn();
                $("#global-loader .loader-text").html('Exporting CSV. Please wait...');
            },
            success: function (response) {
                const blob = new Blob([response], { type: 'text/csv;charset=utf-8;' });
                const link = document.createElement('a');
                link.href = URL.createObjectURL(blob);
                link.download = document.getElementById("pivot-table-title").innerText + ".csv";
                link.click();

                $("#global-loader").fadeOut("slow");
                $("#global-loader .loader-text").html('');
            },
            error: function (xhr, status, error) {
                console.error('CSV export failed:', error);
                $("#global-loader").fadeOut();
            }
        });

    }

    $(document).on('click','#export-pivot-table',function(e){
        e.preventDefault();
        exportPivotTableCSV();
    });

    $(document).on('click','#print-pivot-table',function(e){
        e.preventDefault();
        window.print();
    });

</script>



<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/srm_phpv81_or_later/srm/dashboard/resources/views/dashboard/pivot-tables/show.blade.php ENDPATH**/ ?>