<div class="row">
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title"><i class="fas fa-cog"></i> General Settings</h5>
            </div>
            <div class="card-body">
                <div class="form-group">
                    <label for="category" class="form-label">Category</label>
                    <i class="fa fa-question-circle" data-toggle="tooltip"
                        data-title="The category where you want to organize the pivot table. Categories act as folders, helping you classify and manage your resources efficiently on the manage page."
                        style="color: #68b3c8; margin-left: 5px" data-original-title="" title="">
                    </i>
                    <select name="category" id="category" class="form-control">
                        @foreach ($categories as $category)
                        <option value="{{ $category->id }}" @if(isset($pivotTable) && $pivotTable->category_id == $category->id)
                            selected
                            @endif>{{ $category->name }}</option>
                        @endforeach
                    </select>
                </div>

                <div class="form-group">
                    <label for="combine-filters" class="form-label">Combine Filters By</label>
                    <i class="fa fa-question-circle" data-toggle="tooltip"
                        data-title='You can choose to group all filtering conditions using "AND" (default) or "OR", depending on how you want the filters to be applied.'
                        style="color: #68b3c8; margin-left: 5px" data-original-title="" title="">
                    </i>
                    <select name="combine_filters" id="combine-filters" class="form-control">
                        <option value="and" {{ isset($pivotTable) && $pivotTable->getResourceConfiguration('combine_filters') == "and" ? 'selected' : '' }}>And</option>
                        <option value="or" {{ isset($pivotTable) && $pivotTable->getResourceConfiguration('combine_filters') == "or" ? 'selected' : '' }}>Or</option>
                    </select>
                </div>

                <div class="form-group form-check">
                    @php
                        $defaultShowGrandTotals = isset($pivotTable)
                            ? $pivotTable->getResourceConfiguration('show_grand_totals')
                            : true; // Default to checked on create
                    @endphp

                    <input type="hidden" name="show_grand_totals" value="0">

                    <input type="checkbox" class="form-check-input" id="show-grand-totals"
                        name="show_grand_totals" value="1" {{ $defaultShowGrandTotals ? 'checked' :'' }}>

                    <label for="show-grand-totals" class="form-label">Show Grand Totals</label>
                </div>

            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title"><i class="fas fa-lock"></i> Access Settings</h5>
            </div>
            <div class="card-body">
                <div class="form-group">
                    <label for="access-level" class="form-label">Access Level</label>
                    <i class="fa fa-question-circle" data-toggle="tooltip" data-html="true"
                        data-title="Choose who can view the pivot table:
                        <br>• Private: Only users in specific groups can view the pivot table<br>• Public: Anyone with the URL can access it without logging in. Use this if you plan to share or embed it on a public webpage"
                        style="color: #68b3c8; margin-left: 5px" data-original-title="" title="">
                    </i>

                    <select name="access_level" id="access-level" class="form-control">
                        <option value="private" {{ isset($pivotTable) && $pivotTable->getResourceConfiguration('access_level') == "private" ? 'selected' : '' }}>Private</option>
                        <option value="public" {{ isset($pivotTable) && $pivotTable->getResourceConfiguration('access_level') == "public" ? 'selected' : '' }}>Public</option>
                    </select>
                </div>
                <div class="form-group">
                    <label for="groups" class="form-label">Allowed Groups</label>
                    <i class="fa fa-question-circle" data-toggle="tooltip"
                        data-title="Select the user groups that will have access to the pivot table if the private access level is chosen."
                        style="color: #68b3c8; margin-left: 5px" data-original-title="" title="">
                    </i>

                    <select name="groups[]" id="groups" class="form-control" style="height: 125px;" multiple>
                        @foreach ($groups as $group)
                        <option value="{{ $group->group_ID }}" @if(isset($pivotTable) && $pivotTable->
                            resource_permissions->contains('group_ID', $group->group_ID))
                            selected
                            @elseif(!auth()->user()->isAdminOrOwner() && auth()->user()->group_id == $group->group_ID)
                            selected
                            @endif
                            >{{ $group->name }}</option>
                        @endforeach
                    </select>
                </div>
            </div>
        </div>
    </div>
</div>
