@extends('layouts.app')

@section('styles')

<link rel="stylesheet" href="{{ get_asset('dist/css/jstree.min.css'). '?v='. $srmVersion }}" />
<link rel="stylesheet" href="{{ get_asset('dist/css/bootstrap-icons.css'). '?v='. $srmVersion }}" />
<link id="theme-stylesheet" rel="stylesheet" href="">
<link rel="stylesheet" href="{{ get_asset('dist/css/pivot-table.css'). '?v='. $srmVersion }}" />
<link rel="stylesheet" href="{{ get_asset('dist/css/nouislider.min.css'). '?v='. $srmVersion }}" />

<style>
    @media print {
        .card-primary.card-outline {
            border-top: 0px solid #007bff;
        }

        table th,
        table td {
            -webkit-print-color-adjust: exact;
            print-color-adjust: exact;
        }

        table {
            width: 100% !important;
            max-width: 100% !important;
            overflow: visible !important;
        }

        #pivot-table tr {
            display: table-row !important;
        }

        td,
        th {
            white-space: nowrap;
        }

        .table-responsive {
            overflow: visible !important;
        }

        .card {
            width: 100% !important;
            max-width: 100% !important;
            overflow: visible !important;

        }

        .table-container {
            width: 100% !important;
            max-width: 100% !important;
            overflow: visible !important;

        }

        #pagination {
            display: none !important;
        }

        .title-container {
            display: block !important;
            text-align: center;
        }

        .table-preview {
            margin: 0 !important;
            padding: 0 !important;
        }

        #pivot-table .main-header {
            display: table-header-group !important;
        }

    }

    .btn-group-dropdown {

        position: relative;
        display: inline-flex;
        vertical-align: middle;
    }

    .btn-group {
        display: flex;
        align-items: center;
        gap: 10px;
        width: 100%;
    }

    .parameter-label {
        white-space: nowrap;
    }

    .btn-group input[type="date"] {
        flex: 1;
        min-width: 0;
    }

    .card-tabs .card {
        height: 100% !important;

    }

    .table-preview .row>* {
        width: 100%;
    }
</style>
@endsection

@section('content')
@include('dashboard.pivot-tables.partials.info-modal')
@include('dashboard.pivot-tables.partials.confirm-public')
@include('dashboard.pivot-tables.partials.show-hide-modal')
@include('dashboard.pivot-tables.partials.static-filters-modal')

<div id="add-joins-modal-container">
</div>
<div class="content-wrapper" id="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid px-4">
            <div class="row mt-2">
                <div class="col-sm-6">
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('pivot-tables.index') }}">Pivot Tables</a></li>
                        <li class="breadcrumb-item">{{ $pivotTable->name }}</li>

                    </ol>
                </div>
            </div>
            <div class="row mb-2 mt-2">
                <div class="col-sm-3 text-left">
                    <div id="pivot-table-name-container" style="display: inline">
                        <h2 class="mr-3 user-select-none pivot-table-name" style="display: inline">{{ $pivotTable->name
                            }}</h2>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="save-errors alert bootstrap-alert-danger mx-4 mb-3" style="display: none;" title="">
                    </div>
                    <div class="save-success alert bootstrap-alert-success mx-4 mb-3" style="display: none;" title="">
                    </div>

                </div>
                <div class="col-sm-3 text-right">
                    <button id="save-btn" class="btn btn-success px-5 mr-2 rounded-0">
                        Save
                    </button>
                    <a href="{{ route('pivot-tables.index') }}" class="btn btn-white btn-outline-dark px-5 rounded-0">
                        Cancel
                    </a>
                </div>
            </div>

        </div>
    </section>

    <div class="container-fluid mt-2 px-4">
        @if(session()->has('success'))
        <div class="alert alert-success">
            {!! session()->get('success') !!}
        </div>
        @endif

        @if(session()->has('failed'))
        <div class="alert alert-danger">
            {{ session()->get('failed') }}
        </div>
        @endif
        <div class="tabs-container">
            <form data-apply="{{ route('pivot-tables.apply') }}"
                data-update="{{ route('pivot-tables.update') }}/{{ $pivotTable->id }}" method="POST"
                id="pivot-table-form" data-status="update">
                @csrf
                <input type="text" name="pivot_table_name" id="pivot-table-name-textbox" class="d-none"
                    value="Pivot_Table1">

                <div class="row no-print">
                    <div class="col-12 col-md-3">

                        <div class="card card-primary card-outline p-3">
                            <select name="connection" id="connection" class="form-control" {{ checkDemo()
                                ? "data-demo=true" :''}}>
                                <option value="default"
                                    data-url="{{ route('data_connections.getConnectionTree', 'default') }}">Default
                                    Connection</option>

                                @foreach ($connections as $connection)
                                <option value="{{ $connection->id }}" {{ $pivotTable->data_connection_id ==
                                    $connection->id ? "selected" :"" }}
                                    data-url="{{ route('data_connections.getConnectionTree', $connection->id) }}">{{
                                    $connection->connection_name }}</option>
                                @endforeach
                                <option value="add-new-connection"
                                    data-url="{{ route('quick-add',['add'=> 'data-connections']) }}">
                                    + Add New Connection</option>
                            </select>
                            @include('dashboard.pivot-tables.partials._tree')
                        </div>
                    </div>
                    <div class="col-md-9">
                        <div class="card card-primary card-outline card-tabs">
                            <div class="card-header p-0 pt-1 border-bottom-0">
                                <ul class="nav nav-tabs" id="custom-tabs-three-tab" role="tablist">
                                    <li class="nav-item">
                                        <a class="nav-link active" id="fields-tab" data-toggle="pill" href="#fields"
                                            role="tab" aria-controls="fields" aria-selected="false">Fields</a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link" id="options-tab" data-toggle="pill" href="#options"
                                            role="tab" aria-controls="options" aria-selected="true">Options</a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link" id="appearance-tab" data-toggle="pill" href="#appearance"
                                            role="tab" aria-controls="appearance" aria-selected="false">Appearance &
                                            Titles</a>
                                    </li>
                                </ul>
                            </div>
                            <div class="card-body" style="height: 494px;overflow: auto;">
                                <div class="tab-content" id="custom-tabs-three-tabContent">
                                    <div class="tab-pane fade active show" id="fields" role="tabpanel"
                                        aria-labelledby="fields-tab">
                                        @include('dashboard.pivot-tables.partials._fields')
                                    </div>
                                    <div class="tab-pane fade" id="options" role="tabpanel"
                                        aria-labelledby="options-tab">
                                        @include('dashboard.pivot-tables.partials._options')
                                    </div>
                                    <div class="tab-pane fade" id="appearance" role="tabpanel"
                                        aria-labelledby="appearance-tab">
                                        @include('dashboard.pivot-tables.partials._appearance')

                                    </div>
                                </div>
                                <div class="text-center mt-3">
                                    <div class="d-inline mr-2">
                                        <button class="btn btn-primary px-5 rounded-0" id="apply-button">Apply</button>
                                    </div>
                                    <div class="d-inline">
                                        <button class="btn btn-secondary px-5 rounded-0"
                                            id="clear-button">Clear</button>
                                    </div>

                                </div>

                            </div>
                        </div>

                    </div>
                </div>
                <div class="row">
                    <div class="col-12">
                        <div class="card card-primary card-outline"
                            style="min-height: 400px;max-height: 800px;overflow: auto;">
                            <div class="card-body">
                                @include('dashboard.pivot-tables.partials._preview')
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

</div>


@endsection



@section('scripts')


<script src=" {{ get_asset('dist/js/jstree.min.js') }}"></script>
<script src=" {{ get_asset('dist/js/nouislider.min.js') }}"></script>

<script src="{{ get_asset('dist/js/pivot-tables/pivot-functions.js') }}"></script>
<script src="{{ get_asset('dist/js/pivot-tables/database-tree.js') }}"></script>

<script src="{{ get_asset('dist/js/pivot-tables/edit.js') }}"></script>


<script>
    function exportPivotTableCSV() {

        $.ajax({
            type: 'POST',
            url: "{{ route('pivot-tables.createExport') }}",
            data: (function () {
                let formArray = $("#pivot-table-form").serializeArray();

                // Set operation to export
                let hasOperation = false;
                let hasExportType = false;

                for (let i = 0; i < formArray.length; i++) {
                    if (formArray[i].name === 'operation') {
                        formArray[i].value = 'export';
                        hasOperation = true;
                    }
                    if (formArray[i].name === 'export_type') {
                        formArray[i].value = 'csv';
                        hasExportType = true;
                    }
                }

                if (!hasOperation) {
                    formArray.push({ name: 'operation', value: 'export' });
                }

                if (!hasExportType) {
                    formArray.push({ name: 'export_type', value: 'csv' });
                }

                return $.param(formArray);
            })(),

            beforeSend: function () {
                $("#global-loader").fadeIn();
                $("#global-loader .loader-text").html('Exporting CSV. Please wait...');
            },
            success: function (response) {
                const blob = new Blob([response], { type: 'text/csv;charset=utf-8;' });
                const link = document.createElement('a');
                link.href = URL.createObjectURL(blob);
                link.download = document.getElementById("pivot-title").innerText + ".csv";
                link.click();

                $("#global-loader").fadeOut("slow");
                $("#global-loader .loader-text").html('');
            },
            error: function (xhr, status, error) {
                console.error('CSV export failed:', error);
                $("#global-loader").fadeOut();
            }
        });

    }

    $(document).on('click','#export-pivot-table',function(e){
        e.preventDefault();
        exportPivotTableCSV();
    });

    $(document).on('click','#print-pivot-table',function(e){
        e.preventDefault();
        window.print();
    });

</script>



@endsection