<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    @if(!is_null(request()->query('expires')))
    <script>
        document.addEventListener("DOMContentLoaded", function () {

        if (window.top === window.self) {

            document.open();
            document.write(

            '<!doctype html><html><head><meta charset="utf-8"><title>403 Forbidden</title>' +

            '<meta name="viewport" content="width=device-width, initial-scale=1">' +

            '<style>body{font-family:system-ui,-apple-system,Segoe UI,Roboto,sans-serif;margin:0;padding:2rem;color:#222}' +

            'h1{margin:.2rem 0 .6rem;font-size:1.5rem}p{margin:0;line-height:1.5}</style></head>' +

            '<body><h1>403 Forbidden</h1><p>Direct access is denied!</p></body></html>'

            );

            document.close();

            throw new Error();
        } else {

            // if allowed, reveal content immediately

            document.addEventListener("DOMContentLoaded", function () {

            var el = document.getElementById('content');

            if (el) el.style.display = 'block';

            });

        }

    });
    </script>
    @endif
    
    <link rel="stylesheet" href="{{ get_asset('dist/css/c3.min.css'). '?v='. $srmVersion }}" />
    <link rel="stylesheet" href="{{ get_asset('dist/css/all.min.css'). '?v='. $srmVersion}}">
    <link rel="stylesheet" href="{{ get_asset('dist/css/adminlte.min.css'). '?v='. $srmVersion}}">
    <link rel="stylesheet" href="{{ get_asset('dist/css/style.css'). '?v='. $srmVersion}}" />
    <style>
        .content-wrapper {
            background-color: white;
        }

        .content-wrapper>* {
            font-family: 'poppins', 'arial';
        }

        .card-tools-custom {
            float: right;
            margin-right: 0.15rem;
            margin-top: 0.5rem;
        }

        .card-tools-right {
            /* float: right; */
            text-align: right
        }


        .icon-custom {
            right: 2rem !important;
            top: 2rem !important;
        }

        .bg-purple {
            background-color: purple !important;
        }
    </style>

</head>

<body>
    <div class="container-fluid">

        <div class="clearfix"></div>
        @if(!is_null($metric))
        @if($metric->configurations->chart_type == "gauge_chart")
        <div class="col-lg-3 col-6">
            <div class="small-box bg-white">
                <h6 class="float-left pt-2 pl-2" style="font-size:0.8rem">{{ $metric->name }}</h6>
                <div class="clearfix"></div>
                <div class="inner" style="padding: 0">
                    <div id="{{ Str::of($metric->name)->kebab() }}"></div>
                </div>
                @if($metric->getResourceConfiguration('drill_down'))
                    <a href="{{ resourceInternalSignedUrl('metrics.drill',['metric' => $metric->name], is_null(request()->query('expires')))  }}"
                        class="small-box-footer">
                        More info <i class="fas fa-arrow-circle-right"></i>
                    </a>
                @endif

            </div>
        </div>
        @else
        <div class="col-lg-3 col-6">

            <div class="small-box {{ $metric->getMetricBgColor() }}">
                <div class="inner">
                    @if($metric->getResourceConfiguration('compare_with') != "no_comparison")
                    <span style="margin-left: 1rem;font-size:small">
                        @if(!in_array($metric->getResourceConfiguration('display_format'),['percentage','percentage_of_total']))
                        {{ $metric->data['change'] }}
                        @endif
                        (
                        @if(!is_numeric($metric->data['trend']))
                        {{$metric->data['trend'] }}%
                        @elseif($metric->data['trend_direction'] == "positive")
                        ↑{{$metric->data['trend'] }}%
                        @elseif($metric->data['trend_direction'] == "negative")
                        ↓{{$metric->data['trend'] }}%
                        @endif
                        )</span>
                    @endif
                    <h3 @if($metric->getResourceConfiguration('compare_with') == "no_comparison")
                        class="mt-4" @endif>{{ $metric->data['original_metric'] }}</h3>
                    <p>{{ $metric->name }}</p>

                </div>
                @if($metric->configurations->chart_type == "info_box_with_icon")
                <div class="icon">
                    {{-- <i class="fas {{ $metric->info_box_icon }} icon-custom"></i> --}}
                    <i class="icon-custom fas" style="font-family: 'FontAwesome'">{!!
                        $metric->getResourceIcon() !!}</i>
                </div>
                @endif

                @if($metric->getResourceConfiguration('drill_down'))
                    <a href="{{ resourceInternalSignedUrl('metrics.drill',['metric' => $metric->name], is_null(request()->query('expires')))  }}" class="small-box-footer">
                        More info <i class="fas fa-arrow-circle-right"></i>
                    </a>
                @endif

            </div>
        </div>
        @endif


        @endif



    </div>
    <script src="{{ get_asset('dist/js/jquery.min.js') . '?v='. $srmVersion }}"></script>
    <script src="{{ get_asset('dist/js/moment.min.js') . '?v='. $srmVersion }}"></script>
    <script src="{{ get_asset('dist/js/d3.v5.min.js') . '?v='. $srmVersion }}"></script>
    <script src="{{ get_asset('dist/js/c3.min.js') . '?v='. $srmVersion }}"></script>
    <script src="{{ get_asset('dist/js/metrics.js') . '?v='. $srmVersion }}"></script>
    <script>
        {!! $metric->script !!}
    </script>

</body>
</htm>
