@extends('layouts.app')

@section('styles')

<link rel="stylesheet" href="{{ get_asset('dist/css/c3.min.css'). '?v='. $srmVersion }}" />

<link rel="stylesheet" href="{{ get_asset('dist/css/metrics.css'). '?v='. $srmVersion }}">

@endsection


@section('content')
<script src="{{ get_asset('dist/js/d3.v5.min.js'). '?v='. $srmVersion}}"></script>
<script src="{{ get_asset('dist/js/c3.min.js'). '?v='. $srmVersion}}"></script>
<div class="content-wrapper" style="">
    @include('dashboard.metrics.partials._metric-confirmation-modal',[
    'id' => 'delete-metric',
    'modal_title' =>'Delete Confirmation',
    'method'=> 'DELETE'
    ])

    <div id="change-category-modal-container">
    </div>

    @if((isset($metricModule) && $metricModule->checkWhoCanAccessModule()) || auth()->user()->isAdminOrOwner())
    @include('dashboard.metrics.iframe.create')
    @endif
    @include('dashboard.metrics.iframe.edit')
    @include('dashboard.metrics.partials.success-modal')
    @include('dashboard.metrics.duplicate')

    <!-- Content Header (Page header) -->
    <section class="content-header mx-3">
        <div class="container-fluid">
            <div class="row mb-2 mt-3">
                <div class="col-sm-6">
                    <h3> <i class="fas fa-chart-line fa-fw"></i>
                        Metrics</h3>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                        <li class="breadcrumb-item active">Metrics</li>
                    </ol>
                </div>
            </div>
        </div>
        <!-- /.container-fluid -->
        <div class="container-fluid metric-parent-container">

            <div>
                <form action="{{ route('metrics.index') }}" method="GET" id="metric-search-form">
                    <div class="bg-white py-3">

                        <div class="row bg-white mx-3 row-no-padding-left">
                            <div class="col">
                                <label class="sr-only">Title</label>
                                <div class="input-group input-box">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text rounded-small">Title</div>
                                    </div>
                                    <input type="text" class="form-control rounded-small" id="metric-title"
                                        placeholder="Search" name="metricTitle" value="{{ request()->metricTitle }}">
                                    <i class="fa fa-search"></i>

                                </div>
                            </div>
                            <div class="col">
                                <label class="sr-only">Metric</label>
                                <div class="input-group input-box">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text rounded-small">Metric</div>
                                    </div>
                                    <select type="text" class="form-control rounded-small" id="metric-category"
                                        placeholder="search" name="metricCategory">
                                        <option value="">Please Choose Metric Category</option>
                                        @foreach ($categories as $category)
                                        <option value="{{ $category->id }}" {{ request()->metricCategory ==
                                            $category->id ? 'selected' : ''}} >{{
                                            $category->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="text-center mt-3">
                        <button class="btn btn-primary px-3 py-2 my-2 my-sm-0 srm-button" id="metric-search"
                            type="submit">
                            <i class="fas fa-search"></i> Search
                        </button>

                        <button class="btn btn-outline-primary px-3 py-2 my-sm-0 srm-button show-all" type="button">
                            <i class="fa-solid fa-eye"></i> Show All
                        </button>
                    </div>

                </form>
            </div>
            <div class="mt-4">
                @if((isset($metricModule) && $metricModule->checkWhoCanAccessModule()) ||
                auth()->user()->isAdminOrOwner())

                <button class="btn btn-primary px-3 py-2 float-right srm-button" type="button" id="add-metric-button"
                    data-url="{{ route('metrics.wizard.appearance.show') }}"
                    data-forget="{{ route('charts.forgetSession') }}">
                    <i class="fas fa-plus"></i> Add New Metric
                </button>
                @endif
            </div>
            <div class="clearfix"></div>
            <div class="metric-container" style="min-height: 40vh">
                <div class="metrics mt-4">
                    @if(!empty($metrics[0]))

                    <div class="loader" style="display: none">
                        <img src="{{get_asset('dist/images/loader.gif')}}" class="loader-img" alt="Loader">
                    </div>

                    <div class="row">
                        @foreach($metrics as $metric)

                        @if(!is_null($metric))

                        @if($metric->configurations->chart_type == "gauge_chart")
                        <div class="col-md-3 col-12">

                            <div class="small-box bg-white">
                                <h6 class="float-left pt-2 pl-2 mb-0" style="font-size:0.8rem">{{
                                    $metric->getResourceConfiguration('title') }}</h6>
                                @if(!array_key_exists('error',$metric->data))
                                <div class="card-tools-right pt-2 float-right">
                                    @if(
                                    (
                                    isset($metric->creator) &&
                                    $metric->creator->user_ID == auth()->user()->user_ID
                                    )
                                    ||
                                    auth()->user()->isAdminOrOwner())

                                    <div class="dropdown">
                                        <button type="button" id="ellipsisMenu2" data-toggle="dropdown"
                                            aria-haspopup="true" aria-expanded="false"
                                            style="border:none;background:none;padding: 0 10px;">
                                            <!-- Your SVG icon -->
                                            <svg xmlns=" http://www.w3.org/2000/svg" width="16" height="16"
                                                fill="currentColor" class="bi bi-three-dots-vertical"
                                                viewBox="0 0 16 16">
                                                <path
                                                    d="M9.5 13a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0z">
                                                </path>
                                            </svg>
                                        </button>
                                        <div class="dropdown-menu dropdown-menu-right" aria-labelledby="ellipsisMenu">
                                            @if(auth()->user()->isAdminOrOwner())
                                                <a class="dropdown-item duplicate-metric"
                                                    data-url="{{ route('metrics.duplicate',$metric->name) }}"
                                                    data-name="{{ $metric->name }}"
                                                    >Duplicate</a>
                                            @endif

                                            @if(
                                            (
                                            isset($metric->creator) &&
                                            $metric->creator->user_ID == auth()->user()->user_ID
                                            )
                                            ||
                                            auth()->user()->isAdminOrOwner())
                                            <a class="dropdown-item edit-metric"
                                                data-url="{{ route('metrics.wizard.appearance.edit',$metric->name) }}">Edit</a>

                                            <a class="dropdown-item change-category"
                                                data-url="{{ route('metrics.getCategories',$metric->name) }}">Change
                                                category</a>

                                            <a class="dropdown-item delete-metric" data-toggle="modal"
                                                data-target="#delete-metric-modal"
                                                data-url="{{ route('metrics.destroy',$metric->name) }}">Delete</a>
                                            @endif
                                        </div>
                                    </div>
                                    @endif
                                </div>
                                @endif
                                <div class="clearfix"></div>
                                <div class="inner" style="padding: 0">
                                    @if(!array_key_exists('error',$metric->data))
                                    <div id="{{ Str::of($metric->name)->kebab() }}"></div>

                                    @else
                                    <div class="text-center text-danger pt-4" style="height: 110px"
                                    data-toggle="tooltip" data-placement="top" data-title="{{$metric->data['error']}}">{{
                                        \Illuminate\Support\Str::limit($metric->data['error'], 80)}}</div>
                                    @endif
                                </div>
                                <script>
                                    {!! $metric->script !!}
                                </script>

                                @if(!array_key_exists('error',$metric->data))

                                @if($metric->getResourceConfiguration('drill_down'))
                                <a href="{{ route('metrics.drill',$metric->name) }}" class="small-box-footer">
                                    More info <i class="fas fa-arrow-circle-right"></i>
                                </a>
                                @endif
                                @else
                                <div style="height: 30px;background-color:rgba(0, 0, 0, .1)">
                                </div>
                                @endif
                            </div>


                        </div>
                        @else
                        <div class="col-md-3 col-12">

                            <div class="small-box {{ $metric->getMetricBgColor() }}">
                                @if(!array_key_exists('error',$metric->data))

                                <div class="card-tools-custom">
                                    @if(
                                    $metric->creator->user_ID == auth()->user()->user_ID
                                    ||
                                    auth()->user()->isAdminOrOwner()
                                    )

                                    <div class="dropdown">
                                        <button type="button" id="ellipsisMenu2" data-toggle="dropdown"
                                            aria-haspopup="true" aria-expanded="false" style="border:none;background:none;
                                            @if($metric->metric_color != 'white' ) {{ 'color:white' }} @endif">
                                            <!-- Your SVG icon -->
                                            <svg xmlns=" http://www.w3.org/2000/svg" width="16" height="16"
                                                fill="currentColor" class="bi bi-three-dots-vertical"
                                                viewBox="0 0 16 16">
                                                <path
                                                    d="M9.5 13a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0z">
                                                </path>
                                            </svg>
                                        </button>
                                        <div class="dropdown-menu dropdown-menu-right" aria-labelledby="ellipsisMenu">
                                            @if(auth()->user()->isAdminOrOwner())
                                                <a class="dropdown-item duplicate-metric"
                                                    data-url="{{ route('metrics.duplicate',$metric->name) }}"
                                                    data-name="{{ $metric->name }}"

                                                    >Duplicate</a>
                                            @endif

                                            @if(
                                            $metric->creator->user_ID == auth()->user()->user_ID
                                            ||
                                            auth()->user()->isAdminOrOwner())
                                            <a class="dropdown-item edit-metric"
                                                data-url="{{ route('metrics.wizard.appearance.edit',$metric->name) }}">Edit</a>

                                            <a class="dropdown-item change-category"
                                                data-url="{{ route('metrics.getCategories',$metric->name) }}">Change
                                                category</a>

                                            <a class="dropdown-item delete-metric" data-toggle="modal"
                                                data-target="#delete-metric-modal"
                                                data-url="{{ route('metrics.destroy',$metric->name) }}">Delete</a>
                                            @endif
                                        </div>
                                    </div>
                                    @endif
                                </div>
                                @endif
                                <div class="inner">
                                    @if(!array_key_exists('error',$metric->data))

                                    @if($metric->getResourceConfiguration('compare_with') != "no_comparison")
                                    <span data-toggle="custom-tooltip" data-html="true" data-placement="bottom"
                                        title="{{ $metric->data['tooltip'] }}"
                                        style="margin-left: 1rem;font-size:small">
                                        @if(!in_array($metric->getResourceConfiguration('display_format'),['percentage','percentage_of_total']))
                                        {{ $metric->data['change'] }}
                                        @endif
                                        (
                                        @if(!is_numeric($metric->data['trend']))
                                        {{$metric->data['trend'] }}%
                                        @elseif($metric->data['trend_direction'] == "positive")
                                        ↑{{$metric->data['trend'] }}%
                                        @elseif($metric->data['trend_direction'] == "negative")
                                        ↓{{$metric->data['trend'] }}%
                                        @endif
                                        )</span>
                                    <br>
                                    <span @if($metric->getResourceConfiguration('compare_with') == "no_comparison")
                                        class="mt-4" @endif data-toggle="custom-tooltip" data-html="true"
                                        data-placement="bottom" style="font-size:2rem;font-weight:bold"
                                        title="{{ $metric->data['tooltip'] }}">{{ $metric->data['original_metric'] }}
                                    </span>
                                    <p>{{ $metric->getResourceConfiguration('title') }}</p>

                                    @else
                                    <h3 @if($metric->getResourceConfiguration('compare_with') == "no_comparison")
                                        class="mt-4" @endif>{{ $metric->data['original_metric'] }}</h3>
                                    <p>{{ $metric->getResourceConfiguration('title') }}</p>
                                    @endif
                                    @else
                                    <p>{{ $metric->getResourceConfiguration('title') }}</p>
                                    <div class="text-center text-danger" style="height: 75px" 
                                    data-toggle="tooltip" data-placement="top" data-title="{{$metric->data['error']}}">{{
                                        \Illuminate\Support\Str::limit($metric->data['error'], 80)}}</div>
                                    @endif
                                </div>
                                @if($metric->configurations->chart_type == "info_box_with_icon")
                                <div class="icon">
                                    {{-- <i class="fas {{ $metric->info_box_icon }} icon-custom"></i> --}}
                                    <i class="icon-custom fas" style="font-family: 'FontAwesome'">{!!
                                        $metric->getResourceIcon() !!}</i>
                                </div>
                                @endif
                                @if(!array_key_exists('error',$metric->data))
                                @if($metric->getResourceConfiguration('drill_down'))
                                <a href="{{ route('metrics.drill',$metric->name) }}" class="small-box-footer">
                                    More info <i class="fas fa-arrow-circle-right"></i>
                                </a>
                                @endif
                                @else
                                <div style="height: 30px;background-color:rgba(0, 0, 0, .1)">
                                </div>

                                @endif
                            </div>
                        </div>
                        @endif

                        @endif
                        @endforeach
                    </div>
                    @else
                    @if($search)
                    <div class="text-center message">
                        <h6>No records matches your search criteria.</h6>
                    </div>
                    @else
                    <div class="text-center message">
                        <h6>No metric to preview.</h6>
                    </div>
                    @endif
                    @endif

                </div>

            </div>
            @if($metrics->lastPage() > 1)
            <div class="float-right">
                {{ $metrics->appends(request()->query())->links() }}
            </div>
            <div class="clearfix"></div>
            @endif

    </section>

</div>
@endsection


@section('scripts')
<script src="{{ get_asset('dist/js/metrics.js') . '?v='. $srmVersion }}"></script>

@if(session('add'))

<script>
    window.onload= function(){
        $('#add-metric-button').click();
    }

</script>

@endif


@endsection
