@extends('layouts.public')

@section('styles')
<style>
    .content-wrapper>* {
        font-family: 'poppins', 'arial';
    }
    .content-wrapper{
        background-color: white !important
    }
</style>

@endsection

@section('content')
@include('dashboard.charts.partials.success-modal')

<section class="content-header">
    <div class="container-fluid px-4">
        <div class="row mb-2 mt-2">
            <div class="col-sm-8">
                <h2 style="font-weight: bold">{{ ucwords($chart->getResourceConfiguration('title')) }}
                </h2>
                <h6>{{ \Carbon\Carbon::now()->format('d M Y h:i A') }}</h6>
            </div>
            <div class="col-sm-4 text-right">
                <div class="p-2 branding-logo">
                    @include('partials._logo')
                </div>
            </div>
        </div>
        <hr style="border-top: 1px solid rgba(0, 0, 0, .5);">
    </div>
    <div class="container-fluid mt-4 px-4">
        <div class="row">
            <div class="col-6">
                @if(is_array($label))
                <h6 class="py-3" style="font-weight:bold">{{
                    ucwords($chart->getResourceConfiguration('x_axis_column')) }}
                    : <span class="text-primary " style="font-weight:normal">{{ $label[0]
                        }}</span> to
                    <span class="text-primary" style="font-weight:normal">{{
                        $label[1] }}</span>
                </h6>
                @else
                <h6 class="py-3" style="font-weight:bold">{{
                    ucwords($chart->getResourceConfiguration('x_axis_column')) }}
                    : <span class="text-primary" style="font-weight:normal">{{ ucwords($xValue) }}</span>
                </h6>
                @endif
            </div>

            <div class="col-6">
                <div class="buttons text-right mb-4">
                    <a href="{{ resourceInternalSignedUrl('charts.drill.print',['chart' => $chart->name], is_null(request()->query('expires'))).'&xValue=' . $xValue .'&page=' . $data->currentPage() }}"

                        
                        id="print-chart" class="btn btn-light py-3 px-4 btn-xl shadow-sm mx-4"
                        style="display: inline-block">
                        <i class="fa-solid fa-print"></i> Print
                    </a>
                    <a href="{{ resourceInternalSignedUrl('charts.drill.export',['chart' => $chart->name], is_null(request()->query('expires'))).'&xValue=' . $xValue .'&page=' . $data->currentPage()}}"
                        id="export-chart" class="btn btn-light py-3 px-3 shadow-sm" style="display: inline-block">
                        <i class="fa-solid fa-file-export"></i> Export
                    </a>
                </div>
            </div>

        </div>
        <div class="clearfix"></div>

        <div class="table table-bordered table-striped" style="overflow-x: auto;word-break:keep-all;">
            <table id="reports" style="width: 100%">
                <thead>
                    <tr style="background-color: #d6d8da">
                        @foreach($keys as $key)
                        <th>{{ ucwords($key) }}</th>
                        @endforeach
                    </tr>
                </thead>
                <tbody>
                    @if($data->total() > 0)
                    @foreach($data as $row)
                    <tr class="smaller-font">
                        @foreach($row as $item)

                        <td>{{ $item }}</td>
                        @endforeach
                    </tr>
                    @endforeach
                    @else
                    <tr style="background-color:transparent">
                        <td style="text-align: center" colspan="{{ count($keys) }}">
                            <h6>Sorry, There is no data</h6>
                        </td>
                    </tr>
                    @endif
                </tbody>
            </table>
        </div>
        <div class="float-right">
            {{ $data->appends(request()->query())->links() }}
        </div>
        <div class="clearfix"></div>


    </div>




    @endsection


    @section('scripts')
    @php
        $gdEnabled = extension_loaded('gd');
    @endphp
    <script>
        $(document).on('click','#export-chart',function(e){
            e.preventDefault();
            let gdEnabled = @json($gdEnabled);

            if (!gdEnabled) {
                $(`#success-modal`).find('h5').html(`
                    <div class="text-left">
                        <strong>⚠️ GD extension is not enabled on your server.</strong>
                        <br><br>
                        <strong>To enable it:</strong>
                        <ul>
                            <li>Open your <code>php.ini</code> file.</li>
                            <li>Find this line: <code>;extension=gd</code></li>
                            <li>Remove the semicolon (uncomment it): <code>extension=gd</code></li>
                            <li>Restart your web server (Apache, Nginx, etc).</li>
                        </ul>
                        <p><strong>Note:</strong> In some PHP versions, the extension name may be <code>gd2</code> instead of <code>gd</code>.</p>
                    </div>
                `).show();
                $(`#success-modal`).modal('show');
            }else{

                $("#global-loader").fadeIn();
                $("#global-loader .loader-text").html('Please wait, this may take a few minutes.');

                $.ajax({
                    type: 'GET',
                    url: $("#export-chart").attr('href'),
                    xhrFields:{
                        responseType: 'blob'
                    },
                    beforeSend:function(){
                        $("#global-loader").fadeIn();
                        $("#global-loader .loader-text").html('Please wait, this may take a few minutes.');

                    },
                    success: function(response) {
                        var blob = new Blob([response]);
                        var link = document.createElement('a');
                        link.href = URL.createObjectURL(blob);
                        link.download = "{{ ucwords($chart->getResourceConfiguration('title')) }}-{{ $formatedXValue }}-page {{ $data->currentPage() }}.pdf";
                        link.click();

                        $("#global-loader").fadeOut("slow");
                        $("#global-loader .loader-text").html('');

                    },
                    error: function(xhr, status, error) {
                        $("#global-loader").fadeOut("slow");
                        $("#global-loader .loader-text").html('');
                    }
                });
            }
        });

    $(document).on('click','#print-chart',function(e){
        e.preventDefault();

        let gdEnabled = @json($gdEnabled);

        if (!gdEnabled) {
            $(`#success-modal`).find('h5').html(`
                <div class="text-left">
                    <strong>⚠️ GD extension is not enabled on your server.</strong>
                    <br><br>
                    <strong>To enable it:</strong>
                    <ul>
                        <li>Open your <code>php.ini</code> file.</li>
                        <li>Find this line: <code>;extension=gd</code></li>
                        <li>Remove the semicolon (uncomment it): <code>extension=gd</code></li>
                        <li>Restart your web server (Apache, Nginx, etc).</li>
                    </ul>
                    <p><strong>Note:</strong> In some PHP versions, the extension name may be <code>gd2</code> instead of <code>gd</code>.</p>
                </div>
            `).show();
            $(`#success-modal`).modal('show');
        }else{
            $("#global-loader").fadeIn();
            $("#global-loader .loader-text").html('Please wait, this may take a few minutes.');

            window.location.href = $("#print-chart").attr('href')
        }
    });

    </script>

    @endsection
