@extends('layouts.app')
@section('styles')
<!-- DataTables -->
<link rel="stylesheet"
    href="{{ get_asset('dist/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css'). '?v='. $srmVersion}}">
<link rel=" stylesheet"
    href="{{ get_asset('dist/plugins/datatables-responsive/css/responsive.bootstrap4.min.css'). '?v='. $srmVersion}}">
<link rel=" stylesheet"
    href="{{ get_asset('dist/plugins/datatables-buttons/css/buttons.bootstrap4.min.css'). '?v='. $srmVersion}}">

@endsection

@section('content')

<div id="edit-barcode-modal-container">

</div>
@include('dashboard.barcodes.partials._barcode-confirmation-modal',[
'id' => 'delete-barcode',
'modal_title' => 'Delete Confirmation',
'method'=> 'DELETE'
])


@include('dashboard.barcodes.partials._barcode-add-modal',[
'id' => 'add-barcode',
])
@include('dashboard.barcodes.partials.success-modal')
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header mx-3">
        <div class="container-fluid">
            <div class="row mb-2 mt-3">
                <div class="col-sm-6">
                    <h3> <i class="fa-solid fa-barcode fa-fw"></i>
                        Barcode Definitions</h3>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                        <li class="breadcrumb-item active">Barcode Definitions</li>
                    </ol>
                </div>
            </div>
        </div>
        <!-- /.container-fluid -->

        <div class="row ml-5">
            <label for="search-barcodes" class="mr-3 mt-2 h5">Barcode Label</label>
            <div class="form-group col-md-9">

                <input id="search-barcodes" class="form-control w-100" type="text" placeholder="Search"
                    aria-label="Search" style="height: 50px;">
                @include('dashboard.users.partials._session')

            </div>


        </div>
        <div class="form-group text-center mt-3">
            <button class="btn btn-primary px-3 py-2 my-2 my-sm-0 srm-button search-filter" type="submit"><i
                    class="fas fa-search"></i> Search</button>
            <button class="btn btn-outline-primary px-3 py-2 my-2 ml-2 my-sm-0 srm-button reset-filter" type="button"><i
                    class="fa-solid fa-eye"></i> Show All</button>
        </div>

        <button class="btn btn-primary add-barcode-button px-3 py-2 mb-3 float-right srm-button " type="button"
            data-toggle="modal" data-target="#add-barcode-modal">
            <i class="fas fa-plus"></i> Add New Barcode Definition
        </button>


        <div class="clearfix card-body mt-3">
            <table id="barcodes" class="table table-bordered table-hover">
                <thead>
                    <tr>
                        <th>Label</th>
                        <th>Barcode Type</th>
                        <th>Example Barcode</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($barcodes as $barcode)

                    <tr>
                        <td style="vertical-align: middle">
                            {{ $barcode->label }}
                        </td>
                        <td style="vertical-align: middle">{{ getBarCodeLabel($barcode->type) }}</td>
                        <td style="width: 300px">
                            <div class="barcode text-center"
                                jsbarcode-format="{{ $barcode->type }}" jsbarcode-barwidth="{{ $barcode->width }}"
                                jsbarcode-barheight="{{ $barcode->height }}"
                                jsbarcode-value="{{ getBarCodeExample($barcode->type) }}"
                                jsbarcode-textalign="{{ $barcode->text_align }}"
                                jsbarcode-displayvalue="{{ $barcode->display_value }}"
                                jsbarcode-fontsize="{{$barcode->font_size}}" jsbarcode-textmargin="0"
                                jsbarcode-fontoptions="bold">
                            </div>
                        </td>
                        <td>
                            <div class="dropdown">
                                <button type="button" id="ellipsisMenu1" data-toggle="dropdown" aria-haspopup="true"
                                    aria-expanded="false" style="border:none;background:none">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor"
                                        class="bi bi-three-dots-vertical" viewBox="0 0 16 16">
                                        <path
                                            d="M9.5 13a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0z" />
                                    </svg>
                                </button>
                                <div class="dropdown-menu" aria-labelledby="ellipsisMenu">
                                    <a class="dropdown-item edit-barcode"
                                        data-url="{{ route('barcode_definitions.edit',$barcode->id) }}">Edit</a>
                                    <a class="dropdown-item delete-barcode" data-toggle="modal"
                                        data-target="#delete-barcode-modal"
                                        data-url="{{ route('barcode_definitions.destroy',$barcode->id) }}">Delete</a>
                                </div>
                            </div>
                        </td>
                    </tr>
                    @endforeach

                </tbody>
            </table>
        </div>

    </section>

</div>
@endsection
@section('scripts')
<script src="{{ get_asset('dist/plugins/datatables/jquery.dataTables.min.js'). '?v='. $srmVersion}}"></script>
<script src="{{ get_asset('dist/plugins/datatables-responsive/js/dataTables.responsive.min.js'). '?v='. $srmVersion}}">
</script>
<script src="{{ get_asset('dist/plugins/datatables-responsive/js/responsive.bootstrap4.min.js'). '?v='. $srmVersion}}">
</script>
<script src="{{ get_asset('dist/plugins/datatables-buttons/js/dataTables.buttons.min.js'). '?v='. $srmVersion}}">
</script>
<script src="{{ get_asset('dist/plugins/datatables-buttons/js/buttons.bootstrap4.min.js'). '?v='. $srmVersion}}">
</script>
<script src="{{ get_asset('dist/plugins/jszip/jszip.min.js'). '?v='. $srmVersion}}"></script>
<script src="{{ get_asset('dist/plugins/pdfmake/pdfmake.min.js'). '?v='. $srmVersion}}"></script>
<script src="{{ get_asset('dist/plugins/pdfmake/vfs_fonts.js'). '?v='. $srmVersion}}"></script>
<script src="{{ get_asset('dist/plugins/datatables-buttons/js/buttons.html5.min.js'). '?v='. $srmVersion}}"></script>
<script src="{{ get_asset('dist/plugins/datatables-buttons/js/buttons.print.min.js'). '?v='. $srmVersion}}"></script>
<script src="{{ get_asset('dist/plugins/datatables-buttons/js/buttons.colVis.min.js'). '?v='. $srmVersion}}"></script>
<script src="{{ get_asset('dist/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js'). '?v='. $srmVersion}}">
</script>
<script src="{{ get_asset('dist/js/JsBarcode.min.js'). '?v='. $srmVersion}}" defer></script>
<script src="{{ get_asset('dist/js/custom-datatables.js'). '?v='. $srmVersion}}" defer></script>

<script>
    displayUserPanel();
    
</script>


<script src="{{ get_asset('dist/js/barcode.js'). '?v='. $srmVersion }}" defer>
</script>


<script>
    $(function() {
        document.querySelectorAll('div.barcode').forEach(div => {
            const value = div.getAttribute('jsbarcode-value') || '';
            let format = div.getAttribute('jsbarcode-format') || 'CODE128';


            const barWidth = parseFloat(div.getAttribute('jsbarcode-barwidth')) || 2;
            const barHeight = parseFloat(div.getAttribute('jsbarcode-barheight')) || 60;
            const textAlign = div.getAttribute('jsbarcode-textalign') || 'center';
            const fontSize = div.getAttribute('jsbarcode-fontsize') || 20;
            const fontOptions = div.getAttribute('jsbarcode-fontoptions') || 'bold';
            const displayValue = div.getAttribute('jsbarcode-displayvalue') !== '0';

            // Clear existing content (optional, to avoid duplicates)
            div.innerHTML = '';
            
            const svg = document.createElementNS("http://www.w3.org/2000/svg", "svg");

            div.appendChild(svg);

            try{
                JsBarcode(svg, value, {
                    format: format,
                    width: barWidth,
                    height: barHeight,
                    textAlign: textAlign,
                    fontOptions: fontOptions,
                    fontSize: fontSize,
                    displayValue: displayValue,
                    background: "#ffffff",
                    lineColor: "#000000"
                });
            }catch(e){
                div.innerHTML = value;
            }
        });
    });
</script>

@endsection