@extends('layouts.app')

@section('styles')
<link rel="stylesheet"
  href="{{ get_asset('dist/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css'). '?v='. $srmVersion}}">
<link rel=" stylesheet"
  href="{{ get_asset('dist/plugins/datatables-responsive/css/responsive.bootstrap4.min.css'). '?v='. $srmVersion}}">
<link rel=" stylesheet"
  href="{{ get_asset('dist/plugins/datatables-buttons/css/buttons.bootstrap4.min.css'). '?v='. $srmVersion}}">
<link rel=" stylesheet"
  href="{{ get_asset('dist/plugins/datatables-rowgroup/css/rowGroup.bootstrap4.min.css'). '?v='. $srmVersion}}">

<style>
  div.custom-control-right {
    padding-right: 24px;
    padding-left: 0;
    margin-left: 0;
    margin-right: 0;
  }

  div.custom-control-right .custom-control-label::after {
    right: -1.5rem;
    left: auto;
  }

  div.custom-control-right .custom-control-label::before {
    right: -2.35rem;
    left: auto;
  }
</style>
@endsection


@section('content')

<div id="view-access-log-modal-container">

</div>

<div class="content-wrapper">
  <div class="content-header mx-3">
    <div class="container-fluid">
      <div class="row mb-2 mt-3">
        <div class="col-sm-8">
          <h1 class="m-0"><i class="fa fa-history mx-2"></i> Embedded Resources Access Log
          </h1>
        </div>
        <div class="col-sm-4">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
            <li class="breadcrumb-item active">Access Log</li>
          </ol>
        </div>
      </div>
    </div>
    <div class="form-section alert" style="background-color: #DAE8FC">
      <div class="d-flex align-items-center mb-3">
        <i class="fas fa-info-circle text-primary mx-2"></i>
        <strong>About This Page</strong>
      </div>
      <p class="help-text">
        This log records access to private embedded resources using an access key and embed token. Please note that
        visits to public embedded resources are not logged.
      </p>
    </div>

    <div class="row">
      <div class="col-1">
        <label for="ipaddress-search" class="mt-1">IP Address</label>
      </div>
      <div class="col-4 row">
        <div class="col-2"></div>
        <div class="col-10">
          <input type="text" class="form-control" id="ipaddress-search">
        </div>
      </div>
      <div class="col-2"></div>
      <div class="col-4 row">
        <div class="col-3">
          <label for="origin-search" class="mt-1">Origin</label>
        </div>
        <div class="col-9">
          <input type="text" class="form-control" id="origin-search">
        </div>
      </div>
    </div>

    <div class="row mt-3">
      <div class="col-1">
        <label class="mt-1">Visit Date</label>
      </div>
      <div class="col-4 row">
        <div class="col-2">
          <label for="from-date" class="mt-1">From</label>
        </div>
        <div class="col-10">
          <input type="date" class="form-control" id="from-date">
        </div>
      </div>
      <div class="col-2"></div>
      <div class="col-4 row">
        <div class="col-3">
          <label for="to-date" class="mt-1">To</label>
        </div>
        <div class="col-9">
          <input type="date" class="form-control" id="to-date">
        </div>
      </div>
    </div>

    <div class="form-group mt-4">
      <div class="form-group text-center">
        <button class="btn btn-primary px-3 py-2 my-2 my-sm-0 srm-button search-filter" type="submit"><i
            class="fas fa-search"></i> Search</button>
        <button class="btn btn-outline-primary px-3 py-2 my-2 ml-2 my-sm-0 srm-button reset-filter" type="button"><i
            class="fa-solid fa-eye"></i> Show
          All</button>
      </div>
    </div>

    <div class="card-body">
      <table id="access-logs" class="table table-bordered table-hover">
        <thead>
          <tr>
            <th style="vertical-align: middle">Accese Key label</th>
            <th style="vertical-align: middle">Visitor IP</th>
            <th style="vertical-align: middle">Origin</th>
            <th style="vertical-align: middle">Visit Date</th>
            <th style="vertical-align: middle">Actions</th>
          </tr>
        </thead>
        <tbody>
          @foreach($logs as $log)

          <tr>
            <td style="vertical-align: middle">{{ isset($log->accessKey) ? $log->accessKey->label : '' }}</td>
            <td style="vertical-align: middle">{{ $log->attembed_ip }}</td>
            <td style="vertical-align: middle">{{ $log->origin }}</td>
            <td style="vertical-align: middle">{{ $log->created_at }}</td>
            <td>
              <div class="dropdown">
                <button type="button" id="ellipsisMenu1" data-toggle="dropdown" aria-haspopup="true"
                  aria-expanded="false" style="border:none;background:none">
                  <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor"
                    class="bi bi-three-dots-vertical" viewBox="0 0 16 16">
                    <path
                      d="M9.5 13a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0z" />
                  </svg>
                </button>
                <div class="dropdown-menu" aria-labelledby="ellipsisMenu">
                  <a class="dropdown-item view-access-log" data-toggle="modal"
                    data-url="{{ route('access_log.show',$log->id) }}">View</a>
                </div>
              </div>
            </td>
          </tr>
          @endforeach
        </tbody>
      </table>
    </div> {{-- End of card body --}}
  </div>
</div>

@endsection

@section('scripts')

<script src="{{ get_asset('dist/plugins/datatables/jquery.dataTables.min.js'). '?v='. $srmVersion}}"></script>
<script src="{{ get_asset('dist/plugins/datatables-responsive/js/dataTables.responsive.min.js'). '?v='. $srmVersion}}">
</script>
<script src="{{ get_asset('dist/plugins/datatables-responsive/js/responsive.bootstrap4.min.js'). '?v='. $srmVersion}}">
</script>
<script src="{{ get_asset('dist/plugins/datatables-buttons/js/dataTables.buttons.min.js'). '?v='. $srmVersion}}">
</script>
<script src="{{ get_asset('dist/plugins/datatables-buttons/js/buttons.bootstrap4.min.js'). '?v='. $srmVersion}}">
</script>
<script src="{{ get_asset('dist/plugins/jszip/jszip.min.js'). '?v='. $srmVersion}}"></script>
<script src="{{ get_asset('dist/plugins/pdfmake/pdfmake.min.js'). '?v='. $srmVersion}}"></script>
<script src="{{ get_asset('dist/plugins/pdfmake/vfs_fonts.js'). '?v='. $srmVersion}}"></script>
<script src="{{ get_asset('dist/plugins/datatables-buttons/js/buttons.html5.min.js'). '?v='. $srmVersion}}"></script>
<script src="{{ get_asset('dist/plugins/datatables-buttons/js/buttons.print.min.js'). '?v='. $srmVersion}}"></script>
<script src="{{ get_asset('dist/plugins/datatables-buttons/js/buttons.colVis.min.js'). '?v='. $srmVersion}}"></script>
<script src="{{ get_asset('dist/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js'). '?v='. $srmVersion}}">
</script>
<script src="{{ get_asset('dist/plugins/datatables-rowgroup/js/dataTables.rowGroup.min.js'). '?v='. $srmVersion}}">
</script>
<script src="{{ get_asset('dist/plugins/datatables-rowgroup/js/rowGroup.bootstrap4.min.js'). '?v='. $srmVersion}}">
</script>
<script src="{{ get_asset('dist/js/custom-datatables.js'). '?v='. $srmVersion}}"></script>


<script src="{{ get_asset('dist/js/qrcode.min.js')}}"></script>

<script src="{{ get_asset('dist/js/access-log.js') }}" defer>
</script>
@endsection