<div class="modal fade" id="{{ $id }}-modal" tabindex="-1" role="dialog" aria-labelledby="{{ $id }}-modal"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <div class="modal-content custom-rounded-edges">
            <div class="modal-header">
                <h5 class="modal-title ml-3" id="exampleModalLongTitle">
                    <i class="fa-solid fa-key fa-fw mx-2"></i>
                    New Access Key
                </h5>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>

            <div class="modal-body mx-4">
                <form id="{{ $id }}-form">
                    @csrf

                    <div class="form-group">
                        <label for="label" class="mr-2 h5">Label</label>
                        <span class="tool-question mx-2" data-toggle="tooltip" data-placement="top" title=""
                            data-original-title="A name to identify this access key. It’s for your reference.">
                            <i class="fa-solid fa-circle-question"></i>
                        </span>
                        <input type="text" class="form-control" id="label" name="label">
                    </div>

                    <div class="form-group">
                        <label for="type" class="mr-2 h5">Type</label>
                        <span class="tool-question mx-2" data-toggle="tooltip" data-placement="top" title=""
                            data-original-title="Choose whether this key can access all resources or is limited to a specific group's permissions">
                            <i class="fa-solid fa-circle-question"></i>
                        </span>

                        <select class="form-control" name="type" id="type">
                            <option value="limited">Limited</option>
                            <option value="full">Full</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="group" class="mr-2 h5">Group</label>
                        <span class="tool-question mx-2" data-toggle="tooltip" data-placement="top" title=""
                            data-original-title="Select the group whose resources this key should have access to.">
                            <i class="fa-solid fa-circle-question"></i>
                        </span>

                        <select class="form-control" name="group" id="group">
                            <option value="">Select Group</option>

                            @foreach ($groups as $group)
                            <option value="{{ $group->group_ID }}">{{ $group->name }}</option>

                            @endforeach
                            @if(auth()->user()->isAdminOrOwner())
                            <option value="add-new-group"
                                data-url="{{ route('quick-add',['add'=> 'groups']) }}">
                                + Add New Group</option>
                            @endif
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="origin" class="mr-2 h5">Embedding Origin Restriction</label>
                        <span class="tool-question mx-2" data-toggle="tooltip" data-placement="top" title=""
                            data-original-title="This option controls how the access key can be used for embedding reports, dashboards, pivot tables, charts, and KPIs — either from any domain, only from this domain (same origin), or from a specified list of approved domains.">
                            <i class="fa-solid fa-circle-question"></i>
                        </span>

                        <select class="form-control" name="origin" id="origin">
                            <option value="same-origin">Allow embedding only from same origin</option>
                            <option value="any-origin">Allow embedding from any origin</option>
                            <option value="approved-origins">Allow embedding only from approved origins</option>
                        </select>
                    </div>

                    <div class="form-group mt-2">
                        <label for="allowed-origins" class="mr-2 h5">Allowed Origins</label>
                        <span class="tool-question mx-2" data-toggle="tooltip" data-placement="top" title="" data-html="true"
                            data-original-title="Enter one origin per line.  

                            - You must include the scheme (http:// or https://) and the port if it is not the default (80 for http, 443 for https).<br>
                            Example: https://example.com or http://example.com:8080<br>
                            - If you want to allow subdomains, you must list them separately or use a wildcard.<br>
                            Example: https://sub.example.com or https://*.example.com<br>
                            Only the origins you list here will be permitted to use the access key.<br>">
                            <i class="fa-solid fa-circle-question"></i>
                        </span>
                        <textarea class="form-control" id="allowed-origins" name="allowed_origins" disabled></textarea>
                    </div>

                    <div class="text-center">
                        <button type="button" id="saveBtn-{{ $id }}" class="btn btn-primary mx-2 px-5 py-2 my-2">
                            Save
                        </button>
                        <button type="button" class="btn btn-light mx-2 px-5 py-2 my-2" id="cancelBtn-{{ $id }}"
                            data-dismiss="modal">
                            Cancel
                        </button>

                    </div>
                    <div class="col-md-12 mt-3">
                        <div id="{{ $id }}-confirm" class="alert bootstrap-alert-success mx-4 mb-3" role="alert"
                            style="display: none">
                            <div style="display: flex; align-items: center; justify-content: space-between;">
                                <div>
                                    <span id="access-key-message"></span><br>
                                    <code id="access-key-value" style="font-weight:bold;color:black"></code>
                                </div>
                                <button id="copy-key"
                                    style="border:none; background:none; cursor:pointer; display:flex; align-items:center; gap:5px;"
                                    title="Copy">
                                    <i id="copy-icon" class="fa-solid fa-copy"></i>
                                    <span id="copy-text">Copy</span>
                                </button>
                            </div>

                        </div>
                        <div id="{{ $id }}-error" class="alert bootstrap-alert-danger mx-4 mb-3" role="alert"
                            style="display: none">
                        </div>

                    </div>
                </form>
            </div>
        </div>
    </div>
</div>