@extends('layouts.auth')

@section('content')
<div class="container">

    <div class="modal fade login" id="loginModal">
        <div class="modal-dialog login animated">
            <div class="modal-content">

                <div class="modal-body">
                    <div class="box">
                        <div class="content registerBox">
                            <form class="form" data-register="{{ route('register') }}" id="registerform">
                                <div style="margin: 5px;"><img src="{{ get_asset('dist/auth/img/srm-logo.jpg')}}"
                                        width="100%" />
                                </div>
                                @csrf
                                <input type="text" id="firstName" class="form-control" placeholder="First Name"
                                    name="first_name" value="{{ old('first_name') }}">

                                <input type="text" id="lastName" class="form-control" placeholder="Last Name"
                                    name="last_name" value="{{ old('last_name') }}">

                                <input type="text" id="user_name" class="form-control" placeholder="User Name"
                                    name="user_name" value="{{ old('user_name') }}">

                                <input id="email" class="form-control" type="text" placeholder="Email" name="email"
                                    value="{{ old('email') }}">

                                <input id="password" class="form-control" type="password" placeholder="Password"
                                    name="password">

                                <input id="password_confirmation" class="form-control" type="password"
                                    placeholder="Repeat Password" name="password_confirmation">

                                <select name="Security_question_index" id="security_question">
                                    @foreach ($security_questions as $index=>$security_question)
                                    <option value="{{ $index }}" {{ (old('security_question')==$index) ? 'selected' : ''
                                        }}>
                                        {{$security_question }}
                                    </option>
                                    @endforeach
                                </select>
                                {{-- <input type="text" id="security question" class="form-control"
                                    placeholder="security question" name="security question"> --}}

                                <input type="text" id="answer" class="form-control" placeholder="Enter Your Answer"
                                    name="Security_answer" value="{{ old('Security_answer') }}">

                                <input class="btn btn-default btn-register" type="button" value="Create account"
                                    name="register" id="register">
                            </form>
                            <div class="alert alert-danger" id="error" style="margin-top: 0.5em">

                            </div>
                            <div class="alert alert-success" id="success" style="margin-top: 0.5em">

                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <div class="forgot register-footer">
                        <span>Already have an account?</span>
                        <a href="{{ route('login') }}">Login</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="{{ get_asset('dist/auth/js/jquery-1.10.2.js')}}" type="text/javascript"></script>
<script src="{{ get_asset('dist/auth/js/bootstrap.js')}}" type="text/javascript"></script>
<script src="{{ get_asset('dist/auth/js/login-register.js')}}" type="text/javascript"></script>
<script>
    $(document).ready(function(){

$('.big-login').trigger('click');
})

</script>
@endsection
