$(document).ready(function () {

    // delete report modal
    $('#reports').on('click', ".delete-report", function (event) {
        let report = $(this).closest('tr').find('td:first').text();
        $('#delete-report-modal').find('.modal-body p').text(`Are you sure you want to delete "${report}" report?`)
        $('#delete-report-form').attr('data-url', $(this).attr('data-url'))
    });

    $("#delete-report-form").on("click", "#saveBtn-delete-report", function () {

        sendAjaxRequestWithSuccess("delete-report-form", 'delete-report-modal', reloadReportTable, ["reports"]);

    });


    // change report category

    $('#reports').on('click', ".change-category", function () {
        let url = $(this).data('url');

        $.ajax({
            type: "GET",
            url: url,
            beforeSend: function () {
                $("#global-loader").fadeIn();
            },

            success: function (response) {
                $("#global-loader").fadeOut();

                $('#change-category-modal-container').html(response);
                $('#change-category-modal').modal('show');

                $("#change-category-modal").on("click", "#saveBtn-change-category", function () {

                    let fields = ["report_category"];
                    sendAjaxRequest("change-category-form", fields, "confirm-change-category", "error-change-category", reloadReportTable, ["reports"]);
                });

                $("#change-category-modal").on("click", "#cancelBtn-change-category", function () {
                    reloadForm("change-category-form");
                    $('#error-change-category, #confirm-change-category').hide();

                });


            },
        });

    });


    // display report

    $('#reports').on('click', ".display-report", function () {
        let url = $(this).data('url');
        let display = $(this).data('display');



        $.ajax({
            type: "GET",
            url: url,
            beforeSend: function () {
                if (display != "inside_page") {
                    $('#display-blank-report-modal').modal('show');
                    $("#display-report-iframe-loader").fadeIn();
                }

            },

            success: function (response) {
                if (display == "inside_page") {
                    window.location.href = url;
                } else {

                    $('#display-blank-report-modal-container').find("iframe").attr("src", response.url);
                    $("#display-report-iframe-loader").fadeOut();

                    $("#display-blank-report-iframe").on('load', function () {
                        $("#display-report-iframe-loader").fadeOut();
                    });

                    $('#display-blank-report-modal').on('hidden.bs.modal', function () {
                        $('#display-blank-report-modal-container').find("iframe").attr("src", "");

                        $.ajax({
                            type: "POST",
                            url: prepareUrl($('#display-blank-report-iframe').attr("src"), 2, "shared/exit.php"),
                        });
                    });
                }
            }, error: function (response) {

                $(`#success-modal`).find('h5').text(response.responseJSON.message).show();
                $(`#success-modal`).modal('show');

                $("#global-loader").fadeOut();

                setTimeout(function () {

                    $('#display-blank-report-modal').modal('hide');

                }, 1000);

            }

        });

    });


    // create report

    $('.container-fluid').on('click', ".create-report", function () {
        let url = $(this).data('url');

        $.ajax({
            type: "GET",
            url: url,
            beforeSend: function () {
                $('#create-report-modal').modal('show');
                $("#create-report-iframe-loader").fadeIn();

                // Store the modal's scroll position
                var modalScrollPosition = 0;

                // Save the current scroll position when modal is shown
                $('.create-report-modal').on('show.bs.modal', function () {
                    modalScrollPosition = $(this).scrollTop();
                });

                // Restore the previous scroll position when modal is fully shown
                $('.create-report-modal').on('shown.bs.modal', function () {
                    $(this).scrollTop(modalScrollPosition);
                });

            },

            success: function (response) {
                $('#create-report-modal-container').find("iframe").attr("src", response.url);
                $("#create-report-iframe-loader").fadeOut();



                $("#create-report-modal-iframe").on('load', function () {

                    $("#create-report-iframe-loader").fadeOut();

                    adjustModalHeight("create-report-modal-iframe");

                });

                $('#create-report-modal').on('hidden.bs.modal', function () {

                    $.ajax({
                        type: "POST",
                        url: prepareUrl($('#create-report-modal-iframe').attr("src"), 0, "services/disconnect.php"),
                        success: function (response) {
                            reloadReportTable('reports');
                            $('#create-report-modal-container').find("iframe").attr("src", "");
                        }

                    });
                });

            }, error: function (response) {
                $(`#success-modal`).find('h5').text(response.responseJSON.message).show();
                $(`#success-modal`).modal('show');
                $("#global-loader").fadeOut();

            }

        });

    });


    $('#reports').on('click', ".edit-report", function () {
        let url = $(this).data('url');
        setCookie("report_url", $(this).data("display"), 1);

        $.ajax({
            type: "GET",
            url: url,
            beforeSend: function () {
                $('#edit-report-modal').modal('show');

                $("#edit-report-iframe-loader").fadeIn();


                // Store the modal's scroll position
                var modalScrollPosition = 0;

                // Save the current scroll position when modal is shown
                $('.edit-report-modal').on('show.bs.modal', function () {
                    modalScrollPosition = $(this).scrollTop();
                });

                // Restore the previous scroll position when modal is fully shown
                $('.edit-report-modal').on('shown.bs.modal', function () {
                    $(this).scrollTop(modalScrollPosition);
                });

            },
            success: function (response) {
                $('#edit-report-modal-container').find("iframe").attr("src", response.url);

                $("#edit-report-iframe-loader").fadeOut();

                $("#edit-report-modal-iframe").on('load', function () {
                    $("#edit-report-iframe-loader").fadeOut();

                    adjustModalHeight("edit-report-modal-iframe");

                });


                $('#edit-report-modal').on('hidden.bs.modal', function () {

                    $.ajax({
                        type: "POST",
                        url: prepareUrl($('#edit-report-modal-iframe').attr("src"), 0, "services/disconnect.php"),
                        success: function (response) {
                            reloadReportTable('reports');
                            $('#edit-report-modal-container').find("iframe").attr("src", "");
                        }
                    });
                });
                $("#global-loader").fadeOut();
            }, error: function (response) {
                $(`#success-modal`).find('h5').text(response.responseJSON.message).show();
                $(`#success-modal`).modal('show');
                $("#global-loader").fadeOut();

            }

        });

    });


    function prepareUrl(url, sliceCount, joinWith) {
        if (url.includes('index.php')) {
            url = url.replace('index.php', '');
        }

        if (sliceCount == 0)
            url = url.split("/");
        else
            url = url.split("/").slice(0, -`${sliceCount}`)
        url.push(joinWith);

        return url = url.join('/')
    }

    $(document).on('click', ".duplicate-report", function () {
        let url = $(this).data('url');
        $('#duplicate-modal').modal('show');
        $('#duplicate-form').attr('data-url', $(this).attr('data-url'))
        $('#duplicate-form #name').val($(this).attr('data-name') + "_1")
    });


    $(document).on("click", "#saveBtn-duplicate", function () {
        
        sendAjaxRequestWithErrorsAndWithSuccess("duplicate-form", 'duplicate-modal','error-duplicate', reloadReportTable, ["reports"]);

    });

});
