const existingJoins = new Set();
var arrayCollection;


function initializeJSTree(connection) {
    $.ajax({
        url: $(connection).find('option:selected').data('url'),
        type: 'GET',
        data: {
            connection: $(connection).val()
        },
        success: function (response) {
            arrayCollection = response.data;

            $('#jstree').jstree('destroy');

            $('#jstree').on('move_node.jstree', function (e, data) {
                data.instance.refresh();
            });

            $('#jstree').jstree({
                "plugins": ["types", "state", "dnd"],
                'core': {
                    'check_callback': false,
                    'data': arrayCollection,
                    'themes': {
                        'dots': false,
                        'responsive': true,
                    },
                    'expand_selected_onload': true
                },

            }).on('loaded.jstree', function () {
                var firstNode = $(this).jstree(true).get_node('#').children[0];
                $(this).jstree('open_node', firstNode);

            });

        }
    });

    loadJoinsModal($(connection).val())

}

function loadJoinsModal(connection) {

    $.ajax({
        type: "GET",
        url: $("#add-joins-button").attr('data-url'),
        data: { connection: connection },
        success: function (response) {

            $('#add-joins-modal-container').html(response);

        },
    });
}

function getDefaultDateLabel(datatype){
        var dataTimeTypes = ['datetime', 'timestamp'];

        if (datatype === 'date') {
            return `Quarter`;

        } else if (datatype === 'time') {
            return `Raw Value`;
        } else if (dataTimeTypes.includes(datatype)) {
            return `Quarter`;
        }
    return `Raw Value`;

}

function getDefaultDateFunction(datatype){
        var dataTimeTypes = ['datetime', 'timestamp'];

        if (datatype === 'date') {
            return `quarter`;

        } else if (datatype === 'time') {
            return `raw`;
        } else if (dataTimeTypes.includes(datatype)) {
            return `quarter`;
        }
    return `raw`;

}

function buildDropdownMenu(closestList, datatype) {

    var dataTimeTypes = ['datetime', 'timestamp'];

    if (closestList === 'row-headers' || closestList === 'column-headings') {
        if (datatype === 'date') {
            return `
        <ul class="dropdown-menu text-sm">
            <li><a class="column_function" data-action="raw" href="#">Raw Value</a></li>
            <li><a class="column_function" data-action="year" href="#">Year</a></li>
            <li><a class="column_function" data-action="quarter" href="#">Quarter</a></li>
            <li><a class="column_function" data-action="month" href="#">Month</a></li>
            <li><a class="column_function" data-action="week" href="#">Week</a></li>
            <li><a class="column_function" data-action="weekday" href="#">Weekday</a></li>
            <li><a class="column_function" data-action="day" href="#">Day</a></li>
        </ul>
    `;

        } else if (datatype === 'time') {
            return `
                <ul class="dropdown-menu text-sm">
                    <li><a class="column_function" data-action="raw" href="#">Raw Value</a></li>
                    <li><a class="column_function" data-action="hour" href="#">Hour</a></li>
                </ul>
            `;
        } else if (dataTimeTypes.includes(datatype)) {
            return `
                <ul class="dropdown-menu text-sm">
                    <li><a class="column_function" data-action="raw" href="#">Raw Value</a></li>
                    <li><a class="column_function" data-action="year" href="#">Year</a></li>
                    <li><a class="column_function" data-action="quarter" href="#">Quarter</a></li>
                    <li><a class="column_function" data-action="month" href="#">Month</a></li>
                    <li><a class="column_function" data-action="week" href="#">Week</a></li>
                    <li><a class="column_function" data-action="weekday" href="#">Weekday</a></li>
                    <li><a class="column_function" data-action="day" href="#">Day</a></li>
                    <li><a class="column_function" data-action="hour" href="#">Hour</a></li>
                </ul>
            `;
        }
    }
    return `
        <ul class="dropdown-menu text-sm"><li><a class="column_function" data-action="raw" href="#">Raw Value</a></li></ul>
    `;

}


function buildValuesDropdownMenu(closestList, datatype) {

    var numerical = ["bit", "bigint", "decimal", "double", "float", "int", "integer", "mediumint", "smallint", "tinyint"
        , "unsignedbiginteger", "unsignedinteger", "unsignedmediuminteger", "unsignedsmallinteger", "unsignedtinyinteger"];

    var date = ["date", "datetime", "timestamp", "time", "year"];


    if (closestList === 'values-fields') {
        if (numerical.includes(datatype)) {
            return `
        <ul class="dropdown-menu text-sm">
            <li><a class="column_function" data-action="count" href="#">Count</a></li>
            <li><a class="column_function" data-action="sum" href="#">Sum</a></li>
            <li><a class="column_function" data-action="count-distinct" href="#">Count Distinct</a></li>
            <li><a class="column_function" data-action="average" href="#">Average</a></li>
            <li><a class="column_function" data-action="min" href="#">Min</a></li>
            <li><a class="column_function" data-action="max" href="#">Max</a></li>
            <li><a class="column_function" data-action="first-value" href="#">First Value</a></li>
        </ul>
    `;

        } else if (date.includes(datatype)) {
            return `
                <ul class="dropdown-menu text-sm">
                <li><a class="column_function" data-action="count" href="#">Count</a></li>
                <li><a class="column_function" data-action="count-distinct" href="#">Count Distinct</a></li>
                <li><a class="column_function" data-action="min" href="#">Min</a></li>
                <li><a class="column_function" data-action="max" href="#">Max</a></li>
                <li><a class="column_function" data-action="first-value" href="#">First Value</a></li>
                </ul>
            `;
        }
    }


    return `
    <ul class="dropdown-menu text-sm">
    <li><a class="column_function" data-action="count" href="#">Count</a></li>
    <li><a class="column_function" data-action="count-distinct" href="#">Count Distinct</a></li>
    <li><a class="column_function" data-action="first-value" href="#">First Value</a></li>
    </ul>
`;

}

function buildParametersDropdownMenu(closestList, datatype) {
    datatype = datatype.toLowerCase();

    let booleanAndEnum = ["bit","boolean", "tinyint(1)", "enum", "set"];
    let numerical = ["integer","int", "tinyint", "smallint", "mediumint", "bigint", "decimal", "numeric", "float", "double", "year"];
    let text = ["varchar", "text", "char", "tinytext", "mediumtext", "longtext", "string"];
    let date = ["date", "datetime", "timestamp"];
    let time = ["time"];

    if (closestList === 'parameters') {
        let defaultSelectedDataType = "";
        let options = "";

        if (booleanAndEnum.includes(datatype)) {
            defaultSelectedDataType = "Multi-Select Filter";
            options = `<li><a class="parameters_function" data-action="multi-select" href="#">Multi-Select Filter</a></li>`;
        } else if (datatype === 'json') {
            defaultSelectedDataType = "Search Box";
            options = `<li><a class="parameters_function" data-action="search-box" href="#">Search Box</a></li>`;
        } else if (text.includes(datatype)) {
            defaultSelectedDataType = "Multi-Select Filter";
            options = `
                <li><a class="parameters_function" data-action="search-box" href="#">Search Box</a></li>
                <li><a class="parameters_function" data-action="multi-select" href="#">Multi-Select Filter</a></li>
            `;
        } else if (numerical.includes(datatype)) {
            defaultSelectedDataType = "Numeric Slider";
            options = `
                <li><a class="parameters_function" data-action="numeric-search-box" href="#">Numeric Search Box</a></li>
                <li><a class="parameters_function" data-action="numeric-slider" href="#">Numeric Slider</a></li>
                <li><a class="parameters_function" data-action="multi-select" href="#">Multi-Select Filter</a></li>
            `;
        } else if (date.includes(datatype)) {
            defaultSelectedDataType = "Date Calendar";
            options = `
                <li><a class="parameters_function" data-action="date-calendar" href="#">Date Calendar</a></li>
                <li><a class="parameters_function" data-action="multi-select" href="#">Multi-Select Filter</a></li>
            `;
        } else if (time.includes(datatype)) {
            defaultSelectedDataType = "Time Slider";
            options = `
                <li><a class="parameters_function" data-action="time-slider" href="#">Time Slider</a></li>
                <li><a class="parameters_function" data-action="multi-select" href="#">Multi-Select Filter</a></li>
            `;
        }

        return `
            <span role="button" class="dropdown-toggle label text-sm function" data-toggle="dropdown">
                [${defaultSelectedDataType}]
            </span>
            <ul class="dropdown-menu dropdown-menu-parameters text-sm">
                ${options}
            </ul>
        `;
    }

    return `
        <div class="position-relative z-3">
            <div class="position-fixed">
                <ul class="dropdown-menu text-sm">
                    <li><a class="column_function" data-action="multi-select" href="#">Multi-Select Filter</a></li>
                </ul>
            </div>
        </div>
    `;
}


function getDefaultParameterDataType(datatype) {
    datatype = datatype.toLowerCase();
    let booleanAndEnum = ["bit","boolean", "tinyint(1)", "enum", "set"];
    let numerical = ["integer","int", "tinyint", "smallint", "mediumint", "bigint", "decimal", "numeric", "float", "double", "year"];
    let text = ["varchar", "text", "char", "tinytext", "mediumtext", "longtext", "string"];
    let date = ["date", "datetime", "timestamp"];
    let time = ["time"];

        let defaultSelectedDataType = "";

        if (booleanAndEnum.includes(datatype)) {
            defaultSelectedDataType = "multi-select";
        } else if (datatype === 'json') {
            defaultSelectedDataType = "search-box";
        } else if (text.includes(datatype)) {
            defaultSelectedDataType = "multi-select";
        } else if (numerical.includes(datatype)) {
            defaultSelectedDataType = "numeric-slider";
        } else if (date.includes(datatype)) {
            defaultSelectedDataType = "date-calendar";
        } else if (time.includes(datatype)) {
            defaultSelectedDataType = "time-slider";
        }

        return defaultSelectedDataType;

}




function createFieldListItem(id, text, icon, table, datatype, parent, closestList, enumValues) {

    deleteToolTip = 'Remove this field from the pivot table.';
    editTooltip = 'Assign a label to this field.';
    
    isValuesDropMenu = closestList == "values-fields" ? true : false;
    defaultSelectedDataType = isValuesDropMenu ? 'Count' : getDefaultDateLabel(datatype);

    let _function = isValuesDropMenu ? 'count' : getDefaultDateFunction(datatype);

    return `
    <li class="px-2 list-item d-inline w-100"
        data-id="${id}" data-name="${text.original}" data-label="${text.original}"
        data-icon="${icon}" data-type="${datatype}" data-parent="${parent}" data-table="${table}"
        data-function="${_function}" data-enum="${enumValues}">
        <span role="button" class="label text-sm column-name" data-tooltip="tooltip" data-title="${text.original}">
        ${text.truncated}
        </span>
        <span role="button" class="dropdown-toggle label text-sm function" data-toggle="dropdown">
        ${' [' + defaultSelectedDataType + ']'}
        </span>
        ${isValuesDropMenu ? buildValuesDropdownMenu(closestList, datatype) : buildDropdownMenu(closestList, datatype)}
        <div class="icon-container">
            <a role="button" data-toggle="tooltip" data-title="${deleteToolTip}" class="delete-icon btn btn-default btn-sm" style="float: right; margin-left: 5px"><i class="fa fa-trash mr-0"></i></a>
            <a role="button" data-toggle="tooltip" data-title="${editTooltip}" class="modify-field btn btn-default btn-sm" style="float: right;"><i class="fa fa-edit mr-0"></i></a>
        </div>
        <hr style="border: 0; border-top: 1px solid #ccc; margin: 5px 0;">
    </li>
    `;

}

function createParameterListItem(id, text, icon,  table, datatype, parent,  closestList, enumValues) {

    let deleteTooltip = "Remove this field from the pivot table.";
    let  editTooltip = "Assign a label to this field.";

    let _function = getDefaultParameterDataType(datatype);

    if(preventColumnDropWhenTableNotExists(table, id))
        return;

    if (preventDuplicateDrop(closestList, id)) {
        return;
    }

    return `
    <li class="px-2 list-item d-inline w-100"
        data-id="${id}" data-name="${text.original}" data-label="${text.original}"
        data-icon="${icon}" data-type="${datatype}" data-parent="${parent}" data-table="${table}"
        data-function="${_function}" data-enum="${enumValues}">
        <span role="button" class="label text-sm column-name" data-tooltip="tooltip" data-title="${text.original}">
        ${text.truncated}
        </span>
        ${buildParametersDropdownMenu(closestList, datatype)}
        <div class="icon-container">
            <a role="button" data-toggle="tooltip" data-title="${deleteTooltip}" class="delete-icon btn btn-default btn-sm" style="float: right; margin-left: 5px"><i class="fa fa-trash mr-0"></i></a>
            <a role="button" data-toggle="tooltip" data-title="${editTooltip}" class="modify-field btn btn-default btn-sm" style="float: right;"><i class="fa fa-edit mr-0"></i></a>
        </div>
        <hr style="border: 0; border-top: 1px solid #ccc; margin: 5px 0;">
    </li>
    `;

}

function createStaticFilterItem(id, text, table, datatype, values) {

    let exists = $("#static-filters li[data-name='" + text.original + "']").length > 0;
    let index = exists ? $("#static-filters li[data-name='" + text.original + "']").length + 1 : 1;

    let attributes = '';
    if (values.min !== null) attributes += ` data-min="${values.min}"`;
    if (values.max !== null) attributes += ` data-max="${values.max}"`;
    if (values.value !== null) attributes += ` data-value="${values.value}"`;
    if (values.criteria !== null) attributes += ` data-criteria="${values.criteria}"`;
    if (values.typeOfRange !== null) attributes += ` data-type-of-range="${values.typeOfRange}"`;
    if (values.relative !== null) attributes += ` data-relative="${values.relative}"`;
    if (values.fixed !== null) attributes += ` data-fixed="${values.fixed}"`;
    if (values.enumValues !== null) attributes += ` data-enum="${values.enumValues}"`;
    if (values.selectType !== null) attributes += ` data-select-type="${values.selectType}"`;

    return `
    <li class="px-2 list-item d-inline w-100"
        data-id="${id}_Filter_${index}" data-name="${text.original}" data-label="${text.original}"
        data-type="${datatype}" data-table="${table}" ${attributes}>
        <span role="button" class="label text-sm column-name modify-static-filter" data-tooltip="tooltip" data-title="${text.original}_Filter_${index}"
        data-index="${index}">

        ${text.truncated}_Filter_${index}

        </span>
        <div class="icon-container">
            <a role="button" data-toggle="tooltip" data-title="Remove this field from the pivot table." class="delete-icon btn btn-default btn-sm" style="float: right; margin-left: 5px"><i class="fa fa-trash mr-0"></i></a>
            <a role="button" data-toggle="tooltip" data-title="edit static filters." class="modify-static-filter btn btn-default btn-sm" style="float: right;"><i class="fa fa-edit mr-0"></i></a>
        </div>
        <hr style="border: 0; border-top: 1px solid #ccc; margin: 5px 0;">
    </li>
    `;

}

function modifyStaticFilterItem(id, text, table, datatype, values) {

    let attributes = {};
    if (values.min !== undefined && values.min !== null) attributes["data-min"] = values.min;
    if (values.max !== undefined && values.max !== null) attributes["data-max"] = values.max;
    if (values.value !== undefined && values.value !== null) attributes["data-value"] = values.value;
    if (values.criteria !== undefined && values.criteria !== null) attributes["data-criteria"] = values.criteria;
    if (values.typeOfRange !== undefined && values.typeOfRange !== null) attributes["data-type-of-range"] = values.typeOfRange;
    if (values.relative !== undefined && values.relative !== null) attributes["data-relative"] = values.relative;
    if (values.fixed !== undefined && values.fixed !== null) attributes["data-fixed"] = values.fixed;
    if (values.enumValues !== undefined && values.enumValues !== null) attributes["data-enum"] = values.enumValues;
    if (values.selectType !== undefined && values.selectType !== null) attributes["data-select-type"] = values.selectType;

    let staticFilterItem = $(`#static-filters li[data-id="${id}"]`);

    if (staticFilterItem.length > 0) {
        staticFilterItem.attr('data-type', datatype);
        staticFilterItem.attr('data-table', table);
        staticFilterItem.attr('data-label', text.original);
        staticFilterItem.attr(attributes);
    }

}


function createAutoJoinListItem(primaryTable, primaryKey, foreignTable, foreignKey) {

    text = prepareMessage(primaryTable + " - " + foreignTable, 20).fullMsg;

    return `
    <li class="px-2 list-item d-inline w-100"
        data-primaryTable="${primaryTable}" data-primaryKey="${primaryKey}"
        data-foreignTable="${foreignTable}" data-foreignKey="${foreignKey}"
        data-jointype="inner"
        data-name="${primaryTable}.${primaryKey}=${foreignTable}.${foreignKey}=inner">
        <span role="button" class="modify-join label text-sm join-tables" data-toggle="tooltip"
        data-title="${primaryTable} - ${foreignTable}">
        ${text}
        </span>
        <div class="icon-container">
            <a role="button" data-toggle="tooltip" data-title="Remove this field from the pivot table." class="delete-join btn btn-default btn-sm" style="float: right; margin-left: 5px"><i class="fa fa-trash mr-0"></i></a>
            <a role="button" data-toggle="tooltip" data-title="edit join." class="modify-join btn btn-default btn-sm" style="float: right;"><i class="fa fa-edit mr-0"></i></a>
        </div>
        <hr style="border: 0; border-top: 1px solid #ccc; margin: 5px 0;">
    </li>
    `;
}

// Helper function to check and create joins
function processJoin(table1, table2, connection, existingJoins) {
    if (table1 === table2) return;

    const joinKey1 = `${table1}-${table2}`;
    const joinKey2 = `${table2}-${table1}`;

    if (!existingJoins.has(joinKey1) && !existingJoins.has(joinKey2)) {
        autoJoin(table1, table2, connection);
        existingJoins.add(joinKey1);
    }
}

function checkAutoJoin() {


    var rowHeaders = $('#row-headers').children('li');
    var columnHeaders = $('#column-headings').children('li');
    var valueFields = $('#values-fields').children('li');
    connection = $('#connection').val();


    // Main logic
    if (rowHeaders.length > 0 || columnHeaders.length > 0 || valueFields.length > 0) {
        const allTables = new Set();

        // Process cross-joins between row/column headers and value fields
        if (valueFields.length > 0) {
            // Row headers + ValueFields
            if (rowHeaders.length > 0) {
                for (const rowHeader of rowHeaders) {
                    const rowTable = $(rowHeader).data('table');
                    for (const valueField of valueFields) {
                        const valueTable = $(valueField).data('table');
                        processJoin(rowTable, valueTable, connection, existingJoins);
                    }
                }
            }

            // Column headers + ValueFields
            if (columnHeaders.length > 0) {
                for (const colHeader of columnHeaders) {
                    const colTable = $(colHeader).data('table');
                    for (const valueField of valueFields) {
                        const valueTable = $(valueField).data('table');
                        processJoin(colTable, valueTable, connection, existingJoins);
                    }
                }
            }

            // ValueFields self-joins
            for (let i = 0; i < valueFields.length; i++) {
                const val1 = $(valueFields[i]);
                const table1 = val1.data('table');
                for (let j = i + 1; j < valueFields.length; j++) {
                    const val2 = $(valueFields[j]);
                    const table2 = val2.data('table');
                    processJoin(table1, table2, connection, existingJoins);
                }
            }
        }

        // Original header-to-header logic (now includes value field considerations)
        if (rowHeaders.length > 0 && columnHeaders.length > 0) {
            for (const rowHeader of rowHeaders) {
                const rowTable = $(rowHeader).data('table');
                for (const colHeader of columnHeaders) {
                    const colTable = $(colHeader).data('table');
                    processJoin(rowTable, colTable, connection, existingJoins);
                }
            }
        }

        // Handle remaining header self-joins if no value fields
        else {
            if (rowHeaders.length > 0) {
                for (let i = 0; i < rowHeaders.length; i++) {
                    const h1 = $(rowHeaders[i]);
                    const t1 = h1.data('table');
                    for (let j = i + 1; j < rowHeaders.length; j++) {
                        const h2 = $(rowHeaders[j]);
                        const t2 = h2.data('table');
                        processJoin(t1, t2, connection, existingJoins);
                    }
                }
            }

            if (columnHeaders.length > 0) {
                for (let i = 0; i < columnHeaders.length; i++) {
                    const h1 = $(columnHeaders[i]);
                    const t1 = h1.data('table');
                    for (let j = i + 1; j < columnHeaders.length; j++) {
                        const h2 = $(columnHeaders[j]);
                        const t2 = h2.data('table');
                        processJoin(t1, t2, connection, existingJoins);
                    }
                }
            }
        }
    }
}

function autoJoin(rowTable, columnTable, connection) {
    let url = $("#add-joins-button").attr("data-checkjoin") + "/" + connection + "/check_join";

    $.ajax({
        type: "GET",
        url: url,
        data: { rowTable: rowTable, columnTable: columnTable, connection: connection },
        dataType: "json",
        headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
        success: function (response) {
            if (response.data) {
                let relation = response.data.data;
                let relationParts = relation.split('=');
                let primaryPart = relationParts[0].split('.');
                let foreignPart = relationParts[1].split('.');

                let primaryTable = primaryPart[0];
                let primaryKey = primaryPart[1];
                let foreignTable = foreignPart[0];
                let foreignKey = foreignPart[1];

                let normalizedKey = `${primaryTable}.${primaryKey}=${foreignTable}.${foreignKey}=inner`;

                if ($(`#joins li[data-name="${normalizedKey}"]`).length === 0) {
                    let item = createAutoJoinListItem(primaryTable, primaryKey, foreignTable, foreignKey);
                    $(item).attr("data-name", normalizedKey); // Store join key in attribute
                    $(`#joins`).append(item);
                    updateJoinTextBox("joins", `joins-textbox`);

                    initializeTooltip()
                }
            }
        },
    });
}


// prevent duplicate elements in the same list
// if the element already exists in the list, return
function preventDuplicateDrop(closestList, droppedElementId) {

    if ($(`#${closestList}`).find(`[data-id="${droppedElementId}"]`).length > 0) {

        $(`#pivot-info-modal`).find('h5').text("This field has already been added to the parameter box. Please edit the existing block instead of adding the same field again.");

        $(`#pivot-info-modal`).modal({
            keyboard: false,
            show: true
        });

        return true;
    }

    return false;
}


// only allow drops in the following areas
// if the dropped item is not in one of these areas, return
function preventWrongDropArea(closestList) {

    let onlyDropPlaces = [
        'row-headers',
        'row-headers-container',
        'column-headings',
        'column-headings-container',
        'values-fields',
        'values-fields-container',
        'static-filters',
        'static-filters-container',
        'parameters',
        'parameters-container',
        'drop-field-label-first-row'
    ];

    return onlyDropPlaces.includes(closestList) ? true : false;

}

function preventAddingMoreThanTwoElements(closestList) {

    let validations = {
        "row-headers": "Only one field can be added to the Row Headers.",
        "column-headings": "Only one field can be added to the Column Headers.",
        "values-fields": "You can only add one field to the Values section."
    }

    let unlimitedDropPlaces = [
        'static-filters',
        'static-filters-container',
        'parameters',
        'parameters-container'
    ]

    if ($(`#${closestList}`).children('li').length == 1 && !unlimitedDropPlaces.includes(closestList)) {

        $(`#pivot-info-modal`).find('h5').text(validations[closestList]);

        $(`#pivot-info-modal`).modal({
            keyboard: false,
            show: true
        });

        return true;
    }

    return false;
}

function updateColumnFunction(columnFunction, e) {
    var closestList = columnFunction.parent().parent().parent().closest('ul').attr('id');
    var action = columnFunction.attr("data-action");
    var listItem = columnFunction.closest('li.list-item');
    var columnLabel = listItem.data('label');


    listItem.attr('data-function', action);
    listItem.find('.column-name').text(`${columnLabel}`);
    listItem.find('.function').text(`[${columnFunction.text()}]`);
    updateFieldTextBox(closestList, `${closestList}-textbox`);

    initializeTooltip()
}


function updateParameterFunction(columnFunction, e) {

    // Find the correct dropdown using data-dropdown-id
    var dropdownId = columnFunction.closest('.dropdown-menu').attr('data-dropdown-id');
    var $trigger = $('[data-dropdown-id="' + dropdownId + '"]'); // Find the trigger by ID


    var closestList = $trigger.closest('ul').attr('id');
    var action = columnFunction.attr("data-action");
    var listItem = $trigger.closest('li.list-item');
    var columnLabel = listItem.attr('data-label');

    listItem.attr('data-function', action);
    listItem.find('.column-name').text(`${columnLabel}`);
    listItem.find('.function').text(`[${columnFunction.text()}]`);
    updateFieldTextBox(closestList, `${closestList}-textbox`);

    initializeTooltip();
}




function bindModifyFieldEvent() {
    $(document).on('click', '.modify-field', function () {
        var closestList = $(this).closest('ul').attr('id');
        var listItem = $(this).closest('li');

        var currentText = listItem.attr('data-label');

        var inputBox = '<div class="input-container" style=" margin-top: 5px;">' +
            '<input type="text" class="modify-input" value="' + currentText + '" style="width: 100%; display: block;">' +
            '</div>';

        listItem.append(inputBox);
        listItem.find('.modify-input').focus();

        listItem.find('.modify-input').on('keypress', function (e) {

            if (e.which === 13 && $(this).val() !== "") {
                updateLabelAndTextBox.call(this, closestList);
            }

        });

        listItem.find('.modify-input').on('blur', function () {
            updateLabelAndTextBox.call(this, closestList);

        });


    });
}

function updateLabelAndTextBox(closestList) {
    var newText = $(this).val();
    $(this).closest('li').attr('data-label', newText);
    $(this).closest('li').find('span.column-name').attr('data-original-title', newText);
    $(this).closest('li').find('span.column-name').attr('data-title', newText);
    $(this).closest('li').find('span.column-name').text(newText);
    $(this).closest('.input-container').remove();
    updateFieldTextBox(closestList, `${closestList}-textbox`);
}


function bindDeleteEvent(closestList) {
    $(document).on('click', '.delete-icon', function () {
        $(this).closest('li').remove();
        if ($(`#${closestList}`).children('li').length === 0) {
            $('#drop-field-label').show();
        }
        if ($(`#${closestList}`).children('li').length == 0) {
            $(`#${closestList}`).parent().siblings('.text-center').find('.drop-field-label-first-row').show();
            $(`#${closestList}`).parent().siblings('.text-center').find('.drop-field-label').show();
        }

        if (closestList != "static-filters") {
            updateFieldTextBox(closestList, `${closestList}-textbox`);
        } else {
            updateStaticFilterTextBox(closestList, `${closestList}-textbox`);
        }
        $(".dropdown-menu-parameters").hide();
        $('.tooltip').remove();
    });




}

function toggleFieldLabels(closestList) {
    if ($(`#${closestList}`).children('li').length > 0) {
        $(`#${closestList}`).parent().siblings('.text-center').find('.drop-field-label-first-row').hide();
        $(`#${closestList}`).parent().siblings('.text-center').find('.drop-field-label').hide();

    } else {
        $(`#${closestList}`).parent().siblings('.text-center').find('.drop-field-label-first-row').show();
        $(`#${closestList}`).parent().siblings('.text-center').find('.drop-field-label').show();

    }
}

function updateFieldTextBox(fieldId, textboxId) {
    var selectedItems = [];

    $(`#${fieldId} >  li`).each(function () {
        var table = $(this).attr("data-table");
        var name = $(this).attr("data-name");
        var label = $(this).attr("data-label");
        var type = $(this).attr("data-type");
        var _function = $(this).attr("data-function");
        selectedItems.push(`${type}.${table}.${name}.${label}:${_function}`);

    });
    $(`#${textboxId}`).val(selectedItems.join(', '));
}

function updateStaticFilterTextBox(fieldId, textboxId) {
    var selectedItems = [];

    $(`#${fieldId} >  li`).each(function () {
        var table = $(this).attr("data-table");
        var name = $(this).attr("data-name");
        var fixed = $(this).attr("data-fixed");
        var relative = $(this).attr("data-relative");
        var range = $(this).attr("data-range");
        var min = $(this).attr("data-min");
        var max = $(this).attr("data-max");
        var value = $(this).attr("data-value");
        var criteria = $(this).attr("data-criteria");
        var type = $(this).attr("data-type");
        var typeOfRange = $(this).attr("data-type-of-range");

        var filter = `table=${table}&column=${name}&type=${type.toLowerCase()}`;
        if (fixed) {
            filter += `&fixed=${fixed}`;
        }
        if (relative) {
            filter += `&relative=${relative}`;
        }
        if (range) {
            filter += `&range=${range}`;
        }
        if (min) {
            filter += `&min=${min}`;
        }
        if (max) {
            filter += `&max=${max}`;
        }
        if (value) {
            filter += `&value=${value}`;
        }
        if (criteria) {
            filter += `&criteria=${criteria}`;
        }
        if (typeOfRange) {
            filter += `&typeOfRange=${typeOfRange}`;
        }
        selectedItems.push(filter);

    });

    $(`#${textboxId}`).val(selectedItems.join('; '));
}


function updateJoinTextBox(fieldId, textboxId) {
    var selectedItems = [];
    existingJoins.clear();

    $(`#${fieldId} >  li`).each(function () {
        var name = $(this).attr("data-name");
        selectedItems.push(`${name}`);
        existingJoins.add(name);
    });
    $(`#${textboxId}`).val(selectedItems.join(', '));

}

function buildHTMLRow(content) {

    return `<div class="row">
                ${content}
            </div>`
}

function buildLabelReadOnlyTextBox(content, label, columnSize) {

    return `
            <div class="${columnSize}">
                <div class="form-group">
                    <label>${label}</label>
                    <input type="text" class="form-control" value="${content}" readonly>
                </div>
            </div>
            `
}

function buildReadOnlyTextBox(content, id, columnSize) {

    return `
            <div class="${columnSize}">
                <div class="form-group">
                    <input type="text" id="${id}" class="form-control" value="${content}" readonly>
                </div>
            </div>
            `
}

function buildTextBox(label, id, name, columnSize, disabled = false, isHidden = false, value = null) {

    return `
            <div class="${columnSize}" style="display: ${isHidden ? 'none' : 'block'}">
                <div class="form-group">
                    <label>${label}</label>
                    <input type="text" class="form-control" id="${id}" name="${name}" ${disabled ? 'disabled' : ''}
                    ${value !== null ? 'value="' + value + '"' : ''}>
                </div>
            </div>
            `
}

function buildTextBoxWithPlaceholder(placeholder, id, name, columnSize, disabled = false) {

    return `
            <div class="${columnSize}">
                <div class="form-group">
                    <input placeholder="${placeholder}" type="text" class="form-control" id="${id}" name="${name}" ${disabled ? 'disabled' : ''}>
                </div>
            </div>
            `
}

function buildSelectWithLabel(options, label, id, name, columnSize, isInline = false, values = null, isMultiple = "single") {

    let optionsHTML = "";

    if (isMultiple == "multiple")
        values = values.split(",");
    options.forEach(option => {

        if (values) {
            if (Array.isArray(values)) {
                if (values.includes(option.value)) {
                    optionsHTML += `<option value="${option.value}" selected>${option.label}</option>`;
                } else {
                    optionsHTML += `<option value="${option.value}">${option.label}</option>`;
                }
            } else {
                optionsHTML += `<option value="${option.value}" ${values == option.value ? 'selected' : ''}>${option.label}</option>`;
            }

        } else {
            optionsHTML += `<option value="${option.value}" ${option.default == true ? 'selected' : ''}>${option.label}</option>`;
        }

    });

    return `
        <div class="${columnSize}">
            <div class="form-group">
                <label for="${id}">${label}</label>
                <select class="form-control ${isInline ? 'd-inline w-50' : ''}" id="${id}" name="${name}" ${isMultiple == "multiple" ? 'multiple' : ''} >
                    ${optionsHTML}
                </select>
            </div>
        </div>
    `;
}



function buildSelectWithoutLabel(options, id, name, columnSize, isHidden = false, values = null) {

    let optionsHTML = "";

    options.forEach(option => {

        if (values) {
            optionsHTML += `<option value="${option.value}" ${values == option.value ? 'selected' : ''}>${option.label}</option>`;
        } else {
            optionsHTML += `<option value="${option.value}" ${option.default == true ? 'selected' : ''}>${option.label}</option>`;
        }

    });

    return `
        <div class="${columnSize} ${isHidden ? 'd-none' : ''}">
            <div class="form-group">
                <select class="form-control" id="${id}" name="${name}">
                    ${optionsHTML}
                </select>
            </div>
        </div>
    `;
}

function addColumnSpace(numberOfColumn, columnSize) {

    let htmlContent = '';

    for (let i = 0; i < numberOfColumn; i++) {
        htmlContent += `<div class="${columnSize}"></div>`;
    }

    return htmlContent;

}

function buildCheckBox(label, id, name, columnSize) {

    return `
            <div class="${columnSize}">
                <div class="form-group">
                    <input type="checkbox" id="${id}" name="${name}">
                    <label for="${id}">${label}</label>
                </div>
            </div>
            `
}

function writeValidationError(error) {

    $('#add-filter-error').text(error);
}

function numericFilterValidations() {
    let criteria = $(`#criteria`).val();
    let value = $(`#value`).val();
    let valid = true;

    if (!((criteria == "is_null") || (criteria == "is_not_null") || (criteria == "between"))) {
        if (!value.trim()) {
            writeValidationError("Please enter a filter value")
            valid = false;
        } else if (isNaN(value) || isNaN(parseFloat(value))) {
            writeValidationError("The filter value must be a numeric value and not empty")
            valid = false;
        }

    } else if (criteria == "between") {
        let min = $(`#min`).val();
        let max = $(`#max`).val();
        if (!min.trim() || !max.trim()) {
            writeValidationError("Please enter a filter value")
            valid = false;
        } else if (isNaN(min) || isNaN(parseFloat(min))) {
            writeValidationError("The filter value must be a numeric value and not empty")
            valid = false;
        } else if (isNaN(max) || isNaN(parseFloat(max))) {
            writeValidationError("The filter value must be a numeric value and not empty")
            valid = false;
        }

    }

    return valid;
}

function numericCriteriaChange() {
    $(document).on('change', '#criteria', function () {
        const showValue = $(this).val() !== "between";
        const showMinMax = $(this).val() === "between";

        $("#min").parent().parent().toggle(showMinMax);
        $("#max").parent().parent().toggle(showMinMax);
        $(`#value`).parent().parent().toggle(showValue);
        $(`#value`).prop('disabled', $(this).val() === "is_null" || $(this).val() === "is_not_null");
    });

}

function getNumericFilterHTML(datatype, text, table, id, values) {
    $(document).off('click', '#saveBtn-filter');

    let options = [
        {
            "label": "Greater than (>)",
            "value": "greater_than"
        },
        {
            "label": "Less than (<)",
            "value": "less_than"
        },
        {
            "label": "Between [Min, Max]",
            "value": "between",
            "default": true
        },
        {
            "label": "Equal (=)",
            "value": "equal"
        },
        {
            "label": "Not Equal (!=)",
            "value": "not_equal"
        },
        {
            "label": "Is Null",
            "value": "is_null"
        },
        {
            "label": "Is Not Null",
            "value": "is_not_null"
        }
    ];

    let filteredColumn = buildLabelReadOnlyTextBox(text.original ?? text, "Filtered Column", "col-md-4");
    let criteria = buildSelectWithLabel(options, "Criteria", "criteria", "criteria", "col-md-4", false, values.criteria);
    let value = buildTextBox("Filter Value", "value", "value", "col-md-4", false, [null, "between"].includes(values.criteria), values.value);
    let min = buildTextBox("min", "min", "min", "col-md-2", false, ![null, "between"].includes(values.criteria), values.min);
    let max = buildTextBox("max", "max", "max", "col-md-2", false, ![null, "between"].includes(values.criteria), values.max);
    let space = addColumnSpace(2, "col-md-4");

    let fullHTML = `${filteredColumn}${criteria}${value}${min}${max}${space}`;

    $(`#value`).parent().parent().hide();


    numericCriteriaChange();

    $(document).on('click', '#saveBtn-filter', function () {
        if (!numericFilterValidations()) {
            $('#add-filter-error').show();

        } else {
            $('#add-filter-error').text("").hide();

            values.value = $("#value").val();
            values.min = $("#min").val();
            values.max = $("#max").val();
            values.criteria = $("#criteria").val();

            if (values.edit) {
                modifyStaticFilterItem(id, text, table, datatype, values);
                $(`#static-filters-modal`).modal("hide");

            } else {
                addStaticFilterItem(id, text, table, datatype, values);
            }

            updateStaticFilterTextBox("static-filters", "static-filters-textbox");

        }
    });

    return buildHTMLRow(fullHTML);
}

function getSpecialDataTypeOptions(dataType) {

    let options = [
        {
            "label": "Is Null",
            "value": "is_null"
        },
        {
            "label": "Is Not Null",
            "value": "is_not_null"
        },
    ];

    if (["BLOB", "LONGBLOB", "MEDIUMBLOB", "TINYBLOB"].includes(dataType.toUpperCase())) {
        options.push(
            {
                "label": "Is Empty Binary",
                "value": "is_empty_binary"
            }
        )

    }

    if (dataType.toUpperCase() === "JSON") {
        options.push(
            {
                "label": "Is Empty JSON",
                "value": "is_empty_json"
            },
            {
                "label": "JSON Contains Key",
                "value": "json_contains_key"
            },
            {
                "label": "JSON Contains Value",
                "value": "json_contains_value"
            }
        )
    }

    return options;
}

function specialDataTypeFilterValidations() {
    let criteria = $(`#criteria`).val();
    let value = $(`#value`).val();
    let valid = true;


    if (!["is_null", "is_not_null", "is_empty_binary", "is_empty_json"].includes(criteria)) {

        if (!value.trim()) {
            writeValidationError("Please enter a filter value")
            valid = false;
        }
    }

    return valid;
}

function getSpecialDataTypeFilterHTML(datatype, text, table, id, values) {
    $(document).off('click', '#saveBtn-filter');


    let options = getSpecialDataTypeOptions(datatype);

    let isDisabled = [null, "is_null", "is_not_null", "is_empty_binary", "is_empty_json"];
    let filteredColumn = buildLabelReadOnlyTextBox(text.original ?? text, "Filtered Column", "col-md-4");
    let criteria = buildSelectWithLabel(options, "Criteria", "criteria", "criteria", "col-md-4", false, values.criteria);
    let value = buildTextBox("Filter Value", "value", "value", "col-md-4", isDisabled.includes(values.criteria), false, values.value);

    let fullHTML = `${filteredColumn}${criteria}${value}`;


    $(document).on('change', '#criteria', function () {

        if (isDisabled.includes($(this).val())) {
            $(`#value`).prop('disabled', true);
        } else {
            $(`#value`).prop('disabled', false);
        }

    });

    $(document).on('click', '#saveBtn-filter', function () {
        if (!specialDataTypeFilterValidations()) {
            $('#add-filter-error').show();

        } else {
            $('#add-filter-error').text("").hide();

            values.value = $(`#value`).val().replace(/["']/g, "");
            values.criteria = $("#criteria").val();

            if (values.edit) {

                if (isDisabled.includes(values.criteria)) {
                    $(`#value`).val("");
                    values.value = "";
                }

                modifyStaticFilterItem(id, text, table, datatype, values);
                $(`#static-filters-modal`).modal("hide");

            } else {

                addStaticFilterItem(id, text, table, datatype, values);
            }

            updateStaticFilterTextBox("static-filters", "static-filters-textbox");

        }
    });

    return buildHTMLRow(fullHTML);


}

function TextualDataTypeFilterValidations() {
    let criteria = $(`#criteria`).val();
    let value = $(`#value`).val();
    let valid = true;


    if (!["is_null", "is_not_null"].includes(criteria)) {

        if (!value.trim()) {
            writeValidationError("Please enter a filter value")
            valid = false;
        }
    }

    return valid;

}

function getTextualFilterHTML(datatype, text, table, id, values) {
    $(document).off('click', '#saveBtn-filter');

    let options = [
        {
            "label": "Contains",
            "value": "contains"
        },
        {
            "label": "Does Not Contain",
            "value": "does_not_contain"
        },
        {
            "label": "Starts With",
            "value": "starts_with"
        },
        {
            "label": "Ends With",
            "value": "ends_with"
        },
        {
            "label": "Equals (Exact Match)",
            "value": "equals"
        },
        {
            "label": "Not Equal",
            "value": "not_equal"
        },
        {
            "label": "Is Null",
            "value": "is_null"
        },
        {
            "label": "Is Not Null",
            "value": "is_not_null"
        },
    ];

    let isDisabled = ["is_null", "is_not_null"];

    let filteredColumn = buildLabelReadOnlyTextBox(text.original ?? text, "Filtered Column", "col-md-4");
    let criteria = buildSelectWithLabel(options, "Criteria", "criteria", "criteria", "col-md-4", false, values.criteria);
    let value = buildTextBox("Filter Value", "value", "value", "col-md-4", isDisabled.includes(values.criteria), false, values.value);


    let fullHTML = `${filteredColumn}${criteria}${value}`;


    $(document).on('change', '#criteria', function () {

        if (isDisabled.includes($(this).val())) {
            $(`#value`).prop('disabled', true);
        } else {
            $(`#value`).prop('disabled', false);
        }

    });

    $(document).on('click', '#saveBtn-filter', function () {
        if (!TextualDataTypeFilterValidations()) {
            $('#add-filter-error').show();

        } else {
            $('#add-filter-error').text("").hide();

            values.value = $("#value").val();
            values.criteria = $("#criteria").val();

            if (values.edit) {

                if (isDisabled.includes(values.criteria)) {
                    $(`#value`).val("");
                    values.value = "";
                }

                modifyStaticFilterItem(id, text, table, datatype, values);
                $(`#static-filters-modal`).modal("hide");

            } else {

                addStaticFilterItem(id, text, table, datatype, values);
            }

            updateStaticFilterTextBox("static-filters", "static-filters-textbox");

        }
    });

    return buildHTMLRow(fullHTML);
}

function buildRadioButton(label, id, name, columnSize, values) {

    return `
    <div class="${columnSize}">
        <label>${label}</label>
        <div class="form-group">
            <input type="radio" id="${id}-true" value="true" name="${name}" ${values.value == "true" ? 'checked' : ''}>
            <label for="${id}-true">True</label><br>
            <input type="radio" id="${id}-false" value="false" name="${name}" ${values.value == "false" ? 'checked' : ''}>
            <label for="${id}-false">False</label>
        </div>
    </div>
    `
}
function getBooleanFilterHTML(datatype, text, table, id, values) {
    $(document).off('click', '#saveBtn-filter');

    let filteredColumn = buildLabelReadOnlyTextBox(text.original ?? text, "Filtered Column", "col-md-4");

    let space = addColumnSpace(1, "col-md-4");
    let value = buildRadioButton("Filter Value", "value", "value", "col-md-4", values);

    let fullHTML = `${filteredColumn}${space}${value}`;

    $(document).on('click', '#saveBtn-filter', function () {

        values.value = $("input[name=value]:checked").val();

        if (values.edit) {

            modifyStaticFilterItem(id, text, table, datatype, values);
            $(`#static-filters-modal`).modal("hide");

        } else {

            addStaticFilterItem(id, text, table, datatype, values);
        }

        updateStaticFilterTextBox("static-filters", "static-filters-textbox");

    });


    return buildHTMLRow(fullHTML);

}

function getEnumFilterHTML(datatype, text, table, id, values) {

    $(document).off('click', '#saveBtn-filter');

    let enumValuesArray = values.enumValues?.split(',');

    let enums = enumValuesArray.map((value, index) => {
        return {
            "label": value.trim(),
            "value": value.trim()
        };
    });

    let typeOfSelectionOptions = [
        {
            "label": "Single Selection",
            "value": "single"
        },
        {
            "label": "Multiple Selection",
            "value": "multiple"
        }
    ];

    let typeOfSelect = buildSelectWithLabel(typeOfSelectionOptions, "Type of Select", "type-of-select", "type_of_select", "col-md-8", true, values.selectType);
    let space = addColumnSpace(1, "col-md-3");
    let filteredColumn = buildLabelReadOnlyTextBox(text.original ?? text, "Filtered Column", "col-md-6");
    let selectValues = buildSelectWithLabel(enums, "Filter Value", "value", "value", "col-md-6", false, values.value, values.selectType);


    let fullHTML = `${typeOfSelect}${space}
    ${filteredColumn}${selectValues}`;

    $(document).on('change', '#type-of-select', function () {
        switch ($(this).val()) {
            case "single":
                $("#value").prop('multiple', false)
                break;
            case "multiple":
                $("#value").prop('multiple', true)
                break;
        }
    });

    $(document).on('click', '#saveBtn-filter', function () {
        if (!DateDataTypeFilterValidations()) {

            $('#add-filter-error').show();

        } else {
            $('#add-filter-error').text("").hide();

            values.value = $("#value").val();
            values.selectType = $("#type-of-select").val();

            if (values.edit) {

                modifyStaticFilterItem(id, text, table, datatype, values);
                $(`#static-filters-modal`).modal("hide");

            } else {

                addStaticFilterItem(id, text, table, datatype, values);

            }
        }

        updateStaticFilterTextBox("static-filters", "static-filters-textbox");

    });

    return buildHTMLRow(fullHTML);

}


function buildLabel(label, id, columnSize, isHidden = false) {

    return `
        <div id="${id}" class="${columnSize} ${isHidden ? 'd-none' : ''}">
            <div class="text-center mt-2">
                <label>${label}</label>
            </div>
        </div>
    `;
}

function buildDateTimePicker(label, id, name, columnSize, isHidden = false, datatype = 'datetime', values) {

    let pickerType = 'datetime-local';

    let isLabeled = label == null ? false : true;

    if (["DATETIME", "TIMESTAMP"].includes(datatype)) {

        pickerType = 'datetime-local';

    } else if (datatype == "DATE") {

        pickerType = 'date';

    } else {

        pickerType = 'time';

    }



    return `
    <div class="${columnSize} ${isHidden ? 'd-none' : ''}">
        <div class="form-group">
            ${isLabeled ? `<label>${label}</label>` : ''}
            <input type="${pickerType}" class="form-control ${isLabeled ? `w-75` : ''} d-inline" id="${id}" name="${name}"
                value="${values ?? ''}">
        </div>
    </div>`
}


function DateDataTypeFilterValidations() {
    let typeOfRange = $(`#type-of-range`).val();
    let fixedRange = $(`#fixed-range`).val();
    let from = $(`#from`).val();
    let to = $(`#to`).val();
    let valid = true;

    if (typeOfRange == "relative_range") {

        return true;

    }

    if (["greater_than", "less_than", "equal"].includes(fixedRange)) {

        if (!from.trim()) {
            writeValidationError("Please enter a filter value")
            valid = false;

        }

    } else if (fixedRange == "between") {

        if (!from.trim() || !to.trim()) {
            writeValidationError("Please enter a filter value")
            valid = false;
        }

    }

    return valid;

}

function fixedRangeEffects() {
    switch ($("#fixed-range").val()) {
        case "between":
            $(`#from`).parent().parent().removeClass('d-none').removeClass('col-md-4').addClass('col-md-3');
            $(`#to`).parent().parent().removeClass('d-none').removeClass('col-md-4').addClass('col-md-3');
            $("#filtered-column").parent().parent().removeClass('col-md-4').removeClass('col-md-6');
            $("#filtered-column").parent().parent().addClass('col-md-3');
            $("#fixed-range").parent().parent().removeClass('col-md-4').removeClass('col-md-6');
            $("#fixed-range").parent().parent().addClass('col-md-3');
            break;
        case "equal":
        case "greater_than":
        case "less_than":
            $(`#from`).parent().parent().removeClass('d-none').removeClass('col-md-3').addClass('col-md-4');
            $(`#to`).parent().parent().addClass('d-none');

            $("#filtered-column").parent().parent().addClass('col-md-4');
            $("#filtered-column").parent().parent().removeClass('col-md-3').removeClass('col-md-6');
            $("#fixed-range").parent().parent().addClass('col-md-4');
            $("#fixed-range").parent().parent().removeClass('col-md-3').removeClass('col-md-6');
            break;
        case "is_null":
        case "is_not_null":
            $(`#from`).parent().parent().addClass('d-none');
            $(`#to`).parent().parent().addClass('d-none');

            $("#filtered-column").parent().parent().addClass('col-md-6');
            $("#filtered-column").parent().parent().removeClass('col-md-3').removeClass('col-md-4');
            $("#fixed-range").parent().parent().addClass('col-md-6');
            $("#fixed-range").parent().parent().removeClass('col-md-3').removeClass('col-md-4');
            break;
    }

}

function getDateTimeFilterHTML(datatype, text, table, id, values) {
    $(document).off('click', '#saveBtn-filter');

    let relativeRangeOptions;
    let typeOfRangesOptions = [
        {
            "label": "Relative Range Filter",
            "value": "relative_range"
        },
        {
            "label": "Fixed Range Filter",
            "value": "fixed_range"
        },
    ]
    if (["DATE"].includes(datatype)) {

        relativeRangeOptions = [
            {
                "label": "This Year",
                "value": "this_year"
            },
            {
                "label": "Last 12 Months",
                "value": "last_12_months"
            },
            {
                "label": "This Quarter",
                "value": "this_quarter"
            },
            {
                "label": "Last Quarter",
                "value": "last_quarter"
            },
            {
                "label": "This Month",
                "value": "this_month"
            },
            {
                "label": "Last 30 Days",
                "value": "last_30_days"
            },
            {
                "label": "This Week",
                "value": "this_week"
            },
            {
                "label": "Last 7 Days",
                "value": "last_7_days"
            },
            {
                "label": "Today",
                "value": "today"
            },
            {
                "label": "Yesterday",
                "value": "yesterday"
            }
        ];
    } else if (["DATETIME", "TIMESTAMP"].includes(datatype)) {

        relativeRangeOptions = [
            {
                "label": "This Year",
                "value": "this_year"
            },
            {
                "label": "Last 12 Months",
                "value": "last_12_months"
            },
            {
                "label": "This Quarter",
                "value": "this_quarter"
            },
            {
                "label": "Last Quarter",
                "value": "last_quarter"
            },
            {
                "label": "This Month",
                "value": "this_month"
            },
            {
                "label": "Last 30 Days",
                "value": "last_30_days"
            },
            {
                "label": "This Week",
                "value": "this_week"
            },
            {
                "label": "Last 7 Days",
                "value": "last_7_days"
            },
            {
                "label": "Today",
                "value": "today"
            },
            {
                "label": "Yesterday",
                "value": "yesterday"
            },
            {
                "label": "This hour",
                "value": "this_hour"
            },
            {
                "label": "Previous hour",
                "value": "previous_hour"
            }

        ];

    } else {
        relativeRangeOptions = [
            {
                "label": "This hour",
                "value": "this_hour"
            },
            {
                "label": "Previous hour",
                "value": "previous_hour"
            }

        ];
    }

    let fixedRangeOptions = [
        {
            "label": "Greater Than",
            "value": "greater_than"
        },
        {
            "label": "Less Than",
            "value": "less_than"
        },
        {
            "label": "Between",
            "value": "between",
            "default": true
        },
        {
            "label": "Equal",
            "value": "equal",
        },
        {
            "label": "Is Null",
            "value": "is_null",
        },
        {
            "label": "Is Not Null",
            "value": "is_not_null",
        },
    ];

    let isRelative = [null, "relative_range"];

    let relativeRangeSelectColumns;
    let fixedRangeSelectColumns;
    let filteredColumnColumns;
    let fromDateColumns;
    let hideFrom = true;
    let hideTo = true;


    const isRelativeRange = isRelative.includes(values.typeOfRange);
    const isFixedRangeGT_LT_EQ = ["greater_than", "less_than", "equal"].includes(values.fixed);
    const isFixedRangeNullNotNull = ["is_null", "is_not_null"].includes(values.fixed);

    if (isRelativeRange) {
        filteredColumnColumns = "col-md-4";
        relativeRangeSelectColumns = "col-md-4";
        fixedRangeSelectColumns = "col-md-4";
        fromDateColumns = "col-md-3";
    } else if (isFixedRangeGT_LT_EQ) {
        fixedRangeSelectColumns = "col-md-4";
        fromDateColumns = "col-md-4";
        filteredColumnColumns = "col-md-4";
        hideFrom = false;
        hideTo = true;
    } else if (isFixedRangeNullNotNull) {
        filteredColumnColumns = "col-md-6";
        fixedRangeSelectColumns = "col-md-6";
        hideFrom = true;
        hideTo = true;
    } else {
        relativeRangeSelectColumns = "col-md-4";
        fixedRangeSelectColumns = "col-md-3";
        filteredColumnColumns = "col-md-3";
        fromDateColumns = "col-md-3";
        hideFrom = false;
        hideTo = false;
    }

    let space = addColumnSpace(1, "col-md-3");
    let typeOfRangeSelect = buildSelectWithLabel(typeOfRangesOptions, "Type of Range", "type-of-range", "type_of_range", "col-md-8", true, values.typeOfRange);

    let filteredColumn = buildReadOnlyTextBox(text.original ?? text, "filtered-column", filteredColumnColumns);
    let fallsInLabel = buildLabel("falls in", "falls-in", "col-md-4", !isRelativeRange);
    let relativeRangeSelect = buildSelectWithoutLabel(relativeRangeOptions, "relative-range", "relative_range", relativeRangeSelectColumns ?? "col-md-4", !isRelativeRange, values.relative);
    let fixedRangeSelect = buildSelectWithoutLabel(fixedRangeOptions, "fixed-range", "fixed_range", fixedRangeSelectColumns, isRelativeRange, values.fixed);
    let fromDate = buildDateTimePicker(null, "from", "from", fromDateColumns, hideFrom, datatype, values.min);
    let toDate = buildDateTimePicker("and", "to", "to", "col-md-3", hideTo, datatype, values.max);


    let fullHTML = `${typeOfRangeSelect}${space}
    ${filteredColumn}${fallsInLabel}${relativeRangeSelect}
    ${fixedRangeSelect}${fromDate}${toDate}`;

    $(document).on('change', '#type-of-range', function () {
        switch ($(this).val()) {
            case "relative_range":
                $(`#falls-in`).removeClass('d-none');
                $(`#relative-range`).parent().parent().removeClass('d-none');
                $(`#fixed-range`).parent().parent().addClass('d-none');
                $(`#from`).parent().parent().addClass('d-none');
                $(`#to`).parent().parent().addClass('d-none');
                $("#filtered-column").parent().parent().removeClass('col-md-3').removeClass('col-md-6');
                $("#filtered-column").parent().parent().addClass('col-md-4');
                break;
            case "fixed_range":
                $("#filtered-column").parent().parent()
                    .removeClass('col-md-6 col-md-4').addClass('col-md-3');
                $(`#falls-in`).addClass('d-none');
                $(`#relative-range`).parent().parent().addClass('d-none');
                $(`#fixed-range`).parent().parent().removeClass('d-none col-md-4').addClass('col-md-3');

                fixedRangeEffects();
                break;
        }
    });

    $(document).on('change', '#fixed-range', function () {
        fixedRangeEffects();
    });


    $(document).on('click', '#saveBtn-filter', function () {
        if (!DateDataTypeFilterValidations()) {
            $('#add-filter-error').show();

        } else {
            $('#add-filter-error').text("").hide();

            values.value = $("#value").val();
            values.min = $("#from").val();
            values.max = $("#to").val();
            values.typeOfRange = $("#type-of-range").val();
            values.relative = $("#relative-range").val();
            values.fixed = $("#fixed-range").val();

            if (values.typeOfRange == "relative_range") {
                values.fixed = "";
                values.max = "";
                values.min = "";
                values.fixed = "";
            } else {
                values.relative = "";
            }

            if (values.edit) {

                modifyStaticFilterItem(id, text, table, datatype, values);
                $(`#static-filters-modal`).modal("hide");

            } else {

                addStaticFilterItem(id, text, table, datatype, values);

            }

            updateStaticFilterTextBox("static-filters", "static-filters-textbox");


        }
    });

    return buildHTMLRow(fullHTML);

}


function addStaticFilterItem(id, text, table, datatype, values) {

    let listItem = createStaticFilterItem(id, text, table, datatype, values);

    $("#static-filters").append(listItem);

    toggleFieldLabels("static-filters");
    initializeTooltip();
    $(`#static-filters-modal`).modal("hide");
}


function getStaticFilterHTML(datatype, text, table, id, values) {

    const numericTypes = ["INT", "TINYINT", "SMALLINT", "MEDIUMINT", "BIGINT", "DECIMAL", "NUMERIC", "FLOAT", "DOUBLE", "INTEGER","YEAR"];
    const specialDataTypes = ["BLOB", "LONGBLOB", "MEDIUMBLOB", "TINYBLOB", "GEOMETRY", "POINT", "LINESTRING", "POLYGON", "JSON"];
    const textualTypes = ["VARCHAR", "TEXT", "CHAR", "TINYTEXT", "MEDIUMTEXT", "LONGTEXT", "STRING"];
    const dateTypes = ["DATE", "DATETIME", "TIMESTAMP", "TIME"];
    const booleanTypes = ["BOOLEAN", "BIT", "TINYINT(1)"];
    const enumTypes = ["ENUM", "SET"];

    let htmlContent = '';

    datatype = datatype.toUpperCase();

    if (numericTypes.includes(datatype)) {

        htmlContent += getNumericFilterHTML(datatype, text, table, id, values);

    } else if (specialDataTypes.includes(datatype)) {

        htmlContent += getSpecialDataTypeFilterHTML(datatype, text, table, id, values);

    } else if (textualTypes.includes(datatype)) {

        htmlContent += getTextualFilterHTML(datatype, text, table, id, values);

    } else if (booleanTypes.includes(datatype)) {

        htmlContent += getBooleanFilterHTML(datatype, text, table, id, values);

    } else if (enumTypes.includes(datatype)) {

        htmlContent += getEnumFilterHTML(datatype, text, table, id, values);

    } else if (dateTypes.includes(datatype)) {

        htmlContent += getDateTimeFilterHTML(datatype, text, table, id, values);

    }

    return htmlContent;
}

function doesTableExist(table, id) {
    let exists = false;
    $('#row-headers > li, #column-headings > li, #values-fields > li').each(function () {

        if ($(this).data('table') === table) {
            exists = true;
            return false;
        }
    });
    return exists;
}


function preventWrongDataTypeDrop(closestList, datatype) {

    let fieldSections = ["row-headers", "column-headings", "values-fields"];
    let parameters = ["parameters"];

    let validations = {
        "row-headers": `The Row Headers Field can't be a ${datatype.toUpperCase()} field. Please select a different field instead.`,
        "row-headers-time": `Row headers cannot be a DateTime field. Please add it to the column headers instead.`,
        "column-headings": `The Column Headings Field can't be a  ${datatype.toUpperCase()} field. Please select a different field instead.`,
        "values-fields": `The Values section Field can't be a ${datatype.toUpperCase()} field. Please select a different field instead.`,
        "parameters": `A field of ${datatype.toUpperCase()} data type cannot be used as a parameter.`
    }

    const dateTypes = ["DATE", "DATETIME", "TIMESTAMP", "TIME"];
    const specialDataTypes = ["BLOB", "LONGBLOB", "MEDIUMBLOB", "TINYBLOB", "GEOMETRY", "POINT", "LINESTRING", "POLYGON"];
    const jsonDataType = ["JSON"];


    if (closestList == "row-headers" && dateTypes.includes(datatype.toUpperCase())) {

        $(`#pivot-info-modal`).find('h5').text(validations["row-headers-time"]);

        $(`#pivot-info-modal`).modal({
            keyboard: false,
            show: true
        });

        return true;
    }

    if (fieldSections.includes(closestList)
        &&
    (
        specialDataTypes.includes(datatype.toUpperCase())
        || jsonDataType.includes(datatype.toUpperCase())
    )
    ) {

        $(`#pivot-info-modal`).find('h5').text(validations[closestList]);

        $(`#pivot-info-modal`).modal({
            keyboard: false,
            show: true
        });

        return true;
    }

    if (parameters.includes(closestList) && specialDataTypes.includes(datatype.toUpperCase())) {

        $(`#pivot-info-modal`).find('h5').text(validations[closestList]);

        $(`#pivot-info-modal`).modal({
            keyboard: false,
            show: true
        });

        return true;
    }

    return false;

}


function preventColumnDropWhenTableNotExists(table, id) {

    const columnExists = doesTableExist(table, id);

    if (!columnExists) {
        $(`#pivot-info-modal`).find('h5').text("This field cannot be used for filtering because it belongs to a table that is not included among the selected tables in row headers, column headers, or values.");

        $(`#pivot-info-modal`).modal({
            keyboard: true,
            show: true
        });
        return true;
    }

    return false;

}

function buildAddFilterModal(datatype, text, table, id, enumValues) {


    let values = {
        edit: false,
        value: null,
        typeOfRange: null,
        relative: null,
        fixed: null,
        criteria: null,
        min: null,
        max: null,
        selectType: null,
        enumValues: enumValues ?? null
    }


    let htmlContainer = document.getElementById("static-filters-container");

    htmlContainer.innerHTML = getStaticFilterHTML(datatype, text, table, id, values);


    if(preventColumnDropWhenTableNotExists(table, id))
        return;


    $("#add-filter-error").text("").hide();
    $("#filter-title").text('Add Filter');

    $(`#static-filters-modal`).modal({
        keyboard: true,
        show: true
    });

}

function getClosestListId(eventTarget) {
    if ($(eventTarget).is('label')) {
        return $(eventTarget).parent().prev().find('ul').attr('id') || $(eventTarget).parent().find('ul').attr('id');
    } else if ($(eventTarget).is("div")) {
        return $(eventTarget).find("ul").attr("id");
    } else {
        return $(eventTarget).closest('ul').attr('id');
    }
}

function modifyStaticFilter(){
    $(document).on('click', '.modify-static-filter', function () {
        let listItem = $(this).closest('li');

        let datatype = listItem.attr('data-type');
        let label = listItem.attr('data-label');
        let table = listItem.attr('data-table');
        let id = listItem.attr('data-id');

        let values = {
            edit: true,
            value: listItem.attr('data-value') ?? null,
            criteria: listItem.attr('data-criteria') ?? null,
            typeOfRange: listItem.attr('data-type-of-range') ?? null,
            min: listItem.attr('data-min') ?? null,
            max: listItem.attr('data-max') ?? null,
            relative: listItem.attr('data-relative') ?? null,
            fixed: listItem.attr('data-fixed') ?? null,
            selectType: listItem.attr('data-select-type') ?? null,
            enumValues: listItem.attr('data-enum') ?? null
        }

        let htmlContainer = document.getElementById("static-filters-container");

        htmlContainer.innerHTML = getStaticFilterHTML(datatype, label, table, id, values);

        $("#filter-title").text('Edit Filter');
        $(`#static-filters-modal`).modal({
            keyboard: true,
            show: true
        });


    });

}

function initializeTooltip(){
    $('[data-toggle="tooltip"], [data-tooltip="tooltip"]').tooltip({ boundary: 'window' });
}

function adjustParametersDropdownMenu(){
    $(document).on('show.bs.dropdown', '#parameters', function (e) {
        var $trigger = $(e.relatedTarget); // Get the clicked element
        var $dropdown = $trigger.siblings('.dropdown-menu');
        var extraY = 5; // Adjust vertical spacing


        // Generate a unique ID if not already assigned
        var dropdownId = $dropdown.attr('data-dropdown-id');
        if (!dropdownId) {
            dropdownId = 'dropdown-' + Date.now(); // Unique identifier
            $dropdown.attr('data-dropdown-id', dropdownId);
            $trigger.attr('data-dropdown-id', dropdownId);
        }

        // Store original parent if not already stored
        if (!$dropdown.data('original-parent')) {
            $dropdown.data('original-parent', $dropdown.parent());
        }

        // Hide all other dropdowns but keep them in the DOM
        $('.dropdown-menu').not($dropdown).each(function () {
            $(this).appendTo($(this).data('original-parent')).hide();
        });

        // Move dropdown to body
        $dropdown.appendTo('body').css({
            position: 'absolute',
            minWidth: $trigger.outerWidth(),
            zIndex: 1050,
            opacity: 0,  // Start hidden for a smooth transition
            display: 'block',
            willChange: 'transform'
        });

        function updateDropdownPosition() {
            var $newTrigger = $('[data-dropdown-id="' + dropdownId + '"]'); // Find the trigger by ID
            if (!$newTrigger.length) return;

            var triggerOffset = $newTrigger.offset();
            var x = triggerOffset.left;
            var y = triggerOffset.top + $newTrigger.outerHeight() + extraY;

            $dropdown.css({
                transform: `translate3d(${x}px, ${y}px, 0)`,
                opacity: 1  // Smooth fade-in effect
            });
        }

        // Apply positioning after Bootstrap initializes
        requestAnimationFrame(updateDropdownPosition);

        // Ensure dropdown follows the clicked element while scrolling or resizing
        var $scrollContainer = $('.parameters-ul-container');
        $scrollContainer.on('scroll.dropdown', updateDropdownPosition);
        $(window).on('resize.dropdown', updateDropdownPosition);

        // Restore dropdown when hidden
        $(document).one('hidden.bs.dropdown', function () {
            $dropdown.appendTo($dropdown.data('original-parent')).removeAttr('style');
            $scrollContainer.off('scroll.dropdown');
            $(window).off('resize.dropdown');
        });
    });



}


$(function () {


    $(document).on('dnd_stop.vakata', function (e, data) {
        var jsonElement,
            id,
            icon,
            parent,
            text,
            datatype,
            droppedElementId,
            listItem,
            closestList;

        droppedElementId = data.data.nodes[0];

        closestList = getClosestListId(data.event.target);


        if (!preventWrongDropArea(closestList)) {
            return;
        }



        if (preventAddingMoreThanTwoElements(closestList)) {
            return;
        }


        if (
            data.data.jstree
            && data.data.origin
            && data.data.origin.get_node(data.element).icon === 'fa fa-columns'
        ) {

            jsonElement = data.data.origin.get_node(data.element);

            id = jsonElement.id;
            icon = jsonElement.icon;
            parent = jsonElement.parent;

            text = {
                original: jsonElement.text,
                truncated: prepareMessage(jsonElement.text, 6).fullMsg
            };

            datatype = jsonElement.original.type;
            table = jsonElement.original.table;
            enumValues = jsonElement.original?.enum;


            if (preventWrongDataTypeDrop(closestList, datatype)) {
                return;
            }

            switch (closestList) {
                case 'static-filters':
                    buildAddFilterModal(datatype, text, table, id, enumValues);
                    break;
                case 'parameters':
                    listItem = createParameterListItem(
                        id,
                        text,
                        icon,
                        table,
                        datatype,
                        parent,
                        closestList,
                        enumValues
                    );
                    break;
                default:
                    listItem = createFieldListItem(
                        id,
                        text,
                        icon,
                        table,
                        datatype,
                        parent,
                        closestList,
                        enumValues
                    );
                    break;
            }

            $(document).on('click', '.column_function', function (e) {
                e.preventDefault();
                updateColumnFunction($(this), e);
            });

            $(document).on('click', '.parameters_function', function (e) {
                e.preventDefault();
                updateParameterFunction($(this), e);
            });


            $(`#${closestList}`).append(listItem);

            bindModifyFieldEvent();

            bindDeleteEvent(closestList);

            toggleFieldLabels(closestList);

            updateFieldTextBox(closestList, `${closestList}-textbox`);

            checkAutoJoin();

        }

        initializeTooltip()
    });

    modifyStaticFilter();



});
