$(document).ready(function () {
  $('#type-of-embed').append(new Option("Please Select Type of Embed", ""));

  $(document).on('change', "#resource-type", function () {
    if ($(`#${$(this).attr("id")} :selected`).val()) {
      let url = $(`#${$(this).attr("id")} :selected`).data("resource-types-url");
      let resourceType = $(`#${$(this).attr("id")} :selected`).text();
      let accessUrl = $(`#${$(this).attr("id")} :selected`).data("access-keys-url");
      let managementSentence = getManagementSentence(resourceType);

      $.ajax({
        type: "GET",
        url: url,
        contentType: false,
        processData: false,
        dataType: "json",
        beforeSend: function () {
          $(".modal-spinner").fadeIn();
          $('.modal-container').fadeOut();
        },
        success: function (response) {
          updateSelectBox("resources", response.data.resources, true, accessUrl, resourceType, "Please Select Resource");
          $(".modal-spinner").fadeOut();
          $('.modal-container').fadeIn();

        }
      });
    }
  });


  $(document).on('change', "#resources", function () {
    if ($(`#${$(this).attr("id")} :selected`).val()) {
      let resourceType = $(`#resource-type :selected`).val();
      let resourceId = $(`#${$(this).attr("id")} :selected`).val();
      let url = $(`#${$(this).attr("id")} :selected`).data("access-url") + "/" + resourceType + "/" + resourceId;
      let managementUrl = $(`#${$(this).attr("id")} :selected`).data("management-url");
      let managementSentence = getManagementSentence(resourceType);

      $.ajax({
        type: "GET",
        url: url,
        contentType: false,
        processData: false,
        dataType: "json",
        beforeSend: function () {
          $(".modal-spinner").fadeIn();
          $('.modal-container').fadeOut();
        },
        success: function (response) {
          let publicOptions = [
            { value: "php_embed", text: "PHP Embed Code" },
            { value: "html_embed", text: "HTML Embed Code" },
            { value: "share_resource_url", text: "Share Resource URL" },
            { value: "qr_code", text: "QR code" },
          ];

          let privateOptions = [
            { value: "php_embed", text: "PHP Embed Code" },
          ];



          updateSelectBox("access-key", response.data.resources, true, null, resourceType, "Please Select Access Key");
          $('#type-of-embed').empty();
          $('#type-of-embed').append(new Option("Please Select Type of Embed", ""));

          if (response.data.access == "public") {
            $("#access-key").prop("disabled", true);
            $("#error-embed-resources").hide();
            publicOptions.forEach(opt => {
              $('#type-of-embed').append(new Option(opt.text, opt.value));
            });

          } else if (response.data.access == "private" && response.data.resources.length > 0) {
            $("#access-key").prop("disabled", false);
            privateOptions.forEach(opt => {
              $('#type-of-embed').append(new Option(opt.text, opt.value));
            });
            $("#error-embed-resources").hide();
          } else {
            $("#access-key").prop("disabled", true);
            $("#error-embed-resources").text("The selected resource is private, and no Access key currently has access to it. Please create one.").show();
          }
          $(".modal-spinner").fadeOut();
          $('.modal-container').fadeIn();

        }
      });
    }
  });

  $(document).on("click", "#saveBtn-embed-resource", function () {
    let fields = ["resource_type", "resources", "access_key", "type_of_embed"];
    let typeOfEmbed = $(`#type-of-embed :selected`).val();

    if (typeOfEmbed == "share_resource_url") {
      sendAjaxRequestShareResourceUrl("embed-resources-form", fields, "share-resource-url-confirm", "error-embed-resources");
    } else if (typeOfEmbed == "qr_code") {
      sendAjaxRequestQrCode("embed-resources-form", fields, "qr-code-confirm", "error-embed-resources");
    } else if (typeOfEmbed == "php_embed") {
      sendAjaxRequestEmbedFile("embed-resources-form", fields, "embed-confirm", "error-embed-resources", null, null, false, "Download PHP Embed File");
    } else if (typeOfEmbed == "html_embed") {
      sendAjaxRequestEmbedFile("embed-resources-form", fields, "embed-confirm", "error-embed-resources", null, null, false, "Download HTML Embed File");
    } else {
      sendAjaxRequest("embed-resources-form", fields, "share-resource-url-confirm", "error-embed-resources");
      $("#share-resource-url-confirm").hide();
      $("#qr-code-confirm").hide();
      $("#embed-confirm").hide();
    }


  });


  $(document).on("click", "#copy-key", function (e) {
    e.preventDefault();

    let keyElement = document.getElementById("share-resource-url");

    if (!keyElement || !keyElement.textContent.trim()) {
      alert("No key to copy!");
      return;
    }

    let range = document.createRange();
    range.selectNodeContents(keyElement);

    let selection = window.getSelection();
    selection.removeAllRanges();
    selection.addRange(range);

    // Change icon & text
    $("#copy-icon").removeClass("fa-copy").addClass("fa-check");
    $("#copy-text").text("Copied");

    try {
      document.execCommand("copy");
      selection.removeAllRanges();

      setTimeout(function () {
        $("#copy-icon").removeClass("fa-check").addClass("fa-copy");
        $("#copy-text").text("Copy");
      }, 2000);

    } catch (err) {
      console.error("Copy failed", err);
      alert("Unable to copy. Please copy manually.");
    }


  });



  function getManagementSentence(resourceType) {
    switch (resourceType) {
      case "Chart":
        return "+ Add new Chart"
      case "Metric / KPI":
        return "+ Add new Metric / KPI"
      case "Report List":
        return "+ Add new Report"
      case "Pivot Table":
        return "+ Add new Pivot Table"
      default:
        break;
    }
  }

  function updateSelectBox(id, data, placeholder, accessUrl, resourceType, placeholderSentence = null) {
    $(`select[id="${id}"]`).empty();

    // if (placeholder && resourceType != "Report")
      $(`select[id="${id}"]`).append(
        `<option value="">${placeholderSentence}</option>`
      );

    $.each(data, function (key, value) {
      let name = value.clean_name || value.name || value.label;
      $(`select[id="${id}"]`).append(
        '<option value="' + value.id + '" data-access-url="' + accessUrl + '">' + name + "</option>"
      );
    });
  }

});